/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.ns.NSField;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.wsdl.generator.SimpleTypeSrcBuilder;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.XSDContext;
import com.wm.util.Name;
import com.wm.util.Strings;

public class ObjectSrcBuilder
extends SourceBuilders {
    private static final boolean debug = false;

    public static void generate(NSField field, XSDContext context) {
        Name fieldUri = ObjectSrcBuilder.getXmlNamespace(field);
        ObjectSrcBuilder.initialize(fieldUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
        int padding = context.getPadding(fieldUri);
        boolean isOptional = field.isOptional();
        boolean isNillable = field.isNillable();
        int dim = field.getDimensions();
        String name = field.getName();
        String minOccurs = isOptional ? null : "1";
        String maxOccurs = dim > 0 ? "unbounded" : "1";
        String src = null;
        String type = null;
        SimpleType st = null;
        boolean useSoapArray = context.isUseSoapArray();
        ContentType ct = field.getContentType();
        if (useSoapArray && dim > 0) {
            String typeName = name;
            if (ObjectSrcBuilder.isProxy(ct)) {
                type = ObjectSrcBuilder.writeSimpleType(fieldUri, context, ct);
            } else {
                type = Strings.cat(ObjectSrcBuilder.getFieldPrefix(context, field), ":", typeName);
                st = (SimpleType)ct;
                src = SimpleTypeSrcBuilder.getSoapType(typeName, st, context, 1);
                xsdSrc.append(src);
            }
            context.putXSDSrc(fieldUri, xsdSrc);
        } else {
            ObjectSrcBuilder.writeElementTag(name, fieldUri, context, ct, minOccurs, maxOccurs, name.indexOf(58) > -1, useSoapArray, field.isNillable());
        }
    }

    static String writeSimpleType(Name fieldUri, XSDContext context, ContentType ct) {
        String type = null;
        Object inlineType = null;
        SimpleType st = null;
        int padding = context.getPadding(fieldUri);
        if (ct == null) {
            type = "xsd:anyType";
        } else if (ct.getType() == 1) {
            st = (SimpleType)ct;
            type = st.isProxy() ? SimpleTypeSrcBuilder.getProxyType(st, context, fieldUri) : SimpleTypeSrcBuilder.getInlineType(st, context, padding);
        }
        return type;
    }

    static boolean isProxy(ContentType ct) {
        SimpleType st;
        if (ct == null) {
            return true;
        }
        return ct.getType() == 1 && (st = (SimpleType)ct).isProxy();
    }

    static void writeElementTag(String name, Name fieldUri, XSDContext context, ContentType ct, String minOccurs, String maxOccurs, boolean useQualified, boolean useSoapArray, boolean isNillable) {
        if (context.isDeclaredElement(fieldUri, name)) {
            return;
        }
        ObjectSrcBuilder.initialize(fieldUri, context);
        StringBuffer xsdSrc = (StringBuffer)context._tnsXSD.get(fieldUri);
        int padding = context.getPadding(fieldUri);
        boolean isProxy = ObjectSrcBuilder.isProxy(ct);
        int index = name.indexOf(58);
        name = index != -1 ? name.substring(index + 1) : name;
        String src = Strings.cat("<xsd:element name=\"", name);
        src = Strings.cat(ObjectSrcBuilder.composePadding(padding), src);
        String part2 = isNillable ? "\" nillable=\"true" : "";
        if (minOccurs != null) {
            part2 = Strings.cat("\" minOccurs=\"", minOccurs, "\" maxOccurs=\"", maxOccurs);
        } else if (maxOccurs != null) {
            part2 = Strings.cat("\" maxOccurs=\"", maxOccurs);
        }
        if (useQualified && (minOccurs != null || maxOccurs != null)) {
            part2 = Strings.cat(part2, "\" form=\"qualified");
        }
        String type = null;
        if (ct == null) {
            xsdSrc.append(src);
            type = "xsd:string";
            src = Strings.cat("\" type=\"", type, part2, "\"/>");
            xsdSrc.append(src);
        } else if (isProxy) {
            xsdSrc.append(src);
            SimpleType st = (SimpleType)ct;
            if (st.getQName() != null && st.getQName().getNamespace() == null) {
                type = st.getName();
                SimpleTypeSrcBuilder.writeUnqualifiedGlobleProxy(st, context);
            } else {
                type = ObjectSrcBuilder.writeSimpleType(fieldUri, context, ct);
            }
            src = Strings.cat("\" type=\"", type, part2, "\"/>");
            xsdSrc.append(src);
        } else {
            src = Strings.cat(src, part2, "\">");
            context.putPadding(fieldUri, ++padding);
            type = ObjectSrcBuilder.writeSimpleType(fieldUri, context, ct);
            if (type != null) {
                src = Strings.cat(src, type);
                xsdSrc.append(src);
                src = Strings.cat(ObjectSrcBuilder.composePadding(--padding), "</xsd:element>");
                xsdSrc.append(src);
            }
        }
        context.putPadding(fieldUri, padding);
        context.putXSDSrc(fieldUri, xsdSrc);
        context.addDeclaredElement(fieldUri, name);
    }

    static void writeSimpleTypeTag(String name, Name fieldUri, XSDContext context, ContentType ct, boolean useSoapArray) {
        ObjectSrcBuilder.initialize(fieldUri, context);
        StringBuffer xsdSrc = context.getXSDSrc(fieldUri);
        int padding = context.getPadding(fieldUri);
        boolean isProxy = ObjectSrcBuilder.isProxy(ct);
        String src = "";
        String type = null;
        if (ct == null) {
            src = Strings.cat(ObjectSrcBuilder.composePadding(padding), "<xsd:simpleType name=\"", name, "\">");
            xsdSrc.append(src);
            type = "xsd:string";
            src = Strings.cat(ObjectSrcBuilder.composePadding(++padding), "<xsd:restriction base=\"", type, "\"/>");
            xsdSrc.append(src);
            src = Strings.cat(ObjectSrcBuilder.composePadding(--padding), "</xsd:simpleType>");
            xsdSrc.append(src);
        } else if (isProxy) {
            src = Strings.cat(ObjectSrcBuilder.composePadding(padding), "<xsd:simpleType name=\"", name, "\">");
            xsdSrc.append(src);
            type = ObjectSrcBuilder.writeSimpleType(fieldUri, context, ct);
            src = Strings.cat(ObjectSrcBuilder.composePadding(++padding), "<xsd:restriction base=\"", type, "\"/>");
            xsdSrc.append(src);
            src = Strings.cat(ObjectSrcBuilder.composePadding(--padding), "</xsd:simpleType>");
            xsdSrc.append(src);
        } else {
            context.putPadding(fieldUri, padding);
            type = ObjectSrcBuilder.writeSimpleType(fieldUri, context, ct);
            int index = type.indexOf(62);
            if (type != null) {
                src = Strings.cat(" name=\"", name, "\"");
                StringBuffer sb = new StringBuffer(type);
                sb.insert(index, src);
                xsdSrc.append(sb.toString());
            }
        }
        context.putPadding(fieldUri, padding);
        context.putXSDSrc(fieldUri, xsdSrc);
    }
}

