/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.ns.NSRecord;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Part;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import java.util.ArrayList;
import java.util.Vector;

public class MessageSrcBuilder
extends SourceBuilders {
    private static final boolean debug = false;
    static final String MSG_OPEN = "<wsdl:message name=\"";
    static final String PART_OPEN = "<wsdl:part name=\"";
    static final String ELEMENT = "\" element=\"";
    static final String MSG_CLOSE = "</wsdl:message>";
    static final Name XSD_PREFIX = Name.create("xsd");
    static final String STRING_TYPE = "xsd:string";
    private static final String COLON = ":";
    private static final String COMPOSITE_ELEMENT = "parameters";

    static void generate(Message msg, WSDContext context) {
        String src;
        String kind;
        String name = MessageSrcBuilder.getComponentName(msg, context);
        boolean useRPC = msg.useSoapRpc();
        Part[] parts = msg.getParts();
        NSRecord record = msg.getNSRecord();
        int padding = 1;
        StringBuffer sb = context._wsdSrc;
        Vector urlPairs = msg.getXSDUrlPairs();
        if (urlPairs != null) {
            context._xsdURLs.addElement(urlPairs);
        }
        sb.append(MessageSrcBuilder.composePadding(padding));
        if (parts != null || record != null) {
            sb.append(MessageSrcBuilder.composePadding(padding));
            sb.append(MSG_OPEN);
            sb.append(name);
            sb.append("\">");
            ++padding;
        } else {
            sb.append(MessageSrcBuilder.composePadding(padding));
            sb.append(MSG_OPEN);
            sb.append(name);
            sb.append("\"/>");
            context.setWSDSrc(sb);
            return;
        }
        QName qName = null;
        String localName = null;
        Name tempUri = null;
        Object tempPrefix = null;
        String partName = null;
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                partName = parts[i].getName();
                qName = parts[i].getElement();
                if (qName != null) {
                    tempUri = qName.getNamespaceName();
                    localName = qName.getNCName();
                    name = tempUri == null ? localName : Strings.cat(context.createNamespacePrefix(tempUri), COLON, localName);
                    kind = ELEMENT;
                } else {
                    qName = parts[i].getType();
                    tempUri = qName.getNamespaceName();
                    localName = qName.getNCName();
                    name = tempUri == null ? localName : Strings.cat(context.createNamespacePrefix(tempUri), COLON, localName);
                    kind = "\" type=\"";
                }
                src = Strings.cat(MessageSrcBuilder.composePadding(padding), PART_OPEN, partName, kind, name, "\"/>");
                sb.append(src);
            }
        } else if (record != null) {
            ArrayList list = msg.getPartInfoFromRecord();
            for (int i = 0; i < list.size(); ++i) {
                QName[] partQNames = (QName[])list.get(i);
                QName elementQName = partQNames[0];
                QName typeQName = partQNames[1];
                partName = elementQName.getNCName();
                if (useRPC) {
                    kind = "\" type=\"";
                    tempUri = typeQName.getNamespaceName();
                    localName = typeQName.getNCName();
                } else {
                    kind = ELEMENT;
                    tempUri = elementQName.getNamespaceName();
                    localName = partName;
                }
                name = tempUri == null ? localName : Strings.cat(context.createNamespacePrefix(tempUri), COLON, localName);
                src = Strings.cat(MessageSrcBuilder.composePadding(padding), PART_OPEN, partName, kind, name, "\"/>");
                sb.append(src);
            }
        }
        sb.append(MessageSrcBuilder.composePadding(--padding));
        sb.append(MSG_CLOSE);
        context.setWSDSrc(sb);
    }
}

