/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.schema.W3CNamespaces;
import com.wm.lang.wsdl.WSD;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.util.Name;
import com.wm.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefinitionSrcBuilder
extends SourceBuilders {
    static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String DEF_OPEN = "<wsdl:definitions name=\"";
    static final String DEF_OPEN_NO_NAME = "<wsdl:definitions";
    static final String XMLNS_SOAP = "xmlns:soap=\"SOAP_NS\"";
    static final String XMLNS_HTTP = "xmlns:http=\"HTTP_NS\"";
    static final String XMLNS_MIME = "xmlns:mime=\"MIME_NS\"";
    static final String XMLNS_TNS_OPEN = "xmlns:tns=\"";
    static final String XMLNS_TARRGETNS_OPEN = "targetNamespace=\"";
    static final String XMLNS_OPEN = "xmlns:";
    static final String WSDL_NS = "xmlns:wsdl= \"http://schemas.xmlsoap.org/wsdl/\"";
    static final String MSG_CLOSE = "</wsdl:message>";
    static final String DEF_CLOSE = "</wsdl:definitions>";

    static void generate(WSD wsd, WSDContext context) {
        int padding = 0;
        StringBuffer sb = new StringBuffer(100);
        String src = Strings.cat(DefinitionSrcBuilder.composePadding(padding, false), XML_PROLOG);
        sb.append(src);
        String targetNS = wsd.getTargetNamespace();
        String name = DefinitionSrcBuilder.makeNameNice(wsd.getName());
        src = name != null ? Strings.cat(DefinitionSrcBuilder.composePadding(padding), DEF_OPEN, name, "\"") : Strings.cat(DefinitionSrcBuilder.composePadding(padding), DEF_OPEN_NO_NAME);
        sb.append(src);
        if (targetNS != null && !targetNS.equals(NULLNS)) {
            src = Strings.cat(" ", XMLNS_TARRGETNS_OPEN, targetNS, "\"");
            sb.append(src);
        } else {
            src = Strings.cat(" ", XMLNS_TARRGETNS_OPEN, W3CNamespaces.WEBM_DEFAULT_NAMESPACE_STRING, "\"");
            sb.append(src);
        }
        Hashtable nsDecls = context.getNSDecls();
        if (nsDecls != null) {
            padding = 3;
            Name uri = null;
            Name prefix = null;
            Enumeration e = nsDecls.keys();
            while (e.hasMoreElements()) {
                uri = (Name)e.nextElement();
                prefix = (Name)nsDecls.get(uri);
                if (SourceBuilders.NULLNS_NAME == uri) {
                    uri = W3CNamespaces.WEBM_DEFAULT_NAMESPACE;
                }
                src = Strings.cat(DefinitionSrcBuilder.composePadding(padding), XMLNS_OPEN, prefix.toString(), "=", "\"", uri.toString(), "\"");
                sb.append(src);
            }
        }
        sb.append(">");
        StringBuffer body = context._wsdSrc;
        sb.append(body.toString());
        padding = 0;
        src = Strings.cat(DefinitionSrcBuilder.composePadding(padding), DEF_CLOSE);
        sb.append(src);
        context.setWSDSrc(sb);
    }
}

