/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.generator;

import com.wm.lang.wsdl.Binding;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.OperationBindingInfo;
import com.wm.lang.wsdl.Signature;
import com.wm.lang.wsdl.generator.SourceBuilders;
import com.wm.lang.wsdl.generator.WSDContext;
import com.wm.util.Strings;

public class BindingSrcBuilder
extends SourceBuilders {
    static final String BINDING_OPEN = "<wsdl:binding name=\"";
    static final String INPUT_OPEN = "<wsdl:input>";
    static final String OUTPUT_OPEN = "<wsdl:output>";
    static final String BINDING_CLOSE = "</wsdl:binding>";
    static final String INPUT_CLOSE = "</wsdl:input>";
    static final String OUTPUT_CLOSE = "</wsdl:output>";
    static final String FAULT_CLOSE = "</wsdl:fault>";
    static final String SOAP_ACTION_OPERATION = "<soap:operation soapAction=\"\"/>";

    static void generate(Binding binding, WSDContext context) {
        String name = BindingSrcBuilder.getComponentName(binding, context);
        String type = BindingSrcBuilder.getComponentName(binding.getPortType(), context);
        int padding = 1;
        StringBuffer sb = context._wsdSrc;
        String src = Strings.cat(BindingSrcBuilder.composePadding(padding), BINDING_OPEN, name, "\" type=\"", "tns:", type, "\">");
        sb.append(src);
        ++padding;
        ExtendedElement[] ees = binding.getExtendElements();
        if (ees != null) {
            for (int i = 0; i < ees.length; ++i) {
                sb = BindingSrcBuilder.writeExtentedElement(ees[i], context, sb, padding);
            }
        }
        OperationBindingInfo[] opers = binding.getOperationInfos();
        Signature sig = null;
        Signature[] faults = null;
        for (int i = 0; i < opers.length; ++i) {
            int j;
            name = BindingSrcBuilder.getComponentName(opers[i], context);
            src = Strings.cat(BindingSrcBuilder.composePadding(padding), "<wsdl:operation name=\"", name, "\">");
            sb.append(src);
            ++padding;
            ees = opers[i].getExtendElements();
            if (ees != null) {
                for (j = 0; j < ees.length; ++j) {
                    sb = BindingSrcBuilder.writeExtentedElement(ees[j], context, sb, padding);
                }
            }
            if (binding.getProtocol() == 2) {
                src = Strings.cat(BindingSrcBuilder.composePadding(padding), SOAP_ACTION_OPERATION);
                sb.append(src);
            }
            if ((sig = opers[i].getInput()) != null) {
                src = Strings.cat(BindingSrcBuilder.composePadding(padding), INPUT_OPEN);
                sb.append(src);
                ees = sig.getExtendedElements();
                ++padding;
                if (ees != null) {
                    for (j = 0; j < ees.length; ++j) {
                        sb = BindingSrcBuilder.writeExtentedElement(ees[j], context, sb, padding);
                    }
                }
                src = Strings.cat(BindingSrcBuilder.composePadding(--padding), INPUT_CLOSE);
                sb.append(src);
            }
            if ((sig = opers[i].getOutput()) != null) {
                src = Strings.cat(BindingSrcBuilder.composePadding(padding), OUTPUT_OPEN);
                sb.append(src);
                ees = sig.getExtendedElements();
                ++padding;
                if (ees != null) {
                    for (j = 0; j < ees.length; ++j) {
                        sb = BindingSrcBuilder.writeExtentedElement(ees[j], context, sb, padding);
                    }
                }
                src = Strings.cat(BindingSrcBuilder.composePadding(--padding), OUTPUT_CLOSE);
                sb.append(src);
            }
            if ((faults = opers[i].getFault()) != null) {
                for (int k = 0; k < faults.length; ++k) {
                    if (sig == null) continue;
                    name = sig.getName();
                    src = Strings.cat(BindingSrcBuilder.composePadding(padding), "<wsdl:fault name=\"", name, "\">");
                    sb.append(src);
                    ees = sig.getExtendedElements();
                    ++padding;
                    if (ees != null) {
                        for (int j2 = 0; j2 < ees.length; ++j2) {
                            sb = BindingSrcBuilder.writeExtentedElement(ees[j2], context, sb, padding);
                        }
                    }
                    src = Strings.cat(BindingSrcBuilder.composePadding(--padding), FAULT_CLOSE);
                    sb.append(src);
                }
            }
            src = Strings.cat(BindingSrcBuilder.composePadding(--padding), "</wsdl:operation>");
            sb.append(src);
        }
        sb.append(BindingSrcBuilder.composePadding(--padding));
        sb.append(BINDING_CLOSE);
        context.setWSDSrc(sb);
    }
}

