/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.compiler;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.NodeValidator;
import com.wm.lang.wsdl.Binding;
import com.wm.lang.wsdl.ExtendedAttribute;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.Folder;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Operation;
import com.wm.lang.wsdl.OperationBindingInfo;
import com.wm.lang.wsdl.Service;
import com.wm.lang.wsdl.Signature;
import com.wm.lang.wsdl.WSD;
import com.wm.lang.wsdl.WSDSourcePackager;
import com.wm.lang.wsdl.compiler.BindingExp;
import com.wm.lang.wsdl.compiler.CompilerWorkspace;
import com.wm.lang.wsdl.compiler.Expressions;
import com.wm.lang.wsdl.compiler.FolderExp;
import com.wm.lang.wsdl.compiler.MessageExp;
import com.wm.lang.wsdl.compiler.ServiceExp;
import com.wm.lang.wsdl.compiler.SymbolComponent;
import com.wm.lang.wsdl.compiler.WSDExp;
import com.wm.lang.wsdl.compiler.WSDInfoSet;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.QName;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

public class WSDCompiler {
    private static boolean debug = new Boolean(System.getProperty("watt.server.WSDL.debug", "false"));
    static final NSName SCHEMA_FOR_WSDL = NSName.create("pub.wsd.w3c:structures");
    private static String INVALID_WSD = "WSDL definition is INVALID";
    private static boolean _wsi = false;
    public static final Expressions WORK_HORSE = Expressions.create();

    public static final IData compile(Namespace ns, String url, Locale locale) throws WMDocumentException, IOException, Exception {
        IData result = WSDCompiler.compile(ns, WSDSourcePackager.build(url), locale);
        return result;
    }

    public boolean isWSI() {
        return _wsi;
    }

    public void setWSI(String wsi) {
        _wsi = wsi.equals("true");
    }

    public static final IData compile(Namespace ns, IData wsdSource, Locale locale) throws WMDocumentException, IOException {
        CompilerWorkspace workspace = new CompilerWorkspace();
        workspace.ns = ns;
        workspace.locale = locale;
        workspace._source = wsdSource;
        workspace._wsi = _wsi;
        WSDInfoSet[] wiss = WSDCompiler.generateWISs(wsdSource);
        boolean successful = WSDCompiler.runFirstPass(wiss, workspace);
        if (debug && successful) {
            System.out.println("WSDCompiler first pass successful");
        }
        successful = WSDCompiler.runSecondPass(workspace);
        if (debug && successful) {
            System.out.println("WSDCompiler second pass successful");
        }
        return workspace.packageResults();
    }

    public static boolean runFirstPass(WSDInfoSet[] wiss, CompilerWorkspace ws) throws WMDocumentException {
        for (int i = 0; i < wiss.length; ++i) {
            ws.pushCurrent(wiss[i]);
            WORK_HORSE.symbolize(wiss[i].getDefination(), ws, null);
            ws.popCurrent();
        }
        return ws.getErrors() == null;
    }

    static boolean runSecondPass(CompilerWorkspace ws) throws WMDocumentException {
        int i;
        int i2;
        ElementNode temp = null;
        QName tempQName = null;
        SymbolComponent[] msa = ws.getMessageSymbols();
        SymbolComponent[] fsa = ws.getFolderSymbols();
        SymbolComponent[] bsa = ws.getBindingSymbols();
        SymbolComponent[] ssa = ws.getServiceSymbols();
        if (msa != null) {
            if (debug) {
                System.out.println("WSDCompiler.runSecondPass calling MessageExp.translate");
            }
            for (i2 = 0; i2 < msa.length; ++i2) {
                temp = msa[i2].getElementNode();
                tempQName = msa[i2].getQName();
                MessageExp.translate(temp, ws, null, tempQName);
            }
        }
        if (fsa != null) {
            if (debug) {
                System.out.println("WSDCompiler.runSecondPass calling FolderExp.translate");
            }
            for (i2 = 0; i2 < fsa.length; ++i2) {
                temp = fsa[i2].getElementNode();
                tempQName = fsa[i2].getQName();
                FolderExp.translate(temp, ws, null, tempQName);
            }
        }
        if (bsa != null) {
            if (debug) {
                System.out.println("WSDCompiler.runSecondPass calling BindingExp.translate");
            }
            for (i2 = 0; i2 < bsa.length; ++i2) {
                temp = bsa[i2].getElementNode();
                tempQName = bsa[i2].getQName();
                BindingExp.translate(temp, ws, null, tempQName);
            }
        }
        Binding[] bindings = ws.getBindings();
        Folder[] folders = ws.getFolders();
        for (i = 0; i < folders.length; ++i) {
            Operation[] operations = folders[i].getOperations();
            if (operations == null) continue;
            for (int ii = 0; ii < operations.length; ++ii) {
                Signature inputSig = operations[ii].getInput();
                String opername = operations[ii].getName();
                for (int iii = 0; iii < bindings.length; ++iii) {
                    ExtendedAttribute partsattr;
                    OperationBindingInfo operationBindingInfo = bindings[iii].getOperationInfo(opername);
                    if (operationBindingInfo == null || operationBindingInfo.getInput() == null) continue;
                    ExtendedElement soapbody = operationBindingInfo.getInput().getExtendedElement(QName.create("http://schemas.xmlsoap.org/wsdl/soap/", "body"));
                    if (soapbody == null) {
                        soapbody = operationBindingInfo.getInput().getExtendedElement(QName.create("http://schemas.xmlsoap.org/wsdl/soap12/", "body"));
                    }
                    if (soapbody == null || (partsattr = soapbody.getExtAttr(QName.create(null, "parts"))) == null) continue;
                    String partsvalue = partsattr.getValue();
                    String[] parts = partsvalue.split("[ ,]");
                    Signature newinputsig = Signature.create(inputSig.getMessage(), operationBindingInfo.getInput().getExtendedElements(), inputSig.getSigType(), inputSig.getName());
                    Signature[] siglist = new Signature[]{newinputsig, operations[ii].getOutput()};
                    operations[ii].setParaOrder(parts);
                    operations[ii].setSignList(siglist);
                }
            }
        }
        if (ssa != null) {
            if (debug) {
                System.out.println("WSDCompiler.runSecondPass calling ServiceExp.translate");
            }
            for (i = 0; i < ssa.length; ++i) {
                temp = ssa[i].getElementNode();
                tempQName = ssa[i].getQName();
                ServiceExp.translate(temp, ws, null, tempQName);
            }
        }
        if (debug) {
            System.out.println("WSDCompiler.runSecondPass calling WSDExp.translate");
        }
        WSDExp.translate(temp, ws, null);
        return ws.getErrors() == null;
    }

    static final WSDInfoSet[] generateWISs(IData wsdSource) throws WMDocumentException, IOException {
        Vector vec = new Vector();
        WSDCompiler.recursiveGetSource(wsdSource, vec);
        Object[] wiss = new WSDInfoSet[vec.size()];
        vec.copyInto(wiss);
        return wiss;
    }

    private static final void recursiveGetSource(IData wsd, Vector holder) throws IOException, WMDocumentException {
        IDataCursor cursor = wsd.getCursor();
        while (cursor.next()) {
            String key = cursor.getKey();
            Object value = cursor.getValue();
            if (key.equals("source")) {
                holder.addElement(new WSDInfoSet((String)value));
                continue;
            }
            if (!key.equals("import-wsd")) continue;
            WSDCompiler.recursiveGetSource((IData)value, holder);
        }
    }

    static final IData validateIncomingWSD(WSDInfoSet[] wiss, Namespace ns) throws WMDocumentException {
        NSNode node = ns.getNode(SCHEMA_FOR_WSDL);
        if (node != null && node.getNodeTypeObj().equals(NSSchema.TYPE)) {
            boolean valid = true;
            for (int i = 0; i < wiss.length; ++i) {
                NodeValidator validator = new NodeValidator(wiss[i].getDefination());
                validator.setMaximumErrors(-1);
                validator.setNamespace(ns);
                IData result = validator.validate();
                IDataCursor idc = result.getCursor();
                if (WSDCompiler.getBoolean(idc, "isValid")) continue;
                IDataUtil.put(idc, "source", wiss[i].getSource());
                IDataUtil.put(idc, "message", INVALID_WSD);
                return result;
            }
            return null;
        }
        return null;
    }

    static boolean getBoolean(IDataCursor idc, String key) {
        Object o = IDataUtil.get(idc, key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return new Boolean(o.toString());
        }
        return false;
    }

    public static void main(String[] args) {
        block3: {
            try {
                WSDCompiler wc = new WSDCompiler();
                String url = args[0];
                IData result = WSDCompiler.compile(null, url, Locale.getDefault());
                IDataCursor idc = result.getCursor();
                WSD wsd = (WSD)IDataUtil.get(idc, "wsdObj");
                Binding[] bindings = wsd.getBindings();
                Service[] svcs = wsd.getServices();
                Folder[] folders = wsd.getFolders();
                Message[] msgs = wsd.getMessages();
                System.out.println("Done");
                for (int i = 0; i < bindings.length; ++i) {
                    Binding binding = bindings[i];
                    int protocol = binding.getProtocol();
                    System.out.println(protocol);
                }
            }
            catch (Exception e) {
                if (!debug) break block3;
                e.printStackTrace();
            }
        }
    }
}

