/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.compiler;

import com.wm.lang.wsdl.ExtendedAttribute;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Signature;
import com.wm.lang.wsdl.compiler.CompilerWorkspace;
import com.wm.lang.wsdl.compiler.Expression;
import com.wm.lang.wsdl.compiler.ExtendedElementExp;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;

public class SignatureExp
extends Expression {
    public static void translate(ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        String name;
        Node extElement = null;
        String comment = null;
        Message msg = null;
        int sigType = -1;
        Name temp = node.getLocalNameWm();
        String identifer = SignatureExp.composeRelativeIdentifier(baseIdentifier, temp.toString(), null);
        for (extElement = node.getFirstChildWm(); extElement != null; extElement = extElement.getNextSiblingWm()) {
            if (extElement.getNodeType() != 1) continue;
            if (extElement.getLocalNameWm().equals(DOCUMENTATION)) {
                comment = extElement.getText();
                continue;
            }
            ExtendedElementExp.translate((ElementNode)extElement, workspace, identifer, 9);
        }
        ExtendedElement[] ea = workspace.getExtendedElements(9);
        if (temp.equals(INPUT)) {
            sigType = 0;
        } else if (temp.equals(OUTPUT)) {
            sigType = 1;
        } else if (temp.equals(FAULT)) {
            sigType = 2;
        } else if (temp.equals(HEADER)) {
            sigType = 3;
        } else {
            System.out.println("error illegal signature type:" + temp + " in '" + workspace.getTargetNamespace() + "'");
        }
        String msgName = node.getAttributeValue(null, MESSAGE);
        if (msgName != null) {
            QName msgQName = SignatureExp.computeQName(msgName, node, workspace, identifer);
            try {
                msg = (Message)workspace._messages.get(msgQName);
                if (msg == null && sigType == 2) {
                    if (workspace.isWSI()) {
                        workspace.addError(baseIdentifier, SignatureExp.getSource(node), WSDMessageBundle.WSI_ERROR_NAMESPACE, new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.WSI_ERROR_NAMESPACE, SignatureExp.getSource(node)));
                    } else {
                        String prefix = "";
                        int indx = msgName.indexOf(":");
                        if (indx > -1) {
                            prefix = msgName.substring(0, indx);
                            QName tempQName = SignatureExp.computeQName("tns:" + msgName.substring(indx + 1), node, workspace, identifer);
                            msg = (Message)workspace._messages.get(tempQName);
                            if (msg != null) {
                                msg.setQName(msgQName);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((name = node.getAttributeValue(null, NAME)) == null && (name = msgName) != null && name.indexOf(":") > -1) {
            name = name.substring(name.indexOf(":") + 1);
        }
        Signature sig = Signature.create(msg, ea, sigType, name);
        if (comment != null) {
            sig.setComment(comment);
        }
        workspace._signatures.addElement(sig);
        Message originalMessage = msg;
        if (ea != null) {
            for (int e = 0; e < ea.length; ++e) {
                if (!ea[e].getQName().getLocalName().toString().equals("header") && !ea[e].getQName().getLocalName().toString().equals("body")) continue;
                ExtendedAttribute oneattr = ea[e].getExtAttr(QName.create(null, "message"));
                if (oneattr != null) {
                    msgName = oneattr.getValue();
                    QName msgQName = SignatureExp.computeQName(msgName, node, workspace, identifer);
                    try {
                        msg = (Message)workspace._messages.get(msgQName);
                        if (msg == null) {
                            if (workspace.isWSI()) {
                                workspace.addError(baseIdentifier, SignatureExp.getSource(node), WSDMessageBundle.WSI_ERROR_NAMESPACE, new LocalizedMessage(WSDMessageBundle.class, WSDMessageBundle.WSI_ERROR_NAMESPACE, SignatureExp.getSource(node)));
                            } else {
                                String prefix = "";
                                int indx = msgName.indexOf(":");
                                if (indx > -1) {
                                    prefix = msgName.substring(0, indx);
                                    QName tempQName = SignatureExp.computeQName("tns:" + msgName.substring(indx + 1), node, workspace, identifer);
                                    msg = (Message)workspace._messages.get(tempQName);
                                    if (msg != null) {
                                        msg.setQName(msgQName);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (msg == null) {
                    msg = originalMessage;
                }
                if (msg == null) continue;
                int type = 3;
                if (!ea[e].getQName().getLocalName().toString().equals("header")) {
                    type = sigType;
                }
                sig = Signature.create(msg, new ExtendedElement[]{ea[e]}, type, msgName);
                if (sigType == 0) {
                    sig.setInputSignature(true);
                } else {
                    sig.setInputSignature(false);
                }
                workspace._signatures.addElement(sig);
            }
        }
        if (workspace._sigExtendedElements != null) {
            workspace._sigExtendedElements.removeAllElements();
        }
    }
}

