/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.compiler;

import com.wm.lang.wsdl.compiler.CompilerWorkspace;
import com.wm.lang.wsdl.compiler.Expression;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.Hashtable;

public class Expressions {
    Hashtable _expressions = new Hashtable(13);
    Hashtable _handlers = new Hashtable(13);
    private static final int TOTAL_EXPRESSIONS = 13;
    private static final int TOTAL_HANDLERS = 13;
    static final String PREFIX = "com.wm.lang.wsdl.compiler.";
    static final Object[][] NOTES_EXPS = new Object[][]{{QName.create("http://schemas.xmlsoap.org/wsdl/", "definitions"), "WSDExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "service"), "ServiceExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "port"), "PortExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "binding"), "BindingExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "portType"), "FolderExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "operation"), "OperationExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "message"), "MessageExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "part"), "PartExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "bindingOperation"), "BindingOperationExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "signature"), "SignatureExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "extElement"), "ExtendedElementExp"}, {QName.create("http://schemas.xmlsoap.org/wsdl/", "extAttribute"), "ExtendedAttributeExp"}};

    private Expressions() {
    }

    public void symbolize(ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        Expression exp = (Expression)this._expressions.get(this.computeQName(node));
        if (exp != null) {
            exp.symbolize(node, workspace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
    }

    public String createIdentifier(ElementNode node) {
        Expression exp = (Expression)this._expressions.get(this.computeQName(node));
        if (exp != null) {
            return exp.createIdentifier(node);
        }
        return null;
    }

    private QName computeQName(ElementNode node) {
        Name ns = node.getNamespaceUri();
        return QName.create(ns, node.getLocalNameWm());
    }

    private void loadExpressions(Object[][] exps) {
        if (exps == null) {
            return;
        }
        for (int i = 0; i < exps.length; ++i) {
            String className = PREFIX + exps[i][1];
            Expression exp = (Expression)this._handlers.get(className);
            if (exp == null) {
                try {
                    Class<?> clazz = Class.forName(className);
                    exp = (Expression)clazz.newInstance();
                    this._handlers.put(className, exp);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (SecurityException ex) {
                }
                catch (IllegalAccessException ex) {
                }
                catch (InstantiationException ex) {
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (exp == null) continue;
            this._expressions.put(exps[i][0], exp);
        }
    }

    static final Expressions create() {
        Expressions exps = new Expressions();
        exps.loadExpressions(NOTES_EXPS);
        return exps;
    }
}

