/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.compiler;

import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.wsdl.compiler.CompilerWorkspace;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;

public class Expression {
    protected static final Name NAME = Name.create("name");
    protected static final Name TYPE = Name.create("type");
    protected static final Name ELEMENT = Name.create("element");
    protected static final Name DOCUMENTATION = Name.create("documentation");
    protected static final Name INPUT = Name.create("input");
    protected static final Name OUTPUT = Name.create("output");
    protected static final Name FAULT = Name.create("fault");
    protected static final Name HEADER = Name.create("header");
    protected static final Name PARAMETER_ORDER = Name.create("paraOrder");
    protected static final Name MESSAGE = Name.create("message");
    protected static final Name BINDING = Name.create("binding");
    protected static final Name EXTENDED_ELEMENT = Name.create("extElement");
    protected static final Name EXTEND_ATTRIBUTE = Name.create("extAttribute");
    protected static final Name PORT = Name.create("port");
    protected static final Name OPERATION = Name.create("operation");
    private String _baseIdentifier;
    protected static final String SEPARATOR = "/";
    protected static final String OPEN = "[";
    protected static final String CLOSE = " ]";
    protected static final String ATTR_PREFIX = "@";
    protected static final String LIST_SEPARATOR = " ";
    protected static final String NAMESYMBOL = "[@name = ";

    public void symbolize(ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
    }

    public static void translate(ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
    }

    protected void setBaseIdentifier(String baseIdentifier) {
        this._baseIdentifier = "/definitions/" + baseIdentifier + OPEN;
    }

    protected String createIdentifier(ElementNode node) {
        return this._baseIdentifier + this.composeRelativeIdentifierUsingName(node) + CLOSE;
    }

    protected String composeRelativeIdentifierUsingName(ElementNode node) {
        return "@name=\"" + node.getAttributeValue(null, NAME) + '\"';
    }

    protected static String createIdentifier(String baseIdentifier, String name) {
        String identifier = "/definitions/" + baseIdentifier + NAMESYMBOL + name + CLOSE;
        return identifier;
    }

    protected static String composeRelativeIdentifier(String baseIdentifier, String relativeIdentifier, String name) {
        String nameAttr = name != null ? NAMESYMBOL + name + CLOSE : "";
        String id = baseIdentifier + SEPARATOR + relativeIdentifier + nameAttr;
        return id;
    }

    protected QName computeQName(ElementNode node) {
        Name ns = node.getNamespaceUri();
        return QName.create(ns, node.getLocalNameWm());
    }

    protected static QName computeQName(String ref, ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        if (ref == null) {
            return null;
        }
        int colon = ref.indexOf(58);
        String prefix = null;
        String ncName = null;
        Name namespaceURI = null;
        if (colon > -1) {
            prefix = ref.substring(0, colon);
        }
        ncName = ref.substring(colon + 1, ref.length());
        if (prefix != null) {
            Name composedPrefix = Name.create(prefix);
            NamespaceDecl ns = node.lookUpInScopeNSDeclByPrefix(composedPrefix);
            if (ns != null) {
                namespaceURI = ns.getUri();
            }
            if (namespaceURI == null) {
                workspace.addError(baseIdentifier, "XSDC-009", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_UNABLE_TO_RESOLVE_QNAME, null));
            }
        } else {
            NamespaceDecl ns = node.lookUpInScopeNSDeclByPrefix(null);
            if (ns != null) {
                namespaceURI = ns.getUri();
            }
        }
        if (namespaceURI == QName.NO_NAMESPACE) {
            namespaceURI = null;
        }
        return QName.create(namespaceURI, Name.create(ncName));
    }

    protected static String getSource(ElementNode node) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("-----   Source   -----\n");
        node.appendGeneratedMarkup(sb);
        sb.append("\n");
        return sb.toString();
    }
}

