/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.compiler;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.wsdl.Binding;
import com.wm.lang.wsdl.ExtendedAttribute;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.Folder;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Operation;
import com.wm.lang.wsdl.OperationBindingInfo;
import com.wm.lang.wsdl.Part;
import com.wm.lang.wsdl.Port;
import com.wm.lang.wsdl.Service;
import com.wm.lang.wsdl.Signature;
import com.wm.lang.wsdl.WSD;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.WSDWorkspace;
import com.wm.lang.wsdl.compiler.SymbolComponent;
import com.wm.lang.wsdl.compiler.WSDInfoSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class CompilerWorkspace
extends WSDWorkspace
implements WSDLKeys {
    public Vector _serviceSymbol;
    public Vector _bindingSymbol;
    public Vector _folderSymbol;
    public Vector _messageSymbol;
    Stack _wissStack;
    Vector _parts = new Vector();
    Vector _signatures = new Vector();
    Vector _operations = new Vector();
    Vector _extendedElements = new Vector();
    Vector _extendedAttributes = new Vector();
    Vector _bindingOperations = new Vector();
    Hashtable _ports = new Hashtable(10);
    Vector _bindingExtendedElements = new Vector();
    Vector _boperExtendedElements = new Vector();
    Vector _sigExtendedElements = new Vector();
    Vector _serExtendedElements = new Vector();
    Vector _portExtendedElements = new Vector();
    Hashtable _messages = new Hashtable(12);
    Hashtable _folders = new Hashtable(5);
    Hashtable _bindings = new Hashtable(5);
    Hashtable _services = new Hashtable(5);
    WSD _wsd;
    IData _source;

    public CompilerWorkspace() {
        this._serviceSymbol = new Vector();
        this._bindingSymbol = new Vector();
        this._folderSymbol = new Vector();
        this._messageSymbol = new Vector();
        this._wissStack = new Stack();
    }

    public SymbolComponent[] getMessageSymbols() {
        return CompilerWorkspace.toComponentArray(this._messageSymbol);
    }

    public SymbolComponent[] getFolderSymbols() {
        return CompilerWorkspace.toComponentArray(this._folderSymbol);
    }

    public SymbolComponent[] getBindingSymbols() {
        return CompilerWorkspace.toComponentArray(this._bindingSymbol);
    }

    public SymbolComponent[] getServiceSymbols() {
        return CompilerWorkspace.toComponentArray(this._serviceSymbol);
    }

    public String getTargetNamespace() {
        WSDInfoSet wis = this.getCurrent();
        return wis != null ? wis.getTargetNS() : null;
    }

    public WSDInfoSet getCurrent() {
        return this._wissStack.empty() ? null : (WSDInfoSet)this._wissStack.peek();
    }

    public WSD getWSD() {
        return this._wsd;
    }

    protected Part[] getParts() {
        if (this._parts == null || this._parts.size() == 0) {
            return null;
        }
        int size = this._parts.size();
        Object[] pa = new Part[size];
        this._parts.copyInto(pa);
        return pa;
    }

    protected Signature[] getSignatures() {
        if (this._signatures == null || this._signatures.size() == 0) {
            return null;
        }
        Object[] sa = new Signature[this._signatures.size()];
        this._signatures.copyInto(sa);
        return sa;
    }

    protected ExtendedElement[] getExtendedElements() {
        if (this._extendedElements == null || this._extendedElements.size() == 0) {
            return null;
        }
        Object[] ea = new ExtendedElement[this._extendedElements.size()];
        this._extendedElements.copyInto(ea);
        return ea;
    }

    protected ExtendedElement[] getExtendedElements(int componentType) {
        Vector ee = null;
        switch (componentType) {
            case 3: {
                ee = this._bindingExtendedElements;
                break;
            }
            case 8: {
                ee = this._boperExtendedElements;
                break;
            }
            case 1: {
                ee = this._serExtendedElements;
                break;
            }
            case 2: {
                ee = this._portExtendedElements;
                break;
            }
            case 9: {
                ee = this._sigExtendedElements;
            }
        }
        if (ee == null || ee.size() == 0) {
            return null;
        }
        Object[] ea = new ExtendedElement[ee.size()];
        ee.copyInto(ea);
        return ea;
    }

    protected Operation[] getOperations() {
        if (this._operations == null || this._operations.size() == 0) {
            return null;
        }
        Object[] oa = new Operation[this._operations.size()];
        this._operations.copyInto(oa);
        return oa;
    }

    protected Port[] getPorts() {
        if (this._ports == null || this._ports.size() == 0) {
            return null;
        }
        Object[] pa = new Port[this._ports.size()];
        CompilerWorkspace.hashCopyInto(this._ports, pa);
        return pa;
    }

    protected Service[] getServices() {
        if (this._services == null || this._services.size() == 0) {
            return null;
        }
        Object[] sa = new Service[this._services.size()];
        CompilerWorkspace.hashCopyInto(this._services, sa);
        return sa;
    }

    protected Binding[] getBindings() {
        if (this._bindings == null || this._bindings.size() == 0) {
            return null;
        }
        Object[] ba = new Binding[this._bindings.size()];
        CompilerWorkspace.hashCopyInto(this._bindings, ba);
        return ba;
    }

    protected Folder[] getFolders() {
        if (this._folders == null || this._folders.size() == 0) {
            return null;
        }
        Object[] fa = new Folder[this._folders.size()];
        CompilerWorkspace.hashCopyInto(this._folders, fa);
        return fa;
    }

    protected Message[] getMessages() {
        if (this._messages == null || this._messages.size() == 0) {
            return null;
        }
        Object[] ma = new Message[this._messages.size()];
        CompilerWorkspace.hashCopyInto(this._messages, ma);
        return ma;
    }

    protected OperationBindingInfo[] getBindingOperations() {
        if (this._bindingOperations == null || this._bindingOperations.size() == 0) {
            return null;
        }
        Object[] oa = new OperationBindingInfo[this._bindingOperations.size()];
        this._bindingOperations.copyInto(oa);
        return oa;
    }

    protected ExtendedAttribute[] getExtendAttributes() {
        if (this._extendedAttributes == null || this._extendedAttributes.size() == 0) {
            return null;
        }
        Object[] aa = new ExtendedAttribute[this._extendedAttributes.size()];
        this._extendedAttributes.copyInto(aa);
        return aa;
    }

    private static SymbolComponent[] toComponentArray(Vector vec) {
        if (vec != null) {
            Object[] scArray = new SymbolComponent[vec.size()];
            vec.copyInto(scArray);
            return scArray;
        }
        return null;
    }

    static void hashCopyInto(Hashtable hash, Object[] oa) {
        Enumeration enumvar = hash.elements();
        int i = 0;
        while (enumvar.hasMoreElements()) {
            oa[i] = enumvar.nextElement();
            ++i;
        }
    }

    public void pushCurrent(WSDInfoSet wiss) {
        if (wiss == null) {
            return;
        }
        this._wissStack.push(wiss);
    }

    public void popCurrent() {
        if (!this._wissStack.empty()) {
            this._wissStack.pop();
        }
    }

    public IData packageResults() {
        IData result = super.packageResults();
        IDataCursor idc = result.getCursor();
        IDataUtil.put(idc, "wsdObj", this._wsd);
        IDataUtil.put(idc, "source", this._source);
        return result;
    }
}

