/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl.compiler;

import com.wm.lang.wsdl.Binding;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.Folder;
import com.wm.lang.wsdl.OperationBindingInfo;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.compiler.BindingOperationExp;
import com.wm.lang.wsdl.compiler.CompilerWorkspace;
import com.wm.lang.wsdl.compiler.Expression;
import com.wm.lang.wsdl.compiler.ExtendedElementExp;
import com.wm.lang.wsdl.compiler.SymbolComponent;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.QName;

public class BindingExp
extends Expression {
    public void symbolize(ElementNode node, CompilerWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        boolean bndDef = false;
        for (Node unknown = node.getFirstChildWm(); unknown != null; unknown = unknown.getNextSiblingWm()) {
            QName nm;
            if (unknown.getNodeType() != 1 || !(nm = QName.create(unknown.getNamespaceUri().toString(), unknown.getLocalName())).getNCName().equals("binding")) continue;
            bndDef = true;
            if (nm.equals(WSDLKeys.SOAP_BINDING_1_1) || nm.equals(WSDLKeys.SOAP_BINDING_1_2)) break;
            return;
        }
        if (!bndDef) {
            return;
        }
        QName qname = QName.create(workspace.getTargetNamespace(), node.getAttributeValue(null, NAME));
        SymbolComponent sc = SymbolComponent.create(qname, node);
        workspace._bindingSymbol.addElement(sc);
    }

    public static void translate(ElementNode node, CompilerWorkspace workspace, String baseIdentifier, QName qname) throws WMDocumentException {
        Node unknown = null;
        String comment = null;
        Name temp = null;
        String ncName = node.getAttributeValue(null, NAME);
        baseIdentifier = BindingExp.createIdentifier("binding", ncName);
        for (unknown = node.getFirstChildWm(); unknown != null; unknown = unknown.getNextSiblingWm()) {
            if (unknown.getNodeType() != 1) continue;
            temp = unknown.getLocalNameWm();
            if (temp.equals(DOCUMENTATION)) {
                comment = unknown.getText();
                continue;
            }
            if (temp.equals(OPERATION)) {
                BindingOperationExp.translate((ElementNode)unknown, workspace, baseIdentifier);
                continue;
            }
            ExtendedElementExp.translate((ElementNode)unknown, workspace, baseIdentifier, 3);
        }
        String typeName = node.getAttributeValue(null, TYPE);
        QName typeQName = BindingExp.computeQName(typeName, node, workspace, baseIdentifier);
        Folder folder = (Folder)workspace._folders.get(typeQName);
        ExtendedElement[] ea = workspace.getExtendedElements(3);
        OperationBindingInfo[] oa = workspace.getBindingOperations();
        Binding binding = Binding.create(qname, folder, oa, ea);
        if (comment != null) {
            binding.setComment(comment);
        }
        if (workspace._bindings.containsKey(qname)) {
            System.out.println("_binding should be unique");
        } else {
            workspace._bindings.put(qname, binding);
        }
        if (workspace._bindingOperations != null) {
            workspace._bindingOperations.removeAllElements();
        }
        if (workspace._bindingExtendedElements != null) {
            workspace._bindingExtendedElements.removeAllElements();
        }
    }
}

