/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl;

import com.wm.dom.AttributeNamedNodeMap;
import com.wm.dom.NodeListImpl;
import com.wm.lang.widl.WattException;
import com.wm.lang.wsdl.WSDException;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xql.XqlQuery;
import com.wm.util.Name;
import com.wm.util.URIParser;
import com.wm.util.Values;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;

public class WsdlMerger {
    private static boolean debug = new Boolean(System.getProperty("watt.server.WSDL.debug", "false"));
    private static Values nsDecls = null;

    public String mergeWSDL(String _internalWSDL, String _externalWSDL, String _internalWSDLURL, String _externalWSDLURL, int wsdType) {
        String[] newMessages = null;
        String soapPrefix = "soap";
        boolean mergeMessage = false;
        if (wsdType == 1) {
            return _internalWSDL;
        }
        XqlQuery xqlquery = null;
        try {
            Node parent;
            if (_externalWSDL == null && _externalWSDLURL != null) {
                if (debug) {
                    System.out.println("WsdlMerger : cached external wsdl is null.Try to stream in the external wsdl from external wsdl url");
                }
                InputStream is = Document.getHostServices().getInputStream(_externalWSDLURL);
                InputStreamReader isr = new InputStreamReader(is);
                Document wsdlDoc = new Document((Reader)isr, _externalWSDLURL, null, 1);
                StringBuffer sb = new StringBuffer();
                wsdlDoc.appendGeneratedMarkup(sb);
                _externalWSDL = sb.toString();
            }
            xqlquery = new XqlQuery("/wsdl:definitions/wsdl:types", WsdlMerger.getNSDecls());
            Document internalWsdlDoc = new Document(_internalWSDL, _internalWSDLURL, null, false, true);
            Node intType = xqlquery.getNode(internalWsdlDoc);
            Node intSchemaNode = null;
            Document externalWsdlDoc = new Document(_externalWSDL, _externalWSDLURL, null, false, true);
            Node extType = xqlquery.getNode(externalWsdlDoc);
            Node extSchemaNode = null;
            xqlquery = new XqlQuery("/wsdl:definitions/wsdl:message", WsdlMerger.getNSDecls());
            Node[] intMessageTest = xqlquery.getNodeArray(internalWsdlDoc);
            xqlquery = new XqlQuery("/wsdl:definitions/wsdl:service/wsdl:port", WsdlMerger.getNSDecls());
            Node[] port = xqlquery.getNodeArray(internalWsdlDoc);
            Node soapAdd = null;
            if (port.length > 0) {
                soapAdd = (Node)port[0].getFirstChild();
            }
            while (soapAdd != null) {
                Node tempNode = soapAdd.getNextSiblingWm();
                if (soapAdd instanceof ElementNode && soapAdd.getLocalName() != null && soapAdd.getLocalName().equalsIgnoreCase("address")) {
                    String sp = soapAdd.getPrefix();
                    if (sp == null || sp.trim().equals("")) break;
                    soapPrefix = sp;
                    break;
                }
                soapAdd = tempNode;
            }
            if (debug) {
                System.out.println("WsdlMerger : saop prefix=" + soapPrefix);
            }
            if (intMessageTest == null || intMessageTest.length <= 0) {
                if (debug) {
                    System.out.println("WsdlMerger :  No new header/fault added; no megring done for header/fault. wsdl:message=[" + intMessageTest + "].wsdl:type[" + intType + "].");
                }
            } else {
                mergeMessage = true;
                if (intType != null) {
                    intSchemaNode = (Node)intType.getFirstChild();
                }
                while (intSchemaNode != null) {
                    Attribute intAttr;
                    AttributeNamedNodeMap intAttributes;
                    String intTns = null;
                    Node tempNode = intSchemaNode.getNextSiblingWm();
                    if (intSchemaNode instanceof ElementNode && (intAttributes = (AttributeNamedNodeMap)intSchemaNode.getAttributes()) != null && (intAttr = (Attribute)intAttributes.getNamedItem("targetNamespace")) != null) {
                        intTns = intAttr.getNodeValue();
                        if (extType != null) {
                            extSchemaNode = (Node)extType.getFirstChild();
                        }
                        boolean matchingNSFound = false;
                        while (extSchemaNode != null) {
                            Attribute extAttr;
                            AttributeNamedNodeMap extAttributes;
                            String extTns = null;
                            Node tempNode1 = extSchemaNode.getNextSiblingWm();
                            if (extSchemaNode instanceof ElementNode && (extAttributes = (AttributeNamedNodeMap)extSchemaNode.getAttributes()) != null && (extAttr = (Attribute)extAttributes.getNamedItem("targetNamespace")) != null && (extTns = extAttr.getNodeValue()) != null && extTns.equals(intTns)) {
                                if (debug) {
                                    System.out.println("WsdlMerger : found matching schema element in internal wsdl for tns=[" + intTns + "].");
                                }
                                matchingNSFound = true;
                                break;
                            }
                            extSchemaNode = tempNode1;
                        }
                        if (matchingNSFound && extSchemaNode != null) {
                            Node intSchemaElement = (Node)intSchemaNode.getFirstChild();
                            if (debug) {
                                System.out.println("WsdlMerger : merging schema element for tns=[" + intTns + "].");
                            }
                            while (intSchemaElement != null) {
                                Node tempNode2 = intSchemaElement.getNextSiblingWm();
                                Node parent2 = intSchemaElement.getParent();
                                parent2.removeChild(intSchemaElement);
                                if (!this.alreadyExist(extSchemaNode, intSchemaElement)) {
                                    extSchemaNode.insertBefore(intSchemaElement, extSchemaNode.getLastChild());
                                }
                                intSchemaElement = tempNode2;
                            }
                            NamespaceDecl nsd = intSchemaNode.getFirstNamespaceDecl();
                            while (nsd != null) {
                                Name name = nsd.getPrefixWm();
                                Name uri = nsd.getUri();
                                extSchemaNode.assignNamespaceDecl(name, uri);
                                nsd = intSchemaNode.getNextNamespaceDecl(nsd);
                            }
                        } else {
                            parent = intSchemaNode.getParent();
                            parent.removeChild(intSchemaNode);
                            if (extType != null) {
                                extType.insertBefore(intSchemaNode, extType.getLastChild());
                            }
                        }
                        if (debug) {
                            System.out.println("WsdlMerger : added external schema element for tns=[" + intTns + "].");
                        }
                    }
                    intSchemaNode = tempNode;
                }
                xqlquery = new XqlQuery("/wsdl:definitions", WsdlMerger.getNSDecls());
                Node extDefination = xqlquery.getNode(externalWsdlDoc);
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:message", WsdlMerger.getNSDecls());
                Node[] extMessages = xqlquery.getNodeArray(externalWsdlDoc);
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:message", WsdlMerger.getNSDecls());
                Node[] intMessages = xqlquery.getNodeArray(internalWsdlDoc);
                if (extDefination != null && extMessages != null && intMessages != null && extMessages.length > 0 && intMessages.length > 0) {
                    newMessages = new String[intMessages.length];
                    for (int i = 0; i < intMessages.length; ++i) {
                        if (intMessages[i] == null) continue;
                        AttributeNamedNodeMap intMessageAttributes = (AttributeNamedNodeMap)intMessages[i].getAttributes();
                        if (intMessageAttributes != null && intMessageAttributes.getNamedItem("name") != null) {
                            newMessages[i] = ((Attribute)intMessageAttributes.getNamedItem("name")).getNodeValue();
                        }
                        if (debug) {
                            System.out.println("WsdlMerger :  adding wsdl:message [" + i + "/" + intMessages.length + "] = " + newMessages);
                        }
                        parent = intMessages[i].getParent();
                        parent.removeChild(intMessages[i]);
                        if (this.alreadyExist(extMessages, intMessages[i])) continue;
                        extDefination.insertBefore(intMessages[i], extMessages[0]);
                    }
                }
                for (int i = 0; newMessages != null && i < newMessages.length; ++i) {
                    Node parent3;
                    String msg;
                    String tgtExtBinding;
                    String tgtExtOperation;
                    int cntExtNode;
                    Node[] tmpExtNode;
                    XqlQuery xqlquery1;
                    String msg2;
                    String tmpBindingName;
                    String tmpOperationName;
                    String tmpMsgName;
                    int j;
                    XqlQuery xqlquery0 = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation/wsdl:input/" + soapPrefix + ":header", WsdlMerger.getNSDecls());
                    Node[] intSoapHeader = xqlquery0.getNodeArray(internalWsdlDoc);
                    block25: for (j = 0; intSoapHeader != null && j < intSoapHeader.length; ++j) {
                        if (debug) {
                            System.out.println("WsdlMerger : Scrolling node type:" + intSoapHeader[j].getLocalName() + "==" + intSoapHeader[j].getLocalNameWm());
                        }
                        if (intSoapHeader[j].getLocalName() == null || !intSoapHeader[j].getLocalName().equals("header")) continue;
                        AttributeNamedNodeMap intSoapHeaderAttributes = (AttributeNamedNodeMap)intSoapHeader[j].getAttributes();
                        tmpMsgName = null;
                        tmpOperationName = null;
                        tmpBindingName = null;
                        if (intSoapHeaderAttributes != null && intSoapHeaderAttributes.getNamedItem("message") != null) {
                            tmpMsgName = ((Attribute)intSoapHeaderAttributes.getNamedItem("message")).getNodeValue();
                        }
                        if (tmpMsgName == null) continue;
                        if (tmpMsgName.indexOf(58) > -1) {
                            tmpMsgName = tmpMsgName.substring(tmpMsgName.indexOf(58) + 1);
                        }
                        if (debug) {
                            System.out.println("WsdlMerger : Scrolling input Header/fault of internal wsdl:" + tmpMsgName);
                        }
                        if (!tmpMsgName.equals(newMessages[i])) continue;
                        try {
                            tmpOperationName = intSoapHeader[j].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            tmpBindingName = intSoapHeader[j].getParent().getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            if (debug) {
                                System.out.println("WsdlMerger : Matching input Header found in internal wsdl :" + tmpMsgName + ",in operation:" + tmpOperationName + ",in binding:" + tmpBindingName);
                            }
                        }
                        catch (Exception e) {
                            msg2 = "WsdlMerger_Error in retriving matched input Header in internal wsdl :" + tmpMsgName + ",in operation:" + tmpOperationName + ",in binding:" + tmpBindingName;
                            if (debug) {
                                System.out.println(msg2);
                            }
                            throw new Exception(msg2 + "---" + e.getMessage());
                        }
                        xqlquery1 = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation/wsdl:input", WsdlMerger.getNSDecls());
                        tmpExtNode = xqlquery1.getNodeArray(externalWsdlDoc);
                        for (cntExtNode = 0; tmpExtNode != null && cntExtNode < tmpExtNode.length; ++cntExtNode) {
                            tgtExtOperation = null;
                            tgtExtBinding = null;
                            try {
                                tgtExtOperation = tmpExtNode[cntExtNode].getParent().getAttributes().getNamedItem("name").getNodeValue();
                                tgtExtBinding = tmpExtNode[cntExtNode].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            }
                            catch (Exception e) {
                                msg = "WsdlMerger_Error in scrolling through input Header in external wsdl :" + tmpMsgName + ",in operation:" + tgtExtOperation + ",in binding:" + tgtExtBinding;
                                if (debug) {
                                    System.out.println(msg);
                                }
                                throw new Exception(msg + "---" + e.getMessage());
                            }
                            if (!tmpOperationName.equals(tgtExtOperation) || !tmpBindingName.equals(tgtExtBinding)) continue;
                            parent3 = intSoapHeader[j].getParent();
                            parent3.removeChild(intSoapHeader[j]);
                            tmpExtNode[cntExtNode].insertBefore(intSoapHeader[j], tmpExtNode[cntExtNode].getLastChild());
                            if (!debug) continue block25;
                            System.out.println("WsdlMerger : Matching input Header inserted  in external wsdl :" + tmpMsgName + ",in operation:" + tmpOperationName + ",in binding:" + tmpBindingName);
                            continue block25;
                        }
                    }
                    xqlquery0 = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation/wsdl:output/" + soapPrefix + ":header", WsdlMerger.getNSDecls());
                    intSoapHeader = xqlquery0.getNodeArray(internalWsdlDoc);
                    block27: for (j = 0; intSoapHeader != null && j < intSoapHeader.length; ++j) {
                        AttributeNamedNodeMap intSoapHeaderAttributes = (AttributeNamedNodeMap)intSoapHeader[j].getAttributes();
                        tmpMsgName = null;
                        tmpOperationName = null;
                        tmpBindingName = null;
                        if (intSoapHeaderAttributes != null) {
                            tmpMsgName = ((Attribute)intSoapHeaderAttributes.getNamedItem("message")).getNodeValue();
                        }
                        if (tmpMsgName == null) continue;
                        if (tmpMsgName.indexOf(58) > -1) {
                            tmpMsgName = tmpMsgName.substring(tmpMsgName.indexOf(58) + 1);
                        }
                        if (debug) {
                            System.out.println("WsdlMerger : Scrolling output Header of internal wsdl:" + tmpMsgName);
                        }
                        if (!tmpMsgName.equals(newMessages[i])) continue;
                        try {
                            tmpOperationName = intSoapHeader[j].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            tmpBindingName = intSoapHeader[j].getParent().getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            if (debug) {
                                System.out.println("WsdlMerger : Matching output Header found in internal wsdl :" + tmpMsgName + ",in operation:" + tmpOperationName + ",in binding:" + tmpBindingName);
                            }
                        }
                        catch (Exception e) {
                            msg2 = "WsdlMerger_Error in retriving matched output Header in internal wsdl :" + tmpMsgName + ",in operation:" + tmpOperationName + ",in binding:" + tmpBindingName;
                            if (debug) {
                                System.out.println(msg2);
                            }
                            throw new Exception(msg2 + "---" + e.getMessage());
                        }
                        xqlquery1 = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation/wsdl:output", WsdlMerger.getNSDecls());
                        tmpExtNode = xqlquery1.getNodeArray(externalWsdlDoc);
                        for (cntExtNode = 0; tmpExtNode != null && cntExtNode < tmpExtNode.length; ++cntExtNode) {
                            tgtExtOperation = null;
                            tgtExtBinding = null;
                            try {
                                tgtExtOperation = tmpExtNode[cntExtNode].getParent().getAttributes().getNamedItem("name").getNodeValue();
                                tgtExtBinding = tmpExtNode[cntExtNode].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            }
                            catch (Exception e) {
                                msg = "WsdlMerger_Error in scrolling through output Header in external wsdl :" + tmpMsgName + ",in operation:" + tgtExtOperation + ",in binding:" + tgtExtBinding;
                                if (debug) {
                                    System.out.println(msg);
                                }
                                throw new Exception(msg + "---" + e.getMessage());
                            }
                            if (!tmpOperationName.equals(tgtExtOperation) || !tmpBindingName.equals(tgtExtBinding)) continue;
                            if (debug) {
                                System.out.println("WsdlMerger : Matching Header/fault destination found in external wsdl :" + tmpMsgName + ",in operation:" + tmpOperationName + ",in binding:" + tmpBindingName);
                            }
                            parent3 = intSoapHeader[j].getParent();
                            parent3.removeChild(intSoapHeader[j]);
                            tmpExtNode[cntExtNode].insertBefore(intSoapHeader[j], tmpExtNode[cntExtNode].getLastChild());
                            continue block27;
                        }
                    }
                    xqlquery0 = new XqlQuery("/wsdl:definitions/wsdl:portType/wsdl:operation/wsdl:fault", WsdlMerger.getNSDecls());
                    Node[] wsdlFaults = xqlquery0.getNodeArray(internalWsdlDoc);
                    block29: for (int j2 = 0; wsdlFaults != null && j2 < wsdlFaults.length; ++j2) {
                        AttributeNamedNodeMap intWsdlFaultAttributes = (AttributeNamedNodeMap)wsdlFaults[j2].getAttributes();
                        String tmpMsgName2 = null;
                        String tmpOperationName2 = null;
                        Object tmpBindingName2 = null;
                        String tmpFaultName = null;
                        String tmpPortTypeName = null;
                        if (intWsdlFaultAttributes != null) {
                            tmpMsgName2 = ((Attribute)intWsdlFaultAttributes.getNamedItem("message")).getNodeValue();
                        }
                        if (tmpMsgName2 == null) continue;
                        if (tmpMsgName2.indexOf(58) > -1) {
                            tmpMsgName2 = tmpMsgName2.substring(tmpMsgName2.indexOf(58) + 1);
                        }
                        if (debug) {
                            System.out.println("WsdlMerger : Scrolling input fault of internal wsdl:" + tmpMsgName2);
                        }
                        if (!tmpMsgName2.equals(newMessages[i])) continue;
                        try {
                            tmpFaultName = wsdlFaults[j2].getAttributes().getNamedItem("name").getNodeValue();
                            tmpOperationName2 = wsdlFaults[j2].getParent().getAttributes().getNamedItem("name").getNodeValue();
                            tmpPortTypeName = wsdlFaults[j2].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                            if (debug) {
                                System.out.println("WsdlMerger : Matching fault found in internal wsdl :" + tmpMsgName2 + ",in operation:" + tmpOperationName2 + ",in portType:" + tmpPortTypeName);
                            }
                        }
                        catch (Exception e) {
                            String msg3 = "WsdlMerger_Error in retriving matched fault in internal wsdl :" + tmpMsgName2 + ",in operation:" + tmpOperationName2 + ",in portType:" + tmpPortTypeName;
                            if (debug) {
                                System.out.println(msg3);
                            }
                            throw new Exception(msg3 + "---" + e.getMessage());
                        }
                        XqlQuery xqlquery12 = new XqlQuery("/wsdl:definitions/wsdl:portType/wsdl:operation", WsdlMerger.getNSDecls());
                        Node[] tmpExtNode2 = xqlquery12.getNodeArray(externalWsdlDoc);
                        for (int cntExtNode2 = 0; tmpExtNode2 != null && cntExtNode2 < tmpExtNode2.length; ++cntExtNode2) {
                            String tgtExtOperation2 = null;
                            String tgtExtPortType = null;
                            try {
                                tgtExtOperation2 = tmpExtNode2[cntExtNode2].getAttributes().getNamedItem("name").getNodeValue();
                                tgtExtPortType = tmpExtNode2[cntExtNode2].getParent().getAttributes().getNamedItem("name").getNodeValue();
                            }
                            catch (Exception e) {
                                String msg4 = "WsdlMerger_Error in scrolling through portType fault in external wsdl :" + tmpMsgName2 + ",in operation:" + tmpOperationName2 + ",in portType:" + tmpPortTypeName;
                                if (debug) {
                                    System.out.println(msg4);
                                }
                                throw new Exception(msg4 + "---" + e.getMessage());
                            }
                            if (!tmpOperationName2.equals(tgtExtOperation2) || !tmpPortTypeName.equals(tgtExtPortType)) continue;
                            Node parent4 = wsdlFaults[j2].getParent();
                            parent4.removeChild(wsdlFaults[j2]);
                            tmpExtNode2[cntExtNode2].insertBefore(wsdlFaults[j2], tmpExtNode2[cntExtNode2].getLastChild());
                            if (!debug) break;
                            System.out.println("WsdlMerger : Matching portType fault inserted in external wsdl :" + tmpMsgName2 + ",in operation:" + tmpOperationName2 + ",in portType:" + tmpPortTypeName);
                            break;
                        }
                        XqlQuery xqlquery2 = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation/wsdl:fault", WsdlMerger.getNSDecls());
                        Node[] tmpIntNode = xqlquery2.getNodeArray(internalWsdlDoc);
                        Node targetInternalBindingfault = null;
                        for (int cntIntNode = 0; tmpIntNode != null && cntIntNode < tmpIntNode.length; ++cntIntNode) {
                            String tgtIntOperation = null;
                            String tgtIntPortType = null;
                            String tgtFaultName = null;
                            try {
                                tgtIntOperation = tmpIntNode[cntIntNode].getParent().getAttributes().getNamedItem("name").getNodeValue();
                                tgtIntPortType = tmpIntNode[cntIntNode].getParent().getParent().getAttributes().getNamedItem("type").getNodeValue();
                                tgtFaultName = tmpIntNode[cntIntNode].getAttributes().getNamedItem("name").getNodeValue();
                            }
                            catch (Exception e) {
                                String msg5 = "WsdlMerger_Error in scrolling through corresponding binding fault in internal wsdl :" + tmpMsgName2 + ",in operation:" + tgtIntOperation + ",in portType:" + tgtIntPortType;
                                if (debug) {
                                    System.out.println(msg5);
                                }
                                throw new Exception(msg5 + "---" + e.getMessage());
                            }
                            if (!tgtIntPortType.endsWith(tmpPortTypeName) || !tmpOperationName2.equals(tgtIntOperation) || !tmpFaultName.equals(tmpFaultName)) continue;
                            if (debug) {
                                System.out.println("WsdlMerger : found right binding fault in internal wsdl:" + tmpMsgName2 + ",in operation:" + tgtIntOperation + ",in portType:" + tgtIntPortType);
                            }
                            targetInternalBindingfault = tmpIntNode[cntIntNode];
                            break;
                        }
                        XqlQuery xqlquery3 = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation", WsdlMerger.getNSDecls());
                        tmpExtNode2 = xqlquery3.getNodeArray(externalWsdlDoc);
                        for (int cntExtNode3 = 0; tmpExtNode2 != null && cntExtNode3 < tmpExtNode2.length; ++cntExtNode3) {
                            String tgtExtOperation3 = null;
                            String tgtExtPortType = null;
                            try {
                                tgtExtOperation3 = tmpExtNode2[cntExtNode3].getAttributes().getNamedItem("name").getNodeValue();
                                tgtExtPortType = tmpExtNode2[cntExtNode3].getParent().getAttributes().getNamedItem("type").getNodeValue();
                            }
                            catch (Exception e) {
                                String msg6 = "WsdlMerger_Error in scrolling through binding fault in external wsdl :" + tmpMsgName2 + ",in operation:" + tgtExtOperation3 + ",in portType:" + tgtExtPortType;
                                if (debug) {
                                    System.out.println(msg6);
                                }
                                throw new Exception(msg6 + "---" + e.getMessage());
                            }
                            if (!tgtExtPortType.endsWith(":" + tmpPortTypeName) || !tmpOperationName2.equals(tgtExtOperation3)) continue;
                            Node parent5 = targetInternalBindingfault.getParent();
                            parent5.removeChild(targetInternalBindingfault);
                            tmpExtNode2[cntExtNode3].insertBefore(targetInternalBindingfault, tmpExtNode2[cntExtNode3].getLastChild());
                            if (!debug) continue block29;
                            System.out.println("WsdlMerger : matching wsdl:binding/wsdl:operation/wsdl:fault inserted to external wsdl :" + tmpMsgName2 + ",in operation:" + tgtExtOperation3 + ",in portType:" + tgtExtPortType);
                            continue block29;
                        }
                    }
                }
            }
            if (wsdType == 2) {
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:binding /wsdl:operation/" + soapPrefix + ":operation", WsdlMerger.getNSDecls());
                Node[] soapOperation = xqlquery.getNodeArray(internalWsdlDoc);
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:binding /wsdl:operation/" + soapPrefix + ":operation", WsdlMerger.getNSDecls());
                Node[] soapExtOperation = xqlquery.getNodeArray(externalWsdlDoc);
                block33: for (int cnt = 0; soapOperation != null && cnt < soapOperation.length; ++cnt) {
                    String operation = soapOperation[cnt].getParent().getAttributes().getNamedItem("name").getNodeValue();
                    String binding = soapOperation[cnt].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                    String soapAction = null;
                    AttributeNamedNodeMap SOAttributes = (AttributeNamedNodeMap)soapOperation[cnt].getAttributes();
                    Attribute soapActionAttr = null;
                    if (SOAttributes != null) {
                        soapActionAttr = (Attribute)SOAttributes.getNamedItem("soapAction");
                    }
                    if (soapActionAttr != null) {
                        soapAction = soapActionAttr.getNodeValue();
                    }
                    for (int cnt1 = 0; soapAction != null && soapExtOperation != null && cnt1 < soapExtOperation.length; ++cnt1) {
                        if (soapExtOperation[cnt1] == null) continue;
                        String extoperation = soapExtOperation[cnt1].getParent().getAttributes().getNamedItem("name").getNodeValue();
                        String extbinding = soapExtOperation[cnt1].getParent().getParent().getAttributes().getNamedItem("name").getNodeValue();
                        if (!operation.equals(extoperation) || !binding.equals(extbinding)) continue;
                        AttributeNamedNodeMap extSOAttributes = (AttributeNamedNodeMap)soapExtOperation[cnt1].getAttributes();
                        Attribute extSoapActionAttr = null;
                        if (extSOAttributes != null) {
                            extSoapActionAttr = (Attribute)extSOAttributes.getNamedItem("soapAction");
                        }
                        if (extSoapActionAttr != null) {
                            extSoapActionAttr.setNodeValue(soapAction);
                            if (debug) {
                                System.out.println("WsdlMerger : SoapAction update to :" + soapAction + "in operation:" + extoperation + ",in binding:" + extbinding);
                            }
                        } else if (extSOAttributes != null) {
                            extSOAttributes.setNamedItem(soapActionAttr);
                            if (debug) {
                                System.out.println("WsdlMerger : SoapAction added to :" + soapAction + "in operation:" + extoperation + ",in binding:" + extbinding);
                            }
                        }
                        soapExtOperation[cnt1] = null;
                        continue block33;
                    }
                }
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:service", WsdlMerger.getNSDecls());
                Node extService = xqlquery.getNode(externalWsdlDoc);
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:service", WsdlMerger.getNSDecls());
                Node intService = xqlquery.getNode(internalWsdlDoc);
                xqlquery = new XqlQuery("/wsdl:definitions", WsdlMerger.getNSDecls());
                Node extDef = xqlquery.getNode(externalWsdlDoc);
                parent = intService.getParent();
                parent.removeChild(intService);
                extDef.insertBefore(intService, extService);
                extDef.removeChild(extService);
                if (debug) {
                    System.out.println("WsdlMerger : wsdl:service updated");
                }
            }
            if (mergeMessage || wsdType == 2) {
                xqlquery = new XqlQuery("/wsdl:definitions", WsdlMerger.getNSDecls());
                Node extDef = xqlquery.getNode(externalWsdlDoc);
                xqlquery = new XqlQuery("/wsdl:definitions", WsdlMerger.getNSDecls());
                Node intDef = xqlquery.getNode(internalWsdlDoc);
                NamespaceDecl nsd = intDef.getFirstNamespaceDecl();
                while (nsd != null) {
                    Name name = nsd.getPrefixWm();
                    Name uri = nsd.getUri();
                    extDef.assignNamespaceDecl(name, uri);
                    if (debug) {
                        System.out.println("WsdlMerger : NamespaceDecl updated in external wsdl defination = prefix:" + name + "-" + uri);
                    }
                    nsd = intDef.getNextNamespaceDecl(nsd);
                }
            }
            StringBuffer sb = new StringBuffer();
            externalWsdlDoc.appendGeneratedMarkup(sb);
            return sb.toString();
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("WsdlMerger_Erorr!!! in merging wsdl. Dumping internal  wsdl for refrence:---\n" + _internalWSDL);
            }
            if (debug) {
                System.out.println("WsdlMerger_Erorr!!! in merging wsdl. Returning unmerged external wsdl-------\n" + e);
            }
            return _externalWSDL;
        }
    }

    public static synchronized Values getNSDecls() {
        if (nsDecls == null) {
            nsDecls = new Values();
            nsDecls.put("wsdl", Name.create("http://schemas.xmlsoap.org/wsdl/"));
            nsDecls.put("xsd", Name.create("http://www.w3.org/2001/XMLSchema"));
            nsDecls.put("xml", Name.create("http://www.w3.org/XML/1998/namespace"));
            nsDecls.put("xsi", Name.create("http://www.w3.org/2001/XMLSchema-instance"));
        }
        return nsDecls;
    }

    private boolean alreadyExist(Node destinationParent, Node sourceChild) {
        boolean exist = false;
        NodeListImpl allNodes = (NodeListImpl)destinationParent.getChildNodes();
        for (int i = 0; allNodes != null && i < allNodes.getLength(); ++i) {
            if (!(allNodes.item(i) instanceof Node) || !this.compare((Node)allNodes.item(i), sourceChild)) continue;
            return true;
        }
        return exist;
    }

    private boolean alreadyExist(Node[] allNodes, Node sourceChild) {
        boolean exist = false;
        for (int i = 0; allNodes != null && i < allNodes.length; ++i) {
            if (!this.compare(allNodes[i], sourceChild)) continue;
            return true;
        }
        return exist;
    }

    private boolean compare(Node destChild, Node sourceChild) {
        boolean exist = false;
        if (sourceChild != null && sourceChild instanceof ElementNode && destChild != null && destChild instanceof ElementNode) {
            ElementNode sourceNode = (ElementNode)sourceChild;
            ElementNode tmpNode = (ElementNode)destChild;
            if (tmpNode.getTagName().equals(sourceNode.getTagName())) {
                String tmpAtt = null;
                String sourceAtt = null;
                if (tmpNode.getFirstAttribute() != null) {
                    tmpAtt = tmpNode.getFirstAttribute().getValue();
                }
                if (sourceNode.getFirstAttribute() != null) {
                    sourceAtt = sourceNode.getFirstAttribute().getValue();
                }
                if (tmpAtt != null && tmpAtt.equals(sourceAtt)) {
                    return true;
                }
            }
        }
        return exist;
    }

    public Document convertRelativeURIs(Document wsdlDoc, String baseURI) throws WSDException {
        Document retDoc = null;
        if (wsdlDoc != null && baseURI != null) {
            try {
                XqlQuery xqlquery = null;
                xqlquery = new XqlQuery("/wsdl:definitions/wsdl:types", WsdlMerger.getNSDecls());
                Node types = xqlquery.getNode(wsdlDoc);
                Node schemaNode = null;
                if (types != null) {
                    schemaNode = (Node)types.getFirstChild();
                    while (schemaNode != null) {
                        Node tempNode = schemaNode.getNextSiblingWm();
                        if (schemaNode instanceof ElementNode) {
                            if (this.updateSchemaLocation("/xsd:import", "schemaLocation", schemaNode, wsdlDoc, baseURI)) {
                                retDoc = wsdlDoc;
                            }
                            if (this.updateSchemaLocation("/xsd:include", "schemaLocation", schemaNode, wsdlDoc, baseURI)) {
                                retDoc = wsdlDoc;
                            }
                            if (this.updateSchemaLocation("/xsd:redefine", "schemaLocation", schemaNode, wsdlDoc, baseURI)) {
                                retDoc = wsdlDoc;
                            }
                            if (this.updateSchemaLocation("/wsdl:import", "location", schemaNode, wsdlDoc, baseURI)) {
                                retDoc = wsdlDoc;
                            }
                            if (this.updateSchemaLocation("/wsdl:include", "location", schemaNode, wsdlDoc, baseURI)) {
                                retDoc = wsdlDoc;
                            }
                        }
                        schemaNode = tempNode;
                    }
                }
            }
            catch (WattException ex) {
                if (debug) {
                    System.out.println("WsdlMerger_Erorr!!! in ConvertRelativeURI:---\n");
                    ex.printStackTrace();
                }
                throw new WSDException(ex);
            }
        }
        return retDoc;
    }

    private boolean updateSchemaLocation(String elementName, String attributeName, Node schemaNode, Document wsdlDoc, String base) throws WSDException {
        boolean replaced = false;
        Node[] nodes = null;
        try {
            XqlQuery xqlquery = new XqlQuery(elementName, WsdlMerger.getNSDecls());
            nodes = xqlquery.getNodeArray(schemaNode);
        }
        catch (WattException ex) {
            if (debug) {
                ex.printStackTrace();
            }
            throw new WSDException(ex);
        }
        for (int i = 0; nodes != null && nodes.length > i; ++i) {
            Attribute attr;
            AttributeNamedNodeMap attributes = (AttributeNamedNodeMap)nodes[i].getAttributes();
            if (attributes == null || (attr = (Attribute)attributes.getNamedItem(attributeName)) == null) continue;
            String schemaLoc = null;
            schemaLoc = attr.getNodeValue();
            if (schemaLoc == null) continue;
            try {
                URI locUri = new URI(schemaLoc);
                if (locUri.isAbsolute()) continue;
                URI baseUri = new URI(URIParser.normalizeFileURL(base));
                locUri = baseUri.resolve(locUri);
                if (debug) {
                    System.out.println(elementName + " " + attributeName + " " + schemaLoc + " changed to:" + locUri.toString());
                }
                attr.setNodeValue(URIParser.normalizeFileURL(locUri.toString()));
                replaced = true;
                continue;
            }
            catch (URISyntaxException ex) {
                if (debug) {
                    System.out.println("WsdlMerger_Erorr!!! in ConvertRelativeURI:---\n");
                    ex.printStackTrace();
                }
                throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.INVALID_URI_SYNTAX, "", new String[]{attributeName, elementName, base, schemaLoc});
            }
        }
        return replaced;
    }
}

