/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.Namespace;
import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import java.util.Locale;
import java.util.Vector;

public class WSDWorkspace {
    private static final boolean debug = false;
    public NSName b2bQName;
    public Namespace ns;
    public NSPackage pkg;
    public Locale locale;
    public boolean _wsi;
    private Vector _errors = new Vector(10);
    private Vector _warnings = new Vector(10);
    private boolean _useCode = true;

    public void addError(String identifier, String errorCode, LocalizedMessage errorMessage) {
        Values error = new Values();
        error.put("identifier", identifier);
        if (this._useCode) {
            error.put("errorCode", errorCode);
        }
        error.put("errorMessage", errorMessage.getLocalizedMessage(this.locale));
        this._errors.addElement(error);
    }

    public void addError(String identifier, String source, String errorCode, LocalizedMessage errorMessage) {
        Values error = new Values();
        error.put("identifier", identifier);
        error.put("source", source);
        if (this._useCode) {
            error.put("errorCode", errorCode);
        }
        error.put("errorMessage", errorMessage.getLocalizedMessage(this.locale));
        this._errors.addElement(error);
    }

    public void addError(LocalizedMessage errorMessage) {
        Values error = new Values();
        error.put("errorMessage", errorMessage.getLocalizedMessage(this.locale));
        this._errors.addElement(error);
    }

    public Values[] getErrors() {
        int size = this._errors.size();
        if (size > 0) {
            Object[] vArray = new Values[size];
            this._errors.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    public void addWarning(String identifier, String warningCode, LocalizedMessage warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        if (this._useCode) {
            warning.put("warningCode", warningCode);
        }
        warning.put("warningMessage", warningMessage.getLocalizedMessage(this.locale));
        this._warnings.addElement(warning);
    }

    public void addWarning(String identifier, String source, String warningCode, LocalizedMessage warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("source", source);
        if (this._useCode) {
            warning.put("warningCode", warningCode);
        }
        warning.put("warningMessage", warningMessage.getLocalizedMessage(this.locale));
        this._warnings.addElement(warning);
    }

    public void addWarning(String warningCode, LocalizedMessage warningMessage) {
        Values warning = new Values(4);
        if (this._useCode) {
            warning.put("warningCode", warningCode);
        }
        warning.put("warningMessage", warningMessage.getLocalizedMessage(this.locale));
        this._warnings.addElement(warning);
    }

    public void addWarning(String warningMessage) {
        Values warning = new Values(4);
        warning.put("warningMessage", warningMessage);
        this._warnings.addElement(warning);
    }

    public Values[] getWarnings() {
        int size = this._warnings.size();
        if (size > 0) {
            Object[] vArray = new Values[size];
            this._warnings.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    public boolean isWSI() {
        return this._wsi;
    }

    public void setWSI(boolean wsi) {
        this._wsi = wsi;
    }

    public void seUseErrorCode(boolean useCode) {
        this._useCode = useCode;
    }

    public IData packageResults() {
        IData result = IDataFactory.create();
        IDataCursor idc = result.getCursor();
        IDataUtil.put(idc, "isSuccessful", new Boolean(this._errors.size() <= 0).toString());
        IDataUtil.put(idc, "warnings", this.getWarnings());
        IDataUtil.put(idc, "errors", this.getErrors());
        idc.destroy();
        return result;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

