/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl;

import com.wm.data.IData;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SimpleTypeUtil;
import com.wm.lang.schema.W3CNamespaces;
import com.wm.lang.schema.conv.Converter;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.websvc.WSBody;
import com.wm.lang.websvc.WSOperation;
import com.wm.lang.websvc.WSReqMessage;
import com.wm.lang.websvc.WSRespMessage;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Part;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.util.Values;
import java.util.Locale;
import java.util.Vector;

public class WSDUtil {
    static final boolean debug = false;
    Vector _errors = new Vector(10);
    Vector _warnings = new Vector(10);
    IData _usedURIPrefixPairs = null;
    NSSchema[] _schemas = null;
    Vector _nodesPersisted = null;

    public WSDUtil(NSSchema[] schemas, Vector nodes) {
        this._schemas = schemas;
        this._nodesPersisted = nodes;
    }

    private boolean genRecords(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, QName root, boolean verbose, Locale locale, boolean useNCName, String universalNs) throws Exception {
        Object wrn;
        NSRecord[] records;
        useNCName = false;
        boolean isSuccessful = false;
        Values result = Converter.wsdlConvert(ns, pkg, ifcName, recordName, partName, attrPrefix, this._schemas, root, verbose, locale, useNCName, universalNs);
        isSuccessful = result.getBoolean("isSuccessful");
        if (!isSuccessful) {
            this._errors.addElement(result.get("errors"));
        }
        if ((records = (NSRecord[])result.get("NSRECORDS")) != null) {
            for (int ind = 0; ind < records.length; ++ind) {
                this._nodesPersisted.insertElementAt(records[ind], 0);
            }
        }
        if (result.containsKey("warnings") && (wrn = result.get("warnings")) != null) {
            this._warnings.addElement(wrn);
        }
        if (result.containsKey("usedPrefixURIPairs")) {
            IData srcPairs = (IData)result.get("usedPrefixURIPairs");
            if (this._usedURIPrefixPairs != null) {
                IDataUtil.merge(srcPairs, this._usedURIPrefixPairs);
            } else {
                this._usedURIPrefixPairs = srcPairs;
            }
        }
        return isSuccessful;
    }

    private boolean genRecordsFromType(Namespace ns, NSPackage pkg, String ifcName, String recordName, String partName, String attrPrefix, QName root, boolean verbose, Locale locale, boolean useNCName, String universalNs) throws Exception {
        Object wrn;
        NSRecord[] records;
        useNCName = false;
        boolean isSuccessful = false;
        Values result = Converter.wsdlConvertFromType(ns, pkg, ifcName, recordName, partName, attrPrefix, this._schemas, root, verbose, locale, useNCName, universalNs);
        isSuccessful = result.getBoolean("isSuccessful");
        if (!isSuccessful) {
            this._errors.addElement(result.get("errors"));
        }
        if ((records = (NSRecord[])result.get("NSRECORDS")) != null) {
            for (int ind = 0; ind < records.length; ++ind) {
                this._nodesPersisted.insertElementAt(records[ind], 0);
            }
        }
        if (result.containsKey("warnings") && (wrn = result.get("warnings")) != null) {
            this._warnings.addElement(wrn);
        }
        if (result.containsKey("usedPrefixURIPairs")) {
            IData srcPairs = (IData)result.get("usedPrefixURIPairs");
            if (this._usedURIPrefixPairs != null) {
                IDataUtil.merge(srcPairs, this._usedURIPrefixPairs);
            } else {
                this._usedURIPrefixPairs = srcPairs;
            }
        }
        return isSuccessful;
    }

    public String genRecords(String recordName, Message msg, String[] parts, Namespace ns, NSPackage pkg, String ifcName, String attrPrefix, boolean verbose, Locale locale, String universalName) throws Exception {
        boolean isRPC = msg.useSoapRpc();
        Part[] pa = msg.getParts();
        String nodeName = recordName.substring(recordName.indexOf(":") + 1);
        String[] partNames = null;
        QName[] partTypes = null;
        QName[] partElements = null;
        if (parts != null && parts.length != 0) {
            partNames = new String[parts.length];
            partTypes = new QName[parts.length];
            partElements = new QName[parts.length];
            block0: for (int j = 0; j < parts.length; ++j) {
                boolean partFound = false;
                for (int i = 0; i < pa.length; ++i) {
                    if (parts[j].equals(pa[i].getName())) {
                        partNames[j] = pa[i].getName();
                        partTypes[j] = pa[i].getType();
                        partElements[j] = pa[i].getElement();
                        partFound = true;
                        continue block0;
                    }
                    if (partFound) continue;
                }
            }
        } else {
            partNames = new String[pa.length];
            partTypes = new QName[pa.length];
            partElements = new QName[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                partNames[i] = pa[i].getName();
                partTypes[i] = pa[i].getType();
                partElements[i] = pa[i].getElement();
            }
        }
        if (this.genRecords(nodeName, partNames, partTypes, partElements, ns, pkg, ifcName, attrPrefix, verbose, locale, isRPC, universalName)) {
            return nodeName;
        }
        return null;
    }

    public boolean genRecords(String recordName, String[] partNames, QName[] partTypes, QName[] partElements, Namespace ns, NSPackage pkg, String ifcName, String attrPrefix, boolean verbose, Locale locale, boolean isRPC) throws Exception {
        return this.genRecords(recordName, partNames, partTypes, partElements, ns, pkg, ifcName, attrPrefix, verbose, locale, isRPC, null);
    }

    public boolean genRecords(String recordName, String[] partNames, QName[] partTypes, QName[] partElements, Namespace ns, NSPackage pkg, String ifcName, String attrPrefix, boolean verbose, Locale locale, boolean isRPC, String universalNamespace) throws Exception {
        NSRecord msgRecord = null;
        Object field = null;
        BuiltIns builtIns = BuiltIns.current();
        boolean isSuccessful = false;
        String pathName = Strings.cat(ifcName, ":", recordName);
        NSName nsName = NSName.create(pathName);
        if (ns.nodeExists(nsName)) {
            return true;
        }
        String universalNamespaceForRecord = universalNamespace;
        for (int i = 0; i < partNames.length; ++i) {
            NSRecord genRecord;
            NSNode node;
            Name uri;
            String name = partNames[i];
            QName typeName = partTypes[i];
            QName elementName = partElements[i];
            if (typeName != null) {
                if (builtIns.containsKey(typeName) || Expression.ANY_TYPE_NAMES.contains(typeName)) {
                    if (isRPC) {
                        name = NCName.decode(name);
                    }
                    isSuccessful = this.getSimpleRecords(ns, nsName, name, pkg, typeName);
                } else {
                    uri = typeName.getNamespaceName();
                    if (typeName.getNamespaceName() == W3CNamespaces.WEBM_DEFAULT_NAMESPACE) {
                        typeName = QName.create(null, typeName.getLocalName());
                    }
                    isSuccessful = this.genRecordsFromType(ns, pkg, ifcName, recordName, name, attrPrefix, typeName, verbose, locale, isRPC, universalNamespace);
                }
            } else if (elementName != null) {
                uri = elementName.getNamespaceName();
                if (elementName.getNamespaceName() == W3CNamespaces.WEBM_DEFAULT_NAMESPACE) {
                    elementName = QName.create(null, elementName.getLocalName());
                }
                isSuccessful = this.genRecords(ns, pkg, ifcName, recordName, name, attrPrefix, elementName, verbose, locale, isRPC, universalNamespace);
            }
            universalNamespace = null;
            if (!isSuccessful || (node = ns.getNode(nsName)) == null) continue;
            msgRecord = genRecord = (NSRecord)node;
            NSField[] fields = genRecord.getFieldNodes();
            for (int j = 0; j < fields.length; ++j) {
                fields[j].setNillable(true);
                fields[j].setOptional(true);
            }
        }
        if (universalNamespaceForRecord != null && msgRecord != null) {
            msgRecord.setUniversalName(QName.create(universalNamespaceForRecord, recordName));
        }
        return isSuccessful;
    }

    boolean getSimpleRecords(Namespace ns, NSName nsName, String fieldName, NSPackage pkg, QName typeName) {
        NSField nsf;
        NSRecord nsr = null;
        if (Expression.ANY_TYPE_NAMES.contains(typeName)) {
            nsf = new NSField(ns, NSRecord.TYPE, fieldName, 3, 0);
        } else {
            nsf = new NSField(ns, NSRecord.TYPE, fieldName, 1, 0);
            SimpleType st = SimpleTypeUtil.create(ns, typeName);
            if (st == null) {
                return false;
            }
            nsf.setContentType(st);
        }
        if (ns.nodeExists(nsName)) {
            nsr = (NSRecord)ns.getNode(nsName);
            nsr.addField(nsf);
        } else {
            nsr = new NSRecord(ns, null, 0);
            nsr.setPackage(pkg);
            nsr.setNSName(nsName);
            nsr.addField(nsf);
        }
        try {
            boolean isRegistered = ns.registerRecord(nsr, true);
            if (!this._nodesPersisted.contains(nsr)) {
                this._nodesPersisted.insertElementAt(nsr, 0);
            }
            return isRegistered;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Vector getErrors() {
        return this._errors;
    }

    public Vector getWarnings() {
        return this._warnings;
    }

    public IData getUsedURIPrefixPairs() {
        return this._usedURIPrefixPairs;
    }

    public static boolean isOneWayMEP(WSOperation operation) {
        return WSDUtil.determineMEPType(operation) == -1;
    }

    public static boolean isResponseOnlyMEP(WSOperation operation) {
        return WSDUtil.determineMEPType(operation) == 1;
    }

    public static int determineMEPType(WSOperation operation) {
        int type = 0;
        String outputrecordname = null;
        String inputrecordname = null;
        if (operation != null) {
            WSBody respbody;
            WSRespMessage respmsg;
            WSReqMessage reqmsg = operation.getWSRequest();
            if (reqmsg != null) {
                WSBody reqbody = reqmsg.getWSBody();
                if (reqbody != null) {
                    inputrecordname = reqbody.getDocType();
                }
                if (inputrecordname != null && !inputrecordname.trim().equals("")) {
                    --type;
                }
            }
            if ((respmsg = operation.getWSResponse()) != null && (respbody = respmsg.getWSBody()) != null) {
                outputrecordname = respbody.getDocType();
            }
            if (outputrecordname != null && !outputrecordname.trim().equals("")) {
                ++type;
            }
        }
        return type;
    }
}

