/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.wsdl;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.XSDSource;
import com.wm.lang.schema.xsd.XSDSourceBuilder;
import com.wm.lang.wsdl.DeweyNumber;
import com.wm.lang.wsdl.WSDException;
import com.wm.lang.wsdl.WSDLKeys;
import com.wm.lang.wsdl.resources.WSDMessageBundle;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.StringMatcher;
import com.wm.util.URIParser;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WSDSourcePackager
implements WSDLKeys {
    static final boolean debug = false;
    private static final Name SCHEMA = Name.create("schema");
    private static final Name IMPORT = Name.create("import");
    private static final Name INCLUDE = Name.create("include");
    private static final Name REDEFINE = Name.create("redefine");
    private static final Name TYPE = Name.create("types");
    private static final Name WSDL_NAMESPACE = Name.create("http://schemas.xmlsoap.org/wsdl/");
    private static final QName WSDL_DEFINITIONS = QName.create(WSDL_NAMESPACE, Name.create("definitions"));
    private static final QName WSDL_IMPORT = QName.create(WSDL_NAMESPACE, IMPORT);
    private static final QName WSDL_TYPE = QName.create(WSDL_NAMESPACE, TYPE);
    private static final Name SCHEMA_10_NAMESPACE = Name.create("http://www.w3.org/2001/XMLSchema");
    private static final QName SCHEMA_10 = QName.create(SCHEMA_10_NAMESPACE, SCHEMA);
    private static final QName SCHEMA_10_IMPORT = QName.create(SCHEMA_10_NAMESPACE, IMPORT);
    private static final QName SCHEMA_10_INCLUDE = QName.create(SCHEMA_10_NAMESPACE, INCLUDE);
    private static final QName SCHEMA_10_REDEFINE = QName.create(SCHEMA_10_NAMESPACE, REDEFINE);
    private static final Name SCHEMA_CR_NAMESPACE = Name.create("http://www.w3.org/2000/10/XMLSchema");
    private static final QName SCHEMA_CR = QName.create(SCHEMA_CR_NAMESPACE, SCHEMA);
    private static final QName SCHEMA_CR_IMPORT = QName.create(SCHEMA_CR_NAMESPACE, IMPORT);
    private static final QName SCHEMA_CR_INCLUDE = QName.create(SCHEMA_CR_NAMESPACE, INCLUDE);
    private static final QName SCHEMA_CR_REDEFINE = QName.create(SCHEMA_CR_NAMESPACE, REDEFINE);
    private static final Name SCHEMA_LOCATION = Name.create("schemaLocation");
    private static final Name LOCATION = Name.create("location");
    private static final Name XMLNS_PREFIX = Name.create("xmlns");
    private static final int iWSDL_IMPORT = 0;
    private static final int iWSDL_TYPE = 1;
    private static final int iSCHEMA_10_INCLUDE = 2;
    private static final int iSCHEMA_CR_INCLUDE = 3;
    private static final int iSCHEMA_10_IMPORT = 4;
    private static final int iSCHEMA_CR_IMPORT = 5;
    private static final int iSCHEMA_10_REDEFINE = 6;
    private static final int iSCHEMA_CR_REDEFINE = 7;
    private static final QName[] COMPOSITION_TYPES = new QName[]{WSDL_IMPORT, WSDL_TYPE, SCHEMA_10_INCLUDE, SCHEMA_CR_INCLUDE, SCHEMA_10_IMPORT, SCHEMA_CR_IMPORT, SCHEMA_10_REDEFINE, SCHEMA_CR_REDEFINE};
    private static final StringMatcher SM_RELATIVE_ENCODING = new StringMatcher("*/soap-encoding.xsd", true);
    private static final StringMatcher SM_SOAP_ENCODING = new StringMatcher("http://schemas.xmlsoap.org/soap/encoding/", true);
    private static final StringMatcher SM_WSDL = new StringMatcher("http://schemas.xmlsoap.org/wsdl/", true);

    public static final IData build(String url) throws IOException, WMDocumentException, WSDException {
        HashSet urls = new HashSet();
        IData wsd = IDataFactory.create();
        try {
            WSDSourcePackager.build(url, url, urls, wsd, true, null);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (WMDocumentException wmde) {
            throw wmde;
        }
        catch (WSDException wsde) {
            throw wsde;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WSDException(t.toString());
        }
        return wsd;
    }

    public static final IData build(Document doc, String base) throws IOException, WMDocumentException, WSDException {
        HashSet urls = new HashSet();
        IData wsd = IDataFactory.create();
        try {
            WSDSourcePackager.build(base, base, urls, wsd, true, doc);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (WMDocumentException wmde) {
            throw wmde;
        }
        catch (WSDException wsde) {
            throw wsde;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WSDException(t.toString());
        }
        return wsd;
    }

    public static final IData build(Document doc) throws IOException, WMDocumentException, WSDException {
        HashSet urls = new HashSet();
        IData wsd = IDataFactory.create();
        try {
            WSDSourcePackager.build(null, null, urls, wsd, true, doc);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (WMDocumentException wmde) {
            throw wmde;
        }
        catch (WSDException wsde) {
            throw wsde;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WSDException(t.toString());
        }
        return wsd;
    }

    public static final IData[] getXSDArray(IData wsd) throws WSDException {
        Vector list = new Vector();
        HashSet urls = new HashSet();
        IDataCursor idc = wsd.getCursor();
        String key = null;
        IData value = null;
        Object tempKey = null;
        Object tempCursor = null;
        Object tempValue = null;
        boolean allowDup = false;
        while (idc.next()) {
            key = idc.getKey();
            if (key.equals("redefine-xsd")) {
                throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.NOT_SUPPORT_REDEFINE, "");
            }
            if (key.equals("import-wsd")) {
                IData[] xsdArrayFromImport;
                value = (IData)idc.getValue();
                for (IData xsdSource : xsdArrayFromImport = WSDSourcePackager.getXSDArray(value)) {
                    if (urls.contains(((XSDSource)xsdSource).getUsage())) continue;
                    list.add(xsdSource);
                    urls.add(((XSDSource)xsdSource).getUsage());
                }
                continue;
            }
            if (key.equals("url") || key.equals("source")) continue;
            value = (IData)idc.getValue();
            if (key.equals("type-xsd")) {
                allowDup = false;
            }
            list = WSDSourcePackager.recursiveGetXSD(value, list, urls, allowDup);
        }
        WSDSourcePackager.trax1_659L8(list);
        Object[] xsdArray = new XSDSource[list.size()];
        list.copyInto(xsdArray);
        return xsdArray;
    }

    private static void trax1_659L8(Vector list) {
        boolean wsdFound = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            XSDSource xsdS = (XSDSource)list.elementAt(i);
            String namespace = xsdS.getNamespace();
            String url = xsdS.getURL();
            if (namespace == null && url == null && xsdS.getSource() == null) {
                list.removeElementAt(i);
                continue;
            }
            if (namespace != null && "http://schemas.xmlsoap.org/soap/encoding/".equals(namespace) || url != null && "http://schemas.xmlsoap.org/soap/encoding/".equals(url)) {
                list.removeElementAt(i);
                continue;
            }
            if (namespace != null && "http://schemas.xmlsoap.org/wsdl/".equals(namespace) || url != null && "http://schemas.xmlsoap.org/wsdl/".equals(url)) {
                list.removeElementAt(i);
                wsdFound = true;
                continue;
            }
            if (url == null || !SM_RELATIVE_ENCODING.match(url) && !SM_SOAP_ENCODING.match(url) && !SM_WSDL.match(url)) continue;
            list.removeElementAt(i);
        }
        XSDSource xsdEncoding = XSDSource.create("<?xml version='1.0'?><!-- XML Schema for SOAP v 1.1 Encoding --><schema xmlns='http://www.w3.org/1999/XMLSchema'        xmlns:wmns1='http://schemas.xmlsoap.org/soap/encoding/'        targetNamespace='http://schemas.xmlsoap.org/soap/encoding/'> <attribute name='root' use='default' value='0'>    <simpleType base='boolean'>      <pattern value='0|1'/>    </simpleType> </attribute>  <attributeGroup name='commonAttributes'>    <attribute name='id' type='ID'/>    <attribute name='href' type='uriReference'/>    <anyAttribute namespace='##other'/>  </attributeGroup>  <simpleType name='arrayCoordinate' base='string'/>  <attribute name='arrayType' type='string'/>  <attribute name='offset' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayAttributes'>    <attribute ref='wmns1:arrayType' use='required'/>    <attribute ref='wmns1:offset'/>  </attributeGroup>  <attribute name='position' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayMemberAttributes'>    <attribute ref='wmns1:position'/>  </attributeGroup>  <element name='Array' type='wmns1:Array'/>  <group name='Array'>    <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Array' content='elementOnly'>    <group ref='wmns1:Array' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:arrayAttributes'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>   <element name='Struct' type='wmns1:Struct'/>  <group name='Struct'>      <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Struct'>    <group ref='wmns1:Struct' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <simpleType name='base64' base='binary'>    <encoding value='base64'/>  </simpleType>  <element name='string' type='wmns1:string'/>  <complexType name='string' base='string' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='boolean' type='wmns1:boolean'/>  <complexType name='boolean' base='boolean' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='float' type='wmns1:float'/>  <complexType name='float' base='float' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='double' type='wmns1:double'/>  <complexType name='double' base='double' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='decimal' type='wmns1:decimal'/>  <complexType name='decimal' base='decimal' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeDuration' type='wmns1:timeDuration'/>  <complexType name='timeDuration' base='timeDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDuration' type='wmns1:recurringDuration'/>  <complexType name='recurringDuration' base='recurringDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='binary' type='wmns1:binary'/>  <complexType name='binary' base='binary' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='uriReference' type='wmns1:uriReference'/>  <complexType name='uriReference' base='uriReference' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ID' type='wmns1:ID'/>  <complexType name='ID' base='ID' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREF' type='wmns1:IDREF'/>  <complexType name='IDREF' base='IDREF' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITY' type='wmns1:ENTITY'/>  <complexType name='ENTITY' base='ENTITY' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NOTATION' type='wmns1:NOTATION'/>  <complexType name='NOTATION' base='NOTATION' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='QName' type='wmns1:QName'/>  <complexType name='QName' base='QName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='language' type='wmns1:language'/>  <complexType name='language' base='language' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREFS' type='wmns1:IDREFS'/>  <complexType name='IDREFS' base='IDREFS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITIES' type='wmns1:ENTITIES'/>  <complexType name='ENTITIES' base='ENTITIES' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKEN' type='wmns1:NMTOKEN'/>  <complexType name='NMTOKEN' base='NMTOKEN' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKENS' type='wmns1:NMTOKENS'/>  <complexType name='NMTOKENS' base='NMTOKENS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='Name' type='wmns1:Name'/>  <complexType name='Name' base='Name' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NCName' type='wmns1:NCName'/>  <complexType name='NCName' base='NCName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='integer' type='wmns1:integer'/>  <complexType name='integer' base='integer' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonPositiveInteger' type='wmns1:nonPositiveInteger'/>  <complexType name='nonPositiveInteger' base='nonPositiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='negativeInteger' type='wmns1:negativeInteger'/>  <complexType name='negativeInteger' base='negativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='long' type='wmns1:long'/>  <complexType name='long' base='long' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='int' type='wmns1:int'/>  <complexType name='int' base='int' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='short' type='wmns1:short'/>  <complexType name='short' base='short' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='byte' type='wmns1:byte'/>  <complexType name='byte' base='byte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonNegativeInteger' type='wmns1:nonNegativeInteger'/>  <complexType name='nonNegativeInteger' base='nonNegativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedLong' type='wmns1:unsignedLong'/>  <complexType name='unsignedLong' base='unsignedLong' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedInt' type='wmns1:unsignedInt'/>  <complexType name='unsignedInt' base='unsignedInt' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedShort' type='wmns1:unsignedShort'/>  <complexType name='unsignedShort' base='unsignedShort' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedByte' type='wmns1:unsignedByte'/>  <complexType name='unsignedByte' base='unsignedByte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='positiveInteger' type='wmns1:positiveInteger'/>  <complexType name='positiveInteger' base='positiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeInstant' type='wmns1:timeInstant'/>  <complexType name='timeInstant' base='timeInstant' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='time' type='wmns1:time'/>  <complexType name='time' base='time' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timePeriod' type='wmns1:timePeriod'/>  <complexType name='timePeriod' base='timePeriod' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='date' type='wmns1:date'/>  <complexType name='date' base='date' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='month' type='wmns1:month'/>  <complexType name='month' base='month' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='year' type='wmns1:year'/>  <complexType name='year' base='year' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='century' type='wmns1:century'/>  <complexType name='century' base='century' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDate' type='wmns1:recurringDate'/>  <complexType name='recurringDate' base='recurringDate' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDay' type='wmns1:recurringDay'/>  <complexType name='recurringDay' base='recurringDay' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ur-type'/>  <complexType name='ur-type'/></schema>", 1, "http://schemas.xmlsoap.org/soap/encoding/");
        xsdEncoding.setNamespace("http://schemas.xmlsoap.org/soap/encoding/");
        xsdEncoding.setUsage("http://schemas.xmlsoap.org/soap/encoding/");
        list.addElement(xsdEncoding);
        if (wsdFound) {
            XSDSource wsdEncoding = XSDSource.create("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><schema xmlns=\"http://www.w3.org/2001/XMLSchema\"xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"targetNamespace=\"http://schemas.xmlsoap.org/wsdl/\"elementFormDefault=\"qualified\"><complexType mixed = \"true\" name = \"tDocumentation\"><sequence><any minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/></sequence></complexType><complexType name = \"tDocumented\"><annotation><documentation>This type is extended by  component types to allow them to be documented </documentation></annotation><sequence><element name = \"documentation\" type = \"wsdl:tDocumentation\" minOccurs=\"0\"/></sequence></complexType><complexType name=\"tExtensibleAttributesDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component types to allow attributes from other namespaces to be added.</documentation></annotation><anyAttribute namespace=\"##other\"/></extension></complexContent></complexType><complexType name=\"tExtensibleDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component typesto allow attributes from other namespaces to be added.</documentation></annotation><sequence><any namespace=\"##other\" minOccurs = \"0\" maxOccurs = \"unbounded\"/></sequence></extension></complexContent></complexType><element name=\"definitions\" type=\"wsdl:tDefinitions\"><key name=\"message\"><selector xpath=\"wsdl:message\"/><field xpath=\"@name\"/></key><key name=\"portType\"><selector xpath=\"wsdl:portType\"/><field xpath=\"@name\"/></key><key name=\"binding\"><selector xpath=\"wsdl:binding\"/><field xpath=\"@name\"/></key><key name=\"service\"><selector xpath=\"wsdl:service\"/><field xpath=\"@name\"/></key><key name=\"import\"><selector xpath=\"wsdl:import\"/><field xpath=\"@namespace\"/></key><key name=\"port\"><selector xpath=\"wsdl:service/wsdl:port\"/><field xpath=\"@name\"/></key></element><group name = \"anyTopLevelOptionalElement\"><annotation><documentation>Any top level optional element allowed to appear more then once- any child of definitions element except wsdl:types. Any extensibility element is allowed in any place </documentation></annotation><choice><element name = \"import\"   type = \"wsdl:tImport\"/><element name = \"types\"    type = \"wsdl:tTypes\"/><element name = \"message\"  type = \"wsdl:tMessage\"><unique name=\"part\"><selector xpath=\"wsdl:part\"/><field xpath=\"@name\"/></unique></element><element name = \"portType\" type = \"wsdl:tPortType\" /><element name = \"binding\"  type = \"wsdl:tBinding\"/><element name = \"service\"  type = \"wsdl:tService\"/></choice></group><complexType name = \"tDefinitions\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><group ref = \"wsdl:anyTopLevelOptionalElement\"  minOccurs=\"0\"   maxOccurs = \"unbounded\"/></sequence><attribute name=\"targetNamespace\" type=\"anyURI\" use=\"optional\"/><attribute name=\"name\"            type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tImport\"><complexContent><extension base = \"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"namespace\" type=\"anyURI\" use=\"required\"/><attribute name=\"location\" type=\"anyURI\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tTypes\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"/></complexContent></complexType><complexType name=\"tMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"part\" type = \"wsdl:tPart\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPart\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"element\" type=\"QName\" use=\"optional\"/><attribute name=\"type\" type=\"QName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tPortType\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><sequence><element name = \"operation\" type = \"wsdl:tOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><choice><group ref=\"wsdl:request-response-one-way-operation\"/><group ref=\"wsdl:solicit-response-notification-operation\"/></choice><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"parameterOrder\" type=\"NMTOKENS\" use=\"optional\"/></extension></complexContent></complexType><group name = \"optional-response-fault\"><choice><sequence/><sequence><element name = \"output\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"request-response-one-way-operation\"><sequence><element name = \"input\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-response-fault\"/></sequence></group><group name = \"optional-solicit-fault\"><choice><sequence/><sequence><element name = \"input\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"solicit-response-notification-operation\"><sequence><element name = \"output\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-solicit-fault\"/></sequence></group><complexType name=\"tParam\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tFault\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\"  use=\"required\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBinding\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"operation\" type=\"wsdl:tBindingOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"type\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationFault\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBindingOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"input\"  type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"output\" type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"fault\"  type=\"wsdl:tBindingOperationFault\"   minOccurs=\"0\" maxOccurs = \"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tService\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"port\" type = \"wsdl:tPort\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPort\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"binding\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><attribute name=\"arrayType\" type=\"string\"/><attribute name=\"required\" type = \"boolean\"/><complexType name=\"tExtensibilityElement\" abstract = \"true\"><sequence/><attribute ref=\"wsdl:required\" use=\"optional\"/></complexType></schema>", 1, "http://schemas.xmlsoap.org/wsdl/");
            wsdEncoding.setNamespace("http://schemas.xmlsoap.org/wsdl/");
            wsdEncoding.setUsage("http://schemas.xmlsoap.org/wsdl/");
            list.addElement(wsdEncoding);
        }
    }

    static final Vector recursiveGetXSD(IData child, Vector list, HashSet urls, boolean allowDup) throws WSDException {
        String source = null;
        int type = -1;
        String url = null;
        IDataCursor idc = child.getCursor();
        Object tempCursor = null;
        Object key = null;
        Object value = null;
        boolean localAllowDup = false;
        url = IDataUtil.getString(idc, "url");
        source = IDataUtil.getString(idc, "source");
        if (source != null) {
            try {
                IData[] xsdArray = XSDSourceBuilder.build(url, new ByteArrayInputStream(source.getBytes("UTF8")));
                for (int i = 0; i < xsdArray.length; ++i) {
                    if (!(xsdArray[i] instanceof XSDSource) || !allowDup && urls.contains(((XSDSource)xsdArray[i]).getUsage())) continue;
                    urls.add(((XSDSource)xsdArray[i]).getUsage());
                    list.addElement(xsdArray[i]);
                }
            }
            catch (Exception e) {
                throw new WSDException(e);
            }
        }
        return list;
    }

    public static final IData[] makeItSimple(IData wsd) {
        Vector vec = new Vector();
        WSDSourcePackager.makeItSimple(wsd, vec);
        Object[] wsdArray = new IData[vec.size()];
        vec.copyInto(wsdArray);
        return wsdArray;
    }

    private static final void makeItSimple(IData wsd, Vector bag) {
        IDataCursor cursor = wsd.getCursor();
        IData description = IDataFactory.create();
        bag.addElement(description);
        IDataCursor descriptionCursor = description.getCursor();
        while (cursor.next()) {
            String key = cursor.getKey();
            Object value = cursor.getValue();
            if (value instanceof String) {
                descriptionCursor.insertAfter(key, value);
                continue;
            }
            if (!(value instanceof IData)) continue;
            WSDSourcePackager.makeItSimple((IData)value, bag);
        }
    }

    public static final void writeToStream(OutputStream os, IData wsd) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF8"));
        WSDSourcePackager.write(writer, wsd, new DeweyNumber());
    }

    private static final void write(Writer writer, IData wsd, DeweyNumber deweyNumber) throws IOException {
        IDataCursor cursor = wsd.getCursor();
        while (cursor.next()) {
            String key = cursor.getKey();
            Object value = cursor.getValue();
            writer.write("-----");
            String id = deweyNumber.toString();
            writer.write(id);
            for (int i = 5 + id.length() - 1; i < 75; ++i) {
                writer.write(45);
            }
            writer.write(10);
            writer.write(key);
            writer.write(61);
            if (value instanceof String) {
                writer.write(value.toString());
                writer.write("\n\n");
            } else if (value instanceof IData) {
                writer.write("\n\n");
                deweyNumber.incrementSection();
                WSDSourcePackager.write(writer, (IData)value, deweyNumber);
                deweyNumber.decrementSection();
            }
            deweyNumber.increment();
        }
        writer.flush();
    }

    private static final void build(String base, String url, HashSet urls, IData wsd, boolean isTop) throws IOException, WMDocumentException, WSDException {
        WSDSourcePackager.build(base, url, urls, wsd, isTop, null);
    }

    private static final void build(String base, String url, HashSet urls, IData wsd, boolean isTop, Document doc) throws IOException, WMDocumentException, WSDException {
        ElementNode rootNode;
        if (url == null && doc == null) {
            return;
        }
        if (url != null && (SM_RELATIVE_ENCODING.match(url) || SM_SOAP_ENCODING.match(url) || SM_WSDL.match(url))) {
            IDataCursor cursor = wsd.getCursor();
            cursor.insertAfter("url", url);
            cursor.destroy();
            return;
        }
        InputStream is = null;
        try {
            if (doc == null) {
                String tempurl = url;
                int indx = tempurl.indexOf("\\");
                while (indx > -1) {
                    tempurl = tempurl.substring(0, indx) + "/" + tempurl.substring(indx + 1);
                    indx = tempurl.indexOf("\\", indx);
                }
                if (tempurl.toLowerCase().startsWith("file:///")) {
                    tempurl = tempurl.substring(7);
                } else if (tempurl.toLowerCase().startsWith("file:/")) {
                    tempurl = tempurl.substring(5);
                }
                is = Document.getHostServices().getInputStream(tempurl);
                doc = new Document(is, tempurl, null, true, true);
            }
            doc.completeLoad();
            rootNode = (ElementNode)doc.getFirstElement();
        }
        catch (FileNotFoundException e) {
            if (is != null) {
                is.close();
            }
            throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.FILE_NOT_FOUND, "", url);
        }
        catch (WMDocumentException wmde) {
            if (is != null) {
                is.close();
            }
            throw wmde;
        }
        if (rootNode == null) {
            if (is != null) {
                is.close();
            }
            throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.UNABLE_TO_PARSE, "", url);
        }
        QName rootName = QName.create(rootNode.getNamespaceUri(), rootNode.getLocalNameWm());
        if (isTop && rootName != WSDL_DEFINITIONS) {
            if (is != null) {
                is.close();
            }
            throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.NOT_A_VALID_WSD, "", url);
        }
        Hashtable<Name, NamespaceDecl> nsdeclHT = new Hashtable<Name, NamespaceDecl>();
        if (isTop) {
            NamespaceDecl decl = rootNode.getNextNamespaceDecl(null);
            while (decl != null) {
                if (decl.getPrefixWm() != null) {
                    nsdeclHT.put(decl.getPrefixWm(), decl);
                }
                decl = rootNode.getNextNamespaceDecl(decl);
            }
        }
        Node node = rootNode;
        boolean duplicatesAllowed = true;
        Name location = null;
        try {
            StringBuffer sb = new StringBuffer();
            doc.appendGeneratedMarkup(sb);
            IDataCursor cursor = wsd.getCursor();
            cursor.insertAfter("url", url);
            String wsdlString = sb.toString();
            cursor.insertAfter("source", wsdlString);
            for (node = node.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                if (node.getNodeType() != 1) continue;
                ElementNode elementNode = (ElementNode)node;
                QName anotherName = QName.create(elementNode.getNamespaceUri(), elementNode.getLocalNameWm());
                String nextKey = null;
                int compositionType = WSDSourcePackager.computeCompositionType(anotherName);
                boolean wsdButXsd = false;
                if (compositionType == 0) {
                    String tempLocation = elementNode.getAttributeValue(null, LOCATION);
                    String tempNextURL = URIParser.abs2(base, tempLocation = WSDSourcePackager.formatImportURI(tempLocation));
                    compositionType = WSDSourcePackager.lookahead(tempNextURL);
                    if (compositionType != 0) {
                        wsdButXsd = true;
                    }
                }
                switch (compositionType) {
                    case 0: {
                        nextKey = "import-wsd";
                        location = LOCATION;
                        duplicatesAllowed = false;
                        break;
                    }
                    case 1: {
                        WSDSourcePackager.buildTypes(base, elementNode, urls, wsd, nsdeclHT);
                        break;
                    }
                    case 2: 
                    case 3: {
                        nextKey = "include-xsd";
                        location = SCHEMA_LOCATION;
                        duplicatesAllowed = false;
                        break;
                    }
                    case 4: 
                    case 5: {
                        nextKey = "import-xsd";
                        duplicatesAllowed = false;
                        if (wsdButXsd) {
                            location = LOCATION;
                            break;
                        }
                        location = SCHEMA_LOCATION;
                        break;
                    }
                    case 6: 
                    case 7: {
                        nextKey = "redefine-xsd";
                        location = SCHEMA_LOCATION;
                        break;
                    }
                }
                if (nextKey != null) {
                    String nextURL = elementNode.getAttributeValue(null, location);
                    nextURL = WSDSourcePackager.formatImportURI(nextURL);
                    if ((nextURL = URIParser.abs2(base, nextURL)) != null && (duplicatesAllowed || !urls.contains(nextURL))) {
                        IData nextModule = IDataFactory.create();
                        cursor.insertAfter(nextKey, nextModule);
                        boolean isNextTop = false;
                        if (nextKey == "import-wsd") {
                            isNextTop = true;
                        }
                        if (!duplicatesAllowed) {
                            urls.add(nextURL);
                        }
                        WSDSourcePackager.build(nextURL, nextURL, urls, nextModule, isNextTop);
                    }
                }
                duplicatesAllowed = true;
            }
        }
        catch (WMDocumentException wde) {
            if (is != null) {
                is.close();
            }
            throw wde;
        }
    }

    private static String formatImportURI(String url) {
        if (url == null || url.startsWith("#") || url.startsWith("http://") || url.startsWith("https://") || url.startsWith("mailto:") || url.startsWith("javascript:") || url.startsWith("telnet:") || url.startsWith("nntp:") || url.startsWith("news:") || url.startsWith("file:") || url.startsWith("gopher:") || url.startsWith("ftp:")) {
            return url;
        }
        if (url == null) {
            return url;
        }
        String temp = url;
        if (temp.toLowerCase().startsWith("file:/")) {
            return temp;
        }
        if (temp.toLowerCase().startsWith("http:/")) {
            return temp;
        }
        if (temp.charAt(0) != '/' && temp.charAt(0) != '\\') {
            String newTemp = URIParser.normalize(temp);
            if (newTemp.indexOf(":" + File.separator) != -1) {
                temp = "file:/" + temp;
                return temp;
            }
            return temp;
        }
        return "file:/" + temp;
    }

    private static int computeCompositionType(QName compositionType) {
        for (int i = 0; i < COMPOSITION_TYPES.length; ++i) {
            if (COMPOSITION_TYPES[i] != compositionType) continue;
            return i;
        }
        return -1;
    }

    private static int lookahead(String url) throws IOException, WMDocumentException, WSDException {
        if (url == null) {
            return -1;
        }
        if (SM_RELATIVE_ENCODING.match(url) || SM_SOAP_ENCODING.match(url) || SM_WSDL.match(url)) {
            return -1;
        }
        String tempurl = url;
        int indx = tempurl.indexOf("\\");
        while (indx > -1) {
            tempurl = tempurl.substring(0, indx) + "/" + tempurl.substring(indx + 1);
            indx = tempurl.indexOf("\\", indx);
        }
        if (tempurl.toLowerCase().startsWith("file:///")) {
            tempurl = tempurl.substring(7);
        } else if (tempurl.toLowerCase().startsWith("file:/")) {
            tempurl = tempurl.substring(5);
        }
        InputStream is = Document.getHostServices().getInputStream(tempurl);
        try {
            Document doc = new Document(is, tempurl, null, true, true);
            doc.completeLoad();
            ElementNode rootNode = (ElementNode)doc.getFirstElement();
            if (rootNode == null) {
                throw new WSDException(WSDMessageBundle.class, WSDMessageBundle.UNABLE_TO_PARSE, "", url);
            }
            QName rootName = QName.create(rootNode.getNamespaceUri(), IMPORT);
            return WSDSourcePackager.computeCompositionType(rootName);
        }
        catch (WMDocumentException de) {
            is.close();
            throw de;
        }
        catch (WSDException wsde) {
            is.close();
            throw wsde;
        }
        catch (IOException ioe) {
            is.close();
            throw ioe;
        }
    }

    private static final void buildTypes(String base, ElementNode typesNode, HashSet urls, IData wsd, Hashtable nsdecls) throws IOException, WMDocumentException, WSDException {
        IDataCursor wsdCursor = wsd.getCursor();
        wsdCursor.last();
        Name location = null;
        NamespaceDecl decl = typesNode.getNextNamespaceDecl(null);
        while (decl != null) {
            if (decl.getPrefixWm() != null) {
                nsdecls.put(decl.getPrefixWm(), decl);
            }
            decl = typesNode.getNextNamespaceDecl(decl);
        }
        int i = 0;
        for (Node tNode = typesNode.getFirstChildWm(); tNode != null; tNode = tNode.getNextSiblingWm()) {
            ElementNode childNode;
            QName childName;
            ++i;
            if (tNode.getNodeType() != 1 || (childName = QName.create((childNode = (ElementNode)tNode).getNamespaceUri(), childNode.getLocalNameWm())) != SCHEMA_CR && childName != SCHEMA_10) continue;
            IData typeXSD = IDataFactory.create();
            wsdCursor.insertAfter("type-xsd", typeXSD);
            IDataCursor cursor = typeXSD.getCursor();
            StringBuffer sb = new StringBuffer();
            childNode.appendGeneratedMarkup(sb);
            if (nsdecls != null && nsdecls.size() > 0) {
                Hashtable declClone = (Hashtable)nsdecls.clone();
                decl = childNode.getNextNamespaceDecl(null);
                while (decl != null) {
                    if (decl.getPrefixWm() != null) {
                        declClone.remove(decl.getPrefixWm());
                    }
                    decl = childNode.getNextNamespaceDecl(decl);
                }
                Enumeration nsPrfxs = declClone.keys();
                StringBuffer nsDeclSB = new StringBuffer();
                nsDeclSB.append(" ");
                while (nsPrfxs.hasMoreElements()) {
                    Object key = nsPrfxs.nextElement();
                    decl = (NamespaceDecl)declClone.get(key);
                    decl.appendNSDecls(nsDeclSB);
                    nsDeclSB.append(" ");
                }
                String os = sb.toString();
                int offset = os.indexOf("schema");
                if (offset > -1) {
                    offset += 6;
                }
                sb.insert(offset, nsDeclSB.toString());
            }
            cursor.insertAfter("url", i == 0 ? base : base + i);
            cursor.insertAfter("source", sb.toString());
            for (Node node = childNode.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                if (node.getNodeType() != 1) continue;
                ElementNode elementNode = (ElementNode)node;
                QName anotherName = QName.create(elementNode.getNamespaceUri(), elementNode.getLocalNameWm());
                String nextKey = null;
                int compositionType = WSDSourcePackager.computeCompositionType(anotherName);
                switch (compositionType) {
                    case 2: 
                    case 3: {
                        nextKey = "include-xsd";
                        location = SCHEMA_LOCATION;
                        break;
                    }
                    case 4: 
                    case 5: {
                        nextKey = "import-xsd";
                        location = SCHEMA_LOCATION;
                        break;
                    }
                    case 6: 
                    case 7: {
                        nextKey = "redefine-xsd";
                        location = SCHEMA_LOCATION;
                        break;
                    }
                }
                if (nextKey == null) continue;
                String nextURL = elementNode.getAttributeValue(null, location);
                nextURL = WSDSourcePackager.formatImportURI(nextURL);
                if ((nextURL = URIParser.abs2(base, nextURL)) == null || urls.contains(nextURL)) continue;
                urls.add(nextURL);
                IData nextModule = IDataFactory.create();
                cursor.insertAfter(nextKey, nextModule);
                WSDSourcePackager.build(nextURL, nextURL, urls, nextModule, false);
            }
        }
    }

    public static void main(String[] args) {
        try {
            IData wsd = WSDSourcePackager.build(args[0]);
            WSDSourcePackager.writeToStream(System.out, wsd);
            IData[] wsdArray = WSDSourcePackager.makeItSimple(wsd);
            IData[] xsdArray = WSDSourcePackager.getXSDArray(wsd);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

