/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.widl;

import com.wm.lang.widl.WattReferenceException;
import com.wm.util.Name;

public class ParseName {
    public static boolean isXmlNameStartChar(int ch) {
        return Character.isLetter((char)ch) || ch == 95;
    }

    public static boolean isXmlNameChar(int ch) {
        return Character.isLetterOrDigit((char)ch) || ch == 46 || ch == 45 || ch == 95;
    }

    public static boolean isValidName(String name) {
        if (!ParseName.isXmlNameStartChar(name.charAt(0))) {
            return false;
        }
        int iLen = name.length();
        for (int iCtr = 1; iCtr < iLen; ++iCtr) {
            char ch = name.charAt(iCtr);
            if (ParseName.isXmlNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    public static Name getPrefix(String name) throws WattReferenceException {
        int prefixIndex = (name = name.trim()).indexOf(58);
        if (prefixIndex > 0) {
            String prefix = name.substring(0, prefixIndex);
            if (!prefix.equals("*") && !ParseName.isValidName(prefix)) {
                throw new WattReferenceException("incorrect prefix name '" + name + "'");
            }
            return Name.create(prefix);
        }
        return null;
    }

    public static Name getLocalName(String name) throws WattReferenceException {
        int prefixIndex = (name = name.trim()).indexOf(58);
        if (prefixIndex > 0) {
            if (name.length() > prefixIndex + 1) {
                if (!(name = name.substring(prefixIndex + 1)).equals("*") && !ParseName.isValidName(name)) {
                    throw new WattReferenceException("incorrect element name '" + name + "'");
                }
                return Name.create(name);
            }
            throw new WattReferenceException("incorrect element name '" + name + "'");
        }
        return Name.create(name);
    }

    public static boolean isValidLongName(String name) throws WattReferenceException {
        String prefix;
        if (name == null) {
            return false;
        }
        int prefixIndex = (name = name.trim()).indexOf(58);
        if (prefixIndex > 0 && !(prefix = name.substring(0, prefixIndex)).equals("*") && !ParseName.isValidName(prefix)) {
            return false;
        }
        return name.length() <= prefixIndex + 1 || (name = name.substring(prefixIndex + 1)).equals("*") || ParseName.isValidName(name);
    }
}

