/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.widl;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.widl.ORNObjectRef;
import com.wm.lang.widl.ParseName;
import com.wm.lang.widl.WattException;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.TreeExpression;
import com.wm.lang.xql.VariableUtils;
import com.wm.util.List;
import com.wm.util.Name;
import com.wm.util.Values;

public class ORNReference
extends TreeExpression {
    String expression;
    ORNObjectRef cachedRef;
    ORNObjectRef cachedTypeRef;
    boolean hasVariables;
    Object identities;
    String bestResultType;

    static TreeExpression create(String expression) throws WattException {
        return new ORNReference(expression);
    }

    static TreeExpression createIfNotName(String expression, TreeExpression oldExpr) {
        try {
            return ORNReference.create(expression);
        }
        catch (WattException x) {
            return null;
        }
    }

    public ORNReference(String expression) throws WattException {
        if (expression == null) {
            throw new WattExpressionException("Expression is empty");
        }
        if ((expression = expression.trim()).length() == 0) {
            throw new WattExpressionException("Expression is empty");
        }
        this.hasVariables = VariableUtils.hasVariables(expression);
        this.expression = expression;
    }

    public ORNReference(Node node) throws WattException, WMDocumentException {
        this(node.getTextAsData());
    }

    public String getExpression() {
        return this.expression;
    }

    public TreeExpression getSubstitution(Values variables) throws WattException {
        if (!this.hasVariables) {
            return this;
        }
        String expansion = VariableUtils.substitute(this.expression, variables);
        if (expansion == this.expression) {
            return this;
        }
        return new ORNReference(expansion);
    }

    public String toString() {
        return "<ORNReference: " + this.expression + ">";
    }

    public String getString(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        ORNObjectRef oref = this.getObjectRef(this.expression, 1, node.isXML());
        return this.getProperty(oref, node, this.expression, node);
    }

    public String getStringWithIdentities(Object tree) throws WattException, WMDocumentException {
        this.identities = null;
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        boolean isXML = node.isXML();
        String saveExpression = this.expression;
        ORNObjectRef oref = this.getObjectRef(this.expression, 1, isXML);
        String o = this.getProperty(oref, node, this.expression, node);
        if (o != null) {
            node = (Node)tree;
            ORNObjectRef nodeRef = this.getObjectRef(saveExpression, 0, isXML);
            Node result = this.getObject(nodeRef, node);
            if (result != null) {
                String pos = new String(Integer.toString(result.getPosition()));
                this.identities = pos;
            }
        }
        return o;
    }

    public String[] getStringArray(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        String ref = this.expression;
        Node node = (Node)tree;
        ORNObjectRef oref = this.getObjectRef(ref, 1, node.isXML());
        if (oref.size() == 1) {
            return this.getPropertyArray(oref, node, node);
        }
        Node[] o = this.getObjectArray(oref, node);
        if (o == null) {
            return null;
        }
        if (oref.isPropArray()) {
            return this.getPropertyArray(oref, o[0], node);
        }
        String[] sol = new String[o.length];
        String[] temp = null;
        for (int i = 0; i < sol.length; ++i) {
            if (o[i] != null) {
                temp = this.getPropertyArray(oref, o[i], node);
                if (temp != null && temp.length > 0) {
                    sol[i] = temp[0];
                    continue;
                }
                sol[i] = null;
                continue;
            }
            sol[i] = null;
        }
        return sol;
    }

    public String[] getStringArrayWithIdentities(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        this.identities = null;
        String ref = this.expression;
        ORNObjectRef oref = this.getObjectRef(ref, 1, node.isXML());
        if (oref.size() == 1) {
            return this.getPropertyArray(oref, node, node);
        }
        Node[] o = this.getObjectArray(oref, node);
        if (o == null) {
            return null;
        }
        if (oref.isPropArray()) {
            return this.getPropertyArray(oref, o[0], node);
        }
        String[] sol = new String[o.length];
        String[] temp = null;
        for (int i = 0; i < sol.length; ++i) {
            if (o[i] != null) {
                temp = this.getPropertyArray(oref, o[i], node);
                if (temp != null && temp.length > 0) {
                    sol[i] = temp[0];
                    continue;
                }
                sol[i] = null;
                continue;
            }
            sol[i] = null;
        }
        String[] pos = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            pos[i] = new String(Integer.toString(o[i].getPosition()));
        }
        this.identities = pos;
        return sol;
    }

    public String[][] getStringTable(Object tree) throws WattException, WMDocumentException {
        Node[][] o;
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        String ref = this.expression;
        Node node = (Node)tree;
        ORNObjectRef oref = this.getObjectRef(ref, 1, node.isXML());
        if (oref.size() == 1) {
            o = new Node[1][1];
            o[0][0] = node;
        } else {
            o = this.getObjectTable(oref, node);
        }
        if (o == null) {
            return null;
        }
        String[][] sol = null;
        String[] temp = null;
        if (oref.isPropArray()) {
            sol = new String[o[0].length][];
            for (int i = 0; i < o[0].length; ++i) {
                sol[i] = this.getPropertyArray(oref, o[0][i], node);
            }
        } else {
            sol = new String[o.length][o[0].length];
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[0].length; ++j) {
                    if (o[i][j] != null) {
                        temp = this.getPropertyArray(oref, o[i][j], node);
                        if (temp != null && temp.length > 0) {
                            sol[i][j] = temp[0];
                            continue;
                        }
                        sol[i][j] = null;
                        continue;
                    }
                    sol[i][j] = null;
                }
            }
        }
        return sol;
    }

    public String[][] getStringTableWithIdentities(Object tree) throws WattException, WMDocumentException {
        Node[][] o;
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        this.identities = null;
        String ref = this.expression;
        ORNObjectRef oref = this.getObjectRef(ref, 1, node.isXML());
        if (oref.size() == 1) {
            o = new Node[1][1];
            o[0][0] = node;
        } else {
            o = this.getObjectTable(oref, node);
        }
        if (o == null) {
            return null;
        }
        String[][] sol = null;
        String[] temp = null;
        if (oref.isPropArray()) {
            sol = new String[o[0].length][];
            for (int i = 0; i < o[0].length; ++i) {
                sol[i] = this.getPropertyArray(oref, o[0][i], node);
            }
            String[][] pos = new String[o.length][];
            for (int i = 0; i < o.length; ++i) {
                if (o[0][i] == null) continue;
                pos[0][i] = new String(Integer.toString(o[0][i].getPosition()));
            }
            this.identities = pos;
        } else {
            sol = new String[o.length][o[0].length];
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[0].length; ++j) {
                    if (o[i][j] != null) {
                        temp = this.getPropertyArray(oref, o[i][j], node);
                        if (temp != null && temp.length > 0) {
                            sol[i][j] = temp[0];
                            continue;
                        }
                        sol[i][j] = null;
                        continue;
                    }
                    sol[i][j] = null;
                }
            }
            String[][] pos = new String[o.length][o[0].length];
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[0].length; ++j) {
                    if (o[i][j] == null) continue;
                    pos[i][j] = Integer.toString(o[i][j].getPosition());
                }
            }
            this.identities = pos;
        }
        return sol;
    }

    public Node getNode(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        boolean isXML = node.isXML();
        ORNObjectRef oref = this.getObjectRef(this.expression, 0, isXML);
        Node n = this.getObject(oref, node);
        if (n != null) {
            Node tmp = this.getObject(oref, node);
            if (tmp == null || isXML) {
                return tmp;
            }
            return tmp.getReferenceNode();
        }
        return null;
    }

    public Node getNodeWithIdentities(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        boolean isXML = node.isXML();
        this.identities = null;
        ORNObjectRef oref = this.getObjectRef(this.expression, 0, isXML);
        Node o = this.getObject(oref, node);
        if (o != null && !isXML) {
            o = o.getReferenceNode();
        }
        if (o != null) {
            String pos = new String(Integer.toString(o.getPosition()));
            this.identities = pos;
        }
        return o;
    }

    public Node[] getNodeArray(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        boolean isXML = node.isXML();
        ORNObjectRef oref = this.getObjectRef(this.expression, 0, isXML);
        Node[] o = this.getObjectArray(oref, node);
        if (o == null) {
            return null;
        }
        Node[] e = new Node[o.length];
        if (isXML) {
            for (int i = 0; i < o.length; ++i) {
                e[i] = o[i];
            }
        } else {
            for (int i = 0; i < o.length; ++i) {
                if (o[i] == null) continue;
                e[i] = o[i].getReferenceNode();
            }
        }
        return e;
    }

    public Node[] getNodeArrayWithIdentities(Object tree) throws WattException, WMDocumentException {
        int i;
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        this.identities = null;
        boolean isXML = node.isXML();
        ORNObjectRef oref = this.getObjectRef(this.expression, 0, isXML);
        Node[] o = this.getObjectArray(oref, node);
        if (o == null) {
            return null;
        }
        Node[] e = new Node[o.length];
        if (isXML) {
            for (i = 0; i < o.length; ++i) {
                e[i] = o[i];
            }
        } else {
            for (i = 0; i < o.length; ++i) {
                if (o[i] == null) continue;
                e[i] = o[i].getReferenceNode();
            }
        }
        String[] pos = new String[o.length];
        for (int i2 = 0; i2 < o.length; ++i2) {
            if (o[i2] == null) continue;
            pos[i2] = new String(Integer.toString(o[i2].getPosition()));
        }
        this.identities = pos;
        return e;
    }

    public Node[][] getNodeTable(Object tree) throws WattException, WMDocumentException {
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        boolean isXML = node.isXML();
        ORNObjectRef oref = this.getObjectRef(this.expression, 0, isXML);
        Node[][] o = this.getObjectTable(oref, node);
        if (o == null) {
            return null;
        }
        Node[][] e = new Node[o.length][o[0].length];
        if (isXML) {
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[i].length; ++j) {
                    e[i][j] = o[i][j];
                }
            }
        } else {
            for (int i = 0; i < o.length; ++i) {
                for (int j = 0; j < o[i].length; ++j) {
                    if (o[i][j] == null) continue;
                    e[i][j] = o[i][j].getReferenceNode();
                }
            }
        }
        return e;
    }

    public Node[][] getNodeTableWithIdentities(Object tree) throws WattException, WMDocumentException {
        int j;
        int i;
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        boolean isXML = node.isXML();
        this.identities = null;
        ORNObjectRef oref = this.getObjectRef(this.expression, 0, isXML);
        Node[][] o = this.getObjectTable(oref, node);
        if (o == null) {
            return null;
        }
        Node[][] e = new Node[o.length][o[0].length];
        if (isXML) {
            for (i = 0; i < o.length; ++i) {
                for (j = 0; j < o[i].length; ++j) {
                    e[i][j] = o[i][j];
                }
            }
        } else {
            for (i = 0; i < o.length; ++i) {
                for (j = 0; j < o[i].length; ++j) {
                    if (o[i][j] == null) continue;
                    e[i][j] = o[i][j].getReferenceNode();
                }
            }
        }
        String[][] pos = new String[o.length][o[0].length];
        for (i = 0; i < o.length; ++i) {
            for (int j2 = 0; j2 < o[i].length; ++j2) {
                if (o[i][j2] == null) continue;
                pos[i][j2] = new String(Integer.toString(o[i][j2].getPosition()));
            }
        }
        this.identities = pos;
        return e;
    }

    public Object getIdentities() {
        return this.identities;
    }

    public Object getBestResultsWithIdentities(Object tree) throws WattException {
        int resType;
        ORNObjectRef oref;
        Object o;
        if (!(tree instanceof Node)) {
            throw new WattEvaluationException("Tree type not supported");
        }
        Node node = (Node)tree;
        this.identities = null;
        boolean isXML = node.isXML();
        if (!isXML) {
            node = node.getReferenceNode();
        }
        if ((o = this.getObjectTable(oref = this.getObjectRef(this.expression, resType = 0, isXML), node)) == null) {
            resType = 1;
            if (isXML) {
                this.cachedRef = null;
                oref = this.getObjectRef(this.expression, resType, isXML);
                o = this.getObjectTable(oref, node);
            } else {
                this.cachedRef = null;
                o = this.getStringTableWithIdentities(tree);
            }
        }
        if (o == null) {
            this.bestResultType = null;
            return null;
        }
        if (resType == 1) {
            if (((Node[][])o).length > 1) {
                this.bestResultType = "String[][]";
                return this.getStringTableWithIdentities(tree);
            }
            if (((Node[][])o).length == 1 && o[0].length == 1) {
                this.bestResultType = "String";
                return this.getStringWithIdentities(tree);
            }
            if (o[0].length > 1) {
                this.bestResultType = "String[]";
                return this.getStringArrayWithIdentities(tree);
            }
            throw new WattEvaluationException("getBestResultWithIdentities unknown result size");
        }
        if (((Node[][])o).length > 1) {
            this.bestResultType = "Object[][]";
            return this.getNodeTableWithIdentities(tree);
        }
        if (((Node[][])o).length == 1 && o[0].length == 1) {
            this.bestResultType = "Object";
            return this.getNodeWithIdentities(tree);
        }
        if (o[0].length > 1) {
            this.bestResultType = "Object[]";
            return this.getNodeArrayWithIdentities(tree);
        }
        throw new WattEvaluationException("getBestResultWithIdentities unknown result size");
    }

    public String getBestResultType() {
        return this.bestResultType;
    }

    private Node getObject(ORNObjectRef ref, Node node) throws WattException, WMDocumentException {
        Node[][] e = ref.getObjectTable(node);
        if (e == null) {
            return null;
        }
        return e[0][0];
    }

    private Node[] getObjectArray(ORNObjectRef ref, Node node) throws WattException, WMDocumentException {
        Node[][] e = ref.getObjectTable(node);
        if (e == null) {
            return null;
        }
        return e[0];
    }

    private Node[][] getObjectTable(ORNObjectRef ref, Node node) throws WattException, WMDocumentException {
        return ref.getObjectTable(node);
    }

    private String[] getPropertyArray(ORNObjectRef ref, Node node, Node doc) throws WattException, WMDocumentException {
        String type = ref.getPropType();
        if (type == null) {
            return null;
        }
        ORNObjectRef typeRef = this.getObjectTypeRef(type, 1, node.isXML());
        String src = this.getProperty(typeRef, node, type, doc);
        if (src == null) {
            return null;
        }
        return ref.getPropArray(src);
    }

    private static int getIndex(Node doc, Node node) throws WMDocumentException {
        int iCtr = 0;
        Node parent = null;
        List path = new List();
        ORNReference.getNodePath(doc, node.getPosition(), path);
        parent = path.size() > 1 ? (Node)path.elementAt(1) : doc;
        Node sibling = parent.getFirstChildWm();
        while (sibling != null && sibling != node) {
            if (sibling.getNodeType() == 1 && sibling.isQueryReturnable() && node.getLocalNameWm() != null && node.getLocalNameWm().equals(sibling.getLocalNameWm()) && (node.getNamespacePrefix() == sibling.getNamespacePrefix() || node.getNamespacePrefix() != null && node.getNamespacePrefix().equals(sibling.getNamespacePrefix()))) {
                ++iCtr;
            }
            sibling = parent.getNextSiblingOfChild(sibling);
        }
        return iCtr;
    }

    public static String getAttributeValueByPrefix(Node node, Name prefix, Name localname) {
        for (Attribute attr = node.getFirstAttribute(); attr != null; attr = attr.getNext()) {
            if ((attr.getNamespacePrefix() != null || prefix != null) && (attr.getNamespacePrefix() == null || prefix == null || !attr.getNamespacePrefix().equals(prefix)) || !attr.getLocalNameWm().equals(localname)) continue;
            return attr.getValue();
        }
        return null;
    }

    private String getProperty(ORNObjectRef oref, Node node, String ref, Node doc) throws WattException, WMDocumentException {
        String[] ra;
        String res;
        if (oref.size() > 1) {
            Node o = this.getObject(oref, node);
            if (o == null) {
                return null;
            }
            String[] res2 = this.getPropertyArray(oref, o, doc);
            if (res2 == null || res2.length == 0) {
                return null;
            }
            return res2[0];
        }
        boolean match = false;
        int len = ref.indexOf(91);
        if (len > 0) {
            match = true;
            ref = ref.substring(0, len);
        }
        Name prefixName = ParseName.getPrefix(ref);
        Name localName = ParseName.getLocalName(ref);
        if (!node.isXML()) {
            localName = Name.create(localName.toString().toUpperCase());
        }
        if ((res = ORNReference.getAttributeValueByPrefix(node, prefixName, localName)) == null) {
            StringBuffer sb;
            if ((ref = ref.toUpperCase()).equals("SOURCE") || ref.equals("SRC")) {
                sb = new StringBuffer();
                node.appendOriginalMarkup(sb);
                res = sb.toString();
            } else if (ref.equals("TEXT") || ref.equals("VALUE") || ref.equals("TXT") || ref.equals("VAL")) {
                res = node.getText();
            } else if (ref.equals("ETEXT") || ref.equals("ETXT")) {
                res = node.getTextOfChildren();
            } else if (ref.equals("REFERENCE") || ref.equals("REF")) {
                res = ORNReference.getAbsoluteObjectRef(doc, node, null, false);
            } else if (ref.equals("INDEX") || ref.equals("IDX")) {
                res = Integer.toString(ORNReference.getIndex(doc, node));
            } else if (ref.equals("TAGTYPE") || ref.equals("TTYPE")) {
                if (node.getNamespacePrefix() != null) {
                    res = node.getNamespacePrefix().toString();
                    if (res.length() > 0) {
                        res = res.concat(":");
                    }
                } else {
                    res = "";
                }
                res = res + node.getLocalNameWm().toString();
            } else if (ref.equals("TITLE")) {
                ORNReference query = new ORNReference("title[0].text");
                res = query.getString(node);
            } else if (ref.equals("URL")) {
                res = node.getDocument().getURL();
            } else if (ref.equals("CSOURCE") || ref.equals("CSRC")) {
                sb = new StringBuffer();
                node.appendGeneratedMarkup(sb);
                res = sb.toString();
            }
        }
        if (match && (ra = oref.getPropArray(res)) != null && ra.length > 0) {
            res = ra[0];
        }
        return res;
    }

    ORNObjectRef getObjectRef(String ref, int type, boolean isXML) throws WattException {
        ORNObjectRef oref = this.cachedRef;
        if (oref == null) {
            oref = new ORNObjectRef(ref, type, isXML);
            if (!this.hasVariables) {
                this.cachedRef = oref;
            }
        } else {
            try {
                oref = (ORNObjectRef)oref.clone();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return oref;
    }

    ORNObjectRef getObjectTypeRef(String ref, int type, boolean isXML) throws WattException {
        ORNObjectRef oref = this.cachedTypeRef;
        if (oref == null) {
            oref = new ORNObjectRef(ref, type, isXML);
            if (!this.hasVariables) {
                this.cachedTypeRef = oref;
            }
        } else {
            try {
                oref = (ORNObjectRef)oref.clone();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return oref;
    }

    private String getAttributeValue(Node node, Name prefixName, Name localName) {
        for (Attribute child = node.getFirstAttribute(); child != null; child = child.getNext()) {
            Name nUri;
            if (localName != null && !localName.equals("*") && !localName.equals(child.getLocalNameWm()) || !(prefixName == null ? (nUri = child.getNamespaceUri()) == null : (nUri = child.getNamespacePrefix()) != null && nUri.equals(prefixName))) continue;
            return child.getValue();
        }
        return null;
    }

    public static Node getNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        Node result = ORNReference.quicklyGetNodePath(node, nodeId, path);
        if (result == null) {
            path.reset();
            result = ORNReference.slowlyGetNodePath(node, nodeId, path);
        }
        return result;
    }

    private static Node quicklyGetNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        if (node.getPosition() == nodeId) {
            return node;
        }
        Node child = node.getFirstChildWm();
        if (child == null) {
            return null;
        }
        Node lookAhead = node.getNextSiblingOfChild(child);
        while (lookAhead != null && nodeId >= lookAhead.getPosition()) {
            child = lookAhead;
            lookAhead = node.getNextSiblingOfChild(lookAhead);
        }
        Node theNode = ORNReference.getNodePath(child, nodeId, path);
        if (theNode != null) {
            path.addElement(child);
            return theNode;
        }
        return null;
    }

    private static Node slowlyGetNodePath(Node node, int nodeId, List path) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        if (node.getPosition() == nodeId) {
            return node;
        }
        Node child = node.getFirstChildWm();
        while (child != null) {
            Node theNode = ORNReference.slowlyGetNodePath(child, nodeId, path);
            if (theNode != null) {
                path.addElement(child);
                return theNode;
            }
            child = node.getNextSiblingOfChild(child);
        }
        return null;
    }

    public static String getAbsoluteObjectRef(Node doc, List v, String attribute, boolean textQuery) throws WMDocumentException {
        int vSize;
        if (v == null) {
            return null;
        }
        Node o = null;
        StringBuffer name = new StringBuffer();
        for (int i = vSize = v.size(); i > 0; --i) {
            String tmpName;
            o = (Node)v.elementAt(i - 1);
            if (o.getLocalNameWm() == null) continue;
            if (o.getNamespacePrefix() != null) {
                tmpName = o.getNamespacePrefix().toString();
                if (tmpName.length() > 0) {
                    tmpName = tmpName.concat(":");
                }
            } else {
                tmpName = "";
            }
            name.append(tmpName + o.getLocalNameWm() + "[" + ORNReference.getIndex(doc, o) + "].");
        }
        String query = v.size() == 0 ? "doc" : (o.isXML() ? "doc." + name.toString() : "doc." + name.toString().toLowerCase());
        if (attribute != null) {
            query = v.size() == 0 ? "doc." + attribute : query + attribute;
        } else if (v.size() == 0) {
            if (textQuery) {
                query = query + ".text";
            }
        } else {
            query = textQuery ? query + "text" : query.substring(0, query.length() - 1);
        }
        return query;
    }

    public static String getAbsoluteObjectRef(Node doc, Node node, String attribute, boolean textQuery) throws WMDocumentException {
        List path = new List();
        if (ORNReference.getNodePath(doc, node.getPosition(), path) != null) {
            return ORNReference.getAbsoluteObjectRef(doc, path, attribute, textQuery);
        }
        return null;
    }

    public static void dumpNodePath(List path) {
        int pSize = path.size();
        for (int iCtr = 0; iCtr < pSize; ++iCtr) {
            Node tmp = (Node)path.elementAt(iCtr);
            System.out.println("ORNReference.dumpNodePath [" + iCtr + "]=" + tmp.getPosition() + " '" + tmp.getNamespacePrefix() + ":" + tmp.getLocalNameWm() + "'");
        }
    }
}

