/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.widl;

import com.wm.lang.widl.ORNReference;
import com.wm.lang.widl.ParseName;
import com.wm.lang.widl.WattReferenceException;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xml.token.HtmlType;
import com.wm.util.List;
import com.wm.util.Name;
import com.wm.util.StringMatcher;
import com.wm.util.StringParser;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ORNObjectRef
implements Cloneable {
    public static final int OBJECT = 0;
    public static final int PROPERTY = 1;
    static Hashtable refCache = new Hashtable(100);
    public static final int ELEMENTS = 1;
    public static final int BYATTR = 2;
    public static final int PARENT = 3;
    public static final int ROOT = 4;
    public static final int SEQUENCE = 5;
    public static final int ORDER = 6;
    static Name unknownName = Name.create("?");
    static Name any = Name.create("?");
    static Name wildcard = Name.create("?");
    public static final int TEXT = 1;
    public static final int NUM = 2;
    public static final int END = 4;
    public static final int TEXT_REGEX = 8;
    public static final int ELEMENT = 1;
    public static final int RANGE = 2;
    public static final int OFFSET = 4;
    String reference;
    int type;
    int lastRow;
    int nullCount;
    int collected;
    int maxRowLen;
    List root;
    List row;
    List tokens;
    RefElement current = null;
    boolean isHTML;

    ORNObjectRef(String reference, int type, boolean isXML) throws WattReferenceException {
        this.reference = reference;
        this.type = type;
        this.isHTML = !isXML;
        this.tokens = new List();
        this.parse();
    }

    public static ORNObjectRef create(String ref, int type, boolean isXML) throws WattReferenceException {
        String key = (isXML ? "X" : "H") + ref;
        ORNObjectRef oref = (ORNObjectRef)refCache.get(key);
        if (oref == null) {
            oref = new ORNObjectRef(ref, type, isXML);
            refCache.put(key, oref);
        }
        try {
            return (ORNObjectRef)oref.clone();
        }
        catch (Exception e) {
            return new ORNObjectRef(ref, type, isXML);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int collect() {
        if (this.type == 0) {
            return this.size() - 1;
        }
        return this.size() - 2;
    }

    public int dimensions() {
        return this.nullCount;
    }

    public int size() {
        return this.tokens.size();
    }

    private void parse() throws WattReferenceException {
        if (this.type != 0 && this.type != 1) {
            throw new WattReferenceException("Invalid Object Reference Type");
        }
        StringParser sp = new StringParser(this.reference, ".", "'/", true);
        int count = 0;
        sp.countTokens();
        while (sp.hasMoreTokens()) {
            this.tokens.addElement(new RefElement(sp.nextToken(), count++));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<<ORNObjectRef: type=" + this.type);
        int len = this.type == 0 ? this.tokens.size() : this.tokens.size() - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(this.tokens.elementAt(i));
        }
        return sb.toString() + ">>";
    }

    public static void main(String[] args) throws WattReferenceException {
        if (args.length == 1) {
            System.out.println(new ORNObjectRef(args[0], 0, true).toString());
        } else if (args.length == 2) {
            System.out.println(new ORNObjectRef(args[0] + "." + args[1], 1, true).toString());
        }
    }

    public Node[][] getObjectTable(Node store) throws WattReferenceException, WMDocumentException {
        this.lastRow = 0;
        this.nullCount = 0;
        this.collected = 0;
        this.maxRowLen = 0;
        this.root = new List();
        this.row = null;
        this.retrieve(store, store, 0);
        if (this.collected == 0) {
            return null;
        }
        Node[][] table = new Node[this.root.size()][this.maxRowLen];
        int rSize = this.root.size();
        for (int i = 0; i < rSize; ++i) {
            int rowSize;
            Object[] currow = new Node[this.maxRowLen];
            this.row = (List)this.root.elementAt(i);
            this.row.copyInto(currow);
            for (int j = rowSize = this.row.size(); j < this.maxRowLen; ++j) {
                currow[j] = null;
            }
            table[i] = currow;
        }
        this.row = null;
        this.root = null;
        return table;
    }

    private void retrieve(Node doc, Node store, int index) throws WattReferenceException, WMDocumentException {
        RefElement current = (RefElement)this.tokens.elementAt(index);
        if (current == null) {
            return;
        }
        List temp = new List();
        current.retrieve(doc, store, temp);
        if (index == this.collect()) {
            if (this.nullCount >= 2) {
                return;
            }
            if (this.row == null) {
                this.row = new List();
                this.root.addElement(this.row);
            }
            this.nullCount = 0;
            this.collected += temp.size();
            this.lastRow += temp.size();
            if (this.lastRow > this.maxRowLen) {
                this.maxRowLen = this.lastRow;
            }
            int tSize = temp.size();
            for (int i = 0; i < tSize; ++i) {
                this.row.addElement(temp.elementAt(i));
            }
        } else {
            int tSize = temp.size();
            for (int i = 0; i < tSize; ++i) {
                Node target = (Node)temp.elementAt(i);
                if (target == null) continue;
                this.retrieve(doc, target, index + 1);
            }
        }
        if (temp.size() > 1 || current.isArray()) {
            this.row = null;
            this.lastRow = 0;
            ++this.nullCount;
        }
    }

    RefElement getLastElement() {
        return (RefElement)this.tokens.lastElement();
    }

    public int getRefType() {
        return this.type;
    }

    public boolean isPropArray() {
        if (this.type == 0) {
            return this.getLastElement().isArray();
        }
        return this.getLastElement().size() > 1;
    }

    public String getPropType() {
        return this.getLastElement().property;
    }

    public String[] getPropArray(String source) throws WMDocumentException {
        if (source == null) {
            return null;
        }
        List sol = this.getLastElement().getPropArray(source);
        if (sol == null || sol.size() == 0) {
            return null;
        }
        Object[] ret = new String[sol.size()];
        sol.copyInto(ret);
        return ret;
    }

    class RefRange {
        int type;
        int offset = 0;
        String value;
        int nextText = 0;

        RefRange(String text) throws WattReferenceException {
            if (text == null) {
                throw new WattReferenceException("Range Element is NULL");
            }
            this.parse(text);
        }

        public void init() {
            this.nextText = 0;
        }

        public String toString() {
            return this.value + (this.offset != 0 ? "(" + this.offset + ")" : "");
        }

        int index(String source) {
            switch (this.type) {
                case 4: {
                    return source.length() - 1 + this.offset;
                }
                case 2: {
                    try {
                        return Integer.valueOf(this.value) + this.offset;
                    }
                    catch (Exception e) {
                        return this.offset;
                    }
                }
                case 1: {
                    return source.indexOf(this.value);
                }
            }
            return -1;
        }

        String text(String source) {
            StringMatcher sm = new StringMatcher(this.value, true);
            return sm.getTokens(source);
        }

        String regex(String source) throws WMDocumentException {
            StringBuffer sb = new StringBuffer();
            try {
                MatchResult result;
                int groups;
                Perl5Compiler compiler = new Perl5Compiler();
                Perl5Matcher matcher = new Perl5Matcher();
                Pattern pattern = compiler.compile(this.value);
                PatternMatcherInput input = new PatternMatcherInput(source);
                if (matcher.contains(input, pattern) && (groups = (result = matcher.getMatch()).groups()) >= 1 && result.group(1) != null) {
                    for (int i = 1; i < groups; ++i) {
                        sb.append(result.group(i));
                    }
                }
            }
            catch (Exception e) {
                return null;
            }
            return sb.toString();
        }

        int index(List list) throws WMDocumentException {
            switch (this.type) {
                case 4: {
                    return list.size() - 1 + this.offset;
                }
                case 2: {
                    try {
                        return Integer.valueOf(this.value) + this.offset;
                    }
                    catch (Exception e) {
                        return this.offset;
                    }
                }
                case 1: {
                    StringMatcher sm = new StringMatcher(this.value);
                    int lSize = list.size();
                    for (int i = this.nextText; i < lSize; ++i) {
                        if (!sm.match(this.element(list, i).getText())) continue;
                        this.nextText = i + 1;
                        return i;
                    }
                    return -1;
                }
                case 8: {
                    try {
                        Perl5Compiler compiler = new Perl5Compiler();
                        Perl5Matcher matcher = new Perl5Matcher();
                        Pattern pattern = compiler.compile(this.value);
                        int listSize = list.size();
                        for (int i = this.nextText; i < listSize; ++i) {
                            if (!matcher.contains(this.element(list, i).getText(), pattern)) continue;
                            this.nextText = i + 1;
                            return i;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return -1;
                }
            }
            return -1;
        }

        Node element(List list) throws WMDocumentException {
            return this.element(list, this.index(list));
        }

        Node element(List list, int pos) {
            if (pos > list.size() - 1 || pos < 0) {
                return null;
            }
            return (Node)list.elementAt(pos);
        }

        private void parse(String text) throws WattReferenceException {
            if (text.indexOf(39) == 0) {
                this.type = 1;
                if (text.charAt(text.length() - 1) != '\'') {
                    throw new WattReferenceException("Text Range Element missing close in (" + text + ")");
                }
                this.value = text.substring(1, text.length() - 1);
            } else if (text.indexOf(47) == 0) {
                this.type = 8;
                if (text.charAt(text.length() - 1) != '/') {
                    throw new WattReferenceException("Regex Range Element missing close in (" + text + ")");
                }
                this.value = text.substring(1, text.length() - 1);
            } else if (text.indexOf(40) == 0) {
                int dash = text.indexOf(45);
                if (text.indexOf(41) != text.length() - 1 || dash < 0) {
                    throw new WattReferenceException("Range Offset Invalid");
                }
                RefRange sample = new RefRange(text.substring(1, dash));
                try {
                    this.offset = Integer.valueOf(text.substring(dash, text.length() - 1));
                }
                catch (Exception e) {
                    throw new WattReferenceException("Value '" + text.substring(dash, text.length() - 1) + "' must be an integer");
                }
                this.type = sample.type;
                this.value = sample.value;
            } else {
                this.value = text;
                if (text.equalsIgnoreCase("END")) {
                    this.type = 4;
                } else {
                    try {
                        Integer.valueOf(text).intValue();
                        this.type = 2;
                    }
                    catch (NumberFormatException x) {
                        throw new WattReferenceException("Invalid range in object reference: " + text);
                    }
                }
            }
        }
    }

    class RefByRange {
        int type;
        int increment = 1;
        RefRange start;
        RefRange end;
        boolean recurse;

        RefByRange(String text, boolean recurse) throws WattReferenceException {
            if (text == null) {
                throw new WattReferenceException("Null Index Element");
            }
            this.recurse = recurse;
            this.parse(text);
        }

        public String toString() {
            return "[" + this.start + ", " + this.end + (this.increment > 1 ? " +" + this.increment : "") + "]";
        }

        public void getPropArray(String source, List row) throws WMDocumentException {
            if (source == null) {
                return;
            }
            int i1 = 0;
            int i2 = 0;
            switch (this.type) {
                case 1: {
                    if (this.start.type == 1) {
                        row.addElement(this.start.text(source));
                        return;
                    }
                    if (this.start.type == 8) {
                        row.addElement(this.start.regex(source));
                        return;
                    }
                    i1 = this.start.index(source);
                    i2 = i1 + 1;
                    break;
                }
                case 2: {
                    i1 = this.start.index(source);
                    i2 = this.end.index(source) + 1;
                    break;
                }
                default: {
                    return;
                }
            }
            int len = source.length();
            if (i2 > len) {
                i2 = len;
            }
            if (i1 < 0 || i2 < 0 || i1 > len) {
                return;
            }
            if (i1 > i2) {
                throw new WMDocumentException("Begin index " + i1 + " is larger than end index " + (i2 - 1));
            }
            row.addElement(new String(source.substring(i1, i2)));
        }

        private void gatherChildren(Node parent, List collect, Name[] nsPrefixes, Name[] localNames, boolean recurse) throws WMDocumentException, WattReferenceException {
            if (parent.getFirstRealChild() == null) {
                return;
            }
            Node child = parent.getFirstRealChild();
            while (child != null) {
                if (!child.isTextNode() && !child.isFalseNode()) {
                    for (int i = 0; i < localNames.length; ++i) {
                        Name nsPrefix = nsPrefixes[i];
                        Name localName = localNames[i];
                        if (localName != wildcard && localName != child.getLocalNameWm() || nsPrefix != wildcard && nsPrefix != child.getNamespacePrefix()) continue;
                        collect.addElement(child);
                    }
                    if (recurse) {
                        this.gatherChildren(child, collect, nsPrefixes, localNames, recurse);
                    }
                }
                if (child == null) continue;
                child = parent.getNextRealSiblingOfChild(child);
            }
        }

        private List getChildrenByType(Node parent, Name nsPrefix, Name localName) throws WMDocumentException, WattReferenceException {
            List results = new List();
            if (parent == null) {
                return results;
            }
            Node child = parent.getFirstChildWm();
            if (child == null) {
                return results;
            }
            while (child != null) {
                if (child.getLocalNameWm() == localName && child.getNamespacePrefix() == nsPrefix) {
                    results.addElement(child);
                }
                child = parent.getNextSiblingOfChild(child);
            }
            if (results.size() > 0) {
                return results;
            }
            return null;
        }

        void retrieve(Node store, List row, Name[] nsPrefixes, Name[] localNames) throws WMDocumentException, WattReferenceException {
            List collected = null;
            if (localNames.length == 1 && localNames[0] != wildcard) {
                collected = this.getChildrenByType(store, nsPrefixes[0], localNames[0]);
            }
            if (collected == null || collected.size() == 0) {
                collected = new List();
                this.gatherChildren(store, collected, nsPrefixes, localNames, false);
                if (collected.size() == 0 && this.recurse) {
                    this.gatherChildren(store, collected, nsPrefixes, localNames, true);
                }
            }
            if (collected == null || collected.size() == 0) {
                return;
            }
            this.retrieve(row, collected);
        }

        synchronized void retrieve(List row, List collected) throws WMDocumentException {
            this.start.init();
            if (this.end != null) {
                this.end.init();
            }
            switch (this.type) {
                case 1: {
                    if (this.start.type == 1 || this.start.type == 8) {
                        Node o;
                        while ((o = this.start.element(collected)) != null) {
                            row.addElement(o);
                        }
                        break;
                    }
                    row.addElement(this.start.element(collected));
                    break;
                }
                case 2: {
                    int i1 = this.start.index(collected);
                    int i2 = this.end.index(collected);
                    for (int i = i1; i <= i2; ++i) {
                        row.addElement(this.start.element(collected, i));
                    }
                    break;
                }
                case 4: {
                    int i1 = this.start.index(collected);
                    int i2 = this.end.index(collected);
                    for (int i = i1; i <= i2; i += this.increment) {
                        if (i > i2) continue;
                        row.addElement(this.start.element(collected, i));
                    }
                    break;
                }
            }
        }

        private void parse(String text) throws WattReferenceException {
            if (text.charAt(0) == '(') {
                int loc = text.indexOf(41);
                if (loc < 0) {
                    throw new WattReferenceException("() element missing close parenthesis");
                }
                int loc2 = text.indexOf(45, loc);
                if (loc2 > 0) {
                    this.type = 2;
                    this.start = new RefRange(text.substring(0, loc + 1));
                    this.end = new RefRange(text.substring(loc2 + 1));
                } else {
                    this.type = 1;
                    this.start = new RefRange(text);
                }
            } else if (text.charAt(0) == '/') {
                this.type = 1;
                this.start = new RefRange(text);
            } else {
                int loc = text.indexOf(43);
                if (loc >= 0 && text.charAt(0) != '\'') {
                    this.type = 4;
                    int len = text.length();
                    if (loc >= len - 1) {
                        throw new WattReferenceException("Range increment is NULL");
                    }
                    this.start = new RefRange(text.substring(0, loc));
                    this.end = new RefRange("end");
                    try {
                        this.increment = Integer.valueOf(text.substring(loc + 1));
                    }
                    catch (Exception e) {
                        throw new WattReferenceException("Subscript '" + text.substring(loc + 1) + "' must be an integer");
                    }
                    if (this.increment <= 0) {
                        throw new WattReferenceException("Range increment is less than 1");
                    }
                } else {
                    loc = text.indexOf(45);
                    if (loc >= 0 && text.charAt(0) != '\'') {
                        this.type = 2;
                        this.start = new RefRange(text.substring(0, loc));
                        this.end = new RefRange(text.substring(loc + 1));
                    } else {
                        this.type = 1;
                        this.start = new RefRange(text);
                    }
                }
            }
        }
    }

    class RefByAttr {
        Name attrNSPrefix;
        Name attrLocalName;
        String value;
        boolean isRegex = false;

        RefByAttr(String text, boolean isHTML) throws WattReferenceException {
            if (text == null) {
                throw new WattReferenceException("Null Attribute Element");
            }
            if (text.indexOf(61) < 0) {
                throw new WattReferenceException("Attribute Element lacks a value");
            }
            this.parse(text, isHTML);
        }

        void retrieve(Node store, List row, Name elemNSPrefix, Name elemLocalName) throws WMDocumentException, WattReferenceException {
            this.collectByAttrVal(row, store, elemNSPrefix, elemLocalName);
        }

        private void collectByAttrVal(List row, Node parent, Name elemNSPrefix, Name elemLocalName) throws WMDocumentException, WattReferenceException {
            if (parent == null) {
                return;
            }
            Node nodeList = parent.getFirstRealChild();
            if (this.isRegex) {
                try {
                    Perl5Compiler compiler = new Perl5Compiler();
                    Perl5Matcher matcher = new Perl5Matcher();
                    Pattern pattern = compiler.compile(this.value);
                    String attrVal = null;
                    while (nodeList != null) {
                        String val;
                        this.collectByAttrVal(row, nodeList, elemNSPrefix, elemLocalName);
                        attrVal = ORNReference.getAttributeValueByPrefix(nodeList, this.attrNSPrefix, this.attrLocalName);
                        if (attrVal != null && (val = attrVal.toString()) != null && matcher.contains(val, pattern)) {
                            row.addElement(nodeList);
                        }
                        nodeList = parent.getNextRealSiblingOfChild(nodeList);
                    }
                }
                catch (Exception e) {}
            } else {
                String attrVal = null;
                StringMatcher sm = new StringMatcher(this.value);
                Object attribute = null;
                while (nodeList != null) {
                    if ((elemLocalName == any || elemLocalName == null || nodeList.getLocalNameWm() == elemLocalName && nodeList.getNamespacePrefix() == elemNSPrefix) && (attrVal = ORNReference.getAttributeValueByPrefix(nodeList, this.attrNSPrefix, this.attrLocalName)) != null && sm.match(attrVal)) {
                        row.addElement(nodeList);
                    }
                    this.collectByAttrVal(row, nodeList, elemNSPrefix, elemLocalName);
                    nodeList = parent.getNextRealSiblingOfChild(nodeList);
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            if (this.attrNSPrefix != null) {
                sb.append(this.attrNSPrefix);
                sb.append(':');
            }
            sb.append(this.attrLocalName);
            sb.append('=');
            sb.append(this.value);
            sb.append(')');
            return sb.toString();
        }

        private void parse(String text, boolean isHTML) throws WattReferenceException {
            int eIdx = text.indexOf(61);
            if (eIdx > 0) {
                String name = text.substring(0, eIdx);
                if (isHTML) {
                    this.attrLocalName = Name.create(name.toUpperCase());
                } else {
                    this.attrNSPrefix = ParseName.getPrefix(name);
                    this.attrLocalName = ParseName.getLocalName(name);
                }
                if (text.charAt(eIdx + 1) == '\'') {
                    this.value = text.substring(eIdx + 2, text.length() - 1);
                } else if (text.charAt(eIdx + 1) == '/') {
                    this.value = text.substring(eIdx + 2, text.length() - 1);
                    this.isRegex = true;
                } else {
                    this.value = text.substring(eIdx + 1);
                }
            } else {
                throw new WattReferenceException("attribute missing ='value'");
            }
        }
    }

    class RefElement {
        int type;
        int sequence;
        int ancestor = 0;
        boolean byName = true;
        boolean isArray = false;
        boolean allowRecurse = true;
        String property = null;
        List ranges = new List();
        List localNames = new List();
        List nsPrefixes = new List();
        RefByAttr attr;

        public RefElement(String text, int sequence) throws WattReferenceException {
            if (text == null || text.length() == 0) {
                throw new WattReferenceException("Object Token is NULL (two periods?)");
            }
            this.sequence = sequence;
            this.parse(text);
        }

        public int size() {
            if (this.ranges == null) {
                return 0;
            }
            return this.ranges.size();
        }

        public boolean isArray() {
            return this.isArray;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{" + this.nsPrefixes + ", " + this.localNames + "," + this.type + ",");
            if (this.type != 2) {
                int rSize = this.ranges.size();
                for (int i = 0; i < rSize; ++i) {
                    sb.append(this.ranges.elementAt(i).toString());
                }
            } else {
                sb.append(this.attr.toString());
            }
            return sb.toString() + "}";
        }

        private Node getPeerByOffset(Node parent, int offset) throws WMDocumentException {
            Node peer = parent.getFirstRealChild();
            int iCtr = -1;
            while (peer != null && iCtr < offset) {
                if (peer.getNodeType() == 1) {
                    ++iCtr;
                }
                if (iCtr == offset) {
                    return peer;
                }
                peer = parent.getNextRealSiblingOfChild(peer);
            }
            return peer;
        }

        private Node getSiblingByOffset(Node parent, Node node, int offset) throws WMDocumentException {
            Node sibling = parent.getFirstChildWm();
            int iCtr = -1;
            while (sibling != null) {
                if (sibling.getNodeType() == 1 && node.getLocalNameWm() == sibling.getLocalNameWm() && node.getNamespacePrefix() == sibling.getNamespacePrefix() && ++iCtr == offset) {
                    return sibling;
                }
                sibling = parent.getNextSiblingOfChild(sibling);
            }
            return null;
        }

        private int getPeerIndex(Node parent, Node node) throws WMDocumentException {
            int iCtr = 0;
            if (parent == null) {
                return 0;
            }
            Node sibling = parent.getFirstRealChild();
            while (sibling != null && sibling != node) {
                if (sibling.getNodeType() == 1) {
                    ++iCtr;
                }
                sibling = parent.getNextRealSiblingOfChild(sibling);
            }
            return iCtr;
        }

        private int getIndex(Node parent, Node node) throws WMDocumentException {
            int iCtr = 0;
            if (parent == null) {
                return 0;
            }
            Node sibling = parent.getFirstChildWm();
            while (sibling != null && sibling != node) {
                if (sibling.getNodeType() == 1 && node.getLocalNameWm() == sibling.getLocalNameWm() && node.getNamespacePrefix() == sibling.getNamespacePrefix()) {
                    ++iCtr;
                }
                sibling = parent.getNextSiblingOfChild(sibling);
            }
            return iCtr;
        }

        void retrieve(Node doc, Node store, List row) throws WMDocumentException, WattReferenceException {
            switch (this.type) {
                case 1: {
                    Object[] myLocalNames = new Name[this.localNames.size()];
                    Object[] myNSPrefixes = new Name[this.nsPrefixes.size()];
                    this.localNames.copyInto(myLocalNames);
                    this.nsPrefixes.copyInto(myNSPrefixes);
                    int rSize = this.ranges.size();
                    for (int i = 0; i < rSize; ++i) {
                        ((RefByRange)this.ranges.elementAt(i)).retrieve(store, row, (Name[])myNSPrefixes, (Name[])myLocalNames);
                    }
                    break;
                }
                case 3: {
                    if (this.ancestor <= 0) {
                        return;
                    }
                    Node o = store;
                    int i = 0;
                    while (o != null && i++ < this.ancestor) {
                        if ((o = o.getParent()) != null) continue;
                        return;
                    }
                    row.addElement(o);
                    break;
                }
                case 2: {
                    int lSize = this.localNames.size();
                    for (int x = 0; x < lSize; ++x) {
                        this.attr.retrieve(store, row, (Name)this.nsPrefixes.elementAt(x), (Name)this.localNames.elementAt(x));
                    }
                    break;
                }
                case 4: {
                    Node o = doc;
                    row.addElement(o);
                    break;
                }
                case 5: {
                    store = store.getReferenceNode();
                    Node p = store.getParent();
                    if (p == null) {
                        return;
                    }
                    int offset = this.getIndex(p, store);
                    if ((offset += this.ancestor) < 0) {
                        return;
                    }
                    Node s = this.getSiblingByOffset(p, store, offset);
                    if (s == null) {
                        return;
                    }
                    row.addElement(s);
                    break;
                }
                case 6: {
                    store = store.getReferenceNode();
                    Node p = store.getParent();
                    if (p == null) {
                        return;
                    }
                    int offset = this.getPeerIndex(p, store);
                    if ((offset += this.ancestor) < 0) {
                        return;
                    }
                    Node s = this.getPeerByOffset(p, offset);
                    if (s == null) {
                        return;
                    }
                    row.addElement(s);
                }
            }
        }

        public List getPropArray(String source) throws WMDocumentException {
            List row = new List();
            if (this.type == 1) {
                int rSize = this.ranges.size();
                for (int i = 0; i < rSize; ++i) {
                    ((RefByRange)this.ranges.elementAt(i)).getPropArray(source, row);
                }
            } else {
                row.addElement(source);
            }
            return row;
        }

        private void parse(String text) throws WattReferenceException {
            char firstChar = text.charAt(0);
            if (firstChar == '~') {
                this.allowRecurse = false;
                text = text.substring(1);
                firstChar = text.charAt(0);
            }
            int len = text.length();
            int open = text.indexOf(91);
            int open2 = text.indexOf(40);
            if (firstChar == '^') {
                this.type = 3;
                this.ancestor = 1;
                if (len > 1) {
                    try {
                        this.ancestor = Integer.parseInt(text.substring(1));
                    }
                    catch (NumberFormatException e) {
                        this.ancestor = 1;
                    }
                }
            } else if (firstChar == '+' || firstChar == '-') {
                this.type = 5;
                try {
                    this.ancestor = len > 1 ? Integer.parseInt(text.substring(1)) : 1;
                }
                catch (NumberFormatException e) {
                    this.ancestor = 1;
                }
                if (firstChar == '-') {
                    this.ancestor = 0 - this.ancestor;
                }
            } else if (firstChar == '@') {
                this.type = 6;
                try {
                    this.ancestor = len > 1 ? Integer.parseInt(text.substring(1)) : 1;
                }
                catch (NumberFormatException e) {
                    this.ancestor = 1;
                }
            } else if (open >= 0 && (open2 < 0 || open2 > open)) {
                StringParser tokens;
                this.type = 1;
                this.property = text.substring(0, open);
                this.getObjectTypes(this.property);
                if (text.charAt(len - 1) != ']') {
                    throw new WattReferenceException("Invalid Object Reference. No close bracket in \"" + text + "\"");
                }
                String indexStr = text.substring(open + 1, len - 1);
                if (indexStr.length() == 0) {
                    indexStr = "0-end";
                }
                if ((tokens = new StringParser(indexStr, ",", "'/", true)).countTokens() > 1) {
                    this.isArray = true;
                }
                while (tokens.hasMoreTokens()) {
                    RefByRange tempRange = new RefByRange(tokens.nextToken(), this.allowRecurse);
                    this.ranges.addElement(tempRange);
                    if (tempRange.end == null) continue;
                    this.isArray = true;
                }
            } else if (open2 >= 0) {
                open = open2;
                this.type = 2;
                this.getObjectTypes(text.substring(0, open));
                if (text.charAt(len - 1) != ')') {
                    throw new WattReferenceException("Invalid Object Reference. No close parenthesis in \"" + text + "\"");
                }
                String indexStr = text.substring(open + 1, len - 1);
                this.attr = new RefByAttr(indexStr, ORNObjectRef.this.isHTML);
            } else if (text.equalsIgnoreCase("doc")) {
                this.type = 4;
            } else {
                this.type = 2;
                this.nsPrefixes.addElement(null);
                this.localNames.addElement(unknownName);
                this.property = text;
                StringBuffer sb = new StringBuffer();
                sb.append("name='");
                sb.append(text);
                sb.append('\'');
                this.attr = new RefByAttr(sb.toString(), ORNObjectRef.this.isHTML);
                this.byName = false;
            }
        }

        private void getObjectTypes(String typeString) throws WattReferenceException {
            StringTokenizer st = new StringTokenizer(typeString, "|");
            if (ORNObjectRef.this.isHTML) {
                while (st.hasMoreTokens()) {
                    this.nsPrefixes.addElement(null);
                    this.localNames.addElement(HtmlType.equivalent(st.nextToken().toUpperCase()));
                }
            } else {
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    this.nsPrefixes.addElement(ParseName.getPrefix(name));
                    this.localNames.addElement(ParseName.getLocalName(name));
                }
            }
        }
    }
}

