/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSFault;
import com.wm.lang.websvc.WSHeader;
import com.wm.lang.websvc.WSMessage;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;

public class WSRespMessage
extends WSMessage {
    public static final String KEY_WSRESP_BODY = "body";
    public static final String KEY_WSRESP_HEADERS = "headers";
    public static final String KEY_WSRESP_FAULTS = "faults";

    public WSRespMessage(Namespace ns) {
        super(ns);
    }

    public static WSRespMessage create(IData data, Namespace ns) {
        WSRespMessage resp = new WSRespMessage(ns);
        resp.setFromData(data);
        return resp;
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, String portType) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, portType, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, String portType, WSContext wsdc) throws WSDLException {
        BindingOutput bindingoutput = definition.createBindingOutput();
        Output output = null;
        if (this.getWSBody() != null && this.getWSBody().getName() != null) {
            output = definition.createOutput();
            this.getWSBody().toDefinition(definition, (WSDLElement)output, (WSDLElement)bindingoutput, wsd, portType, wsdc);
        }
        boolean headerfound = false;
        WSHeader[] wsheaders = this.getWSHeaders();
        for (int h = 0; h < wsheaders.length; ++h) {
            wsheaders[h].toDefinition(definition, (WSDLElement)definition, (WSDLElement)bindingoutput, wsd, wsdc);
            headerfound = true;
        }
        boolean faultfound = false;
        WSFault[] wsfaults = this.getFaults();
        for (int f = 0; f < wsfaults.length; ++f) {
            wsfaults[f].toDefinition(definition, parent, bindingparent, wsd, wsdc);
            faultfound = true;
        }
        if (output != null && output.getMessage() != null) {
            ((Operation)parent).setOutput(output);
            ((BindingOperation)bindingparent).setBindingOutput(bindingoutput);
        } else if (headerfound || faultfound) {
            ((BindingOperation)bindingparent).setBindingOutput(bindingoutput);
        }
    }
}

