/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSFault;
import com.wm.lang.websvc.WSHeader;
import com.wm.lang.websvc.WSMessage;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;

public class WSReqMessage
extends WSMessage {
    public static final String KEY_WSREQ_BODY = "body";
    public static final String KEY_WSREQ_HEADERS = "headers";
    public static final String KEY_WSREQ_FAULTS = "faults";

    public WSReqMessage(Namespace ns) {
        super(ns);
    }

    public static WSReqMessage create(IData data, Namespace ns) {
        WSReqMessage req = new WSReqMessage(ns);
        req.setFromData(data);
        return req;
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, String portType) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, portType, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, String portType, WSContext wsdc) throws WSDLException {
        BindingInput bindinginput = definition.createBindingInput();
        Input input = null;
        if (this.getWSBody() != null && this.getWSBody().getName() != null) {
            input = definition.createInput();
            this.getWSBody().toDefinition(definition, (WSDLElement)input, (WSDLElement)bindinginput, wsd, portType, wsdc);
        }
        boolean headerfound = false;
        WSHeader[] wsheaders = this.getWSHeaders();
        for (int h = 0; h < wsheaders.length; ++h) {
            wsheaders[h].toDefinition(definition, (WSDLElement)definition, (WSDLElement)bindinginput, wsd, wsdc);
            headerfound = true;
        }
        boolean faultfound = false;
        WSFault[] wsfaults = this.getFaults();
        for (int h = 0; h < wsfaults.length; ++h) {
            wsfaults[h].toDefinition(definition, parent, bindingparent, wsd, wsdc);
            faultfound = true;
        }
        if (input != null && input.getMessage() != null) {
            ((Operation)parent).setInput(input);
            ((BindingOperation)bindingparent).setBindingInput(bindinginput);
        } else if (headerfound || faultfound) {
            ((BindingOperation)bindingparent).setBindingInput(bindinginput);
        }
    }
}

