/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.UIDRegistry;
import com.wm.lang.websvc.WSBody;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSFault;
import com.wm.lang.websvc.WSHeader;
import com.wm.lang.websvc.WSInvalidWSDLException;
import com.wm.lang.websvc.WSReqMessage;
import com.wm.lang.websvc.WSRespMessage;
import com.wm.lang.websvc.WSSOAPBody;
import com.wm.lang.websvc.WSSOAPElement;
import com.wm.lang.websvc.WSSOAPFault;
import com.wm.lang.websvc.WSSOAPHeader;
import com.wm.lang.websvc.WSSOAPOperation;
import com.wm.lang.websvc.resources.NSWebsvcExceptionBundle;
import com.wm.lang.wsdl.WSDUtil;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSOperation
implements ValuesCodable,
IDataPortable {
    private static boolean debug = new Boolean(System.getProperty("watt.server.WSDL.debug", "false"));
    public static final String KEY_WSO_OP_NAME = "operationName";
    public static final String KEY_WSO_SERVICE_NAME = "serviceName";
    public static final String KEY_WSO_REQUEST_ELEMENT = "requestElement";
    public static final String KEY_WSO_RESPONSE_ELEMENT = "responseElement";
    public static final String ATTR_PREFIX = "@";
    private String _operationName;
    private NSService _service;
    private WSReqMessage _requestMessage;
    private WSRespMessage _responseMessage;
    private Namespace _namespace;
    private NSName _serviceName;
    public static final String ROLE = "role";
    public static final String ACTOR = "actor";
    public static final String MUST_UNDERSTAND = "mustUnderstand";
    private boolean isExpanded = false;

    private WSOperation(Namespace ns) {
        this._namespace = ns;
    }

    public WSOperation(String name, NSService service) {
        this._service = service;
        this._serviceName = service.getNSName();
        this._operationName = name;
        this._namespace = this._service.getNamespace();
        this._requestMessage = new WSReqMessage(this._namespace);
        this._responseMessage = new WSRespMessage(this._namespace);
        NSRecord inRecord = null;
        NSRecord outRecord = null;
        NSSignature sig = service.getSignature();
        if (sig != null) {
            String srvType;
            int indx = name.indexOf(":");
            inRecord = sig.getInput();
            if (inRecord instanceof NSRecordRef) {
                inRecord = ((NSRecordRef)inRecord).getNSRecord();
            }
            if (inRecord != null && inRecord.getFields() != null && inRecord.getFields().length > 0) {
                String inName = inRecord.getName();
                srvType = service.getServiceType().getType();
                if (inName == null || inName.trim().equals("") || srvType.equals("AdapterService")) {
                    inName = name.substring(indx + 1);
                }
                WSBody inputBody = new WSBody(inName, service, true);
                this._requestMessage.setWSBody(inputBody);
            } else {
                this._requestMessage.setWSBody(new WSBody(this._serviceName.getNodeName().toString(), service, true));
            }
            outRecord = sig.getOutput();
            if (outRecord instanceof NSRecordRef) {
                outRecord = ((NSRecordRef)outRecord).getNSRecord();
            }
            if (outRecord != null && outRecord.getFields() != null && outRecord.getFields().length > 0) {
                String outName = outRecord.getName();
                srvType = service.getServiceType().getType();
                if (outName == null || outName.trim().equals("") || srvType.equals("AdapterService")) {
                    outName = name.substring(indx + 1) + "Response";
                }
                WSBody outputBody = new WSBody(outName, service, false);
                this._responseMessage.setWSBody(outputBody);
            } else {
                this._responseMessage.setWSBody(new WSBody(this._serviceName.getNodeName().toString() + "Response", service, false));
            }
        } else {
            this._requestMessage.setWSBody(new WSBody(this._serviceName.getNodeName().toString(), service, true));
            this._responseMessage.setWSBody(new WSBody(this._serviceName.getNodeName().toString() + "Response", service, false));
        }
    }

    public static WSOperation create(IData data, Namespace ns) {
        WSOperation operation = new WSOperation(ns);
        operation.setFromData(data);
        return operation;
    }

    public static WSOperation create(Definition def, Binding binding, Service service, BindingOperation bindingoperation, Namespace ns, boolean provider, Vector<NSNode> nodesPersisted, NSSchema[] schemaArray, NSPackage nsPkg, String ifcName) throws WSInvalidWSDLException {
        Object[][] inputmsgparms;
        LinkedHashMap<String, Values> faults;
        LinkedHashMap<String, Values> outputheaders;
        String outputdoctype;
        String outputnamespace;
        String outputmsgname;
        WSOperation op;
        block78: {
            Values bodyvalues;
            NSNode outnode;
            String use;
            LinkedHashMap<String, Values> inputheaders;
            QName[] outPartElements;
            QName[] outPartTypes;
            String[] outPartNames;
            String inputdoctype;
            String inputnamespace;
            String inputmsgname;
            WSDUtil util;
            String style;
            block77: {
                Message msg;
                Output output;
                Message msg2;
                Input input;
                BindingOutput bindingoutput;
                Object[] obj;
                Object inMessage = null;
                Object outMessage = null;
                Object inName = null;
                Object outName = null;
                style = null;
                util = new WSDUtil(schemaArray, nodesPersisted);
                Operation operation = bindingoperation.getOperation();
                op = new WSOperation(ns);
                op._service = null;
                op._namespace = ns;
                op._operationName = operation.getName();
                List opExt = bindingoperation.getExtensibilityElements();
                Iterator opExtIterator = opExt.iterator();
                WSSOAPBody inputSoapBody = null;
                WSSOAPBody outputSoapBody = null;
                while (opExtIterator.hasNext()) {
                    ExtensibilityElement ext = (ExtensibilityElement)opExtIterator.next();
                    if (ext instanceof SOAPOperation) {
                        style = ((SOAPOperation)ext).getStyle();
                        break;
                    }
                    if (!(ext instanceof SOAP12Operation)) continue;
                    style = ((SOAP12Operation)ext).getStyle();
                    break;
                }
                inputmsgname = "";
                outputmsgname = "";
                inputnamespace = "";
                outputnamespace = "";
                inputdoctype = null;
                outputdoctype = null;
                List inParts = null;
                String[] inPartNames = null;
                QName[] inPartTypes = null;
                QName[] inPartElements = null;
                List outParts = null;
                outPartNames = null;
                outPartTypes = null;
                outPartElements = null;
                javax.xml.namespace.QName inputheadername = null;
                String inputheadertype = "";
                javax.xml.namespace.QName outputheadername = null;
                String outputheadertype = "";
                String faulttype = "";
                inputheaders = new LinkedHashMap<String, Values>();
                outputheaders = new LinkedHashMap<String, Values>();
                faults = new LinkedHashMap<String, Values>();
                use = "";
                HashMap<String, String> namespaces = new HashMap<String, String>();
                for (String key : def.getNamespaces().keySet()) {
                    String nsname = def.getNamespace(key);
                    namespaces.put(nsname, key);
                }
                BindingInput bindinginput = bindingoperation.getBindingInput();
                if (bindinginput != null) {
                    obj = WSOperation.findExtensibilityElement(bindinginput.getExtensibilityElements(), "SOAPBody", op);
                    if (obj != null && obj.length > 0) {
                        WSSOAPBody soapBody;
                        inputSoapBody = soapBody = (WSSOAPBody)obj[0];
                        use = soapBody.getUse();
                        inputnamespace = soapBody.getNamespaceURI();
                        inParts = soapBody.getParts();
                        if (inParts != null && inParts.size() > 0 && inParts.get(0) != null && inParts.get(0) instanceof Part) {
                            inPartNames = new String[inParts.size()];
                            inPartTypes = new QName[inParts.size()];
                            inPartElements = new QName[inParts.size()];
                            for (int i = 0; i < inPartNames.length; ++i) {
                                Part part = (Part)inParts.get(i);
                                inPartNames[i] = part.getName();
                                javax.xml.namespace.QName qn = part.getTypeName();
                                if (qn != null) {
                                    inPartTypes[i] = QName.create(qn.getNamespaceURI(), part.getTypeName().getLocalPart());
                                }
                                if ((qn = part.getElementName()) == null) continue;
                                inPartElements[i] = QName.create(qn.getNamespaceURI(), qn.getLocalPart());
                            }
                        }
                    }
                    if ((obj = WSOperation.findExtensibilityElement(bindinginput.getExtensibilityElements(), "SOAPHeader", op)) != null) {
                        for (int sh = 0; sh < obj.length; ++sh) {
                            WSSOAPHeader soapheader = (WSSOAPHeader)obj[sh];
                            Object role = null;
                            String mustunderstand = "";
                            NSName hdrtype = UIDRegistry.find(QName.create(soapheader.getMessage().getNamespaceURI(), WSOperation.obtainRecordName(WSOperation.getMessage(def, soapheader.getMessage()), new String[]{soapheader.getPart()})));
                            if (hdrtype != null) {
                                inputheadertype = hdrtype.getValue();
                                inputheadername = new javax.xml.namespace.QName(hdrtype.getNodeName().toString());
                            } else {
                                inputheadertype = ifcName + "." + "docTypes" + ":" + WSOperation.obtainRecordName(WSOperation.getMessage(def, soapheader.getMessage()), new String[]{soapheader.getPart()});
                                inputheadername = new javax.xml.namespace.QName(WSOperation.obtainRecordName(WSOperation.getMessage(def, soapheader.getMessage()), new String[]{soapheader.getPart()}));
                            }
                            Object[][] headerparms = new Object[][]{{"name", inputheadername}, {"docType", inputheadertype}, {"nsOwner", inputheadertype}, {"nsOwnerType", 3}, {MUST_UNDERSTAND, mustunderstand.equals("1") || mustunderstand.equalsIgnoreCase("true") ? "true" : "false"}, {ROLE, role}};
                            inputheaders.put(soapheader.getMessage().toString() + "_" + soapheader.getPart(), new Values(headerparms));
                        }
                    }
                }
                if ((bindingoutput = bindingoperation.getBindingOutput()) != null) {
                    obj = WSOperation.findExtensibilityElement(bindingoutput.getExtensibilityElements(), "SOAPBody", op);
                    if (obj != null && obj.length > 0) {
                        WSSOAPBody soapBody;
                        outputSoapBody = soapBody = (WSSOAPBody)obj[0];
                        outputnamespace = soapBody.getNamespaceURI();
                        if (use.equals("")) {
                            use = soapBody.getUse();
                        }
                        if ((outParts = soapBody.getParts()) != null && outParts.size() > 0 && outParts.get(0) != null && outParts.get(0) instanceof Part) {
                            outPartNames = new String[outParts.size()];
                            outPartTypes = new QName[outParts.size()];
                            outPartElements = new QName[outParts.size()];
                            for (int i = 0; i < outPartNames.length; ++i) {
                                Part part = (Part)outParts.get(i);
                                outPartNames[i] = part.getName();
                                javax.xml.namespace.QName qn = part.getTypeName();
                                if (qn != null) {
                                    outPartTypes[i] = QName.create(qn.getNamespaceURI(), part.getTypeName().getLocalPart());
                                }
                                if ((qn = part.getElementName()) == null) continue;
                                outPartElements[i] = QName.create(qn.getNamespaceURI(), qn.getLocalPart());
                            }
                        }
                    }
                    if ((obj = WSOperation.findExtensibilityElement(bindingoutput.getExtensibilityElements(), "SOAPHeader", op)) != null) {
                        for (int sh = 0; sh < obj.length; ++sh) {
                            WSSOAPHeader soapheader = (WSSOAPHeader)obj[sh];
                            String role = null;
                            String mustunderstand = "";
                            NSName hdrtype = UIDRegistry.find(QName.create(soapheader.getMessage().getNamespaceURI(), WSOperation.obtainRecordName(WSOperation.getMessage(def, soapheader.getMessage()), new String[]{soapheader.getPart()})));
                            if (hdrtype != null) {
                                outputheadertype = hdrtype.getValue();
                                outputheadername = new javax.xml.namespace.QName(hdrtype.getNodeName().toString());
                            } else {
                                outputheadertype = ifcName + "." + "docTypes" + ":" + WSOperation.obtainRecordName(WSOperation.getMessage(def, soapheader.getMessage()), new String[]{soapheader.getPart()});
                                outputheadername = new javax.xml.namespace.QName(WSOperation.obtainRecordName(WSOperation.getMessage(def, soapheader.getMessage()), new String[]{soapheader.getPart()}));
                            }
                            Iterator messagesIter = def.getMessages().keySet().iterator();
                            while (messagesIter.hasNext()) {
                                Message msg3 = WSOperation.getMessage(def, (javax.xml.namespace.QName)messagesIter.next());
                                if (!msg3.getQName().getLocalPart().equals(soapheader.getMessage().getLocalPart())) continue;
                                Map attrmap = msg3.getExtensionAttributes();
                                if (attrmap == null) break;
                                for (javax.xml.namespace.QName attrname : attrmap.keySet()) {
                                    if (attrname.getLocalPart().equalsIgnoreCase(ROLE) || attrname.getLocalPart().equalsIgnoreCase(ACTOR)) {
                                        role = msg3.getExtensionAttribute(attrname).toString();
                                        continue;
                                    }
                                    if (!attrname.getLocalPart().equalsIgnoreCase(MUST_UNDERSTAND)) continue;
                                    mustunderstand = ((javax.xml.namespace.QName)msg3.getExtensionAttribute(attrname)).toString();
                                }
                            }
                            Object[][] headerparms = new Object[][]{{"name", outputheadername}, {"docType", outputheadertype}, {"nsOwner", outputheadertype}, {"nsOwnerType", 3}, {MUST_UNDERSTAND, mustunderstand.equals("1") || mustunderstand.equalsIgnoreCase("true") ? "true" : "false"}, {ROLE, role}};
                            outputheaders.put(soapheader.getMessage().toString() + "_" + soapheader.getPart(), new Values(headerparms));
                        }
                    }
                }
                Iterator faultsIter = bindingoperation.getBindingFaults().keySet().iterator();
                while (faultsIter.hasNext()) {
                    BindingFault bindingfault = bindingoperation.getBindingFault((String)faultsIter.next());
                    obj = WSOperation.findExtensibilityElement(bindingfault.getExtensibilityElements(), "SOAPFault", op);
                    if (obj == null || obj.length <= 0) continue;
                    for (int sf = 0; sf < obj.length; ++sf) {
                        NSName hdrtype;
                        WSSOAPFault soapfault = (WSSOAPFault)obj[sf];
                        String faultname = soapfault.getName();
                        if (faultname == null || faultname.equals("")) {
                            String opName = op._operationName;
                            javax.xml.namespace.QName bindingQName = binding.getQName();
                            String bindingName = bindingQName != null ? bindingQName.toString() : "";
                            throw new WSInvalidWSDLException(NSWebsvcExceptionBundle.class.getName(), NSWebsvcExceptionBundle.WSDL_ATTRIBUTE_NOT_FOUND_EXCEPTION, new Object[]{"name", "soap:fault", opName, bindingQName});
                        }
                        String prefix = "";
                        int indx4 = faultname.lastIndexOf(":");
                        if (indx4 > -1) {
                            prefix = faultname.substring(0, indx4);
                            faultname = faultname.substring(indx4 + 1);
                        }
                        faulttype = (hdrtype = UIDRegistry.find(QName.create(soapfault.getNamespaceURI(), faultname))) != null ? hdrtype.getValue() : ifcName + "." + "docTypes" + ":" + WSOperation.obtainRecordName(operation.getFault(bindingfault.getName()).getMessage(), new String[0]);
                        Object[][] faultparms = new Object[][]{{"name", faultname}, {"docType", faulttype}, {"nsOwner", faulttype}};
                        if (soapfault.getNamespaceURI() != null) {
                            faults.put(soapfault.getNamespaceURI() + ":" + faultname, new Values(faultparms));
                            continue;
                        }
                        faults.put(faulttype, new Values(faultparms));
                    }
                }
                NSNode innode = null;
                if ((inputmsgname == null || inputmsgname.trim().equals("") || inParts == null) && (input = operation.getInput()) != null && (msg2 = input.getMessage()) != null) {
                    inputmsgname = binding.getPortType().getQName().getLocalPart() + "_" + bindingoperation.getName() + "_Input";
                    inputnamespace = msg2.getQName().getNamespaceURI();
                    if (inputmsgname != null && !inputmsgname.trim().equals("")) {
                        inputdoctype = ifcName + ".docTypes:" + inputmsgname;
                        innode = ns.getNode(NSName.create(inputdoctype));
                    }
                    if (innode == null || !(innode instanceof NSRecord)) {
                        inParts = msg2.getOrderedParts(null);
                        List parts = null;
                        if (inputSoapBody != null) {
                            parts = inputSoapBody.getParts();
                        }
                        if (inParts != null && parts != null) {
                            inPartNames = new String[parts.size()];
                            inPartTypes = new QName[parts.size()];
                            inPartElements = new QName[parts.size()];
                            block14: for (int i = 0; i < parts.size(); ++i) {
                                String partToBeIncludedInBody = (String)parts.get(i);
                                for (int j = 0; j < inParts.size(); ++j) {
                                    Part part = (Part)inParts.get(j);
                                    if (!part.getName().equals(partToBeIncludedInBody)) continue;
                                    inPartNames[i] = part.getName();
                                    javax.xml.namespace.QName qn = part.getTypeName();
                                    if (qn != null) {
                                        inPartTypes[i] = QName.create(qn.getNamespaceURI(), part.getTypeName().getLocalPart());
                                    }
                                    if ((qn = part.getElementName()) == null) continue block14;
                                    inPartElements[i] = QName.create(qn.getNamespaceURI(), qn.getLocalPart());
                                    continue block14;
                                }
                            }
                        } else if (inParts != null) {
                            inPartNames = new String[inParts.size()];
                            inPartTypes = new QName[inParts.size()];
                            inPartElements = new QName[inParts.size()];
                            for (int i = 0; i < inPartNames.length; ++i) {
                                Part part = (Part)inParts.get(i);
                                inPartNames[i] = part.getName();
                                javax.xml.namespace.QName qn = part.getTypeName();
                                if (qn != null) {
                                    inPartTypes[i] = QName.create(qn.getNamespaceURI(), part.getTypeName().getLocalPart());
                                }
                                if ((qn = part.getElementName()) == null) continue;
                                inPartElements[i] = QName.create(qn.getNamespaceURI(), qn.getLocalPart());
                            }
                        }
                    }
                }
                outnode = null;
                if ((outputmsgname == null || outputmsgname.trim().equals("") || outParts == null) && (output = operation.getOutput()) != null && (msg = output.getMessage()) != null) {
                    outputmsgname = binding.getPortType().getQName().getLocalPart() + "_" + bindingoperation.getName() + "_Output";
                    outputnamespace = msg.getQName().getNamespaceURI();
                    if (outputmsgname != null && !outputmsgname.trim().equals("")) {
                        outputdoctype = ifcName + ".docTypes:" + outputmsgname;
                        outnode = ns.getNode(NSName.create(outputdoctype));
                    }
                    if (outnode == null || !(outnode instanceof NSRecord)) {
                        outParts = msg.getOrderedParts(null);
                        List parts = null;
                        if (outputSoapBody != null) {
                            parts = outputSoapBody.getParts();
                        }
                        if (outParts != null && parts != null) {
                            outPartNames = new String[parts.size()];
                            outPartTypes = new QName[parts.size()];
                            outPartElements = new QName[parts.size()];
                            block17: for (int i = 0; i < parts.size(); ++i) {
                                String partToBeIncludedInBody = (String)parts.get(i);
                                for (int j = 0; j < outParts.size(); ++j) {
                                    Part part = (Part)outParts.get(j);
                                    if (!part.getName().equals(partToBeIncludedInBody)) continue;
                                    outPartNames[i] = part.getName();
                                    javax.xml.namespace.QName qn = part.getTypeName();
                                    if (qn != null) {
                                        outPartTypes[i] = QName.create(qn.getNamespaceURI(), part.getTypeName().getLocalPart());
                                    }
                                    if ((qn = part.getElementName()) == null) continue block17;
                                    outPartElements[i] = QName.create(qn.getNamespaceURI(), qn.getLocalPart());
                                    continue block17;
                                }
                            }
                        } else if (outParts != null) {
                            outPartNames = new String[outParts.size()];
                            outPartTypes = new QName[outParts.size()];
                            outPartElements = new QName[outParts.size()];
                            for (int i = 0; i < outPartNames.length; ++i) {
                                Part part = (Part)outParts.get(i);
                                outPartNames[i] = part.getName();
                                javax.xml.namespace.QName qn = part.getTypeName();
                                if (qn != null) {
                                    outPartTypes[i] = QName.create(qn.getNamespaceURI(), part.getTypeName().getLocalPart());
                                }
                                if ((qn = part.getElementName()) == null) continue;
                                outPartElements[i] = QName.create(qn.getNamespaceURI(), qn.getLocalPart());
                            }
                        }
                    }
                }
                if (use.equals("")) {
                    use = "literal";
                }
                bodyvalues = new Values();
                if (innode != null && innode instanceof NSRecord) {
                    bodyvalues = ((NSRecord)innode).getValues();
                } else if (innode == null && inputmsgname != null && !inputmsgname.trim().equals("")) {
                    boolean verbose = true;
                    try {
                        boolean added;
                        inputmsgname = NSWSDescriptor.wsdl2isname(inputmsgname);
                        inputdoctype = ifcName + ".docTypes:" + inputmsgname;
                        boolean rpcEnc = false;
                        if ("RPC".equalsIgnoreCase(style) && "encoded".equalsIgnoreCase(use)) {
                            rpcEnc = true;
                        }
                        if (added = util.genRecords(inputmsgname, inPartNames, inPartTypes, inPartElements, ns, nsPkg, ifcName + ".docTypes", ATTR_PREFIX, verbose, Locale.getDefault(), rpcEnc)) {
                            innode = ns.getNode(NSName.create(inputdoctype));
                        }
                        if (innode != null && innode.getNodeTypeObj() == NSRecord.TYPE) {
                            bodyvalues = ((NSRecord)innode).getValues();
                        } else if (debug) {
                            System.out.println("!!! DEBUG - No Input Record Found for Operation:" + inputdoctype);
                        }
                    }
                    catch (Exception ex) {
                        if (!debug) break block77;
                        ex.printStackTrace();
                    }
                }
            }
            Object[][] inputbodyparms = new Object[][]{{"name", inputnamespace + ":" + inputmsgname}, {"docType", inputdoctype}, {"nsOwner", inputdoctype}, {"nsOwnerType", 3}};
            inputmsgparms = new Object[][]{{"body", new Values(inputbodyparms)}, {"headers", inputheaders}, {"faults", null}};
            bodyvalues = new Values();
            if (outputdoctype != null) {
                outnode = ns.getNode(NSName.create(outputdoctype));
            }
            if (outnode != null && outnode instanceof NSRecord) {
                bodyvalues = ((NSRecord)outnode).getValues();
            } else if (outnode == null && outputmsgname != null && !outputmsgname.trim().equals("")) {
                boolean verbose = true;
                try {
                    boolean added;
                    outputmsgname = NSWSDescriptor.wsdl2isname(outputmsgname);
                    outputdoctype = ifcName + ".docTypes:" + outputmsgname;
                    boolean rpcEnc = false;
                    if ("RPC".equalsIgnoreCase(style) && "encoded".equalsIgnoreCase(use)) {
                        rpcEnc = true;
                    }
                    if (added = util.genRecords(outputmsgname, outPartNames, outPartTypes, outPartElements, ns, nsPkg, ifcName + ".docTypes", ATTR_PREFIX, verbose, Locale.getDefault(), rpcEnc)) {
                        outnode = ns.getNode(NSName.create(outputdoctype));
                    }
                    if (outnode != null && outnode.getNodeTypeObj() == NSRecord.TYPE) {
                        bodyvalues = ((NSRecord)outnode).getValues();
                    } else if (debug) {
                        System.out.println("!!! DEBUG - No Output Record Found for Operation:" + outputdoctype);
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block78;
                    ex.printStackTrace();
                }
            }
        }
        Object[][] outputbodyparms = new Object[][]{{"name", outputnamespace + ":" + outputmsgname}, {"docType", outputdoctype}, {"nsOwner", outputdoctype}, {"nsOwnerType", 3}};
        Object[][] outputmsgparms = new Object[][]{{"body", new Values(outputbodyparms)}, {"headers", outputheaders}, {"faults", faults}};
        op._requestMessage = WSReqMessage.create(IDataFactory.create(inputmsgparms), ns);
        op._responseMessage = WSRespMessage.create(IDataFactory.create(outputmsgparms), ns);
        String serviceName = NSWSDescriptor.wsdl2isname(op._operationName);
        op._serviceName = provider ? NSName.create(ifcName + "." + "services", serviceName) : NSName.create(ifcName + "." + "connectors", serviceName);
        NSNode opSvc = ns.getNode(op._serviceName);
        if (opSvc instanceof NSService) {
            op._service = (NSService)opSvc;
        }
        return op;
    }

    public void setOperationName(String operationName) {
        this._operationName = operationName;
    }

    public String getOperationName() {
        return this._operationName;
    }

    public NSName getServiceName() {
        return this._serviceName;
    }

    public NSService getService() {
        if (this._service == null) {
            NSNode svc;
            if (this._serviceName == null || this._serviceName.toString().trim().equals("")) {
                this._serviceName = NSName.create(this._operationName);
            }
            if ((svc = this._namespace.getNode(this._serviceName)) != null && svc instanceof NSService) {
                this._service = (NSService)svc;
            }
        }
        return this._service;
    }

    public void setService(NSService service) {
        this._service = service;
        this._serviceName = this._service.getNSName();
    }

    public WSReqMessage getWSRequest() {
        return this._requestMessage;
    }

    public WSRespMessage getWSResponse() {
        return this._responseMessage;
    }

    @Override
    public Values getValues() {
        Values requestMessage = null;
        if (this._requestMessage != null) {
            requestMessage = this._requestMessage.getValues();
        }
        Values responseMessage = null;
        if (this._responseMessage != null) {
            responseMessage = this._responseMessage.getValues();
        }
        Object[][] o = new Object[][]{{KEY_WSO_OP_NAME, this._operationName}, {KEY_WSO_SERVICE_NAME, this._serviceName != null ? this._serviceName.getFullName() : null}, {KEY_WSO_REQUEST_ELEMENT, requestMessage}, {KEY_WSO_RESPONSE_ELEMENT, responseMessage}};
        return new Values(o);
    }

    @Override
    public void setValues(Values values) {
        block7: {
            if (values == null) {
                return;
            }
            this._operationName = values.getString(KEY_WSO_OP_NAME);
            String sName = values.getString(KEY_WSO_SERVICE_NAME);
            if (sName != null && sName.length() > 0) {
                this._serviceName = NSName.create(sName);
                try {
                    NSNode svc = this._namespace.getNode(this._serviceName);
                    if (svc instanceof NSService) {
                        this._service = (NSService)svc;
                    }
                }
                catch (Exception e) {
                    if (!debug) break block7;
                    e.printStackTrace();
                }
            }
        }
        Values f = values.getValues(KEY_WSO_REQUEST_ELEMENT);
        this._requestMessage = new WSReqMessage(this._namespace);
        if (f != null) {
            this._requestMessage.setValues(f);
        }
        f = values.getValues(KEY_WSO_RESPONSE_ELEMENT);
        this._responseMessage = new WSRespMessage(this._namespace);
        if (f != null) {
            this._responseMessage.setValues(f);
        }
    }

    @Override
    public IData getAsData() {
        IData requestMessage = null;
        if (this._requestMessage != null) {
            requestMessage = this._requestMessage.getAsData();
        }
        IData responseMessage = null;
        if (this._responseMessage != null) {
            responseMessage = this._responseMessage.getAsData();
        }
        Object[][] o = new Object[][]{{KEY_WSO_OP_NAME, this._operationName}, {KEY_WSO_SERVICE_NAME, this._serviceName != null ? this._serviceName.getFullName() : null}, {KEY_WSO_REQUEST_ELEMENT, requestMessage}, {KEY_WSO_RESPONSE_ELEMENT, responseMessage}};
        return IDataFactory.create(o);
    }

    @Override
    public void setFromData(IData values) {
        Object f;
        IDataCursor ic;
        block14: {
            if (values == null) {
                return;
            }
            ic = values.getCursor();
            if (ic.first(KEY_WSO_OP_NAME)) {
                this._operationName = IDataUtil.getString(ic);
            }
            if (ic.first(KEY_WSO_SERVICE_NAME)) {
                String sName = IDataUtil.getString(ic);
                this._serviceName = NSName.create(sName);
                try {
                    NSNode svc = this._namespace.getNode(this._serviceName);
                    if (svc instanceof NSService) {
                        this._service = (NSService)svc;
                    }
                }
                catch (Exception e) {
                    if (!debug) break block14;
                    e.printStackTrace();
                }
            }
        }
        this._requestMessage = new WSReqMessage(this._namespace);
        if (ic.first(KEY_WSO_REQUEST_ELEMENT)) {
            f = ic.getValue();
            if (f instanceof Values) {
                this._requestMessage.setValues((Values)f);
            } else if (f instanceof IData) {
                this._requestMessage.setFromData((IData)f);
            }
        }
        this._responseMessage = new WSRespMessage(this._namespace);
        if (ic.first(KEY_WSO_RESPONSE_ELEMENT) && (f = ic.getValue()) != null) {
            if (f instanceof Values) {
                this._responseMessage.setValues((Values)f);
            } else if (f instanceof IData) {
                this._responseMessage.setFromData((IData)f);
            }
        }
    }

    private static Object[] findExtensibilityElement(List extelements, String type, WSOperation op) {
        Vector<WSSOAPElement> objs = new Vector<WSSOAPElement>();
        for (int e = 0; e < extelements.size(); ++e) {
            Object obj = extelements.get(e);
            if (type.equalsIgnoreCase("SOAPBody") && (obj instanceof SOAPBody || obj instanceof SOAP12Body)) {
                objs.add(new WSSOAPBody(obj));
            }
            if (type.equalsIgnoreCase("SOAPHeader") && (obj instanceof SOAPHeader || obj instanceof SOAP12Header)) {
                objs.add(new WSSOAPHeader(obj));
            }
            if (!type.equalsIgnoreCase("SOAPFault") || !(obj instanceof SOAPFault) && !(obj instanceof SOAP12Fault)) continue;
            objs.add(new WSSOAPFault(obj));
        }
        return objs.toArray(new Object[0]);
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, WSContext wsdc) throws WSDLException {
        WSRespMessage resp;
        WSReqMessage req;
        int indx = -1;
        String opname = this.getOperationName();
        indx = opname.indexOf(":");
        if (indx > -1) {
            opname = opname.substring(indx + 1);
        }
        BindingOperation bindingoperation = definition.createBindingOperation();
        bindingoperation.setName(opname);
        boolean operationcreated = false;
        Operation operation = ((PortType)parent).getOperation(this.getOperationName(), null, null);
        if (operation == null) {
            operation = definition.createOperation();
            operation.setName(opname);
            operationcreated = true;
        }
        if ((req = this.getWSRequest()) != null) {
            req.toDefinition(definition, (WSDLElement)operation, (WSDLElement)bindingoperation, wsd, ((PortType)parent).getQName().getLocalPart(), wsdc);
            WSFault[] wsfaults = req.getFaults();
            for (int f = 0; f < wsfaults.length; ++f) {
                wsfaults[f].toDefinition(definition, (WSDLElement)operation, (WSDLElement)bindingoperation, wsd, wsdc);
            }
        }
        if ((resp = this.getWSResponse()) != null) {
            resp.toDefinition(definition, (WSDLElement)operation, (WSDLElement)bindingoperation, wsd, ((PortType)parent).getQName().getLocalPart(), wsdc);
        }
        String soapns = "http://schemas.xmlsoap.org/wsdl/soap/";
        if (wsd.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            soapns = "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        operation.setUndefined(false);
        bindingoperation.setOperation(operation);
        WSSOAPOperation soapoperation = new WSSOAPOperation(wsd.createExtension(BindingOperation.class, new javax.xml.namespace.QName(soapns, "operation")));
        wsdc.getSOAPObjects().add(soapoperation.getElement());
        bindingoperation.addExtensibilityElement(soapoperation.getElement());
        ((Binding)bindingparent).addBindingOperation(bindingoperation);
        if (operationcreated) {
            ((PortType)parent).addOperation(operation);
        }
    }

    public WSOperation copy(String operationName) {
        IData idata = this.getAsData();
        WSOperation copyObj = WSOperation.create(idata, this._namespace);
        if (operationName != null) {
            copyObj.setOperationName(operationName);
        }
        return copyObj;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public Vector<NSRecord> getAllRecordsForOperation(int wsdType) {
        WSBody body;
        WSRespMessage resp;
        WSBody body2;
        Vector<NSRecord> records = new Vector<NSRecord>();
        NSRecord record = null;
        WSReqMessage req = this.getWSRequest();
        if (req != null && wsdType == 1 && (body2 = req.getWSBody()) != null) {
            records.add(body2.getNSRecord());
        }
        if ((resp = this.getWSResponse()) != null && wsdType == 1 && (body = resp.getWSBody()) != null) {
            records.add(body.getNSRecord());
        }
        WSHeader[] wsheaders = req.getWSHeaders();
        for (int h = 0; h < wsheaders.length; ++h) {
            record = wsdType == 1 ? wsheaders[h].getNSRecord() : wsheaders[h].getNSRecordToMergeWSDL();
            if (record == null) continue;
            records.add(record);
        }
        WSFault[] wsfaultsReq = req.getFaults();
        for (int f = 0; f < wsfaultsReq.length; ++f) {
            record = wsdType == 1 ? wsfaultsReq[f].getNSRecord() : wsfaultsReq[f].getNSRecordToMergeWSDL();
            if (record == null) continue;
            records.add(record);
        }
        WSHeader[] wsheadersResp = resp.getWSHeaders();
        for (int h = 0; h < wsheadersResp.length; ++h) {
            record = wsdType == 1 ? wsheadersResp[h].getNSRecord() : wsheadersResp[h].getNSRecordToMergeWSDL();
            if (record == null) continue;
            records.add(record);
        }
        WSFault[] wsfaults = resp.getFaults();
        for (int f = 0; f < wsfaults.length; ++f) {
            record = wsdType == 1 ? wsfaults[f].getNSRecord() : wsfaults[f].getNSRecordToMergeWSDL();
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    private static String obtainRecordName(Message msg, String[] parts) {
        StringBuffer recordNameBuffer = new StringBuffer(16);
        recordNameBuffer.append(msg.getQName().getLocalPart());
        Map partsFromMsgMap = msg.getParts();
        boolean allPartFromMsgIncluded = true;
        Iterator partsFromMsgIter = partsFromMsgMap.values().iterator();
        if (parts != null && parts.length > 0) {
            allPartFromMsgIncluded = false;
            while (partsFromMsgIter.hasNext()) {
                Part partFromMsg = (Part)partsFromMsgIter.next();
                allPartFromMsgIncluded = false;
                for (String part : parts) {
                    if (!partFromMsg.getName().equals(part)) continue;
                    allPartFromMsgIncluded = true;
                    break;
                }
                if (allPartFromMsgIncluded) continue;
                break;
            }
        }
        if (!allPartFromMsgIncluded && parts != null && parts.length > 0) {
            for (String part : parts) {
                recordNameBuffer.append('_').append(part);
            }
        }
        return recordNameBuffer.toString();
    }

    private static Message getMessage(Definition def, javax.xml.namespace.QName name) {
        Map allMessages = def.getMessages();
        if (allMessages != null && allMessages.get(name) != null) {
            return (Message)allMessages.get(name);
        }
        Map allImports = def.getImports();
        if (allImports != null) {
            for (List importsList : allImports.values()) {
                if (importsList == null) continue;
                Iterator importsListItr = importsList.iterator();
                while (importsListItr.hasNext()) {
                    Message message = WSOperation.getMessage(((Import)importsListItr.next()).getDefinition(), name);
                    if (message == null) continue;
                    return message;
                }
            }
        }
        return null;
    }
}

