/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSBody;
import com.wm.lang.websvc.WSElement;
import com.wm.lang.websvc.WSFault;
import com.wm.lang.websvc.WSHeader;
import com.wm.util.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.namespace.QName;

public class WSMessage
extends WSElement {
    public static final String KEY_WSO_HEADER = "headers";
    public static final String KEY_WSO_BODY = "body";
    public static final String KEY_WSO_FAULT = "faults";
    private Vector<WSHeader> _headers;
    private WSBody _body;
    private Vector<WSFault> _faults;

    public WSMessage(Namespace ns) {
        super(ns);
    }

    public WSHeader[] getWSHeaders() {
        Object[] headers = new WSHeader[]{};
        if (this._headers != null) {
            headers = new WSHeader[this._headers.size()];
            this._headers.copyInto(headers);
        }
        return headers;
    }

    public void setWSHeaders(WSHeader[] headers) {
        this._headers = new Vector<WSHeader>(Arrays.asList(headers));
    }

    public String[] getHeaderNames() {
        if (this._headers != null) {
            String[] headers = new String[this._headers.size()];
            for (int i = 0; i < this._headers.size(); ++i) {
                headers[i] = this._headers.get(i).getName();
            }
            return headers;
        }
        return new String[0];
    }

    public QName[] getHeaderQNames() {
        if (this._headers != null) {
            QName[] headers = new QName[this._headers.size()];
            for (int i = 0; i < this._headers.size(); ++i) {
                NSRecord rec = this._headers.get(i).getNSRecord();
                if (rec != null) {
                    headers[i] = new QName(rec.getUniversalName().getNamespace(), rec.getUniversalName().getNCName());
                    continue;
                }
                String headerlocalpart = this._headers.get(i).getName();
                String headernamespace = "";
                int indx = headerlocalpart.indexOf("}");
                if (indx > -1) {
                    headerlocalpart = headerlocalpart.substring(indx + 1);
                    headernamespace = headerlocalpart.substring(1, indx);
                }
                headers[i] = new QName(headernamespace, headerlocalpart);
            }
            return headers;
        }
        return new QName[0];
    }

    public WSBody getWSBody() {
        return this._body;
    }

    public void setWSBody(WSBody body) {
        this._body = body;
    }

    public WSFault[] getFaults() {
        Object[] faults = new WSFault[]{};
        if (this._faults != null) {
            faults = new WSFault[this._faults.size()];
            this._faults.copyInto(faults);
        }
        return faults;
    }

    public void setFaults(WSFault[] faults) {
        if (faults != null) {
            this._faults = new Vector<WSFault>(Arrays.asList(faults));
        }
    }

    public Values getValues() {
        Values[] headerList = null;
        if (this._headers != null) {
            headerList = new Values[this._headers.size()];
            for (int i = 0; i < headerList.length; ++i) {
                WSHeader wsHeader = this._headers.get(i);
                if (wsHeader == null) continue;
                headerList[i] = wsHeader.getValues();
            }
        }
        Values[] faultList = null;
        if (this._faults != null) {
            faultList = new Values[this._faults.size()];
            for (int i = 0; i < faultList.length; ++i) {
                WSFault wsFault = this._faults.get(i);
                if (wsFault == null) continue;
                faultList[i] = wsFault.getValues();
            }
        }
        Values body = null;
        if (this._body != null) {
            body = this._body.getValues();
        }
        Object[][] o = new Object[][]{{KEY_WSO_HEADER, headerList}, {KEY_WSO_BODY, body}, {KEY_WSO_FAULT, faultList}};
        return new Values(o);
    }

    public void setValues(Values values) {
        if (values == null) {
            return;
        }
        Object obj = values.get(KEY_WSO_HEADER);
        Values[] headerList = new Values[]{};
        if (obj instanceof LinkedHashMap) {
            headerList = ((LinkedHashMap)obj).values().toArray(headerList);
        } else if (obj instanceof Values[]) {
            headerList = (Values[])obj;
        }
        if (headerList != null) {
            this._headers = new Vector();
            for (int i = 0; i < headerList.length; ++i) {
                WSHeader header2 = new WSHeader(this.getNamespace());
                header2.setValues(headerList[i]);
                this._headers.add(header2);
            }
        }
        obj = values.get(KEY_WSO_FAULT);
        Values[] faultList = new Values[]{};
        if (obj instanceof LinkedHashMap) {
            faultList = ((LinkedHashMap)obj).values().toArray(faultList);
        } else if (obj instanceof Values[]) {
            faultList = (Values[])obj;
        }
        if (faultList != null) {
            this._faults = new Vector();
            for (int i = 0; i < faultList.length; ++i) {
                WSFault fault = new WSFault(this.getNamespace());
                fault.setValues(faultList[i]);
                this._faults.add(fault);
            }
        }
        Values body = values.getValues(KEY_WSO_BODY);
        this._body = new WSBody(this.getNamespace());
        this._body.setValues(body);
    }

    public IData getAsData() {
        IData[] headerList = null;
        if (this._headers != null) {
            headerList = new IData[this._headers.size()];
            for (int i = 0; i < headerList.length; ++i) {
                WSHeader wsHeader = this._headers.get(i);
                if (wsHeader == null) continue;
                headerList[i] = wsHeader.getAsData();
            }
        }
        IData[] faultList = null;
        if (this._faults != null) {
            faultList = new IData[this._faults.size()];
            for (int i = 0; i < faultList.length; ++i) {
                WSFault wsFault = this._faults.get(i);
                if (wsFault == null) continue;
                faultList[i] = wsFault.getAsData();
            }
        }
        IData body = null;
        if (this._body != null) {
            body = this._body.getAsData();
        }
        Object[][] o = new Object[][]{{KEY_WSO_HEADER, headerList}, {KEY_WSO_BODY, body}, {KEY_WSO_FAULT, faultList}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        IData body;
        int i;
        if (values == null) {
            return;
        }
        IDataCursor ic = values.getCursor();
        this._headers = new Vector();
        Object[] list = new IData[]{};
        Object h = IDataUtil.get(ic, KEY_WSO_HEADER);
        if (h != null) {
            if (h instanceof Vector) {
                list = ((Vector)h).toArray();
            } else if (h instanceof ArrayList) {
                list = ((ArrayList)h).toArray();
            } else if (h instanceof IData[]) {
                list = (IData[])h;
            } else if (h instanceof LinkedHashMap) {
                list = (IData[])((LinkedHashMap)h).values().toArray(list);
            }
            for (i = 0; i < list.length; ++i) {
                WSHeader head = new WSHeader(this.getNamespace());
                head.setFromData((IData)list[i]);
                this._headers.add(head);
            }
        }
        this._faults = new Vector();
        h = IDataUtil.get(ic, KEY_WSO_FAULT);
        if (h != null) {
            list = new IData[]{};
            if (h instanceof Vector) {
                list = ((Vector)h).toArray();
            } else if (h instanceof ArrayList) {
                list = ((ArrayList)h).toArray();
            } else if (h instanceof IData[]) {
                list = (IData[])h;
            } else if (h instanceof LinkedHashMap) {
                list = (IData[])((LinkedHashMap)h).values().toArray(list);
            }
            for (i = 0; i < list.length; ++i) {
                WSFault fault = new WSFault(this.getNamespace());
                fault.setFromData((IData)list[i]);
                this._faults.add(fault);
            }
        }
        if ((body = IDataUtil.getIData(ic, KEY_WSO_BODY)) != null) {
            this._body = WSBody.create(body, this.getNamespace());
        }
    }

    public void addHeader(WSHeader header2) {
        if (this._headers == null) {
            this._headers = new Vector();
        }
        this._headers.add(header2);
    }

    public void addFault(WSFault fault) {
        if (this._faults == null) {
            this._faults = new Vector();
        }
        this._faults.add(fault);
    }

    public void removeHeader(WSHeader header2) {
        if (this._headers == null || header2 == null) {
            return;
        }
        for (int i = 0; i < this._headers.size(); ++i) {
            if (!this._headers.get(i).getValues().equals(header2.getValues())) continue;
            this._headers.removeElementAt(i);
            return;
        }
    }

    public void removeFault(WSFault fault) {
        if (this._faults == null || fault == null) {
            return;
        }
        for (int i = 0; i < this._faults.size(); ++i) {
            if (!this._faults.get(i).getValues().equals(fault.getValues())) continue;
            this._faults.removeElementAt(i);
            return;
        }
    }
}

