/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSElement;
import com.wm.lang.websvc.WSSOAPHeader;
import com.wm.util.Values;
import java.util.Arrays;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;

public class WSHeader
extends WSElement {
    public static final String KEY_WSH_MUST_UNDERSTAND = "mustUnderstand";
    public static final String KEY_WSH_ACTOR = "actor";
    public static final String KEY_WSH_ROLE = "role";
    public static final String KEY_WSH_NONE = "None";
    public static final String KEY_WSH_NEXT = "Next";
    public static final String KEY_WSH_ULTIMATE_RECEIVER = "Ultimate Receiver";
    private boolean _mustUnderstand;
    private String _role;

    public WSHeader(Namespace ns) {
        super(ns);
    }

    public WSHeader(String name, String docType, Namespace ns) {
        super(ns);
        this.setName(name);
        this.setDocType(docType);
    }

    public static WSHeader create(IData data, Namespace ns) {
        WSHeader header2 = new WSHeader(ns);
        header2.setFromData(data);
        return header2;
    }

    public String getRole() {
        return this._role;
    }

    public void setRole(String role) {
        this._role = role;
    }

    public boolean isMustUnderstand() {
        return this._mustUnderstand;
    }

    public void setMustUnderstand(boolean mu) {
        this._mustUnderstand = mu;
    }

    public Values getValues() {
        Values vals = super.getValues();
        vals.put(KEY_WSH_MUST_UNDERSTAND, Boolean.toString(this._mustUnderstand));
        vals.put(KEY_WSH_ROLE, this._role);
        return vals;
    }

    public void setValues(Values values) {
        if (values == null) {
            return;
        }
        super.setValues(values);
        this._mustUnderstand = Boolean.parseBoolean(values.getString(KEY_WSH_MUST_UNDERSTAND));
        this._role = values.getString(KEY_WSH_ROLE);
    }

    public IData getAsData() {
        IData data = super.getAsData();
        IDataCursor idc = data.getCursor();
        IDataUtil.put(idc, KEY_WSH_MUST_UNDERSTAND, this._mustUnderstand ? "true" : "false");
        IDataUtil.put(idc, KEY_WSH_ROLE, this._role);
        idc.destroy();
        return data;
    }

    public void setFromData(IData values) {
        if (values == null) {
            return;
        }
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        this._mustUnderstand = IDataUtil.getBoolean(ic, KEY_WSH_MUST_UNDERSTAND);
        this._role = IDataUtil.getString(ic, KEY_WSH_ROLE);
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, WSContext wsdc) throws WSDLException {
        QName qn;
        String namespace;
        block11: {
            Message msg;
            block12: {
                namespace = "";
                String localName = null;
                String prefix = null;
                NSRecord nsr = this.getNSRecord();
                if (nsr == null) {
                    return;
                }
                qn = this.getQName();
                if (qn == null) {
                    return;
                }
                namespace = qn.getNamespaceURI();
                localName = qn.getLocalPart();
                if (namespace == null || namespace.trim().equals("")) {
                    namespace = wsd.resolveTargetNamespace(this);
                    qn = new QName(namespace, localName);
                }
                if ((prefix = wsdc.getPrefix(namespace)) == null) {
                    int fp = 1;
                    while (definition.getNamespace("HDR" + fp) != null) {
                        ++fp;
                    }
                    prefix = "HDR" + fp;
                    definition.addNamespace(prefix, namespace);
                    wsdc.putPrefix(namespace, prefix);
                }
                qn = new QName(namespace, localName, prefix);
                wsd.formatMessageFragment(this, localName, wsdc);
                msg = definition.getMessage(qn);
                if (msg != null) break block11;
                msg = definition.createMessage();
                msg.setQName(qn);
                msg.setUndefined(false);
                wsd.parseNSRecord(definition, msg, nsr, "HEADER", wsdc);
                if (wsd.getWSDType() == 1) break block12;
                if (wsd.getWSDType() == 1 || !this.isAddedByClient()) break block11;
            }
            ((Definition)parent).addMessage(msg);
        }
        Object[] obj = this.findExtensibilityElement(bindingparent.getExtensibilityElements(), "SOAPHeader");
        Class<BindingInput> clazz = BindingInput.class;
        if (bindingparent instanceof BindingOutput) {
            clazz = BindingOutput.class;
        }
        WSSOAPHeader soapheader = new WSSOAPHeader(wsd.createExtension(clazz, new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header")));
        soapheader.setPart("parameters");
        if (!wsdc.getBinderStyleAndUse().equalsIgnoreCase("doclit") && !wsdc.getBinderStyleAndUse().equalsIgnoreCase("rpclit")) {
            soapheader.setNamespaceURI(namespace);
        }
        soapheader.setMessage(qn);
        if (wsdc.getBinderStyleAndUse().equalsIgnoreCase("rpcenc")) {
            soapheader.setEncodingStyles(Arrays.asList("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        wsdc.getSOAPObjects().add(soapheader.getElement());
        bindingparent.addExtensibilityElement(soapheader.getElement());
    }

    public WSHeader copy(String copyName) {
        WSHeader copyElement = WSHeader.create(this.getAsData(), this.getNamespace());
        if (copyName != null) {
            copyElement.setName(copyName);
        }
        return copyElement;
    }

    public QName getQName() {
        com.wm.util.QName universal;
        String namespace = "";
        String localName = null;
        Object prefix = null;
        QName qn = null;
        NSRecord nsr = this.getNSRecord();
        if (nsr == null) {
            return qn;
        }
        namespace = nsr.getPath();
        if (nsr.getNSName() != null && nsr.getNSName().getNodeName() != null) {
            localName = nsr.getNSName().getNodeName().toString();
        }
        if ((universal = nsr.getUniversalName()) != null) {
            namespace = universal.getNamespace();
            localName = universal.getNCName();
        } else {
            namespace = "";
            localName = this.getName();
            int indx = localName.lastIndexOf("}");
            if (indx > -1) {
                namespace = localName.substring(1, indx);
                if (namespace.trim().equalsIgnoreCase("null")) {
                    namespace = "";
                }
                localName = localName.substring(indx + 1);
            }
        }
        return new QName(namespace, localName);
    }
}

