/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSElement;
import com.wm.lang.websvc.WSSOAPFault;
import com.wm.util.QName;
import java.util.List;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;

public class WSFault
extends WSElement {
    public WSFault(Namespace ns) {
        super(ns);
    }

    public static WSFault create(IData data, Namespace ns) {
        WSFault fault = new WSFault(ns);
        fault.setFromData(data);
        return fault;
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, WSContext wsdc) throws WSDLException {
        Message msg;
        BindingFault bindingfault;
        boolean createdNewBindingFault;
        Fault fault;
        boolean createdNewFault;
        block22: {
            block23: {
                String temp = this.getNSRecord().getName();
                if (temp == null && (temp = this.getName()).startsWith("{null}")) {
                    temp = "{" + wsd.getTargetNamespace() + "}" + temp.substring(6);
                    this.setName(temp);
                }
                String faultname = temp;
                QName universal = this.getNSRecord().getUniversalName();
                if (universal != null && universal.getNCName() != null && !universal.getNCName().trim().equals("")) {
                    faultname = universal.getNCName();
                }
                String faulturl = "";
                String faultprefix = "";
                int indx = faultname.indexOf("}");
                if (indx > -1) {
                    faulturl = temp.substring(1, indx);
                    faultname = temp.substring(indx + 1);
                    faultprefix = wsdc.getPrefix(faulturl);
                } else {
                    indx = temp.indexOf(":");
                    if (indx > -1) {
                        faultprefix = temp.substring(0, indx);
                        faultname = temp.substring(indx + 1);
                        faulturl = definition.getNamespace(faultprefix);
                    }
                }
                String docType = this.getDocType();
                if (docType == null || docType.trim().equals("")) {
                    docType = NSWSDescriptor.resolveNSRecordname(QName.create(faulturl, faultname));
                    this.setDocType(docType);
                }
                if (faulturl == null || faulturl.trim().equals("") || faulturl.trim().equalsIgnoreCase("null")) {
                    faulturl = wsd.resolveTargetNamespace(this);
                    if ((faultprefix == null || faultprefix.trim().equals("")) && (faultprefix = wsdc.getPrefix(faulturl)) == null) {
                        int fp = 1;
                        while (definition.getNamespace("FLT" + fp) != null) {
                            ++fp;
                        }
                        faultprefix = "FLT" + fp;
                    }
                    if (definition.getNamespace(faultprefix) == null) {
                        definition.addNamespace(faultprefix, faulturl);
                        wsdc.putPrefix(faulturl, faultprefix);
                    }
                }
                wsd.formatMessageFragment(this, faultname, wsdc);
                createdNewFault = false;
                fault = ((Operation)parent).getFault(faultname);
                if (fault == null) {
                    fault = definition.createFault();
                    fault.setName(faultname);
                    createdNewFault = true;
                }
                createdNewBindingFault = false;
                String bindingfaultname = faultprefix + ":" + faultname;
                bindingfault = ((BindingOperation)bindingparent).getBindingFault(bindingfaultname);
                if (bindingfault == null) {
                    bindingfault = definition.createBindingFault();
                    bindingfault.setName(faultname);
                    createdNewBindingFault = true;
                }
                WSSOAPFault soapfault = null;
                Object[] obj = null;
                try {
                    List extElements = bindingparent.getExtensibilityElements();
                    obj = this.findExtensibilityElement(extElements, "SOAPFault");
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                if (obj == null || obj.length == 0) {
                    String soapns = "http://schemas.xmlsoap.org/wsdl/soap/";
                    if (wsd.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
                        soapns = "http://schemas.xmlsoap.org/wsdl/soap12/";
                    }
                    soapfault = new WSSOAPFault(wsd.createExtension(BindingFault.class, new javax.xml.namespace.QName(soapns, "fault")));
                    soapfault.setName(faultname);
                    if (!wsdc.getBinderStyleAndUse().equalsIgnoreCase("doclit") && !wsdc.getBinderStyleAndUse().equalsIgnoreCase("rpclit")) {
                        soapfault.setNamespaceURI(faulturl);
                    }
                    wsdc.getSOAPObjects().add(soapfault.getElement());
                    bindingfault.addExtensibilityElement(soapfault.getElement());
                }
                if ((msg = definition.getMessage(new javax.xml.namespace.QName(faulturl, faultname))) != null) break block22;
                msg = definition.createMessage();
                msg.setQName(new javax.xml.namespace.QName(faulturl, faultname, faultprefix));
                wsd.parseNSRecord(definition, msg, this.getDocType(), "FAULT", wsdc);
                msg.setUndefined(false);
                if (wsd.getWSDType() == 1) break block23;
                if (wsd.getWSDType() == 1 || !this.isAddedByClient()) break block22;
            }
            definition.addMessage(msg);
        }
        fault.setMessage(msg);
        if (createdNewBindingFault) {
            ((BindingOperation)bindingparent).addBindingFault(bindingfault);
        }
        if (createdNewFault) {
            ((Operation)parent).addFault(fault);
        }
    }

    public WSFault copy(String copyName) {
        WSFault copyElement = WSFault.create(this.getAsData(), this.getNamespace());
        if (copyName != null) {
            copyElement.setName(copyName);
        }
        return copyElement;
    }
}

