/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.websvc.WSEndpoint;
import com.wm.util.EncUtil;
import com.wm.util.Values;
import com.wm.util.ValuesRegistry;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WSEndpointManager {
    public static final String MESSAGE_INFO = "messageInfo";
    public static final String TRANSPORT_INFO = "transportInfo";
    public static final String USER = "user";
    public static final String PORT = "port";
    public static final String HOST = "host";
    public static final String PRIVATE_KEY_FILE_NAME = "privateKeyFileName";
    public static final String SERVER_CERTIFICATE_FILE_NAMES = "serverCertificateFileNames";
    public static final String PARTNER_PUBLIC_KEY_FILE_NAME = "partnerPublicKeyFileName";
    public static final String TRUSTED_AUTHORITY_DIR_NAME = "trustedAuthorityDirName";
    private File _file;
    private ValuesRegistry _endpoints;
    private Map<String, WSEndpoint> _endpointsCache = new ConcurrentHashMap<String, WSEndpoint>();
    private String _defaultHost;
    private String _defaultPort;
    public static final String KEY_DEFAULT = "default";
    private static WSEndpointManager _endpointManager;

    public static WSEndpointManager current() {
        return _endpointManager;
    }

    public WSEndpointManager(File file, String defaultHost, String defaultPort) {
        this._file = file;
        _endpointManager = this;
        this._endpoints = new ValuesRegistry(this._file);
        this._defaultHost = defaultHost;
        this._defaultPort = defaultPort;
        if (!this._endpoints.containsKey(KEY_DEFAULT)) {
            IData endp = this._endpoints.getIData();
            IDataCursor idc = endp.getCursor();
            idc.first();
            Values transportInfo = new Values();
            transportInfo.put(HOST, this._defaultHost);
            transportInfo.put(PORT, this._defaultPort);
            Values v = new Values();
            v.put(TRANSPORT_INFO, transportInfo);
            idc.insertBefore(KEY_DEFAULT, v);
            idc.destroy();
        }
    }

    public WSEndpoint getEndpoint(String alias) {
        WSEndpoint ept = this._endpointsCache.get(alias);
        if (ept != null) {
            return ept;
        }
        Values aliasProps = (Values)this._endpoints.get(alias);
        if (aliasProps != null) {
            Values transportProps = aliasProps.getValues(TRANSPORT_INFO);
            String transportHost = null;
            String transportPort = null;
            String transportUser = null;
            String transportPrivateKeyFileName = null;
            String transportServersCertificateFileName = null;
            if (transportProps != null) {
                transportHost = transportProps.getString(HOST);
                transportPort = transportProps.getString(PORT);
                transportUser = transportProps.getString(USER);
                transportPrivateKeyFileName = transportProps.getString(PRIVATE_KEY_FILE_NAME);
                transportServersCertificateFileName = transportProps.getString(SERVER_CERTIFICATE_FILE_NAMES);
            }
            Values messageProps = aliasProps.getValues(MESSAGE_INFO);
            String messageUser = null;
            String messagePrivateKeyFileName = null;
            String messageServersCertificateFileName = null;
            String messagePartnerPublicKeyFileName = null;
            String messageTrustedAuthorityDirName = null;
            if (messageProps != null) {
                messageUser = messageProps.getString(USER);
                messagePrivateKeyFileName = messageProps.getString(PRIVATE_KEY_FILE_NAME);
                messageServersCertificateFileName = messageProps.getString(SERVER_CERTIFICATE_FILE_NAMES);
                messagePartnerPublicKeyFileName = messageProps.getString(PARTNER_PUBLIC_KEY_FILE_NAME);
                messageTrustedAuthorityDirName = messageProps.getString(TRUSTED_AUTHORITY_DIR_NAME);
            }
            if (transportHost != null && transportPort != null) {
                ept = new WSEndpoint(alias, new WSEndpoint.TransportInfo(transportHost, transportPort, transportUser, null, transportPrivateKeyFileName, transportServersCertificateFileName), new WSEndpoint.MessageInfo(messageUser, null, messagePrivateKeyFileName, messageServersCertificateFileName, messagePartnerPublicKeyFileName, messageTrustedAuthorityDirName));
            }
            this._endpointsCache.put(alias, ept);
        }
        return ept;
    }

    public WSEndpoint[] listEndpoints() {
        Values tmp = new Values();
        tmp.copyFrom(this._endpoints);
        String[] keys = tmp.getValueKeys();
        WSEndpoint[] epts = new WSEndpoint[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            epts[i] = this.getEndpoint(keys[i]);
        }
        return epts;
    }

    public WSEndpoint addEndpoint(String alias, String oldAlias, WSEndpoint.TransportInfo tInfo, WSEndpoint.MessageInfo mInfo) {
        if (alias == null || tInfo.getHost() == null || tInfo.getPort() == null) {
            return null;
        }
        Values v = new Values();
        if (tInfo != null) {
            Values transportInfo = new Values();
            this.setValue(transportInfo, HOST, tInfo.getHost());
            this.setValue(transportInfo, PORT, tInfo.getPort());
            this.setValue(transportInfo, USER, tInfo.getUser());
            this.setValue(transportInfo, PRIVATE_KEY_FILE_NAME, tInfo.getPrivateKeyFileName());
            this.setValue(transportInfo, SERVER_CERTIFICATE_FILE_NAMES, tInfo.getServerCertificateFileNames());
            v.put(TRANSPORT_INFO, transportInfo);
        }
        if (mInfo != null) {
            Values messageInfo = new Values();
            this.setValue(messageInfo, USER, mInfo.getUser());
            this.setValue(messageInfo, PRIVATE_KEY_FILE_NAME, mInfo.getPrivateKeyFileName());
            this.setValue(messageInfo, SERVER_CERTIFICATE_FILE_NAMES, mInfo.getServerCertificateFileNames());
            this.setValue(messageInfo, PARTNER_PUBLIC_KEY_FILE_NAME, mInfo.getPartnerPublicKeyFileName());
            this.setValue(messageInfo, TRUSTED_AUTHORITY_DIR_NAME, mInfo.getTrustedAuthorityDirName());
            v.put(MESSAGE_INFO, messageInfo);
        }
        if (oldAlias != null && !oldAlias.equals(alias)) {
            this._endpoints.remove(oldAlias);
            this._endpointsCache.remove(oldAlias);
        }
        this._endpoints.putWithWrite(EncUtil.normalize(alias), v);
        this._endpointsCache.remove(alias);
        return new WSEndpoint(alias, tInfo, mInfo);
    }

    private void setValue(Values info, String key, String value) {
        if (value != null && value.trim().length() > 0) {
            info.put(key, value);
        }
    }

    public boolean deleteEndpoint(String alias) {
        if (alias == null) {
            return false;
        }
        if (KEY_DEFAULT.equals(alias)) {
            return false;
        }
        this._endpoints.removeWithWrite(alias);
        this._endpointsCache.remove(alias);
        return true;
    }
}

