/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.security.Util;
import com.wm.util.ServerException;
import com.wm.util.Strings;
import com.wm.util.resources.UtilExceptionBundle;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class WSEndpoint {
    private String _aliasName;
    private TransportInfo _transportInfo;
    private MessageInfo _messageInfo;

    public WSEndpoint(String aliasName, TransportInfo transportInfo, MessageInfo messageInfo) {
        this._aliasName = aliasName;
        this._transportInfo = transportInfo;
        this._messageInfo = messageInfo;
    }

    public String getAliasName() {
        return this._aliasName;
    }

    public MessageInfo getMessageInfo() {
        return this._messageInfo;
    }

    public TransportInfo getTransportInfo() {
        return this._transportInfo;
    }

    private static PrivateKey getServerPrivateKey(String privateKeyFileName) throws ServerException {
        try {
            return Util.loadRSAPrivateKey(privateKeyFileName);
        }
        catch (InvalidKeyException e) {
            throw new ServerException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_PRIVATE_KEY, null, e, new String[]{privateKeyFileName});
        }
        catch (IOException e) {
            throw new ServerException(UtilExceptionBundle.class, UtilExceptionBundle.IO_EXCEPTION_WHILE_READING_KEY_FILE, null, e, new String[]{privateKeyFileName});
        }
    }

    private static X509Certificate[] getServerCertificateChain(String serverCertificateFileNames) throws ServerException {
        try {
            String[] certChain = Strings.getCSL(serverCertificateFileNames);
            for (int i = 0; i < certChain.length; ++i) {
                if (certChain[i] == null) continue;
                certChain[i] = certChain[i].trim();
            }
            return Util.loadX509Chain(certChain);
        }
        catch (CertificateException e) {
            throw new ServerException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_CERTIFICATE, null, e, new String[]{serverCertificateFileNames});
        }
        catch (IOException e) {
            throw new ServerException(UtilExceptionBundle.class, UtilExceptionBundle.IO_EXCEPTION_WHILE_READING_KEY_FILE, null, e, new String[]{serverCertificateFileNames});
        }
    }

    private static X509Certificate getPartnerCertificateChain(String partnerCertificateFileName) throws ServerException {
        try {
            X509Certificate[] certChain = Util.loadCertificateFromFile(partnerCertificateFileName);
            if (certChain != null && certChain.length > 0) {
                return certChain[0];
            }
            return null;
        }
        catch (CertificateException e) {
            throw new ServerException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_CERTIFICATE, null, e, new String[]{partnerCertificateFileName});
        }
        catch (IOException e) {
            throw new ServerException(UtilExceptionBundle.class, UtilExceptionBundle.IO_EXCEPTION_WHILE_READING_KEY_FILE, null, e, new String[]{partnerCertificateFileName});
        }
    }

    public static class MessageInfo {
        private String _user;
        private String _password;
        private String _privateKeyFileName;
        private String _serverCertificateFileNames;
        private String _partnerPublicKeyFileName;
        private String _trustedAuthorityDirName;
        private PrivateKey _serverPrivateKey = null;
        private X509Certificate[] _serverCertificateChain = null;
        private X509Certificate _partnerCertificate = null;
        private X509Certificate[] _trustedAuthorityCertificates = null;

        public MessageInfo(String user, String password, String privateKeyFileName, String serversCertificateFileName, String partnerPublicKeyFileName, String trustedAuthorityDirName) {
            this._user = user;
            this._password = password;
            this._privateKeyFileName = privateKeyFileName;
            this._serverCertificateFileNames = serversCertificateFileName;
            this._partnerPublicKeyFileName = partnerPublicKeyFileName;
            this._trustedAuthorityDirName = trustedAuthorityDirName;
        }

        public String getUser() {
            return this._user;
        }

        public String getPassword() {
            return this._password;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getPrivateKeyFileName() {
            return this._privateKeyFileName;
        }

        public String getServerCertificateFileNames() {
            return this._serverCertificateFileNames;
        }

        public String getPartnerPublicKeyFileName() {
            return this._partnerPublicKeyFileName;
        }

        public String getTrustedAuthorityDirName() {
            return this._trustedAuthorityDirName;
        }

        public PrivateKey getServerPrivateKey() throws ServerException {
            if (this._privateKeyFileName != null && this._privateKeyFileName.trim().length() > 0 && this._serverPrivateKey == null) {
                this._serverPrivateKey = WSEndpoint.getServerPrivateKey(this._privateKeyFileName.trim());
            }
            return this._serverPrivateKey;
        }

        public X509Certificate[] getServerCertificateChain() throws ServerException {
            if (this._serverCertificateFileNames != null && this._serverCertificateFileNames.trim().length() > 0 && this._serverCertificateChain == null) {
                this._serverCertificateChain = WSEndpoint.getServerCertificateChain(this._serverCertificateFileNames);
            }
            return this._serverCertificateChain;
        }

        public X509Certificate getPartnerCertificate() throws ServerException {
            if (this._partnerPublicKeyFileName != null && this._partnerPublicKeyFileName.trim().length() > 0 && this._partnerCertificate == null) {
                this._partnerCertificate = WSEndpoint.getPartnerCertificateChain(this._partnerPublicKeyFileName.trim());
            }
            return this._partnerCertificate;
        }

        public X509Certificate[] getTrustedAuthorityCertificates() {
            if (this._trustedAuthorityDirName != null && this._trustedAuthorityDirName.trim().length() > 0 && this._trustedAuthorityCertificates == null) {
                this._trustedAuthorityCertificates = Util.loadCertificatesFromDir(this._trustedAuthorityDirName.trim());
            }
            return this._trustedAuthorityCertificates;
        }
    }

    public static class TransportInfo {
        private String _host;
        private String _port;
        private String _user;
        private String _password;
        private String _privateKeyFileName;
        private String _serverCertificateFileNames;
        private PrivateKey _serverPrivateKey = null;
        private X509Certificate[] _serverCertificateChain = null;

        public TransportInfo(String host, String port, String user, String password, String privateKeyFileName, String serversCertificateFileName) {
            this._host = host;
            this._port = port;
            this._user = user;
            this._password = password;
            this._privateKeyFileName = privateKeyFileName;
            this._serverCertificateFileNames = serversCertificateFileName;
        }

        public String getHost() {
            return this._host;
        }

        public String getPort() {
            return this._port;
        }

        public String getUser() {
            return this._user;
        }

        public String getPassword() {
            return this._password;
        }

        public void setPassword(String password) {
            this._password = password;
        }

        public String getPrivateKeyFileName() {
            return this._privateKeyFileName;
        }

        public String getServerCertificateFileNames() {
            return this._serverCertificateFileNames;
        }

        public PrivateKey getServerPrivateKey() throws ServerException {
            if (this._privateKeyFileName != null && this._privateKeyFileName.trim().length() > 0 && this._serverPrivateKey == null) {
                this._serverPrivateKey = WSEndpoint.getServerPrivateKey(this._privateKeyFileName);
            }
            return this._serverPrivateKey;
        }

        public X509Certificate[] getServerCertificateChain() throws ServerException {
            if (this._serverCertificateFileNames != null && this._serverCertificateFileNames.trim().length() > 0 && this._serverCertificateChain == null) {
                this._serverCertificateChain = WSEndpoint.getServerCertificateChain(this._serverCertificateFileNames);
            }
            return this._serverCertificateChain;
        }
    }
}

