/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSSOAPAddress;
import com.wm.lang.websvc.WSSOAPBinding;
import com.wm.lang.websvc.WSSOAPBody;
import com.wm.lang.websvc.WSSOAPElement;
import com.wm.lang.websvc.WSSOAPFault;
import com.wm.lang.websvc.WSSOAPHeader;
import com.wm.lang.websvc.WSSOAPOperation;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;

public abstract class WSElement
implements ValuesCodable,
IDataPortable {
    public static final String KEY_WSO_ELEMENT_NAME = "name";
    public static final String KEY_WSO_ELEMENT_DOCTYPE = "docType";
    public static final String KEY_WSO_ELEMENT_NSOWNER = "nsOwner";
    public static final String KEY_WSO_ELEMENT_NSOWNER_TYPE = "nsOwnerType";
    public static final String KEY_WSO_ELEMENT_SCHEMA_URL = "schemaURL";
    public static final String KEY_WSO_ELEMENT_SCHEMA_ELEMENT = "schemaElement";
    public static final String KEY_WSO_ELEMENT_ADDED_BY_CLIENT = "addedByClient";
    private String _name;
    private String _docType;
    private Namespace _namespace;
    private String _nsOwnerName;
    private int _nsOwnerType;
    private String _schemaURL;
    private String _schemaElement;
    public static final int TYPE_EXTERNAL_SCHEMA = 0;
    public static final int TYPE_SERVICE_SIGNATURE_IN = 1;
    public static final int TYPE_SERVICE_SIGNATURE_OUT = 2;
    public static final int TYPE_DOCUMENT_TYPE = 3;
    private boolean _addedByClient = false;
    private boolean isExpanded = false;

    protected WSElement(Namespace ns) {
        this._namespace = ns;
    }

    public String getName() {
        return this._name;
    }

    public Namespace getNamespace() {
        return this._namespace;
    }

    public void setName(String name) {
        this._name = name;
    }

    public NSRecord getNSRecordToMergeWSDL() {
        if (!this._addedByClient) {
            return null;
        }
        return this.getNSRecord();
    }

    public NSRecord getNSRecord() {
        NSRecord nsr = new NSRecord(this._namespace);
        NSNode node = null;
        NSSignature sig = null;
        String xmlns = "";
        String elementname = this._name != null ? this._name : "";
        int indx = elementname.lastIndexOf("}");
        if (indx > -1) {
            xmlns = elementname.substring(1, indx);
            elementname = elementname.substring(indx + 1);
        } else {
            indx = elementname.lastIndexOf(":");
            if (indx > -1) {
                xmlns = elementname.substring(0, indx);
                elementname = elementname.substring(indx + 1);
            }
        }
        if (xmlns.equals("null")) {
            xmlns = "";
        }
        if (this._nsOwnerName != null && !this._nsOwnerName.trim().equals("")) {
            node = this._namespace.getNode(NSName.create(this._nsOwnerName));
        }
        switch (this._nsOwnerType) {
            case 3: {
                String dType;
                if (node == null && (node = this._namespace.getNode(NSName.create(dType = NSWSDescriptor.resolveNSRecordname(QName.create(xmlns, elementname))))) != null) {
                    this.setDocType(dType);
                }
                if (node != null && node instanceof NSRecordRef) {
                    node = ((NSRecordRef)node).getNSRecord();
                    elementname = ((NSRecordRef)node).getTargetName().getNodeName().toString();
                }
                if (node == null || !(node instanceof NSRecord) || (nsr = (NSRecord)node).getName() == null) break;
                elementname = nsr.getName();
                break;
            }
            case 1: {
                if (node != null && node instanceof NSService) {
                    sig = ((NSService)node).getSignature();
                }
                if (sig == null) break;
                NSService temp = (NSService)node;
                node = sig.getInput();
                if (node != null && node instanceof NSRecordRef) {
                    nsr = ((NSRecordRef)node).getNSRecord();
                    elementname = ((NSRecordRef)node).getTargetName().getNodeName().toString();
                } else if (node != null && node instanceof NSRecord && (nsr = (NSRecord)node).getName() != null) {
                    elementname = nsr.getName();
                }
                String srvType = temp.getServiceType().getType();
                if (!srvType.equals("AdapterService") || !elementname.endsWith("Input")) break;
                elementname = elementname.substring(0, elementname.lastIndexOf("Input"));
                break;
            }
            case 2: {
                String srvType;
                if (node != null && node instanceof NSService) {
                    sig = ((NSService)node).getSignature();
                }
                if (sig == null) break;
                NSService temp = (NSService)node;
                node = sig.getOutput();
                if (node != null && node instanceof NSRecordRef) {
                    nsr = ((NSRecordRef)node).getNSRecord();
                    elementname = ((NSRecordRef)node).getTargetName().getNodeName().toString();
                } else if (node != null && node instanceof NSRecord && (nsr = (NSRecord)node).getName() != null) {
                    elementname = nsr.getName();
                }
                if (elementname.equals(temp.getNSName().getNodeName().toString()) && !elementname.endsWith("Response")) {
                    elementname = elementname + "Response";
                }
                if (!(srvType = temp.getServiceType().getType()).equals("AdapterService")) break;
                if (elementname.endsWith("Output")) {
                    elementname = elementname.substring(0, elementname.lastIndexOf("Output"));
                }
                if (elementname.endsWith("Response")) break;
                elementname = elementname + "Response";
                break;
            }
        }
        nsr.setName(elementname);
        return nsr;
    }

    public void setSchemaType(String schemaURL, String schemaElement) {
        throw new UnsupportedOperationException("WSElement.setSchemaType");
    }

    protected void setSchema(String schemaURL, String schemaElement) {
        if (schemaURL != null && schemaElement != null) {
            this._nsOwnerType = 0;
            this._schemaURL = schemaURL;
            this._schemaElement = schemaElement;
            this._nsOwnerName = null;
            this._docType = null;
        }
    }

    public String getSchemaURL() {
        return this._schemaURL;
    }

    public String getSchemaElement() {
        return this._schemaElement;
    }

    public void setNSRecord(String nsOwnerName, int nsOwnerType) {
        if (nsOwnerName != null && nsOwnerType != 0) {
            this._nsOwnerName = nsOwnerName;
            this._nsOwnerType = nsOwnerType;
            this._docType = null;
            this._schemaURL = null;
            this._schemaElement = null;
        }
    }

    public String getDocType() {
        if (this._docType != null) {
            return this._docType;
        }
        if (this._nsOwnerType == 3) {
            return this._nsOwnerName;
        }
        return null;
    }

    public void setDocType(String docType) {
        this._docType = docType;
        this._nsOwnerName = docType;
        this._nsOwnerType = 3;
        this._schemaURL = null;
        this._schemaElement = null;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_WSO_ELEMENT_NAME, this._name}, {KEY_WSO_ELEMENT_DOCTYPE, this._docType}, {KEY_WSO_ELEMENT_NSOWNER, this._nsOwnerName}, {KEY_WSO_ELEMENT_NSOWNER_TYPE, this._nsOwnerType}, {KEY_WSO_ELEMENT_SCHEMA_URL, this._schemaURL}, {KEY_WSO_ELEMENT_SCHEMA_ELEMENT, this._schemaElement}, {KEY_WSO_ELEMENT_ADDED_BY_CLIENT, this._addedByClient}};
        return new Values(o);
    }

    public void setValues(Values values) {
        if (values == null) {
            return;
        }
        this._name = values.getString(KEY_WSO_ELEMENT_NAME);
        this._docType = values.getString(KEY_WSO_ELEMENT_DOCTYPE);
        this._nsOwnerName = values.getString(KEY_WSO_ELEMENT_NSOWNER);
        this._nsOwnerType = values.getInt(KEY_WSO_ELEMENT_NSOWNER_TYPE);
        this._schemaURL = values.getString(KEY_WSO_ELEMENT_SCHEMA_URL);
        this._schemaElement = values.getString(KEY_WSO_ELEMENT_SCHEMA_ELEMENT);
        this._addedByClient = values.getBoolean(KEY_WSO_ELEMENT_ADDED_BY_CLIENT);
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_WSO_ELEMENT_NAME, this._name}, {KEY_WSO_ELEMENT_DOCTYPE, this._docType}, {KEY_WSO_ELEMENT_NSOWNER, this._nsOwnerName}, {KEY_WSO_ELEMENT_NSOWNER_TYPE, this._nsOwnerType}, {KEY_WSO_ELEMENT_SCHEMA_URL, this._schemaURL}, {KEY_WSO_ELEMENT_SCHEMA_ELEMENT, this._schemaElement}, {KEY_WSO_ELEMENT_ADDED_BY_CLIENT, this._addedByClient}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        if (values == null) {
            return;
        }
        IDataCursor ic = values.getCursor();
        this._name = IDataUtil.getString(ic, KEY_WSO_ELEMENT_NAME);
        this._docType = IDataUtil.getString(ic, KEY_WSO_ELEMENT_DOCTYPE);
        this._nsOwnerName = IDataUtil.getString(ic, KEY_WSO_ELEMENT_NSOWNER);
        this._nsOwnerType = IDataUtil.getInt(ic, KEY_WSO_ELEMENT_NSOWNER_TYPE, 3);
        this._schemaURL = IDataUtil.getString(ic, KEY_WSO_ELEMENT_SCHEMA_URL);
        this._schemaElement = IDataUtil.getString(ic, KEY_WSO_ELEMENT_SCHEMA_ELEMENT);
        this._addedByClient = IDataUtil.getBoolean(ic, KEY_WSO_ELEMENT_ADDED_BY_CLIENT);
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd) throws WSDLException {
        throw new UnsupportedOperationException("WSElement.toDefinition");
    }

    protected Object[] findExtensibilityElement(List extelements, String type) {
        Vector<WSSOAPElement> objs = new Vector<WSSOAPElement>();
        for (int e = 0; e < extelements.size(); ++e) {
            Object obj = extelements.get(e);
            if (type.equalsIgnoreCase("SOAPAddress") && (obj instanceof SOAPAddress || obj instanceof SOAP12Address)) {
                objs.add(new WSSOAPAddress(obj));
            }
            if (type.equalsIgnoreCase("SOAPBinding") && (obj instanceof SOAPBinding || obj instanceof SOAP12Binding)) {
                objs.add(new WSSOAPBinding(obj));
            }
            if (type.equalsIgnoreCase("SOAPOperation") && (obj instanceof SOAPOperation || obj instanceof SOAP12Operation)) {
                objs.add(new WSSOAPOperation(obj));
            }
            if (type.equalsIgnoreCase("SOAPBody") && (obj instanceof SOAPBody || obj instanceof SOAP12Body)) {
                objs.add(new WSSOAPBody(obj));
            }
            if (type.equalsIgnoreCase("SOAPHeader") && (obj instanceof SOAPHeader || obj instanceof SOAP12Header)) {
                objs.add(new WSSOAPHeader(obj));
            }
            if (!type.equalsIgnoreCase("SOAPFault") || !(obj instanceof SOAPFault) && !(obj instanceof SOAP12Fault)) continue;
            objs.add(new WSSOAPFault(obj));
        }
        return objs.toArray(new Object[0]);
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public String get_nsOwnerName() {
        return this._nsOwnerName;
    }

    public int get_nsOwnerType() {
        return this._nsOwnerType;
    }

    public boolean isAddedByClient() {
        return this._addedByClient;
    }

    public void setAddedByClient(boolean original) {
        this._addedByClient = original;
    }
}

