/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.wsdl.WSD;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.util.QName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.extensions.ExtensibilityElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSContext {
    private List<String> schemafields = null;
    private List<String> messagesformatted = null;
    private List<String> schemasformatted;
    private List<String> externalNSformatted;
    private HashMap<String, String> namespaces;
    private HashMap<StringBuffer, List<String>> schemaElements;
    public List<ExtensibilityElement> definitionSOAPObjects;
    private HashMap<String, StringBuffer> schemastringBuffers;
    private NSWSDescriptor wsd;
    private Map<String, WSD> oldWSDs;
    HashMap<QName, QName> duplicatesResolved;
    private String binderStyleAndUse;
    private String soapProtocol;

    public WSContext(NSWSDescriptor wsd) {
        this.wsd = wsd;
        this.definitionSOAPObjects = new ArrayList<ExtensibilityElement>();
        this.schemafields = new ArrayList<String>();
        this.messagesformatted = new ArrayList<String>();
        this.schemasformatted = new ArrayList<String>();
        this.externalNSformatted = new ArrayList<String>();
        this.schemastringBuffers = new HashMap();
        this.schemaElements = new HashMap();
        this.namespaces = new HashMap();
        NamespaceDecl[] nsdecls = wsd.getPersistedNSDecls();
        String[] ns = new String[nsdecls.length];
        for (int i = 0; i < nsdecls.length; ++i) {
            this.namespaces.put(nsdecls[i].getUri().toString(), nsdecls[i].getPrefixWm().toString());
        }
        this.binderStyleAndUse = "doclit";
        this.oldWSDs = new HashMap<String, WSD>();
    }

    public List<String> getSchemafields() {
        return this.schemafields;
    }

    public void setSchemafields(List<String> schemafields) {
        this.schemafields = schemafields;
    }

    public List<String> getMessagesformatted() {
        return this.messagesformatted;
    }

    public void setMessagesformatted(List<String> messagesformatted) {
        this.messagesformatted = messagesformatted;
    }

    public List<ExtensibilityElement> getSOAPObjects() {
        return this.definitionSOAPObjects;
    }

    public List<String> getExternalNSFormatted() {
        return this.externalNSformatted;
    }

    public List<String> getSchemasFormatted() {
        return this.schemasformatted;
    }

    public HashMap<String, StringBuffer> getSchemastringBuffers() {
        return this.schemastringBuffers;
    }

    public HashMap<StringBuffer, List<String>> getSchemaElements() {
        return this.schemaElements;
    }

    public String getPrefix(String nsname) {
        return this.namespaces.get(nsname);
    }

    public void putPrefix(String nsname, String prefix) {
        this.namespaces.put(nsname, prefix);
    }

    public HashMap<String, String> getNamespaces() {
        return this.namespaces;
    }

    public String getBinderStyleAndUse() {
        return this.binderStyleAndUse;
    }

    public void setBinderStyleAndUse(String bsu) {
        if ("doclit".equalsIgnoreCase(bsu) || "rpclit".equalsIgnoreCase(bsu) || "rpcenc".equalsIgnoreCase(bsu)) {
            this.binderStyleAndUse = bsu.toLowerCase();
        }
    }

    public String getTNSPrefix() {
        String prefix = "tns";
        if (this.wsd != null && ((prefix = this.namespaces.get(this.wsd.getTargetNamespace())) == null || prefix.equals(""))) {
            prefix = "tns";
        }
        return prefix;
    }

    public void putOldWSD(String msgURI, WSD owsd) {
        this.oldWSDs.put(msgURI, owsd);
    }

    public WSD getOldWSD(String msgURI) {
        return this.oldWSDs.get(msgURI);
    }

    public void setDuplicatesResolved(HashMap<QName, QName> dupsMap) {
        this.duplicatesResolved = dupsMap;
    }

    public HashMap<QName, QName> getDuplicatesResolved() {
        return this.duplicatesResolved;
    }

    public String getSOAPProtocol() {
        return this.soapProtocol != null ? this.soapProtocol : NSWSDescriptor.DEFAULT_SOAP_PROTOCOL;
    }

    public void setSOAPProtocol(String soapPcol) {
        if (!soapPcol.equals("SOAP 1.1 Protocol") && !soapPcol.equals("SOAP 1.2 Protocol")) {
            throw new RuntimeException("Invalid Protocol:" + soapPcol);
        }
        this.soapProtocol = soapPcol;
    }
}

