/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSElement;
import com.wm.lang.websvc.WSSOAPBody;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import java.util.ArrayList;
import java.util.Arrays;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;

public class WSBody
extends WSElement {
    public static final String KEY_WSO_ELEMENT_ORG_DOC_NAME = "originalDocName";
    private String _originalDocName = "";

    public WSBody(Namespace ns) {
        super(ns);
    }

    public WSBody(String name, NSService svc, boolean input) {
        super(svc.getNamespace());
        this.setName(name);
        this.setNSRecord(svc.getNSName().toString(), input ? 1 : 2);
    }

    public static WSBody create(IData data, Namespace ns) {
        WSBody body = new WSBody(ns);
        body.setFromData(data);
        return body;
    }

    public void setSchemaType(String schemaURL, String schemaElement) {
        super.setSchema(schemaURL, schemaElement);
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, String portType) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, portType, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, String portType, WSContext wsdc) throws WSDLException {
        ArrayList<String> parts;
        String ns;
        block25: {
            Message msg;
            block24: {
                int indx;
                String pfix;
                QName universalname;
                msg = definition.createMessage();
                String msgname = this.getName();
                if (msgname.trim().equals(":")) {
                    return;
                }
                NSRecord nsrecord = this.getNSRecord();
                String recname = nsrecord.getName();
                if (recname != null && !msgname.equals(recname)) {
                    msgname = recname;
                }
                ns = "";
                Name nsname = nsrecord.getXmlNamespace();
                if (nsname != null) {
                    ns = nsname.toString();
                }
                if ((universalname = nsrecord.getUniversalName()) != null && universalname.getNamespace() != null) {
                    ns = universalname.getNamespace();
                } else {
                    ns = wsd.getTargetNamespace();
                    universalname = QName.create(Name.create(ns), Name.create(recname));
                }
                if (ns == null || ns.trim().equals("")) {
                    ns = wsd.getTargetNamespace();
                }
                if (wsdc.getPrefix(ns) == null && !wsd.getTargetNamespace().equals(ns)) {
                    int fp = 1;
                    while (definition.getNamespace("BDY" + fp) != null) {
                        ++fp;
                    }
                    pfix = "BDY" + fp;
                    definition.addNamespace(pfix, ns);
                    wsdc.putPrefix(ns, pfix);
                }
                if ((indx = msgname.lastIndexOf(":")) > -1) {
                    pfix = msgname.substring(0, indx);
                    if (wsd.isInbound() && !pfix.equals("tns")) {
                        ns = msgname.substring(0, indx);
                    }
                    msgname = msgname.substring(indx + 1);
                }
                msg.setQName(new javax.xml.namespace.QName(ns, msgname));
                wsd.formatMessageFragment(this, msgname, wsdc);
                parts = null;
                if (this.get_nsOwnerType() != 0) {
                    parts = nsrecord != null ? wsd.parseNSRecord(definition, msg, nsrecord, "BODY", universalname, wsdc) : wsd.parseNSRecord(definition, msg, this.getDocType(), "BODY", wsdc);
                } else {
                    wsd.parseExternalSchema(definition, msg, this.getSchemaElement(), wsdc);
                }
                msg.setQName(new javax.xml.namespace.QName(ns, portType + "_" + msgname));
                msg.setUndefined(false);
                if (parent instanceof Input) {
                    ((Input)parent).setMessage(msg);
                } else {
                    ((Output)parent).setMessage(msg);
                }
                if (wsd.getWSDType() == 1) break block24;
                if (wsd.getWSDType() == 1 || !this.isAddedByClient()) break block25;
            }
            definition.addMessage(msg);
        }
        Class<BindingInput> clazz = BindingInput.class;
        if (bindingparent instanceof BindingOutput) {
            clazz = BindingOutput.class;
        }
        String soapns = "http://schemas.xmlsoap.org/wsdl/soap/";
        if (wsd.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            soapns = "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        WSSOAPBody soapbody = new WSSOAPBody(wsd.createExtension(clazz, new javax.xml.namespace.QName(soapns, "body")));
        if (!wsdc.getBinderStyleAndUse().equalsIgnoreCase("doclit")) {
            soapbody.setNamespaceURI(ns);
        }
        if (wsdc.getBinderStyleAndUse().equalsIgnoreCase("rpcenc")) {
            soapbody.setEncodingStyles(Arrays.asList("http://schemas.xmlsoap.org/soap/encoding/"));
        }
        wsdc.getSOAPObjects().add(soapbody.getElement());
        if (parts != null) {
            soapbody.setParts(parts);
        }
        if (bindingparent instanceof BindingInput) {
            ((BindingInput)bindingparent).addExtensibilityElement(soapbody.getElement());
        } else {
            ((BindingOutput)bindingparent).addExtensibilityElement(soapbody.getElement());
        }
    }

    public String getOriginalDocName() {
        return this._originalDocName;
    }

    public void setOriginalDocName(String originalDocName) {
        this._originalDocName = originalDocName;
    }

    public Values getValues() {
        Values vals = super.getValues();
        vals.put(KEY_WSO_ELEMENT_ORG_DOC_NAME, this._originalDocName);
        return vals;
    }

    public void setValues(Values values) {
        if (values == null) {
            return;
        }
        super.setValues(values);
        this._originalDocName = values.getString(KEY_WSO_ELEMENT_ORG_DOC_NAME);
    }

    public IData getAsData() {
        IData data = super.getAsData();
        IDataCursor idc = data.getCursor();
        IDataUtil.put(idc, KEY_WSO_ELEMENT_ORG_DOC_NAME, this._originalDocName);
        idc.destroy();
        return data;
    }

    public void setFromData(IData values) {
        if (values == null) {
            return;
        }
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        this._originalDocName = IDataUtil.getString(ic, KEY_WSO_ELEMENT_ORG_DOC_NAME);
    }
}

