/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.websvc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSWSDescriptor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSElement;
import com.wm.lang.websvc.WSEndpoint;
import com.wm.lang.websvc.WSEndpointManager;
import com.wm.lang.websvc.WSOperation;
import com.wm.lang.websvc.WSSOAPAddress;
import com.wm.lang.websvc.WSSOAPBinding;
import com.wm.util.Config;
import com.wm.util.Strings;
import com.wm.util.Values;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;

public class WSBinder
extends WSElement {
    public static final String KEY_WSB_NAME = "binderName";
    public static final String KEY_WSB_PORT_ADDRESS = "portAddress";
    public static final String KEY_WSB_PORT_ALIAS = "portAlias";
    public static final String KEY_WSB_BINDING_NAME = "bindingName";
    public static final String KEY_WSB_BINDING_STYLE = "bindingStyle";
    public static final String KEY_WSB_BINDING_USE = "bindingUse";
    public static final String KEY_WSB_BINDING_TYPE = "bindingType";
    public static final String KEY_WSB_BINDING_OPERATION_MAP = "operationMap";
    public static final String KEY_WSB_PORT_NAME = "portName";
    public static final String KEY_WSB_PORT_TYPE_NAME = "portTypeName";
    public static final String KEY_WSB_BINDING_OPERATION_NAME = "operationName";
    public static final String KEY_WSB_BINDING_SOAP_ACTION = "soapAction";
    public static final String KEY_WSB_SOAP_PROTOCOL = "SOAPProtocol";
    public static final String KEY_WSB_SOAP_DIRECTIVE = "SOAPDirective";
    public static final String KEY_WSB_TRANSPORT_TYPE = "transportType";
    public static final String KEY_WSB_BINDING_TRANSPORT = "bindingTransport";
    private String _binderName;
    private String _portAddress;
    private String _portAlias;
    private String _bindingName;
    private String _bindingStyle;
    private String _bindingUse;
    private String _portTypeName;
    private String _bindingType;
    private String _soapProtocol;
    private String _soapDirective;
    private String _transportType;
    private String _portName;
    private NSWSDescriptor _wsd;
    private IData _operationMap = IDataFactory.create();
    private String _bindingTransport = "http://schemas.xmlsoap.org/soap/http";

    public WSBinder(Namespace ns) {
        super(ns);
        this._bindingType = "SOAP";
        this._portAlias = null;
        this._soapDirective = "ws";
        this._transportType = "http";
        this._bindingUse = "literal";
        this._bindingStyle = "document";
    }

    public WSBinder(String name, NSWSDescriptor wsd) {
        super(wsd.getNamespace());
        this._binderName = name;
        this._wsd = wsd;
        this._bindingType = "SOAP";
        this._soapProtocol = wsd.getSOAPProtocol();
        this._portAlias = null;
        this._soapDirective = "ws";
        this._transportType = "http";
        this._bindingUse = "literal";
        this._bindingStyle = "document";
    }

    public static WSBinder create(IData data, Namespace ns) {
        WSBinder binder = new WSBinder(ns);
        binder.setFromData(data);
        return binder;
    }

    public static WSBinder create(Service service, Binding binding, Namespace ns) {
        WSBinder binder = new WSBinder(ns);
        binder.setBindingName(binding.getQName().getLocalPart());
        binder.setBinderName(binding.getQName().getLocalPart());
        List extElements = binding.getExtensibilityElements();
        Iterator elementIterator = extElements.iterator();
        boolean isStyleSet = false;
        while (elementIterator.hasNext() && !isStyleSet) {
            WSSOAPBinding soapbinding = new WSSOAPBinding(elementIterator.next());
            if (soapbinding == null || soapbinding.getStyle() == null) continue;
            binder.setBindingStyle(soapbinding.getStyle());
            isStyleSet = true;
        }
        if (!isStyleSet) {
            binder.setBindingStyle(null);
        }
        Map ports = service.getPorts();
        Port thePort = null;
        for (Port port : ports.values()) {
            if (port.getBinding() != binding) continue;
            thePort = port;
            break;
        }
        if (thePort != null) {
            binder.setPortName(thePort.getName());
            binder.setPortTypeName(binding.getPortType().getQName().getLocalPart());
            extElements = thePort.getExtensibilityElements();
            elementIterator = extElements.iterator();
            while (elementIterator.hasNext()) {
                WSSOAPAddress soapaddress = new WSSOAPAddress(elementIterator.next());
                if (soapaddress == null) continue;
                String addr = soapaddress.getLocationURI();
                binder.setPortAddress(addr);
                if (addr != null && addr.startsWith("https://")) {
                    binder._transportType = "https";
                    continue;
                }
                binder._transportType = "http";
            }
        }
        List bindingExt = binding.getExtensibilityElements();
        for (ExtensibilityElement ext : bindingExt) {
            QName qn = ext.getElementType();
            if (!"binding".equalsIgnoreCase(qn.getLocalPart())) continue;
            if ("http://schemas.xmlsoap.org/wsdl/soap12/".equalsIgnoreCase(qn.getNamespaceURI())) {
                binder.setSOAPProtocol("SOAP 1.2 Protocol");
                break;
            }
            if (!"http://schemas.xmlsoap.org/wsdl/soap/".equalsIgnoreCase(qn.getNamespaceURI())) continue;
            binder.setSOAPProtocol("SOAP 1.1 Protocol");
            break;
        }
        List bindingOperations = binding.getBindingOperations();
        for (BindingOperation bindingOp : bindingOperations) {
            BindingInput bindinginput;
            String opName = bindingOp.getName();
            Object soapAction = null;
            extElements = bindingOp.getExtensibilityElements();
            for (ExtensibilityElement extElement : extElements) {
                String style;
                if (extElement instanceof SOAPOperation) {
                    style = ((SOAPOperation)extElement).getStyle();
                    if (style == null || style.trim().equals("")) break;
                    binder.setBindingStyle(style);
                    break;
                }
                if (!(extElement instanceof SOAP12Operation)) continue;
                style = ((SOAP12Operation)extElement).getStyle();
                if (style == null || style.trim().equals("")) break;
                binder.setBindingStyle(style);
                break;
            }
            if ((bindinginput = bindingOp.getBindingInput()) != null) {
                extElements = bindinginput.getExtensibilityElements();
                for (ExtensibilityElement extElement : extElements) {
                    if (extElement instanceof SOAPBody) {
                        binder._bindingUse = ((SOAPBody)extElement).getUse();
                        continue;
                    }
                    if (!(extElement instanceof SOAP12Body)) continue;
                    binder._bindingUse = ((SOAP12Body)extElement).getUse();
                }
            }
            if ("".equals(binder._bindingUse)) {
                binder._bindingUse = "literal";
            }
            if (!Strings.isEmpty(binder._bindingStyle)) continue;
            binder._bindingStyle = "document";
        }
        return binder;
    }

    public void setWSD(NSWSDescriptor wsd) {
        this._wsd = wsd;
    }

    public NSWSDescriptor getWSD() {
        return this._wsd;
    }

    public String getBinderName() {
        return this._binderName;
    }

    public void setBinderName(String binderName) {
        this._binderName = binderName;
    }

    public String getSOAPDirective() {
        return this._soapDirective;
    }

    public void setSOAPDirective(String soapDirective) {
        this._soapDirective = soapDirective;
        if (this._soapDirective == null) {
            this._soapDirective = "ws";
        }
    }

    public String getPortAddress() {
        return this._portAddress;
    }

    public void setPortAddress(String portAddress) {
        this._portAddress = portAddress;
    }

    public String getPortAlias() {
        return this._portAlias;
    }

    public void setPortAlias(String portAlias) {
        this._portAlias = portAlias;
    }

    public String getBindingName() {
        return this._bindingName;
    }

    public void setBindingName(String bindingName) {
        this._bindingName = bindingName;
    }

    public String getBindingStyle() {
        return this._bindingStyle;
    }

    public void setTransportType(String transportType) {
        this._transportType = transportType != null && transportType.trim().equalsIgnoreCase("http") ? "http" : (transportType != null && transportType.trim().equalsIgnoreCase("https") ? "https" : "http");
    }

    public String getTransportType() {
        return this._transportType;
    }

    public void setPortName(String portName) {
        this._portName = portName;
    }

    public String getPortName() {
        return this._portName;
    }

    public void setBindingType(String bindingType) {
        this._bindingType = bindingType;
    }

    public String getBindingType() {
        return this._bindingType;
    }

    public void setBindingUse(String bindingUse) {
        this._bindingUse = bindingUse;
    }

    public String getBindingUse() {
        return this._bindingUse;
    }

    public void setBindingStyle(String bindingStyle) {
        this._bindingStyle = bindingStyle;
    }

    public void setBindingTransport(String transport) {
        this._bindingTransport = transport;
    }

    public String getBindingTransport() {
        return this._bindingTransport;
    }

    public String getPortTypeName() {
        return this._portTypeName;
    }

    public void setPortTypeName(String porttypeName) {
        this._portTypeName = porttypeName;
    }

    public String getSOAPProtocol() {
        return this._soapProtocol != null ? this._soapProtocol : NSWSDescriptor.DEFAULT_SOAP_PROTOCOL;
    }

    public void setSOAPProtocol(String soapProtocol) {
        if (!soapProtocol.equals("SOAP 1.1 Protocol") && !soapProtocol.equals("SOAP 1.2 Protocol")) {
            throw new RuntimeException("Invalid Protocol:" + soapProtocol);
        }
        this._soapProtocol = soapProtocol;
    }

    public String findOperationName(String soapAction) {
        IDataCursor idc = this._operationMap.getCursor();
        String opName = null;
        if (idc.first(soapAction)) {
            opName = (String)idc.getValue();
        }
        return opName;
    }

    public WSOperation findOperation(String soapAction) {
        if (this._wsd == null) {
            return null;
        }
        String opName = this.findOperationName(soapAction);
        if (opName != null) {
            return this._wsd.getOperation(opName);
        }
        return null;
    }

    public WSOperation getOperation(String name) {
        if (this._wsd == null || name == null) {
            return null;
        }
        WSOperation op = this._wsd.getOperation(name);
        if (op != null) {
            IDataCursor idc = this._operationMap.getCursor();
            Object opName = null;
            while (idc.next()) {
                if (!name.equals(idc.getValue())) continue;
                return op;
            }
        }
        return null;
    }

    public String findSOAPAction(String operationname) {
        if (this._wsd == null || operationname == null) {
            return null;
        }
        WSOperation op = this._wsd.getOperation(operationname);
        if (op != null) {
            IDataCursor idc = this._operationMap.getCursor();
            Object opName = null;
            while (idc.next()) {
                if (!operationname.equals(idc.getValue())) continue;
                return idc.getKey();
            }
        }
        return null;
    }

    public WSOperation[] getOperations() {
        if (this._wsd == null) {
            return null;
        }
        String[] opNames = this.getOperationNames();
        WSOperation[] ops = new WSOperation[opNames.length];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = this._wsd.getOperation(opNames[i]);
        }
        return ops;
    }

    public void addOperation(WSOperation op, String soapAction) {
        if (op != null) {
            if (soapAction == null) {
                soapAction = this.getDefaultSoapAction(op.getOperationName());
            }
            IDataCursor idc = this._operationMap.getCursor();
            idc.insertAfter(soapAction, op.getOperationName());
            idc.destroy();
        }
    }

    public void removeOperation(WSOperation op, String soapAction) {
        if (op != null) {
            IDataCursor idc;
            if (soapAction == null) {
                soapAction = this.getDefaultSoapAction(op.getOperationName());
            }
            if ((idc = this._operationMap.getCursor()).first(soapAction)) {
                idc.delete();
            }
            idc.destroy();
        }
    }

    public void removeOperation(WSOperation op) {
        if (op != null) {
            String opName = op.getOperationName();
            IDataCursor idc = this._operationMap.getCursor();
            while (idc.next()) {
                if (!opName.equals(idc.getValue())) continue;
                idc.delete();
                idc.first();
            }
        }
    }

    public String[] getOperationNames() {
        String[] opNames = new String[]{};
        IDataCursor idc = this._operationMap.getCursor();
        ArrayList<String> names = new ArrayList<String>();
        while (idc.next()) {
            names.add((String)idc.getValue());
        }
        return names.toArray(opNames);
    }

    public IData getOperationMap() {
        return this._operationMap;
    }

    public void setOperationMap(IData map) {
        this._operationMap = map;
    }

    public Values getValues() {
        Values opMap = Values.use(this._operationMap);
        Object[][] o = new Object[][]{{KEY_WSB_NAME, this._binderName}, {KEY_WSB_PORT_ADDRESS, this._portAddress}, {KEY_WSB_PORT_ALIAS, this._portAlias}, {KEY_WSB_BINDING_NAME, this._bindingName}, {KEY_WSB_BINDING_STYLE, this._bindingStyle}, {KEY_WSB_BINDING_TRANSPORT, this._bindingTransport}, {KEY_WSB_TRANSPORT_TYPE, this._transportType}, {KEY_WSB_BINDING_USE, this._bindingUse}, {KEY_WSB_BINDING_TYPE, this._bindingType}, {KEY_WSB_SOAP_PROTOCOL, this._soapProtocol}, {KEY_WSB_PORT_NAME, this._portName}, {KEY_WSB_PORT_TYPE_NAME, this._portTypeName}, {KEY_WSB_SOAP_DIRECTIVE, this._soapDirective}, {KEY_WSB_BINDING_OPERATION_MAP, opMap}};
        return new Values(o);
    }

    public void setValues(Values values) {
        if (values == null) {
            return;
        }
        this._binderName = values.getString(KEY_WSB_NAME);
        this._portAddress = values.getString(KEY_WSB_PORT_ADDRESS);
        this._portAlias = values.getString(KEY_WSB_PORT_ALIAS);
        this._bindingName = values.getString(KEY_WSB_BINDING_NAME);
        this._bindingStyle = values.getString(KEY_WSB_BINDING_STYLE);
        this._bindingUse = values.getString(KEY_WSB_BINDING_USE);
        this._bindingType = values.getString(KEY_WSB_BINDING_TYPE);
        this._bindingTransport = values.getString(KEY_WSB_BINDING_TRANSPORT);
        this._transportType = values.getString(KEY_WSB_TRANSPORT_TYPE);
        this._portName = values.getString(KEY_WSB_PORT_NAME);
        this._portTypeName = values.getString(KEY_WSB_PORT_TYPE_NAME);
        this._soapProtocol = values.getString(KEY_WSB_SOAP_PROTOCOL);
        this._soapDirective = values.getString(KEY_WSB_SOAP_DIRECTIVE);
        Object f = values.get(KEY_WSB_BINDING_OPERATION_MAP);
        this._operationMap = IDataFactory.create();
        if (f != null && f instanceof Values) {
            this._operationMap = ((Values)f).getIData();
        }
    }

    public IData getAsData() {
        Object opMap = null;
        Object[][] o = new Object[][]{{KEY_WSB_NAME, this._binderName}, {KEY_WSB_PORT_ADDRESS, this._portAddress}, {KEY_WSB_PORT_ALIAS, this._portAlias}, {KEY_WSB_BINDING_NAME, this._bindingName}, {KEY_WSB_BINDING_STYLE, this._bindingStyle}, {KEY_WSB_BINDING_USE, this._bindingUse}, {KEY_WSB_BINDING_TYPE, this._bindingType}, {KEY_WSB_PORT_NAME, this._portName}, {KEY_WSB_PORT_TYPE_NAME, this._portTypeName}, {KEY_WSB_BINDING_TRANSPORT, this._bindingTransport}, {KEY_WSB_TRANSPORT_TYPE, this._transportType}, {KEY_WSB_BINDING_OPERATION_MAP, this._operationMap}, {KEY_WSB_SOAP_PROTOCOL, this._soapProtocol}, {KEY_WSB_SOAP_DIRECTIVE, this._soapDirective}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        if (values == null) {
            return;
        }
        IDataCursor ic = values.getCursor();
        if (ic.first(KEY_WSB_NAME)) {
            this._binderName = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_PORT_ADDRESS)) {
            this._portAddress = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_PORT_ALIAS)) {
            this._portAlias = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_BINDING_NAME)) {
            this._bindingName = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_BINDING_STYLE)) {
            this._bindingStyle = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_BINDING_USE)) {
            this._bindingUse = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_BINDING_TYPE)) {
            this._bindingType = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_BINDING_TRANSPORT)) {
            this._bindingTransport = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_TRANSPORT_TYPE)) {
            this._transportType = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_PORT_TYPE_NAME)) {
            this._portTypeName = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_PORT_NAME)) {
            this._portName = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_SOAP_PROTOCOL)) {
            this._soapProtocol = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_SOAP_DIRECTIVE)) {
            this._soapDirective = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSB_BINDING_OPERATION_MAP)) {
            this._operationMap = IDataUtil.getIData(ic, KEY_WSB_BINDING_OPERATION_MAP);
        }
    }

    private String buildLocationURI() {
        String URI2 = this._portAddress;
        if (this._wsd.isInbound()) {
            String alias;
            String host = "localhost";
            String port = Config.getProperty("5555", "watt.server.port");
            try {
                host = Config.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
            String string = alias = this._portAlias == null ? "" : this._portAlias.trim();
            if (alias.length() < 1 && (this._portAddress == null || this._portAddress.trim().length() < 1)) {
                alias = "default";
            }
            if (alias.length() > 0 && WSEndpointManager.current() != null) {
                WSEndpoint wse = WSEndpointManager.current().getEndpoint(alias);
                if (wse != null) {
                    host = wse.getTransportInfo().getHost();
                    port = wse.getTransportInfo().getPort();
                }
                URI2 = this._transportType + "://" + host + ":" + port + "/" + this._soapDirective + "/" + this._wsd.getNSName();
            }
        }
        return URI2;
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd) throws WSDLException {
        this.toDefinition(definition, parent, bindingparent, wsd, new WSContext(wsd));
    }

    public void toDefinition(Definition definition, WSDLElement parent, WSDLElement bindingparent, NSWSDescriptor wsd, WSContext wsdc) throws WSDLException {
        Port port = null;
        String soapns = "http://schemas.xmlsoap.org/wsdl/soap/";
        if (this.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            soapns = "http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        port = definition.createPort();
        port.setName(this.getPortName());
        WSSOAPAddress address = new WSSOAPAddress(wsd.createExtension(Port.class, new QName(soapns, "address")));
        address.setLocationURI(this.buildLocationURI());
        port.addExtensibilityElement(address.getElement());
        Binding binding = definition.createBinding();
        binding.setQName(new QName(wsd.getTargetNamespace(), this.getBindingName()));
        WSSOAPBinding soapbinding = new WSSOAPBinding(wsd.createExtension(Binding.class, new QName(soapns, "binding")));
        soapbinding.setStyle(this.getBindingStyle());
        soapbinding.setTransportURI(this.getBindingTransport());
        binding.addExtensibilityElement(soapbinding.getElement());
        QName porttypeqname = new QName(wsd.getTargetNamespace(), this.getPortTypeName());
        boolean porttypecreated = false;
        PortType porttype = definition.getPortType(porttypeqname);
        if (porttype == null) {
            porttype = definition.createPortType();
            porttype.setQName(porttypeqname);
            porttypecreated = true;
        }
        IDataCursor opIter = this.getOperationMap().getCursor();
        block0: while (opIter.next()) {
            String soapAction = opIter.getKey();
            String opName = (String)opIter.getValue();
            WSOperation wsoperation = this.getOperation(opName);
            if (wsoperation == null) continue;
            wsoperation.toDefinition(definition, (WSDLElement)porttype, (WSDLElement)binding, wsd, wsdc);
            int indx = -1;
            indx = opName.indexOf(":");
            if (indx > -1) {
                opName = opName.substring(indx + 1);
            }
            List bindingOperations = binding.getBindingOperations();
            for (BindingOperation bindingOp : bindingOperations) {
                if (!bindingOp.getName().equals(opName)) continue;
                List opExt = bindingOp.getExtensibilityElements();
                for (ExtensibilityElement ext : opExt) {
                    if (ext instanceof SOAPOperation) {
                        ((SOAPOperation)ext).setSoapActionURI(soapAction);
                        continue block0;
                    }
                    if (!(ext instanceof SOAP12Operation)) continue;
                    ((SOAP12Operation)ext).setSoapActionURI(soapAction);
                    continue block0;
                }
                continue block0;
            }
        }
        opIter.destroy();
        binding.setPortType(porttype);
        port.setBinding(binding);
        binding.setUndefined(false);
        definition.addBinding(binding);
        porttype.setUndefined(false);
        if (porttypecreated) {
            definition.addPortType(porttype);
        }
        ((Service)parent).addPort(port);
        List<ExtensibilityElement> temp = wsdc.getSOAPObjects();
        while (temp.size() > 0) {
            ExtensibilityElement element = temp.remove(0);
            if (element instanceof SOAPBody) {
                ((SOAPBody)element).setUse(this.getBindingUse());
                continue;
            }
            if (element instanceof SOAPHeader) {
                ((SOAPHeader)element).setUse(this.getBindingUse());
                continue;
            }
            if (element instanceof SOAPFault) {
                ((SOAPFault)element).setUse(this.getBindingUse());
                continue;
            }
            if (element instanceof SOAPBinding) {
                ((SOAPBinding)element).setStyle(this.getBindingStyle());
                continue;
            }
            if (element instanceof SOAPOperation) {
                ((SOAPOperation)element).setStyle(this.getBindingStyle());
                continue;
            }
            if (element instanceof SOAP12Body) {
                ((SOAP12Body)element).setUse(this.getBindingUse());
                continue;
            }
            if (element instanceof SOAP12Header) {
                ((SOAP12Header)element).setUse(this.getBindingUse());
                continue;
            }
            if (element instanceof SOAP12Fault) {
                ((SOAP12Fault)element).setUse(this.getBindingUse());
                continue;
            }
            if (element instanceof SOAP12Binding) {
                ((SOAP12Binding)element).setStyle(this.getBindingStyle());
                continue;
            }
            if (!(element instanceof SOAP12Operation)) continue;
            ((SOAP12Operation)element).setStyle(this.getBindingStyle());
        }
    }

    public String getDefaultSoapAction(String operationName) {
        return this._binderName + "_" + operationName;
    }

    public WSBinder copy(String binderName) {
        IData idata = this.getAsData();
        WSBinder copyObj = WSBinder.create(idata, this.getNamespace());
        if (binderName != null) {
            copyObj.setBinderName(binderName);
        }
        copyObj.setWSD(this.getWSD());
        return copyObj;
    }
}

