/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.rec;

import com.wm.lang.schema.AnyAttribute;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SimpleTypeUtil;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.datatypev2.Constraint;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.cr.RestrictionCommon;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import java.util.Vector;

public class RestrictionExp
extends RestrictionCommon {
    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingComplexType()) {
            this.translateC(node, workspace, parentSpace, baseIdentifier);
        } else {
            this.translateS(node, workspace, parentSpace, baseIdentifier);
        }
    }

    protected void translateC(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        int i;
        String base = node.getAttributeValue(null, BASE);
        Space localSpace = new Space();
        Space baseSpace = new Space();
        if (base != null) {
            if (workspace.isProcessingRedefine()) {
                QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
                QName curRedefName = workspace.getCurrentRedefineName();
                if (curRedefName != null) {
                    if (baseQName != curRedefName) {
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-017", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_REDEFINE_BASE_NAME_MISMATCH, null));
                    }
                    workspace.setCurrentRedefineName(null);
                    workspace.setBaseSpecified(true);
                }
            }
            this.processBaseDefinition(base, node, workspace, baseSpace, baseIdentifier);
        }
        super.translate(node, workspace, localSpace, baseIdentifier);
        parentSpace.mixed = false;
        RestrictionExp.copy(localSpace.models, parentSpace.models);
        RestrictionExp.copy(localSpace.elements, parentSpace.elements);
        Vector rAttrs = localSpace.attributes;
        Vector sAttrs = baseSpace.attributes;
        Vector pAttrs = localSpace.prohibited;
        int size = rAttrs.size();
        for (i = 0; i < size; ++i) {
            QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
            String ncName = baseQName.getNCName();
            WmAttribute restrictedAttribute = (WmAttribute)rAttrs.elementAt(i);
            int index = this.lookup(sAttrs, restrictedAttribute.getQName());
            if (index < 0 && !ANY_TYPE.toString().equals(ncName)) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-006", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_RESTRICTED_ATTRIBUTE_DECL, null));
                continue;
            }
            if (index < 0) continue;
            WmAttribute superAttribute = (WmAttribute)sAttrs.elementAt(index);
            if (superAttribute instanceof AnyAttribute) {
                this.applyRestriction((AnyAttribute)superAttribute, (AnyAttribute)restrictedAttribute, node, workspace, baseIdentifier);
                continue;
            }
            this.merge((WmAttribute)sAttrs.elementAt(index), restrictedAttribute);
        }
        size = pAttrs.size();
        for (i = 0; i < size; ++i) {
            QName prohibitedAttributeName = (QName)pAttrs.elementAt(i);
            int index = this.lookup(sAttrs, prohibitedAttributeName);
            if (index < 0) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-006", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_PROHIBITED_ATTRIBUTE_DECL, null));
                continue;
            }
            sAttrs.removeElementAt(index);
        }
        RestrictionExp.copy(sAttrs, parentSpace.attributes);
        RestrictionExp.copy(baseSpace.typeHeirarchy, parentSpace.typeHeirarchy);
        QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
        Type type = (Type)workspace.types.get(baseQName);
        SimpleType st = null;
        TypeDef typedef = baseSpace.getType();
        if (type != null && typedef != null && type.getAbstractionType() == 2 && typedef.getType() == 1) {
            st = (Datatype)typedef;
            Constraint[] facets = workspace.facets.composeConstraint(node);
            if (facets != null) {
                workspace.facets.clear();
                Constraint[] currentFacets = null;
                baseQName = st.getQName();
                type = (Type)workspace.types.get(baseQName);
                if (type != null) {
                    ElementNode typeNode = type.getDefinition();
                    workspace.pushCurrent(typeNode);
                    super.translate(typeNode, workspace, localSpace, baseIdentifier);
                    workspace.popCurrent();
                    st = (SimpleType)localSpace.getType();
                    currentFacets = workspace.facets.composeConstraint(typeNode);
                    currentFacets = this.combineConstraints(st.getConstraints(), currentFacets);
                    workspace.facets.clear();
                } else if (BuiltIns.current().containsKey(baseQName)) {
                    st = SimpleTypeUtil.clone(workspace.ns, baseQName);
                }
                try {
                    if (currentFacets == null) {
                        currentFacets = st.getConstraints();
                    }
                    Constraint[] combineFacets = this.combineConstraints(facets, currentFacets);
                    try {
                        st.setConstraints(combineFacets, workspace.getLocale());
                    }
                    catch (Exception ex) {
                        Object[] subs = new Object[]{st.getClass().getName(), ex.toString()};
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-008", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INCORRECT_FACETS, null, subs));
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
        }
        if (st != null) {
            parentSpace.put(st);
        } else {
            parentSpace.put(baseSpace.getType());
        }
    }

    protected void translateS(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        boolean simpleTypeFound;
        String base = node.getAttributeValue(null, BASE);
        Space localSpace = new Space();
        Space baseSpace = new Space();
        super.translate(node, workspace, localSpace, baseIdentifier);
        Constraint[] facets = workspace.facets.composeConstraint(node);
        workspace.facets.clear();
        boolean facetsFound = facets != null && facets.length > 0;
        boolean baseFound = base != null;
        boolean bl = simpleTypeFound = localSpace.getType() != null;
        if (baseFound && simpleTypeFound || !baseFound && !simpleTypeFound) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-013", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INVALID_SYNTAX, null));
            parentSpace.put(this.createURTypeDefinition(node));
        } else {
            SimpleType baseType = null;
            if (simpleTypeFound) {
                baseType = (SimpleType)localSpace.getType();
                RestrictionExp.copy(localSpace.typeHeirarchy, parentSpace.typeHeirarchy);
            } else {
                if (workspace.isProcessingRedefine()) {
                    QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
                    QName curRedefName = workspace.getCurrentRedefineName();
                    if (curRedefName != null) {
                        if (baseQName != curRedefName) {
                            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-017", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_REDEFINE_BASE_NAME_MISMATCH, null));
                        }
                        workspace.setCurrentRedefineName(null);
                        workspace.setBaseSpecified(true);
                    }
                }
                this.processBaseDefinition(base, node, workspace, baseSpace, baseIdentifier);
                baseType = (SimpleType)baseSpace.getType();
                RestrictionExp.copy(baseSpace.typeHeirarchy, parentSpace.typeHeirarchy);
            }
            SimpleType simpleType = null;
            try {
                simpleType = SimpleTypeUtil.deriveFrom(baseType);
            }
            catch (Exception ex) {
                System.out.println("deriveFrom is wrong" + ex.toString());
            }
            if (facetsFound) {
                try {
                    Constraint[] currentFacets = simpleType.getConstraints();
                    Constraint[] combineFacets = this.combineConstraints(facets, currentFacets);
                    try {
                        simpleType.setConstraints(combineFacets, workspace.getLocale());
                    }
                    catch (Exception ex) {
                        Object[] subs = new Object[]{((Datatype)simpleType).getClass().getName(), ex.toString()};
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-008", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INCORRECT_FACETS, null, subs));
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            parentSpace.put(simpleType);
        }
    }

    protected void createSimpleType(QName base, XSDWorkspace workspace, Space space, String baseIdentifier, ElementNode context) throws WMDocumentException {
        SimpleType type = null;
        if (ANY_SIMPLE_TYPE_NAMES.contains(base)) {
            ElementNode sComponent = (ElementNode)context.getParent();
            String name = sComponent.getAttributeValue(null, NAME);
            try {
                QName[] types;
                type = Datatype.create(name);
                if (type != null && (types = BuiltIns.current().getTypeHeirarchy(QName.create(workspace.getCurrentTargetNamespace(), name))) != null) {
                    for (int i = 0; i < types.length; ++i) {
                        space.typeHeirarchy.add(types[i]);
                    }
                }
                space.put(type);
            }
            catch (Exception ex) {
                workspace.addError(baseIdentifier, this.getSource(context), "XSDC-007", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_BUILT_IN_TYPE, null, name));
                space.put(this.createURTypeDefinition(context));
            }
        } else {
            HashSet set;
            type = SimpleTypeUtil.clone(workspace.ns, base);
            space.put(type);
            if (type != null && (set = type.getTypeHeirarchy()) != null) {
                Object[] types = new QName[set.size()];
                set.toArray(types);
                for (int i = 0; i < types.length; ++i) {
                    space.typeHeirarchy.add(types[i]);
                }
            }
        }
    }

    private Constraint[] combineConstraints(Constraint[] facets, Constraint[] currentFacets) {
        int fType = -1;
        int cfType = -1;
        Vector<Constraint> holder = new Vector<Constraint>();
        for (int i = 0; i < facets.length; ++i) {
            fType = facets[i].getFacetType();
            if (currentFacets != null) {
                for (int j = 0; j < currentFacets.length; ++j) {
                    cfType = currentFacets[j].getFacetType();
                    if (cfType == -1 || cfType == fType) continue;
                    holder.addElement(currentFacets[j]);
                }
            }
            holder.addElement(facets[i]);
        }
        Constraint[] combineFacets = new Constraint[holder.size()];
        for (int i = 0; i < combineFacets.length; ++i) {
            combineFacets[i] = (Constraint)holder.elementAt(i);
        }
        return combineFacets;
    }
}

