/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.rec;

import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.datatypev2.WmList;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.QName;

public class ListExp
extends Expression {
    private static final QName ANY_SIMPLE_TYPE = QName.create("http://www.w3.org/2001/XMLSchema", "anySimpleType");
    private static final QName ANY_LIST = QName.create("http://www.w3.org/2001/XMLSchema", "anyList");

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        String itemType = node.getAttributeValue(null, ITEM_TYPE);
        WmList list = null;
        if (itemType != null) {
            QName itemQName = this.computeQName(itemType, node, workspace, baseIdentifier);
            this.check(itemQName, 1, node, workspace, baseIdentifier);
            list = new WmList(itemQName);
        } else {
            Space localSpace = new Space();
            super.translate(node, workspace, localSpace, baseIdentifier);
            SimpleType type = (SimpleType)localSpace.getType();
            if (type != null) {
                list = new WmList((Datatype)type);
            }
        }
        if (list == null) {
            list = new WmList((Datatype)this.createURTypeDefinition(node));
        }
        parentSpace.put(list);
        parentSpace.typeHeirarchy.add(ANY_SIMPLE_TYPE);
        parentSpace.typeHeirarchy.add(ANY_LIST);
    }
}

