/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.lc;

import com.wm.lang.schema.Model;
import com.wm.lang.schema.WmElementRef;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;

public class ElementRefExp
extends Expression {
    private static final boolean debug = false;

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingModelGroup()) {
            this.translate(node, workspace, parentSpace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        this.spitOut(node, workspace);
        String ref = node.getAttributeValue(null, REF);
        String nullable = node.getAttributeValue(null, NILLABLE);
        String defaultValue = node.getAttributeValue(null, DEFAULT);
        String fixedValue = node.getAttributeValue(null, FIXED);
        QName computedQName = this.computeQName(ref, node, workspace, baseIdentifier, true);
        WmElementRef element = new WmElementRef(computedQName);
        element.setDefaultValue(defaultValue);
        element.setFixedValue(fixedValue);
        element.setGlobal(true);
        if (nullable != null && nullable.equals("true")) {
            element.setNullable(true);
        }
        Model model = Model.create(computedQName);
        this.applyOccurrence(model, node, workspace, baseIdentifier);
        if (!ElementRefExp.isProhibited(model)) {
            parentSpace.models.addElement(model);
            parentSpace.elements.addElement(element);
        }
        if (!workspace.elementDecls.containsKey(computedQName) && !computedQName.equals(QName.create("http://www.w3.org/2001/XMLSchema", "schema"))) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-004", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_DECLARATION, ""));
        } else if (workspace.elementDecls.containsKey(computedQName) && !computedQName.equals(QName.create("http://www.w3.org/2001/XMLSchema", "schema"))) {
            ElementNode elNode = (ElementNode)workspace.elementDecls.get(computedQName);
            ref = elNode.getAttributeValue(null, REF);
            nullable = elNode.getAttributeValue(null, NILLABLE);
            defaultValue = elNode.getAttributeValue(null, DEFAULT);
            fixedValue = elNode.getAttributeValue(null, FIXED);
            element.setDefaultValue(defaultValue);
            element.setFixedValue(fixedValue);
            element.setGlobal(true);
            if (nullable != null && nullable.equals("true")) {
                element.setNullable(true);
            }
        }
    }
}

