/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.lc;

import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;

public class ElementDeclExp
extends Expression {
    private static final boolean debug = false;

    public ElementDeclExp() {
        this.setBaseIdentifier("element");
    }

    public void symbolize(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        QName name = QName.create(workspace.getCurrentTargetNamespace(), node.getAttributeValue(null, NAME));
        ElementNode dup = workspace.elementDecls.put(name, node);
    }

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingModelGroup()) {
            this.translate(node, workspace, parentSpace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        WmElement dup;
        block18: {
            this.spitOut(node, workspace);
            Space localSpace = new Space();
            super.translate(node, workspace, localSpace, baseIdentifier);
            String ncName = node.getAttributeValue(null, NAME);
            String type = node.getAttributeValue(null, TYPE);
            String abstrat = node.getAttributeValue(null, ABSTRACT);
            String equivClass = this.getSubstitutionGroup(node);
            String form = node.getAttributeValue(null, FORM);
            String nullable = this.getNillable(node);
            String defaultValue = node.getAttributeValue(null, DEFAULT);
            String fixedValue = node.getAttributeValue(null, FIXED);
            WmElement element = new WmElement(ncName);
            if (abstrat != null && abstrat.equals("true")) {
                element.setAbstract(true);
            }
            if (equivClass != null) {
                element.setSubstitutableFor(this.computeSubstitutableFor(ncName, equivClass, node, workspace, baseIdentifier));
            }
            element.setDefaultValue(defaultValue);
            element.setFixedValue(fixedValue);
            ContentType ct = null;
            if (type != null) {
                QName computedQName = this.computeQName(type, node, workspace, baseIdentifier);
                Type typeDef = (Type)workspace.types.get(computedQName);
                Name ns = computedQName.getNamespaceName();
                if (ns == XSDCompiler.WEBM_DEFAULT_NAMESPACE) {
                    computedQName = QName.create(null, computedQName.getLocalName());
                }
                Name nsuri = node.getNamespaceUri();
                if (typeDef != null) {
                    ct = typeDef.getAbstractionType() == 2 ? new WmComplexTypeRef(null, computedQName) : DatatypeFactory.createReference(nsuri, computedQName);
                } else if (BuiltIns.current().containsKey(computedQName)) {
                    ct = DatatypeFactory.createReference(nsuri, computedQName);
                } else if (ANY_TYPE_NAMES.contains(computedQName)) {
                    ct = new WmComplexTypeRef(null, computedQName);
                } else {
                    workspace.addError(baseIdentifier, this.getSource(node), "XSDC-003", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_DEFINITION, ""));
                }
            } else {
                ct = localSpace.getType() != null ? localSpace.getType() : (equivClass != null ? this.computeContentTypeUsingSubstitutableFor(element.getSubstitutableFor(), workspace, baseIdentifier, node) : this.createURTypeDefinition(node));
            }
            element.setType(ct);
            if (nullable != null && nullable.equals("true")) {
                element.setNullable(true);
            }
            if (workspace.isCreatingComplexType() || workspace.isCreatingModelGroup()) {
                if (form == null && workspace.getCurrentElementFormDefaultQualified() || form != null && form.equals("qualified")) {
                    element.setNamespaceURI(workspace.getCurrentTargetNamespace());
                    element.setFormQualified(true);
                }
                Model model = Model.create(element.getQName());
                this.applyOccurrence(model, node, workspace, baseIdentifier);
                if (!ElementDeclExp.isProhibited(model)) {
                    parentSpace.models.addElement(model);
                    parentSpace.elements.addElement(element);
                }
                return;
            }
            dup = null;
            try {
                dup = workspace.cSchema.put(element);
            }
            catch (TNSException tns) {
                String tnsname = workspace.cSchema.getTargetNamespace();
                if (tnsname == null || tnsname.equals("http://schemas.xmlsoap.org/soap/encoding/")) break block18;
                workspace.addWarning(baseIdentifier, this.getSource(node), "XSDC-080", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DECL_IN_ANOTHER_SCHEMA, "", tns.getSchemaName()));
            }
        }
        if (dup != null) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-001", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DECL_FOUND_IN_THIS_SCHEMA, ""));
        }
    }

    protected String composeRelativeIdentifier(ElementNode node) {
        return this.composeRelativeIdentifierUsingName(node);
    }

    private HashSet computeSubstitutableFor(String ncName, String equivClass, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        HashSet substitutableFor = new HashSet();
        QName elementName = QName.create(workspace.getCurrentTargetNamespace(), ncName);
        QName qNameOfSubstitutableFor = this.computeQName(equivClass, node, workspace, baseIdentifier);
        while (qNameOfSubstitutableFor != null) {
            if (qNameOfSubstitutableFor.equals(elementName) || substitutableFor.contains(qNameOfSubstitutableFor)) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-010", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_RECURSIVE_EQUIVCLASS, ""));
                return null;
            }
            substitutableFor.add(qNameOfSubstitutableFor);
            qNameOfSubstitutableFor = this._computeSubstitutableFor(ncName, qNameOfSubstitutableFor, node, workspace, baseIdentifier);
        }
        if (substitutableFor.size() > 0) {
            return substitutableFor;
        }
        return null;
    }

    private QName _computeSubstitutableFor(String ncName, QName equivClass, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        QName qNameOfSubstitutableFor = null;
        ElementNode substitutableFor = (ElementNode)workspace.elementDecls.get(equivClass);
        if (substitutableFor != null) {
            String newEquivClass = this.getSubstitutionGroup(substitutableFor);
            if (newEquivClass != null) {
                qNameOfSubstitutableFor = this.computeQName(newEquivClass, substitutableFor, workspace, baseIdentifier);
            }
        } else if (!XSD_NS.contains(equivClass.getNamespace())) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-011", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_EQUIVCLASS_DECLARATION, ""));
        }
        return qNameOfSubstitutableFor;
    }

    private ContentType computeContentTypeUsingSubstitutableFor(HashSet substitutableFor, XSDWorkspace workspace, String baseIdentifier, ElementNode context) throws WMDocumentException {
        TypeDef contentType = null;
        if (substitutableFor != null) {
            Name nsuri = context.getNamespaceUri();
            Iterator it = substitutableFor.iterator();
            while (it.hasNext()) {
                QName equivClass = (QName)it.next();
                ElementNode equivClassDecl = (ElementNode)workspace.elementDecls.get(equivClass);
                if (equivClassDecl == null) continue;
                Space localSpace = new Space();
                super.translate(equivClassDecl, workspace, localSpace, baseIdentifier);
                String type = equivClassDecl.getAttributeValue(null, TYPE);
                if (type != null) {
                    QName computedQName = this.computeQName(type, equivClassDecl, workspace, baseIdentifier);
                    Type typeDef = (Type)workspace.types.get(computedQName);
                    if (typeDef != null) {
                        contentType = typeDef.getAbstractionType() == 2 ? new WmComplexTypeRef(null, computedQName) : DatatypeFactory.createReference(nsuri, computedQName);
                    } else if (BuiltIns.current().containsKey(computedQName)) {
                        contentType = DatatypeFactory.createReference(nsuri, computedQName);
                    } else {
                        workspace.addError(baseIdentifier, this.getSource(equivClassDecl), "XSDC-003", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_DEFINITION, ""));
                    }
                } else if (localSpace.getType() != null) {
                    contentType = localSpace.getType();
                }
                if (contentType == null) continue;
                return contentType;
            }
        }
        if (contentType == null) {
            contentType = this.createURTypeDefinition(context);
        }
        return contentType;
    }

    protected String getSubstitutionGroup(ElementNode node) throws WMDocumentException {
        return node.getAttributeValue(null, EQUIVCLASS);
    }

    protected String getNillable(ElementNode node) throws WMDocumentException {
        return node.getAttributeValue(null, NULLABLE);
    }
}

