/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.lc;

import com.wm.lang.schema.ComplexModel;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.State;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.lc.TypeExp;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import java.util.Vector;

public class ComplexTypeExp
extends TypeExp {
    static final boolean debug = false;

    public ComplexTypeExp() {
        this.setBaseIdentifier("complexType");
    }

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingModelGroup()) {
            this.translate(node, workspace, parentSpace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        this.spitOut(node, workspace);
        workspace.setState(State.CREATING_COMPLEXTYPE);
        Space localSpace = new Space();
        ComplexType type = this.generate(node, workspace, localSpace, baseIdentifier);
        type.rearrageAttributes();
        ElementNode parent = (ElementNode)node.getParent();
        if (parent.getLocalNameWm() == SCHEMA) {
            ContentType dup;
            block6: {
                String ncName = node.getAttributeValue(null, NAME);
                String abstrat = node.getAttributeValue(null, ABSTRACT);
                type.setName(ncName);
                dup = null;
                localSpace.typeHeirarchy.add(QName.create(workspace.getCurrentTargetNamespace(), ncName));
                type.setTypeHeirarchy(localSpace.typeHeirarchy);
                if (abstrat != null && abstrat.equals("true")) {
                    type.setAbstract(true);
                }
                try {
                    dup = workspace.cSchema.put(type);
                }
                catch (TNSException tns) {
                    Type t;
                    String tnsname = workspace.cSchema.getTargetNamespace();
                    if (tnsname == null || tnsname.equals("http://schemas.xmlsoap.org/soap/encoding/") || (t = (Type)workspace.types.get(QName.create(workspace.getCurrentTargetNamespace(), type.getName()))) == null) break block6;
                    ElementNode en = t.getDefinition();
                    if (this.getSource(node).equals(this.getSource(en))) break block6;
                    workspace.addWarning(baseIdentifier, this.getSource(node), "XSDC-081", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DEF_IN_ANOTHER_SCHEMA, "", tns.getSchemaName()));
                }
            }
            if (dup != null) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-002", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DEF_FOUND_IN_THIS_SCHEMA, ""));
            }
        } else {
            parentSpace.put(type);
        }
        workspace.reset();
    }

    ComplexType generate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        String base = node.getAttributeValue(null, BASE);
        String derivedBy = node.getAttributeValue(null, DERIVED_BY);
        String content = node.getAttributeValue(null, CONTENT);
        ComplexType baseType = null;
        if (base != null) {
            QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
            Type type = (Type)workspace.types.get(baseQName);
            if (type != null && type.getAbstractionType() == 1 || BuiltIns.current().containsKey(baseQName)) {
                baseType = new WmComplexType();
                baseType.setSimpleType(this.generate(node, workspace, parentSpace, baseIdentifier, true));
                baseType.setModel(Model.create(1, 1, 2));
                parentSpace.attributes.removeAllElements();
            } else if (type != null && type.getAbstractionType() == 2) {
                ElementNode typeNode = type.getDefinition();
                workspace.pushCurrent(typeNode);
                baseType = this.generate(typeNode, workspace, parentSpace, baseIdentifier);
                workspace.popCurrent();
                parentSpace.typeHeirarchy.add(baseQName);
            } else {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-005", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_BASE_TYPE_DEFINITION, ""));
            }
        }
        if (baseType == null) {
            baseType = new WmComplexType();
            Model model = this.createContentModel(content);
            baseType.setModel(model);
        }
        boolean isRestriction = derivedBy != null && derivedBy.equals("restriction");
        super.translate(node, workspace, parentSpace, baseIdentifier);
        int modelType = baseType.getContentModelType();
        Vector elements = parentSpace.elements;
        Vector attributes = parentSpace.attributes;
        Vector models = parentSpace.models;
        Vector prohibited = parentSpace.prohibited;
        if (isRestriction) {
            baseType.removeAllElements();
            if (modelType == 7) {
                baseType.setModel(this.createContentModel(content));
            }
            if ((modelType = baseType.getContentModelType()) == 4 || modelType == 2) {
                int i;
                ComplexModel cm = (ComplexModel)baseType.getContentModel();
                cm.removeAllModels();
                int size = elements.size();
                for (i = 0; i < size; ++i) {
                    baseType.addElement((WmElement)elements.elementAt(i));
                }
                size = models.size();
                for (i = 0; i < size; ++i) {
                    cm.addModel((Model)models.elementAt(i));
                }
            }
            int size = attributes.size();
            for (int i = 0; i < size; ++i) {
                WmAttribute restrictedAttribute = (WmAttribute)attributes.elementAt(i);
                WmAttribute superAttribute = baseType.getAttribute(restrictedAttribute.getQName());
                this.merge(superAttribute, restrictedAttribute);
                if (superAttribute != null) continue;
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-006", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_RESTRICTED_ATTRIBUTE_DECL, ""));
            }
            int size2 = prohibited.size();
            for (int i = 0; i < size2; ++i) {
                WmAttribute prohibitedAttribute = baseType.removeAttribute((QName)prohibited.elementAt(i));
                if (prohibitedAttribute != null) continue;
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-006", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_PROHIBITED_ATTRIBUTE_DECL, ""));
            }
        } else {
            int size;
            if (modelType == 7) {
                baseType.setModel(this.createContentModel(content));
            }
            if ((modelType = baseType.getContentModelType()) == 4 || modelType == 2) {
                size = elements.size();
                for (int i = 0; i < size; ++i) {
                    baseType.addElement((WmElement)elements.elementAt(i));
                }
                ComplexModel cm = (ComplexModel)baseType.getContentModel();
                int size3 = models.size();
                for (int i = 0; i < size3; ++i) {
                    cm.addModel((Model)models.elementAt(i));
                }
            }
            size = attributes.size();
            for (int i = 0; i < size; ++i) {
                baseType.addAttribute((WmAttribute)attributes.elementAt(i));
            }
        }
        elements.removeAllElements();
        attributes.removeAllElements();
        models.removeAllElements();
        prohibited.removeAllElements();
        return baseType;
    }

    void setBaseType(Type type, QName base) {
    }

    void customize(Type type) {
        type.setAbstractionType(2);
    }

    private Model createContentModel(String content) {
        if (content == null || content.equals("elementOnly")) {
            return Model.create(1, 1, 2);
        }
        if (content.equals("mixed")) {
            return Model.create(0, -1, 4);
        }
        if (content.equals("empty")) {
            return Model.create(1, 1, 7);
        }
        return Model.create(0, 1, 4);
    }

    private void merge(WmAttribute superAttribute, WmAttribute restrictedAttribute) {
        if (superAttribute == null || restrictedAttribute == null) {
            return;
        }
        String defaultValue = restrictedAttribute.getDefaultValue();
        String fixedValue = restrictedAttribute.getFixedValue();
        boolean required = restrictedAttribute.isRequired();
        ContentType type = restrictedAttribute.getType();
        if (restrictedAttribute.isUsageSpecified()) {
            superAttribute.setRequired(required);
        }
        if (defaultValue != null) {
            superAttribute.setDefaultValue(defaultValue);
        }
        if (fixedValue != null) {
            superAttribute.setFixedValue(fixedValue);
        }
        if (type != null && !restrictedAttribute.isURType()) {
            superAttribute.setType(type);
        }
    }
}

