/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.lc;

import com.wm.lang.schema.WmAttributeRef;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;

public class AttributeRefExp
extends Expression {
    private static final boolean debug = false;
    static final Name _wsdlUri = Name.create("http://schemas.xmlsoap.org/wsdl/");
    static final Name _arrayType = Name.create("arrayType");

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingAttributeGroup()) {
            this.translate(node, workspace, parentSpace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        this.spitOut(node, workspace);
        QName name = this.computeQName(node.getAttributeValue(null, REF), node, workspace, baseIdentifier, true);
        WmAttributeRef attr = new WmAttributeRef(name);
        String use = node.getAttributeValue(null, USE);
        String fixed = this.getFixed(node);
        String defaultValue = this.getDefault(node);
        String wsdlArrayType = node.getAttributeValue(_wsdlUri, _arrayType);
        if (wsdlArrayType != null) {
            defaultValue = wsdlArrayType;
            attr.setUseWsdlArrayType(true);
        }
        attr.setDefaultValue(defaultValue);
        attr.setFixedValue(fixed);
        if (use != null) {
            if (use.equals("required")) {
                attr.setRequired(true);
            } else if (use.equals("prohibited")) {
                parentSpace.prohibited.addElement(name);
                return;
            }
            attr.setUsageSpecified();
        }
        parentSpace.attributes.addElement(attr);
        if (!workspace.attributeNames.contains(name)) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-004", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_DECLARATION, ""));
        }
    }

    protected String getFixed(ElementNode node) {
        String use = node.getAttributeValue(null, USE);
        String value = node.getAttributeValue(null, VALUE);
        return use != null && use.equals("fixed") ? value : null;
    }

    protected String getDefault(ElementNode node) {
        String use = node.getAttributeValue(null, USE);
        String value = node.getAttributeValue(null, VALUE);
        return use != null && use.equals("default") ? value : null;
    }
}

