/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.lc;

import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;

public class AttributeDeclExp
extends Expression {
    private static final boolean debug = false;

    public AttributeDeclExp() {
        this.setBaseIdentifier("attribute");
    }

    public void symbolize(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        QName name = QName.create(workspace.getCurrentTargetNamespace(), node.getAttributeValue(null, NAME));
        workspace.attributeNames.add(name);
    }

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingAttributeGroup()) {
            this.translate(node, workspace, parentSpace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        WmAttribute dup;
        block14: {
            this.spitOut(node, workspace);
            Space localSpace = new Space();
            super.translate(node, workspace, localSpace, baseIdentifier);
            String form = node.getAttributeValue(null, FORM);
            String ncName = node.getAttributeValue(null, NAME);
            String type = node.getAttributeValue(null, TYPE);
            String use = node.getAttributeValue(null, USE);
            String fixed = this.getFixed(node);
            String defaultValue = this.getDefault(node);
            WmAttribute attr = null;
            if (use != null && use.equals("prohibited")) {
                parentSpace.prohibited.addElement(QName.create(null, ncName));
                return;
            }
            if (fixed != null && defaultValue != null) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-016", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DEFAULT_FIXED_CANNOT_COEXIST, ""));
            }
            TypeDef st = null;
            boolean isURType = false;
            if (type != null) {
                QName typeName = this.computeQName(type, node, workspace, baseIdentifier);
                this.check(typeName, 1, node, workspace, baseIdentifier);
                Name ns = typeName.getNamespaceName();
                if (ns == XSDCompiler.WEBM_DEFAULT_NAMESPACE) {
                    typeName = QName.create(null, typeName.getLocalName());
                }
                Name nsuri = node.getNamespaceUri();
                st = DatatypeFactory.createReference(nsuri, typeName);
            } else if (localSpace.getType() != null) {
                st = localSpace.getType();
            } else {
                st = this.createURTypeDefinition(node);
                isURType = true;
            }
            attr = new WmAttribute(ncName, use != null && use.equals("required"), defaultValue, fixed, (ContentType)st);
            if (use != null) {
                attr.setUsageSpecified();
            }
            if (isURType) {
                attr.setURTypeFlag();
            }
            if (workspace.isCreatingAttributeGroup() || workspace.isCreatingComplexType()) {
                if (form == null && workspace.getCurrentAttributeFormDefaultQualified() || form != null && form.equals("qualified")) {
                    attr.setNamespaceURI(workspace.getCurrentTargetNamespace());
                }
                parentSpace.attributes.addElement(attr);
                return;
            }
            dup = null;
            try {
                dup = workspace.cSchema.put(attr);
            }
            catch (TNSException tns) {
                String tnsname = workspace.cSchema.getTargetNamespace();
                if (tnsname == null || tnsname.equals("http://schemas.xmlsoap.org/soap/encoding/")) break block14;
                workspace.addWarning(baseIdentifier, this.getSource(node), "XSDC-080", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DECL_IN_ANOTHER_SCHEMA, "", tns.getSchemaName()));
            }
        }
        if (dup != null) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-001", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DECL_FOUND_IN_THIS_SCHEMA, ""));
        }
    }

    protected String composeRelativeIdentifier(ElementNode node) {
        return this.composeRelativeIdentifierUsingName(node);
    }

    protected String getFixed(ElementNode node) {
        String use = node.getAttributeValue(null, USE);
        String value = node.getAttributeValue(null, VALUE);
        return use != null && use.equals("fixed") ? value : null;
    }

    protected String getDefault(ElementNode node) {
        String use = node.getAttributeValue(null, USE);
        String value = node.getAttributeValue(null, VALUE);
        return use != null && use.equals("default") ? value : null;
    }
}

