/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.cr;

import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.DatatypeRef;
import com.wm.lang.schema.datatype.WmUnion;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.QName;
import java.util.StringTokenizer;

public class UnionExp
extends Expression {
    private static final String SEP = " ";
    private static final QName ANY_SIMPLE_TYPE = QName.create("http://www.w3.org/2000/10/XMLSchema", "anySimpleType");
    private static final QName ANY_UNION = QName.create("http://www.w3.org/2000/10/XMLSchema", "anyUnion");

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        Datatype[] dTypes;
        String memberTypes = node.getAttributeValue(null, MEMBER_TYPES);
        WmUnion union = null;
        Space localSpace = new Space();
        if (memberTypes != null) {
            StringTokenizer tokenizer = new StringTokenizer(memberTypes, SEP);
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                QName member = this.computeQName(tokenizer.nextToken(), node, workspace, baseIdentifier);
                this.check(member, 1, node, workspace, baseIdentifier);
                DatatypeRef memberRef = new DatatypeRef(member);
                localSpace.put(memberRef);
                ++i;
            }
        }
        super.translate(node, workspace, localSpace, baseIdentifier);
        Object[] types = localSpace.getTypes();
        if (types != null && types.length > 0) {
            dTypes = new Datatype[types.length];
            System.arraycopy(types, 0, dTypes, 0, types.length);
            union = new WmUnion(dTypes);
        }
        if (union == null) {
            dTypes = new Datatype[]{(Datatype)this.createURTypeDefinition(node)};
            union = new WmUnion(dTypes);
        }
        parentSpace.put(union);
        parentSpace.typeHeirarchy.add(ANY_SIMPLE_TYPE);
        parentSpace.typeHeirarchy.add(ANY_UNION);
    }
}

