/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.cr;

import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;

public abstract class TypeExp
extends Expression {
    static final boolean debug = false;
    static final String SCHEMA_SOAP_ENCODING = "pub.soap.schema:encoding";

    public void redefine(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        if (!workspace.isProcessingRedefine()) {
            return;
        }
        QName typeName = QName.create(workspace.getCurrentTargetNamespace(), node.getAttributeValue(null, NAME));
        workspace.redefineType(typeName);
    }

    public void rename(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        QName typeName = QName.create(workspace.getCurrentTargetNamespace(), node.getAttributeValue(null, NAME));
        workspace.renameType(typeName);
    }

    public void symbolize(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        Type dup;
        QName newName;
        QName name = QName.create(workspace.getCurrentTargetNamespace(), node.getAttributeValue(null, NAME));
        Type type = Type.create(name, node);
        this.customize(type);
        if (workspace.isCurrentRedefineTarget() && (newName = workspace.getTypeRename(name)) != null) {
            name = newName;
        }
        if ((dup = workspace.types.put(name, type)) != null) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-002", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DEF_FOUND_IN_THIS_SCHEMA, null));
        }
    }

    abstract void customize(Type var1);

    protected String composeRelativeIdentifier(ElementNode node) {
        return this.composeRelativeIdentifierUsingName(node);
    }

    protected void addType(TypeDef type, ElementNode node, XSDWorkspace workspace, Space localSpace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        ElementNode parent = (ElementNode)node.getParent();
        if (parent.getLocalNameWm() == SCHEMA || parent.getLocalNameWm() == REDEFINE) {
            ContentType dup;
            block9: {
                String ncName = node.getAttributeValue(null, NAME);
                String abstrat = node.getAttributeValue(null, ABSTRACT);
                if (workspace.isCurrentRedefineTarget() && workspace.getTypeRename(ncName) != null) {
                    return;
                }
                type.setName(ncName);
                dup = null;
                localSpace.typeHeirarchy.add(QName.create(parent.getNamespaceUri(), ANY_TYPE));
                localSpace.typeHeirarchy.add(QName.create(workspace.getCurrentTargetNamespace(), ncName));
                type.setTypeHeirarchy(localSpace.typeHeirarchy);
                if (abstrat != null && abstrat.equals("true")) {
                    type.setAbstract(true);
                }
                try {
                    dup = workspace.cSchema.put(type);
                    JournalLogger.logDebug(9999, 82, ">>> cr TypeExp.addType ADDED tns= " + workspace.cSchema.getTargetNamespace() + " type = " + type.getName());
                }
                catch (TNSException tns) {
                    JournalLogger.logError(9998, 82, tns);
                    JournalLogger.logError(9999, 82, ">>> cr TypeExp.addType EXCEPTION tns= " + workspace.cSchema.getTargetNamespace() + " type = " + type.getName());
                    String tnsname = workspace.cSchema.getTargetNamespace();
                    if (tnsname == null || tnsname.equals("http://schemas.xmlsoap.org/soap/encoding/")) break block9;
                    String nsschemaName = tns.getSchemaName();
                    if (type.getOwner() == null) {
                        JournalLogger.logDebug(1, 82, new Object[]{type, nsschemaName});
                        NSName name = NSName.create(nsschemaName);
                        NSNode schemaNode = workspace.cSchema.getNamespace().getNode(name);
                        if (schemaNode != null && schemaNode.getNodeTypeObj().equals(NSSchema.TYPE)) {
                            type.setOwner((Schema)((Object)schemaNode));
                        }
                    }
                    if (nsschemaName.equals(SCHEMA_SOAP_ENCODING)) break block9;
                    workspace.addWarning(baseIdentifier, this.getSource(node), "XSDC-081", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DEF_IN_ANOTHER_SCHEMA, null, nsschemaName));
                }
            }
            if (dup != null) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-002", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_DUPLICATE_DECL_FOUND_IN_THIS_SCHEMA, null));
            }
        } else {
            parentSpace.put(type);
            TypeExp.copy(localSpace.typeHeirarchy, parentSpace.typeHeirarchy);
        }
    }
}

