/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.cr;

import com.wm.data.IData;
import com.wm.data.IDataUtil;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SimpleTypeUtil;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.cr.RestrictionCommon;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;

public class RestrictionExp
extends RestrictionCommon {
    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingComplexType()) {
            this.translateC(node, workspace, parentSpace, baseIdentifier);
        } else {
            this.translateS(node, workspace, parentSpace, baseIdentifier);
        }
    }

    protected void translateS(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        boolean simpleTypeFound;
        String base = node.getAttributeValue(null, BASE);
        Space localSpace = new Space();
        Space baseSpace = new Space();
        super.translate(node, workspace, localSpace, baseIdentifier);
        Values facets = workspace.facets.compose();
        workspace.facets.clear();
        boolean facetsFound = facets.size() > 0;
        boolean baseFound = base != null;
        boolean bl = simpleTypeFound = localSpace.getType() != null;
        if (baseFound && simpleTypeFound || !baseFound && !simpleTypeFound) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-013", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INVALID_SYNTAX, null));
            parentSpace.put(this.createURTypeDefinition(node));
        } else {
            SimpleType baseType = null;
            if (simpleTypeFound) {
                baseType = (SimpleType)localSpace.getType();
                RestrictionExp.copy(localSpace.typeHeirarchy, parentSpace.typeHeirarchy);
            } else {
                this.processBaseDefinition(base, node, workspace, baseSpace, baseIdentifier);
                baseType = (SimpleType)baseSpace.getType();
                RestrictionExp.copy(baseSpace.typeHeirarchy, parentSpace.typeHeirarchy);
            }
            SimpleType simpleType = null;
            try {
                simpleType = SimpleTypeUtil.deriveFrom(baseType);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (facetsFound) {
                try {
                    IData currentFacets = simpleType.getFacets();
                    IDataUtil.merge(facets, currentFacets);
                    try {
                        simpleType.setFacets(currentFacets, workspace.getLocale());
                    }
                    catch (Exception ex) {
                        Object[] subs = new Object[]{((Datatype)simpleType).getClass().getName(), ex.toString()};
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-008", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INCORRECT_FACETS, null, subs));
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            parentSpace.put(simpleType);
        }
    }

    protected void createSimpleType(QName base, XSDWorkspace workspace, Space space, String baseIdentifier, ElementNode context) throws WMDocumentException {
        SimpleType type = null;
        if (ANY_SIMPLE_TYPE_NAMES.contains(base)) {
            ElementNode sComponent = (ElementNode)context.getParent();
            String name = sComponent.getAttributeValue(null, NAME);
            try {
                QName[] types;
                type = Datatype.create(name);
                if (type != null && (types = BuiltIns.current().getTypeHeirarchy(QName.create(workspace.getCurrentTargetNamespace(), name))) != null) {
                    for (int i = 0; i < types.length; ++i) {
                        space.typeHeirarchy.add(types[i]);
                    }
                }
                space.put(type);
            }
            catch (Exception ex) {
                workspace.addError(baseIdentifier, this.getSource(context), "XSDC-007", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_BUILT_IN_TYPE, null, name));
                space.put(this.createURTypeDefinition(context));
            }
        } else {
            HashSet set;
            type = SimpleTypeUtil.clone(workspace.ns, base);
            space.put(type);
            if (type != null && (set = type.getTypeHeirarchy()) != null) {
                Object[] types = new QName[set.size()];
                set.toArray(types);
                for (int i = 0; i < types.length; ++i) {
                    space.typeHeirarchy.add(types[i]);
                }
            }
        }
    }
}

