/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.cr;

import com.wm.lang.schema.Any;
import com.wm.lang.schema.AnyAttribute;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import java.util.Vector;

public abstract class RestrictionCommon
extends Expression {
    static final int PASS_THRU = 0;
    static final int PASS_IF = 1;
    static final int ERROR = 2;
    static final int[][] ACTION = new int[][]{{0, 0, 0}, {2, 1, 1}, {2, 2, 1}};

    protected void translateC(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        int i;
        String base = node.getAttributeValue(null, BASE);
        Space localSpace = new Space();
        Space baseSpace = new Space();
        if (base != null) {
            if (workspace.isProcessingRedefine()) {
                QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
                QName curRedefName = workspace.getCurrentRedefineName();
                if (curRedefName != null) {
                    if (baseQName != curRedefName) {
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-017", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_REDEFINE_BASE_NAME_MISMATCH, null));
                    }
                    workspace.setCurrentRedefineName(null);
                    workspace.setBaseSpecified(true);
                }
            }
            this.processBaseDefinition(base, node, workspace, baseSpace, baseIdentifier);
        }
        super.translate(node, workspace, localSpace, baseIdentifier);
        parentSpace.mixed = false;
        RestrictionCommon.copy(localSpace.models, parentSpace.models);
        RestrictionCommon.copy(localSpace.elements, parentSpace.elements);
        Vector rAttrs = localSpace.attributes;
        Vector sAttrs = baseSpace.attributes;
        Vector pAttrs = localSpace.prohibited;
        int size = rAttrs.size();
        for (i = 0; i < size; ++i) {
            QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
            String ncName = baseQName.getNCName();
            WmAttribute restrictedAttribute = (WmAttribute)rAttrs.elementAt(i);
            int index = this.lookup(sAttrs, restrictedAttribute.getQName());
            if (index < 0 && !ANY_TYPE.toString().equals(ncName)) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-006", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_RESTRICTED_ATTRIBUTE_DECL, null));
                continue;
            }
            if (index < 0) continue;
            WmAttribute superAttribute = (WmAttribute)sAttrs.elementAt(index);
            if (superAttribute instanceof AnyAttribute) {
                this.applyRestriction((AnyAttribute)superAttribute, (AnyAttribute)restrictedAttribute, node, workspace, baseIdentifier);
                continue;
            }
            this.merge((WmAttribute)sAttrs.elementAt(index), restrictedAttribute);
        }
        size = pAttrs.size();
        for (i = 0; i < size; ++i) {
            QName prohibitedAttributeName = (QName)pAttrs.elementAt(i);
            int index = this.lookup(sAttrs, prohibitedAttributeName);
            if (index < 0) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-006", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_PROHIBITED_ATTRIBUTE_DECL, null));
                continue;
            }
            sAttrs.removeElementAt(index);
        }
        RestrictionCommon.copy(sAttrs, parentSpace.attributes);
        RestrictionCommon.copy(baseSpace.typeHeirarchy, parentSpace.typeHeirarchy);
        parentSpace.put(baseSpace.getType());
    }

    protected void processBaseDefinition(String base, ElementNode node, XSDWorkspace workspace, Space space, String baseIdentifier) throws WMDocumentException {
        Type type;
        String newNCName;
        QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
        String ncName = baseQName.getNCName();
        if (workspace.redefinesPresent() && (newNCName = workspace.calcTypeRename(ncName)) != null) {
            baseQName = QName.create(baseQName.getNamespace(), newNCName);
        }
        if ((type = (Type)workspace.types.get(baseQName)) != null && type.getAbstractionType() == 1 || BuiltIns.current().containsKey(baseQName)) {
            Object simpleType = null;
            if (type != null && !ANY_SIMPLE_TYPE_NAMES.contains(baseQName)) {
                this.createSimpleType(type.getDefinition(), workspace, space, baseIdentifier);
            } else {
                this.createSimpleType(baseQName, workspace, space, baseIdentifier, node);
            }
            space.typeHeirarchy.add(baseQName);
        } else if (type != null && type.getAbstractionType() == 2) {
            ElementNode typeNode = type.getDefinition();
            workspace.pushCurrent(typeNode);
            super.translate(typeNode, workspace, space, baseIdentifier);
            workspace.popCurrent();
            space.typeHeirarchy.add(baseQName);
        } else if (ANY_TYPE_NAMES.contains(baseQName)) {
            space.typeHeirarchy.add(baseQName);
            space.attributes.addElement(this.createAnyAttribute());
        } else {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-005", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_BASE_TYPE_DEFINITION, null));
        }
    }

    protected void merge(WmAttribute superAttribute, WmAttribute restrictedAttribute) {
        if (superAttribute == null || restrictedAttribute == null) {
            return;
        }
        String defaultValue = restrictedAttribute.getDefaultValue();
        String fixedValue = restrictedAttribute.getFixedValue();
        boolean required = restrictedAttribute.isRequired();
        boolean wsdlarraytype = restrictedAttribute.useWsdlArrayType();
        ContentType type = restrictedAttribute.getType();
        if (restrictedAttribute.isUsageSpecified()) {
            superAttribute.setRequired(required);
        }
        if (defaultValue != null) {
            superAttribute.setDefaultValue(defaultValue);
        }
        if (fixedValue != null) {
            superAttribute.setFixedValue(fixedValue);
        }
        if (type != null && !restrictedAttribute.isURType()) {
            superAttribute.setType(type);
        }
        superAttribute.setUseWsdlArrayType(wsdlarraytype);
    }

    protected void createSimpleType(ElementNode node, XSDWorkspace workspace, Space space, String baseIdentifier) throws WMDocumentException {
        workspace.pushCurrent(node);
        super.translate(node, workspace, space, baseIdentifier);
        workspace.popCurrent();
    }

    protected void applyRestriction(AnyAttribute base, AnyAttribute derived, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        Any baseModel = base.getModel();
        Any derivedModel = derived.getModel();
        int baseQualifier = baseModel.getQualifier();
        int derivedQualifier = derivedModel.getQualifier();
        baseModel.setProcessContents(derivedModel.getProcessContents());
        baseModel.setQualifier(derivedQualifier);
        switch (ACTION[baseQualifier][derivedQualifier]) {
            case 0: {
                baseModel.setURIs(derivedModel.getURIs());
                break;
            }
            case 1: {
                if (this.isRestrictive(baseQualifier, baseModel.getURIs(), derivedQualifier, derivedModel.getURIs())) {
                    baseModel.setURIs(derivedModel.getURIs());
                    break;
                }
            }
            case 2: {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-014", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INVALID_ATTRIBUTE_WILDCARD_RESTRICTION, null));
            }
        }
    }

    protected boolean isRestrictive(int baseQualifier, HashSet baseURIs, int derivedQualifier, HashSet derivedURIs) {
        block6: {
            block4: {
                Object[] items;
                block5: {
                    if (baseQualifier != 1) break block4;
                    items = derivedURIs.toArray();
                    if (derivedQualifier != 1) break block5;
                    for (int i = 0; i < items.length; ++i) {
                        if (baseURIs.contains(items[i])) continue;
                        return false;
                    }
                    break block6;
                }
                if (derivedQualifier != 2) break block6;
                for (int i = 0; i < items.length; ++i) {
                    if (!baseURIs.contains(items[i])) continue;
                    return false;
                }
                break block6;
            }
            if (baseQualifier == 2) {
                Object[] items = baseURIs.toArray();
                for (int i = 0; i < items.length; ++i) {
                    if (derivedURIs.contains(items[i])) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected AnyAttribute createAnyAttribute() {
        AnyAttribute wildcardAttr = new AnyAttribute();
        wildcardAttr.setModel(Any.createAny(1, 1));
        return wildcardAttr;
    }

    protected abstract void createSimpleType(QName var1, XSDWorkspace var2, Space var3, String var4, ElementNode var5) throws WMDocumentException;
}

