/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.cr;

import com.wm.lang.schema.Any;
import com.wm.lang.schema.AnyAttribute;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.Sequence;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.Vector;

public class ExtensionExp
extends Expression {
    static final int ANY = 0;
    static final int PLUS = 1;
    static final int PASS_IF_1 = 2;
    static final int PASS_IF_2 = 3;
    static final int PASS_IF_3 = 4;
    static final int[][] ACTION = new int[][]{{0, 0, 0}, {0, 2, 3}, {0, 4, 1}};

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingComplexType()) {
            this.translateC(node, workspace, parentSpace, baseIdentifier);
        } else {
            this.translateS(node, workspace, parentSpace, baseIdentifier);
        }
    }

    private void translateS(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
    }

    private void translateC(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        String base = node.getAttributeValue(null, BASE);
        Space localSpace = new Space();
        Space baseSpace = new Space();
        if (base != null) {
            if (workspace.isProcessingRedefine()) {
                QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
                QName curRedefName = workspace.getCurrentRedefineName();
                if (curRedefName != null) {
                    if (curRedefName != baseQName) {
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-017", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_REDEFINE_BASE_NAME_MISMATCH, null));
                    }
                    workspace.setCurrentRedefineName(null);
                    workspace.setBaseSpecified(true);
                }
            }
            this.processBaseDefinition(base, node, workspace, baseSpace, baseIdentifier);
        }
        super.translate(node, workspace, localSpace, baseIdentifier);
        if (localSpace.elements.isEmpty() && !baseSpace.elements.isEmpty()) {
            parentSpace.mixed = baseSpace.mixed;
        }
        if (!localSpace.elements.isEmpty() && !localSpace.elements.isEmpty()) {
            int i;
            Sequence sm = Sequence.createSequence(1, 1);
            int size = baseSpace.models.size();
            for (i = 0; i < size; ++i) {
                sm.addModel((Model)baseSpace.models.elementAt(i));
            }
            size = localSpace.models.size();
            for (i = 0; i < size; ++i) {
                sm.addModel((Model)localSpace.models.elementAt(i));
            }
            parentSpace.models.addElement(sm);
        } else {
            ExtensionExp.copy(baseSpace.models, parentSpace.models);
            ExtensionExp.copy(localSpace.models, parentSpace.models);
        }
        ExtensionExp.copy(baseSpace.elements, parentSpace.elements);
        ExtensionExp.copy(localSpace.elements, parentSpace.elements);
        Vector lAttrs = localSpace.attributes;
        Vector bAttrs = baseSpace.attributes;
        AnyAttribute lAnyAttr = null;
        AnyAttribute bAnyAttr = null;
        int index = this.lookup(lAttrs, ANY_ATTRIBUTE);
        if (index >= 0) {
            lAnyAttr = (AnyAttribute)lAttrs.elementAt(index);
            lAttrs.removeElementAt(index);
        }
        if ((index = this.lookup(bAttrs, ANY_ATTRIBUTE)) >= 0) {
            bAnyAttr = (AnyAttribute)bAttrs.elementAt(index);
            bAttrs.removeElementAt(index);
        }
        if (lAnyAttr != null && bAnyAttr == null) {
            lAttrs.addElement(lAnyAttr);
        }
        if (lAnyAttr == null && bAnyAttr != null) {
            bAttrs.addElement(bAnyAttr);
        }
        if (lAnyAttr != null && bAnyAttr != null) {
            this.applyExtension(bAnyAttr, lAnyAttr, node, workspace, baseIdentifier);
            bAttrs.addElement(bAnyAttr);
        }
        ExtensionExp.copy(bAttrs, parentSpace.attributes);
        ExtensionExp.copy(lAttrs, parentSpace.attributes);
        ExtensionExp.copy(baseSpace.typeHeirarchy, parentSpace.typeHeirarchy);
        parentSpace.put(baseSpace.getType());
    }

    private void processBaseDefinition(String base, ElementNode node, XSDWorkspace workspace, Space space, String baseIdentifier) throws WMDocumentException {
        Type type;
        String newNCName;
        QName baseQName = this.computeQName(base, node, workspace, baseIdentifier);
        String ncName = baseQName.getNCName();
        if (workspace.redefinesPresent() && (newNCName = workspace.calcTypeRename(ncName)) != null) {
            baseQName = QName.create(baseQName.getNamespace(), newNCName);
        }
        if ((type = (Type)workspace.types.get(baseQName)) != null && type.getAbstractionType() == 1 || BuiltIns.current().containsKey(baseQName)) {
            Name nsuri = node.getNamespaceUri();
            space.put(DatatypeFactory.createReference(nsuri, baseQName));
            space.typeHeirarchy.add(baseQName);
        } else if (type != null && type.getAbstractionType() == 2) {
            ElementNode typeNode = type.getDefinition();
            workspace.pushCurrent(typeNode);
            super.translate(typeNode, workspace, space, baseIdentifier);
            space.mixed = this.retrieveMixed(typeNode);
            workspace.popCurrent();
            space.typeHeirarchy.add(baseQName);
        } else {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-005", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_BASE_TYPE_DEFINITION, null));
        }
    }

    void applyExtension(AnyAttribute base, AnyAttribute derived, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        Any baseModel = base.getModel();
        Any derivedModel = derived.getModel();
        int baseQualifier = baseModel.getQualifier();
        int derivedQualifier = derivedModel.getQualifier();
        HashSet baseUris = baseModel.getURIs();
        HashSet derivedUris = derivedModel.getURIs();
        Iterator it = null;
        int baseProcessContents = baseModel.getProcessContents();
        baseModel.setProcessContents(derivedModel.getProcessContents());
        baseModel.setQualifier(derivedQualifier);
        switch (ACTION[baseQualifier][derivedQualifier]) {
            case 0: {
                baseModel.setURIs(new HashSet());
                baseModel.setQualifier(0);
                break;
            }
            case 1: {
                it = derivedUris.iterator();
                int i = 0;
                while (it.hasNext()) {
                    baseUris.add(it.next());
                    ++i;
                }
                baseModel.setURIs(baseUris);
                break;
            }
            case 2: {
                Object[] items = derivedUris.toArray();
                if (baseUris.size() == derivedUris.size()) {
                    for (int i = 0; i < items.length; ++i) {
                        if (baseUris.contains(items[i])) continue;
                        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-015", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INVALID_ATTRIBUTE_WILDCARD_EXTENSION, null));
                    }
                    break;
                }
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-015", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INVALID_ATTRIBUTE_WILDCARD_EXTENSION, null));
                break;
            }
            case 3: {
                Object[] items = derivedUris.toArray();
                for (int i = 0; i < items.length; ++i) {
                    if (!baseUris.contains(items[i])) continue;
                    baseModel.setURIs(new HashSet());
                    baseModel.setQualifier(0);
                    break;
                }
                baseModel.setProcessContents(baseProcessContents);
                baseModel.setQualifier(baseQualifier);
                break;
            }
            case 4: {
                Object[] items = baseUris.toArray();
                boolean hasIntersect = false;
                for (int i = 0; i < items.length; ++i) {
                    if (!derivedUris.contains(items[i])) continue;
                    baseModel.setURIs(new HashSet());
                    baseModel.setQualifier(0);
                    hasIntersect = true;
                    break;
                }
                if (hasIntersect) break;
                base.setModel(derivedModel);
            }
        }
    }
}

