/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd.cr;

import com.wm.lang.schema.ComplexModel;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.Sequence;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.State;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.cr.TypeExp;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.soap.coder.ArrayType;
import com.wm.soap.coder.ArrayTypeParser;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.XMLUtils;
import java.util.Vector;

public class ComplexTypeExp
extends TypeExp {
    static final boolean _debug = false;

    public ComplexTypeExp() {
        this.setBaseIdentifier("complexType");
    }

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        if (workspace.isCreatingModelGroup()) {
            this.translate(node, workspace, parentSpace, baseIdentifier);
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        String ncName;
        this.spitOut(node, workspace);
        workspace.setState(State.CREATING_COMPLEXTYPE);
        Space localSpace = new Space();
        QName name = null;
        if (workspace.isProcessingRedefine() && (ncName = node.getAttributeValue(null, NAME)) != null) {
            name = QName.create(workspace.getCurrentTargetNamespace(), ncName);
            workspace.setCurrentRedefineName(name);
            workspace.setBaseSpecified(false);
        }
        ComplexType type = this.createComplexType(node, workspace, localSpace, baseIdentifier);
        type.rearrageAttributes();
        this.addType(type, node, workspace, localSpace, parentSpace, baseIdentifier);
        if (workspace.isProcessingRedefine() && name != null && !workspace.isBaseSpecified()) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-018", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_REDEFINE_REQUIRES_BASE, null));
        }
        workspace.reset();
    }

    void customize(Type type) {
        type.setAbstractionType(2);
    }

    private ComplexType createComplexType(ElementNode node, XSDWorkspace workspace, Space space, String baseIdentifier) throws WMDocumentException {
        Model model;
        boolean mixed = this.retrieveMixed(node);
        if (XMLUtils.getFirstChildElement(node) != null) {
            super.translate(node, workspace, space, baseIdentifier);
        } else {
            Sequence defaultMod = (Sequence)Model.create(2);
            Model anyModel = Model.create(0, -1, 6);
            defaultMod.addModel(anyModel);
            space.models.addElement(defaultMod);
        }
        Vector elements = space.elements;
        Vector models = space.models;
        Vector attributes = space.attributes;
        WmComplexType type = new WmComplexType();
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            type.addElement((WmElement)elements.elementAt(i));
        }
        int size2 = attributes.size();
        for (int i = 0; i < size2; ++i) {
            WmAttribute attr = (WmAttribute)attributes.elementAt(i);
            type.addAttribute(attr);
            if (!attr.useWsdlArrayType()) continue;
            WmElement link = this.useWsdlArrayType(attr, node, workspace, baseIdentifier);
            type.addElement(link);
        }
        Model model2 = model = models.size() > 0 ? (Model)models.elementAt(0) : Model.create(7);
        if (mixed || space.mixed) {
            ComplexModel cm = (ComplexModel)Model.create(4);
            cm.addModel(model);
            model = cm;
        }
        type.setModel(model);
        type.setSimpleType((SimpleType)space.getType());
        return type;
    }

    WmElement useWsdlArrayType(WmAttribute attr, ElementNode node, XSDWorkspace workspace, String baseid) throws WMDocumentException {
        Name nsuri = null;
        QName computedQName = null;
        String ncName = null;
        String type = null;
        String abstrat = null;
        Object equivClass = null;
        String form = null;
        String nullable = null;
        String defaultValue = null;
        String fixedValue = null;
        String baseIdentifier = null;
        ElementNode typeNode = null;
        Type typeDef = null;
        ArrayType at = ArrayTypeParser.parseDeclaration(null, attr.getDefaultValue(), node);
        QName qn = at.getItemType();
        if (BuiltIns.current().containsKey(qn) || ANY_TYPE_NAMES.contains(qn)) {
            computedQName = qn;
            nsuri = qn.getNamespaceName();
            ncName = qn.getNCName();
            defaultValue = attr.getDefaultValue();
        } else {
            typeDef = (Type)workspace.types.get(qn);
            if (typeDef != null) {
                typeNode = typeDef.getDefinition();
                baseIdentifier = this.createIdentifier(typeNode);
                ncName = typeNode.getAttributeValue(null, NAME);
                type = typeNode.getAttributeValue(null, TYPE);
                abstrat = typeNode.getAttributeValue(null, ABSTRACT);
                equivClass = null;
                form = typeNode.getAttributeValue(null, FORM);
                nullable = null;
                defaultValue = attr.getDefaultValue();
                fixedValue = typeNode.getAttributeValue(null, FIXED);
                nsuri = typeNode.getNamespaceUri();
                computedQName = typeDef.getName();
                Name ns = computedQName.getNamespaceName();
                if (ns == XSDCompiler.WEBM_DEFAULT_NAMESPACE) {
                    computedQName = QName.create(null, computedQName.getLocalName());
                }
            }
        }
        WmElement element = new WmElement(ncName);
        if (abstrat != null && abstrat.equals("true")) {
            element.setAbstract(true);
        }
        if (equivClass != null) {
            // empty if block
        }
        element.setDefaultValue(defaultValue);
        element.setFixedValue(fixedValue);
        if (nsuri != null) {
            element.setNamespaceURI(nsuri.toString());
        }
        TypeDef ct = null;
        if (typeDef != null) {
            ct = typeDef.getAbstractionType() == 2 ? new WmComplexTypeRef(null, computedQName) : DatatypeFactory.createReference(nsuri, computedQName);
        } else if (computedQName != null && BuiltIns.current().containsKey(computedQName)) {
            ct = DatatypeFactory.createReference(nsuri, computedQName);
        } else if (computedQName != null && ANY_TYPE_NAMES.contains(computedQName)) {
            ct = new WmComplexTypeRef(null, computedQName);
        } else {
            workspace.addError(baseIdentifier, this.getSource(typeNode), "XSDC-003", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_DEFINITION, ""));
        }
        element.setType(ct);
        if (nullable != null && nullable.equals("true")) {
            element.setNullable(true);
        }
        return element;
    }
}

