/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd;

import com.wm.data.IData;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.CompilerWorkspace;
import com.wm.lang.schema.xsd.Expression;
import com.wm.lang.schema.xsd.Facets;
import com.wm.lang.schema.xsd.NSDeclCollecter;
import com.wm.lang.schema.xsd.SchemaInfoset;
import com.wm.lang.schema.xsd.State;
import com.wm.lang.schema.xsd.XSDSource;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDWorkspace
extends CompilerWorkspace {
    private static final boolean debug = false;
    public Hashtable elementDecls = new Hashtable(11);
    public HashSet attributeNames = new HashSet(11);
    public Hashtable attrGroups = new Hashtable(11);
    public Hashtable modelGroups = new Hashtable(11);
    public Hashtable types = new Hashtable(11);
    public String targetNS;
    public boolean attributeFormDefaultQualified;
    public boolean elementFormDefaultQualified;
    Stack _state;
    public Schema cSchema;
    int _currentIndex = 1;
    public Facets facets = new Facets();
    NSDeclCollecter _nsDeclCollecter = new NSDeclCollecter();
    SchemaInfoset[] siss;
    Stack _sissStack;
    String _currentRedefPath;
    QName _currentRedefineName;
    boolean _baseSpecified;
    HashMap<String, HashMap<String, String>> _redefTypes;
    HashMap<String, HashMap<String, String>> _redefGroups;
    HashMap<String, HashMap<String, String>> _redefAttrGroups;
    HashMap<String, HashMap<String, String>> _renameTypes;
    HashMap<String, HashMap<String, String>> _renameGroups;
    HashMap<String, HashMap<String, String>> _renameAttrGroups;
    HashMap<String, String> _fileMap;
    HashMap<String, Integer> _fileIndex;
    boolean _processingRedefine = false;
    boolean _redefinesPresent = false;
    ArrayList<SchemaInfoset> _renameFileList;

    XSDWorkspace() {
        this._state = new Stack();
        this._sissStack = new Stack();
        this._fileMap = new HashMap();
        this._redefTypes = new HashMap();
        this._redefGroups = new HashMap();
        this._redefAttrGroups = new HashMap();
        this._renameTypes = new HashMap();
        this._renameGroups = new HashMap();
        this._renameAttrGroups = new HashMap();
    }

    public void setState(Integer state) {
        this._state.push(state);
    }

    public void reset() {
        if (!this._state.empty()) {
            this._state.pop();
        }
    }

    public Integer getState() {
        if (!this._state.empty()) {
            return (Integer)this._state.peek();
        }
        return State.UNKNOWN;
    }

    public boolean isCreatingAttributeGroup() {
        return this.getState() == State.CREATING_ATTRIBUTEGROUP;
    }

    public boolean isCreatingModelGroup() {
        return this.getState() == State.CREATING_MODELGROUP;
    }

    public boolean isCreatingComplexType() {
        return this.getState() == State.CREATING_COMPLEXTYPE;
    }

    public boolean isCreatingSimpleType() {
        return this.getState() == State.CREATING_SIMPLETYPE;
    }

    public boolean isProcessingRedefine() {
        return this._processingRedefine;
    }

    public void setProcessingRedefine(boolean flag) {
        this._processingRedefine = flag;
    }

    public boolean redefinesPresent() {
        return this._redefinesPresent;
    }

    public void setCurrentRedefineName(QName name) {
        this._currentRedefineName = name;
    }

    public QName getCurrentRedefineName() {
        return this._currentRedefineName;
    }

    public boolean isBaseSpecified() {
        return this._baseSpecified;
    }

    public void setBaseSpecified(boolean flag) {
        this._baseSpecified = flag;
    }

    void setupSchema(String targetNS) {
        String tns = targetNS != null ? targetNS : "$$NULL";
        this.cSchema = (Schema)this.uriSchemaPairs.get(tns);
        if (this.cSchema == null) {
            this.cSchema = this.createTransientSchemas ? NSSchema.createTransientSchema(this.ns, this.pkg, this.computeName()) : NSSchema.create(this.ns, this.pkg, this.computeName());
            try {
                if (!tns.equals("$$NULL")) {
                    this.cSchema.setTargetNamespace(tns);
                }
            }
            catch (TNSException tNSException) {
                // empty catch block
            }
            this.uriSchemaPairs.put(tns, this.cSchema);
        }
    }

    NSName computeName() {
        if (this.b2bQName == null) {
            return null;
        }
        NSName name = this._currentIndex == 1 ? this.b2bQName : NSName.create(this.b2bQName.toString() + "_" + this._currentIndex);
        ++this._currentIndex;
        return name;
    }

    void registerNSDecl(String uriReference, String prefix) {
        this._nsDeclCollecter.put(uriReference, prefix);
    }

    void registerNSDecl(String uri, ElementNode node) {
        Name aPrefix;
        if (uri == null || this._nsDeclCollecter.containsKey(uri)) {
            return;
        }
        Name anURI = Name.create(uri);
        NamespaceDecl decl = node.lookUpInScopeNSDeclByURI(anURI);
        String prefix = null;
        if (decl != null && (aPrefix = decl.getPrefixWm()) != null) {
            prefix = aPrefix.toString();
        }
        this.registerNSDecl(uri, prefix);
    }

    @Override
    protected IData createURIReferencePrefixPairs() {
        return this._nsDeclCollecter.getIData();
    }

    public String getCurrentTargetNamespace() {
        return this.hasValidCurrent() ? this.getCurrent().getTargetNamespace() : null;
    }

    public String getCurrentChameleonNS() {
        return this.getCurrent().getChameleonNS();
    }

    public String getCurrentUsage() {
        return this.getCurrent().getSource().getUsage();
    }

    public boolean isCurrentRedefineTarget() {
        return this.getCurrent().getSource().isRedefineTarget();
    }

    public boolean currentCotnainsRedefines() {
        return this.getCurrent().getSource().containsRedefine();
    }

    public boolean getCurrentAttributeFormDefaultQualified() {
        return this.hasValidCurrent() ? this.getCurrent().getAttributeFormDefaultQualified() : false;
    }

    public boolean getCurrentElementFormDefaultQualified() {
        return this.hasValidCurrent() ? this.getCurrent().getElementFormDefaultQualified() : false;
    }

    public void pushCurrent(SchemaInfoset siss) {
        if (siss == null) {
            return;
        }
        this._sissStack.push(siss);
    }

    public void pushCurrent(ElementNode node) {
        if (node == null) {
            // empty if block
        }
        Node parent = node.getParent();
        Node grandParent = null;
        if (parent != null) {
            grandParent = parent.getParent();
        }
        for (int i = 0; i < this.siss.length; ++i) {
            if (parent != this.siss[i].getSchema() && grandParent != this.siss[i].getSchema() && node != this.siss[i].getSchema()) continue;
            this._sissStack.push(this.siss[i]);
            return;
        }
        throw new RuntimeException("should never get here");
    }

    public void popCurrent() {
        if (this.hasValidCurrent()) {
            this._sissStack.pop();
        }
    }

    private SchemaInfoset getCurrent() {
        return this.hasValidCurrent() ? (SchemaInfoset)this._sissStack.peek() : null;
    }

    private boolean hasValidCurrent() {
        return !this._sissStack.empty();
    }

    public void setCurrentRedefinePath(Node node, boolean initMap) {
        String schemaLoc = node.getAttributeValue(null, Expression.SCHEMA_LOCATION);
        String use = this.getCurrent().getSource().getUsage();
        this._currentRedefPath = XSDSource.redefSubpathName(use, schemaLoc);
        if (initMap) {
            this._fileMap.put(this._currentRedefPath, use);
        }
    }

    public void redefineType(QName typeName) {
        this.redefineTarget(typeName, this._redefTypes);
    }

    public String calcTypeRename(String oldName) {
        return this.calcTargetRename(oldName, this._redefTypes);
    }

    public void setRenameFileList(ArrayList<SchemaInfoset> list) {
        this._renameFileList = list;
    }

    public void setFileIndex(HashMap<String, Integer> fi) {
        this._fileIndex = fi;
    }

    public void renameType(QName typeName) {
        this.renameTarget(typeName, this._redefTypes, this._renameTypes);
    }

    public QName getTypeRename(QName name) {
        return this.getTargetRename(name, this._renameTypes);
    }

    public String getTypeRename(String ncname) {
        String usage = this.getCurrentUsage();
        HashMap<String, String> renameList = this._renameTypes.get(usage);
        if (renameList == null) {
            return null;
        }
        String newName = renameList.get(ncname);
        if (newName == null) {
            return null;
        }
        return newName;
    }

    public void redefineGroup(QName groupName) {
        this.redefineTarget(groupName, this._redefGroups);
    }

    public void renameGroup(QName groupName) {
        this.renameTarget(groupName, this._redefGroups, this._renameGroups);
    }

    public QName getGroupRename(QName name) {
        return this.getTargetRename(name, this._renameGroups);
    }

    public String calcGroupRename(String oldName) {
        return this.calcTargetRename(oldName, this._redefGroups);
    }

    public void redefAttrGroup(QName targetName) {
        this.redefineTarget(targetName, this._redefAttrGroups);
    }

    public void renameAttrGroup(QName targetName) {
        this.renameTarget(targetName, this._redefAttrGroups, this._renameAttrGroups);
    }

    public QName getAttrGroupRename(QName name) {
        return this.getTargetRename(name, this._renameAttrGroups);
    }

    public String calcAttrGroupRename(String oldName) {
        return this.calcTargetRename(oldName, this._redefAttrGroups);
    }

    public String calcTargetRename(String oldName, HashMap<String, HashMap<String, String>> redefTargets) {
        String usage = this.getCurrentUsage();
        HashMap<String, String> list = redefTargets.get(usage);
        if (list == null) {
            return null;
        }
        String newName = list.get(oldName);
        return newName;
    }

    public void redefineTarget(QName targetName, HashMap<String, HashMap<String, String>> redefTargets) {
        this._redefinesPresent = true;
        String target = targetName.getNCName();
        String usage = this.getCurrentUsage();
        HashMap<String, String> targets = redefTargets.get(usage);
        if (targets == null) {
            targets = new HashMap();
            redefTargets.put(usage, targets);
        }
        String renamedTarget = XSDSource.redefTypeName(this._currentRedefPath, target);
        targets.put(target, renamedTarget);
    }

    public void renameTarget(QName targetName, HashMap<String, HashMap<String, String>> redefTargets, HashMap<String, HashMap<String, String>> renameTargets) {
        String redefPath;
        XSDSource xs = this.getCurrent().getSource();
        String type = targetName.getNCName();
        String finalUsage = xs.getUsage();
        String finalRedefPath = xs.getRedefPath();
        String finalRedefUsage = this._fileMap.get(finalRedefPath);
        while ((redefPath = xs.getRedefPath()) != null) {
            String redefTarget;
            String redefUsage = this._fileMap.get(redefPath);
            HashMap<String, String> targets = redefTargets.get(redefUsage);
            if (targets != null && (redefTarget = targets.get(type)) != null) {
                String usage = xs.getUsage();
                HashMap<String, String> renameMap = renameTargets.get(finalUsage);
                if (renameMap == null) {
                    renameMap = new HashMap();
                    renameTargets.put(finalUsage, renameMap);
                }
                renameMap.put(type, redefTarget);
                int index = this._fileIndex.get(finalRedefUsage);
                SchemaInfoset sis = this.siss[index];
                if (!sis.isProcessed()) {
                    sis.markProcessed();
                    this._renameFileList.add(sis);
                }
                return;
            }
            String baseFile = this._fileMap.get(redefPath);
            if (baseFile == null) break;
            int index = this._fileIndex.get(baseFile);
            SchemaInfoset sis = this.siss[index];
            xs = sis.getSource();
            if (!sis.isRedefineTarget() || sis.isProcessed()) continue;
            sis.markProcessed();
            this._renameFileList.add(sis);
        }
        System.out.println("!!! <<< bad news >>> !!!");
    }

    public QName getTargetRename(QName name, HashMap<String, HashMap<String, String>> renameTargets) {
        String ncname = name.getNCName();
        String usage = this.getCurrentUsage();
        HashMap<String, String> renameList = renameTargets.get(usage);
        if (renameList == null) {
            return null;
        }
        String newName = renameList.get(ncname);
        if (newName == null) {
            return null;
        }
        return QName.create(name.getNamespace(), newName);
    }
}

