/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd;

import com.wm.data.IData;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.XSDSource;
import com.wm.lang.schema.xsd.resources.XSDExceptionBundle;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedException;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.StringMatcher;
import com.wm.util.URIParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class XSDSourceBuilder {
    private static final boolean debug = false;
    private static final QName SCHEMA = QName.create("http://www.w3.org/1999/XMLSchema", "schema");
    private static final QName SCHEMA_08_2000 = QName.create("http://www.w3.org/2000/08/XMLSchema", "schema");
    private static final QName SCHEMA_10_2000 = QName.create("http://www.w3.org/2000/10/XMLSchema", "schema");
    private static final QName SCHEMA_2001 = QName.create("http://www.w3.org/2001/XMLSchema", "schema");
    private static final QName INCLUDE = QName.create("http://www.w3.org/1999/XMLSchema", "include");
    private static final QName INCLUDE_08_2000 = QName.create("http://www.w3.org/2000/08/XMLSchema", "include");
    private static final QName INCLUDE_10_2000 = QName.create("http://www.w3.org/2000/10/XMLSchema", "include");
    private static final QName INCLUDE_2001 = QName.create("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName IMPORT = QName.create("http://www.w3.org/1999/XMLSchema", "import");
    private static final QName IMPORT_08_2000 = QName.create("http://www.w3.org/2000/08/XMLSchema", "import");
    private static final QName IMPORT_10_2000 = QName.create("http://www.w3.org/2000/10/XMLSchema", "import");
    private static final QName IMPORT_2001 = QName.create("http://www.w3.org/2001/XMLSchema", "import");
    private static final Name NAMESPACE = Name.create("namespace");
    private static final Name SCHEMALOCATION = Name.create("schemaLocation");
    private static final String WSDL_11_SCHEMA = "http://schemas.xmlsoap.org/wsdl/";
    private static final String REDEFINE = "redefine";
    private static final QName SCHEMA_CR_REDEFINE = QName.create("http://www.w3.org/2000/10/XMLSchema", "redefine");
    private static final QName SCHEMA_10_REDEFINE = QName.create("http://www.w3.org/2001/XMLSchema", "redefine");
    protected static final Name TARGET_NAMESPACE = Name.create("targetNamespace");

    public static final IData[] build(String url) throws IOException, WMDocumentException, Exception {
        Vector list = new Vector();
        HashSet urls = new HashSet();
        XSDSourceBuilder.buildRecursively(null, url, 1, list, urls, null, null);
        XSDSourceBuilder.trax1_659L8(list);
        Object[] xsdArray = new XSDSource[list.size()];
        list.copyInto(xsdArray);
        return xsdArray;
    }

    public static final IData[] build(String url, InputStream is) throws IOException, WMDocumentException, Exception {
        Vector list = new Vector();
        HashSet urls = new HashSet();
        XSDSourceBuilder.buildRecursively(null, url, is, 1, list, urls, null, null);
        XSDSourceBuilder.trax1_659L8(list);
        Object[] xsdArray = new XSDSource[list.size()];
        list.copyInto(xsdArray);
        return xsdArray;
    }

    private static void trax1_659L8(Vector list) {
        boolean wsdFound = false;
        boolean soapFound = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            StringMatcher sm;
            XSDSource xsdS = (XSDSource)list.elementAt(i);
            String namespace = xsdS.getNamespace();
            String url = xsdS.getURL();
            if (namespace == null && url == null && xsdS.getSource() == null) {
                list.removeElementAt(i);
                continue;
            }
            if ("http://schemas.xmlsoap.org/soap/encoding/".equals(namespace)) {
                list.removeElementAt(i);
                soapFound = true;
                continue;
            }
            if (WSDL_11_SCHEMA.equals(namespace)) {
                list.removeElementAt(i);
                wsdFound = true;
                continue;
            }
            if (url == null || !(sm = new StringMatcher("*/soap-encoding.xsd", true)).match(url)) continue;
            list.removeElementAt(i);
            soapFound = true;
        }
        if (soapFound) {
            XSDSource xsdEncoding = XSDSource.create("<?xml version='1.0'?><!-- XML Schema for SOAP v 1.1 Encoding --><schema xmlns='http://www.w3.org/1999/XMLSchema'        xmlns:wmns1='http://schemas.xmlsoap.org/soap/encoding/'        targetNamespace='http://schemas.xmlsoap.org/soap/encoding/'> <attribute name='root' use='default' value='0'>    <simpleType base='boolean'>      <pattern value='0|1'/>    </simpleType> </attribute>  <attributeGroup name='commonAttributes'>    <attribute name='id' type='ID'/>    <attribute name='href' type='uriReference'/>    <anyAttribute namespace='##other'/>  </attributeGroup>  <simpleType name='arrayCoordinate' base='string'/>  <attribute name='arrayType' type='string'/>  <attribute name='offset' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayAttributes'>    <attribute ref='wmns1:arrayType' use='required'/>    <attribute ref='wmns1:offset'/>  </attributeGroup>  <attribute name='position' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayMemberAttributes'>    <attribute ref='wmns1:position'/>  </attributeGroup>  <element name='Array' type='wmns1:Array'/>  <group name='Array'>    <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Array' content='elementOnly'>    <group ref='wmns1:Array' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:arrayAttributes'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>   <element name='Struct' type='wmns1:Struct'/>  <group name='Struct'>      <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Struct'>    <group ref='wmns1:Struct' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <simpleType name='base64' base='binary'>    <encoding value='base64'/>  </simpleType>  <element name='string' type='wmns1:string'/>  <complexType name='string' base='string' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='boolean' type='wmns1:boolean'/>  <complexType name='boolean' base='boolean' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='float' type='wmns1:float'/>  <complexType name='float' base='float' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='double' type='wmns1:double'/>  <complexType name='double' base='double' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='decimal' type='wmns1:decimal'/>  <complexType name='decimal' base='decimal' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeDuration' type='wmns1:timeDuration'/>  <complexType name='timeDuration' base='timeDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDuration' type='wmns1:recurringDuration'/>  <complexType name='recurringDuration' base='recurringDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='binary' type='wmns1:binary'/>  <complexType name='binary' base='binary' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='uriReference' type='wmns1:uriReference'/>  <complexType name='uriReference' base='uriReference' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ID' type='wmns1:ID'/>  <complexType name='ID' base='ID' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREF' type='wmns1:IDREF'/>  <complexType name='IDREF' base='IDREF' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITY' type='wmns1:ENTITY'/>  <complexType name='ENTITY' base='ENTITY' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NOTATION' type='wmns1:NOTATION'/>  <complexType name='NOTATION' base='NOTATION' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='QName' type='wmns1:QName'/>  <complexType name='QName' base='QName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='language' type='wmns1:language'/>  <complexType name='language' base='language' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREFS' type='wmns1:IDREFS'/>  <complexType name='IDREFS' base='IDREFS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITIES' type='wmns1:ENTITIES'/>  <complexType name='ENTITIES' base='ENTITIES' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKEN' type='wmns1:NMTOKEN'/>  <complexType name='NMTOKEN' base='NMTOKEN' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKENS' type='wmns1:NMTOKENS'/>  <complexType name='NMTOKENS' base='NMTOKENS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='Name' type='wmns1:Name'/>  <complexType name='Name' base='Name' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NCName' type='wmns1:NCName'/>  <complexType name='NCName' base='NCName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='integer' type='wmns1:integer'/>  <complexType name='integer' base='integer' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonPositiveInteger' type='wmns1:nonPositiveInteger'/>  <complexType name='nonPositiveInteger' base='nonPositiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='negativeInteger' type='wmns1:negativeInteger'/>  <complexType name='negativeInteger' base='negativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='long' type='wmns1:long'/>  <complexType name='long' base='long' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='int' type='wmns1:int'/>  <complexType name='int' base='int' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='short' type='wmns1:short'/>  <complexType name='short' base='short' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='byte' type='wmns1:byte'/>  <complexType name='byte' base='byte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonNegativeInteger' type='wmns1:nonNegativeInteger'/>  <complexType name='nonNegativeInteger' base='nonNegativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedLong' type='wmns1:unsignedLong'/>  <complexType name='unsignedLong' base='unsignedLong' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedInt' type='wmns1:unsignedInt'/>  <complexType name='unsignedInt' base='unsignedInt' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedShort' type='wmns1:unsignedShort'/>  <complexType name='unsignedShort' base='unsignedShort' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedByte' type='wmns1:unsignedByte'/>  <complexType name='unsignedByte' base='unsignedByte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='positiveInteger' type='wmns1:positiveInteger'/>  <complexType name='positiveInteger' base='positiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeInstant' type='wmns1:timeInstant'/>  <complexType name='timeInstant' base='timeInstant' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='time' type='wmns1:time'/>  <complexType name='time' base='time' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timePeriod' type='wmns1:timePeriod'/>  <complexType name='timePeriod' base='timePeriod' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='date' type='wmns1:date'/>  <complexType name='date' base='date' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='month' type='wmns1:month'/>  <complexType name='month' base='month' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='year' type='wmns1:year'/>  <complexType name='year' base='year' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='century' type='wmns1:century'/>  <complexType name='century' base='century' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDate' type='wmns1:recurringDate'/>  <complexType name='recurringDate' base='recurringDate' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDay' type='wmns1:recurringDay'/>  <complexType name='recurringDay' base='recurringDay' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ur-type'/>  <complexType name='ur-type'/></schema>", 1, "http://schemas.xmlsoap.org/soap/encoding/");
            xsdEncoding.setNamespace("http://schemas.xmlsoap.org/soap/encoding/");
            xsdEncoding.setUsage("http://schemas.xmlsoap.org/soap/encoding/");
            list.addElement(xsdEncoding);
        }
        if (wsdFound) {
            XSDSource wsdEncoding = XSDSource.create("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><schema xmlns=\"http://www.w3.org/2001/XMLSchema\"xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"targetNamespace=\"http://schemas.xmlsoap.org/wsdl/\"elementFormDefault=\"qualified\"><complexType mixed = \"true\" name = \"tDocumentation\"><sequence><any minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/></sequence></complexType><complexType name = \"tDocumented\"><annotation><documentation>This type is extended by  component types to allow them to be documented </documentation></annotation><sequence><element name = \"documentation\" type = \"wsdl:tDocumentation\" minOccurs=\"0\"/></sequence></complexType><complexType name=\"tExtensibleAttributesDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component types to allow attributes from other namespaces to be added.</documentation></annotation><anyAttribute namespace=\"##other\"/></extension></complexContent></complexType><complexType name=\"tExtensibleDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component typesto allow attributes from other namespaces to be added.</documentation></annotation><sequence><any namespace=\"##other\" minOccurs = \"0\" maxOccurs = \"unbounded\"/></sequence></extension></complexContent></complexType><element name=\"definitions\" type=\"wsdl:tDefinitions\"><key name=\"message\"><selector xpath=\"wsdl:message\"/><field xpath=\"@name\"/></key><key name=\"portType\"><selector xpath=\"wsdl:portType\"/><field xpath=\"@name\"/></key><key name=\"binding\"><selector xpath=\"wsdl:binding\"/><field xpath=\"@name\"/></key><key name=\"service\"><selector xpath=\"wsdl:service\"/><field xpath=\"@name\"/></key><key name=\"import\"><selector xpath=\"wsdl:import\"/><field xpath=\"@namespace\"/></key><key name=\"port\"><selector xpath=\"wsdl:service/wsdl:port\"/><field xpath=\"@name\"/></key></element><group name = \"anyTopLevelOptionalElement\"><annotation><documentation>Any top level optional element allowed to appear more then once- any child of definitions element except wsdl:types. Any extensibility element is allowed in any place </documentation></annotation><choice><element name = \"import\"   type = \"wsdl:tImport\"/><element name = \"types\"    type = \"wsdl:tTypes\"/><element name = \"message\"  type = \"wsdl:tMessage\"><unique name=\"part\"><selector xpath=\"wsdl:part\"/><field xpath=\"@name\"/></unique></element><element name = \"portType\" type = \"wsdl:tPortType\" /><element name = \"binding\"  type = \"wsdl:tBinding\"/><element name = \"service\"  type = \"wsdl:tService\"/></choice></group><complexType name = \"tDefinitions\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><group ref = \"wsdl:anyTopLevelOptionalElement\"  minOccurs=\"0\"   maxOccurs = \"unbounded\"/></sequence><attribute name=\"targetNamespace\" type=\"anyURI\" use=\"optional\"/><attribute name=\"name\"            type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tImport\"><complexContent><extension base = \"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"namespace\" type=\"anyURI\" use=\"required\"/><attribute name=\"location\" type=\"anyURI\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tTypes\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"/></complexContent></complexType><complexType name=\"tMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"part\" type = \"wsdl:tPart\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPart\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"element\" type=\"QName\" use=\"optional\"/><attribute name=\"type\" type=\"QName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tPortType\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><sequence><element name = \"operation\" type = \"wsdl:tOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><choice><group ref=\"wsdl:request-response-one-way-operation\"/><group ref=\"wsdl:solicit-response-notification-operation\"/></choice><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"parameterOrder\" type=\"NMTOKENS\" use=\"optional\"/></extension></complexContent></complexType><group name = \"optional-response-fault\"><choice><sequence/><sequence><element name = \"output\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"request-response-one-way-operation\"><sequence><element name = \"input\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-response-fault\"/></sequence></group><group name = \"optional-solicit-fault\"><choice><sequence/><sequence><element name = \"input\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"solicit-response-notification-operation\"><sequence><element name = \"output\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-solicit-fault\"/></sequence></group><complexType name=\"tParam\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tFault\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\"  use=\"required\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBinding\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"operation\" type=\"wsdl:tBindingOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"type\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationFault\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBindingOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"input\"  type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"output\" type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"fault\"  type=\"wsdl:tBindingOperationFault\"   minOccurs=\"0\" maxOccurs = \"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tService\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"port\" type = \"wsdl:tPort\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPort\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"binding\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><attribute name=\"arrayType\" type=\"string\"/><attribute name=\"required\" type = \"boolean\"/><complexType name=\"tExtensibilityElement\" abstract = \"true\"><sequence/><attribute ref=\"wsdl:required\" use=\"optional\"/></complexType></schema>", 1, WSDL_11_SCHEMA);
            wsdEncoding.setNamespace(WSDL_11_SCHEMA);
            wsdEncoding.setUsage(WSDL_11_SCHEMA);
            list.addElement(wsdEncoding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void buildRecursively(String ns, String url, int type, Vector list, HashSet urls, String parentTNS, String redefPath) throws IOException, WMDocumentException, Exception {
        if (ns != null && "http://schemas.xmlsoap.org/soap/encoding/".equals(ns)) {
            list.addElement(XSDSource.create(ns, "<?xml version='1.0'?><!-- XML Schema for SOAP v 1.1 Encoding --><schema xmlns='http://www.w3.org/1999/XMLSchema'        xmlns:wmns1='http://schemas.xmlsoap.org/soap/encoding/'        targetNamespace='http://schemas.xmlsoap.org/soap/encoding/'> <attribute name='root' use='default' value='0'>    <simpleType base='boolean'>      <pattern value='0|1'/>    </simpleType> </attribute>  <attributeGroup name='commonAttributes'>    <attribute name='id' type='ID'/>    <attribute name='href' type='uriReference'/>    <anyAttribute namespace='##other'/>  </attributeGroup>  <simpleType name='arrayCoordinate' base='string'/>  <attribute name='arrayType' type='string'/>  <attribute name='offset' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayAttributes'>    <attribute ref='wmns1:arrayType' use='required'/>    <attribute ref='wmns1:offset'/>  </attributeGroup>  <attribute name='position' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayMemberAttributes'>    <attribute ref='wmns1:position'/>  </attributeGroup>  <element name='Array' type='wmns1:Array'/>  <group name='Array'>    <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Array' content='elementOnly'>    <group ref='wmns1:Array' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:arrayAttributes'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>   <element name='Struct' type='wmns1:Struct'/>  <group name='Struct'>      <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Struct'>    <group ref='wmns1:Struct' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <simpleType name='base64' base='binary'>    <encoding value='base64'/>  </simpleType>  <element name='string' type='wmns1:string'/>  <complexType name='string' base='string' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='boolean' type='wmns1:boolean'/>  <complexType name='boolean' base='boolean' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='float' type='wmns1:float'/>  <complexType name='float' base='float' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='double' type='wmns1:double'/>  <complexType name='double' base='double' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='decimal' type='wmns1:decimal'/>  <complexType name='decimal' base='decimal' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeDuration' type='wmns1:timeDuration'/>  <complexType name='timeDuration' base='timeDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDuration' type='wmns1:recurringDuration'/>  <complexType name='recurringDuration' base='recurringDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='binary' type='wmns1:binary'/>  <complexType name='binary' base='binary' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='uriReference' type='wmns1:uriReference'/>  <complexType name='uriReference' base='uriReference' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ID' type='wmns1:ID'/>  <complexType name='ID' base='ID' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREF' type='wmns1:IDREF'/>  <complexType name='IDREF' base='IDREF' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITY' type='wmns1:ENTITY'/>  <complexType name='ENTITY' base='ENTITY' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NOTATION' type='wmns1:NOTATION'/>  <complexType name='NOTATION' base='NOTATION' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='QName' type='wmns1:QName'/>  <complexType name='QName' base='QName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='language' type='wmns1:language'/>  <complexType name='language' base='language' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREFS' type='wmns1:IDREFS'/>  <complexType name='IDREFS' base='IDREFS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITIES' type='wmns1:ENTITIES'/>  <complexType name='ENTITIES' base='ENTITIES' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKEN' type='wmns1:NMTOKEN'/>  <complexType name='NMTOKEN' base='NMTOKEN' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKENS' type='wmns1:NMTOKENS'/>  <complexType name='NMTOKENS' base='NMTOKENS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='Name' type='wmns1:Name'/>  <complexType name='Name' base='Name' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NCName' type='wmns1:NCName'/>  <complexType name='NCName' base='NCName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='integer' type='wmns1:integer'/>  <complexType name='integer' base='integer' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonPositiveInteger' type='wmns1:nonPositiveInteger'/>  <complexType name='nonPositiveInteger' base='nonPositiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='negativeInteger' type='wmns1:negativeInteger'/>  <complexType name='negativeInteger' base='negativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='long' type='wmns1:long'/>  <complexType name='long' base='long' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='int' type='wmns1:int'/>  <complexType name='int' base='int' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='short' type='wmns1:short'/>  <complexType name='short' base='short' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='byte' type='wmns1:byte'/>  <complexType name='byte' base='byte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonNegativeInteger' type='wmns1:nonNegativeInteger'/>  <complexType name='nonNegativeInteger' base='nonNegativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedLong' type='wmns1:unsignedLong'/>  <complexType name='unsignedLong' base='unsignedLong' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedInt' type='wmns1:unsignedInt'/>  <complexType name='unsignedInt' base='unsignedInt' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedShort' type='wmns1:unsignedShort'/>  <complexType name='unsignedShort' base='unsignedShort' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedByte' type='wmns1:unsignedByte'/>  <complexType name='unsignedByte' base='unsignedByte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='positiveInteger' type='wmns1:positiveInteger'/>  <complexType name='positiveInteger' base='positiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeInstant' type='wmns1:timeInstant'/>  <complexType name='timeInstant' base='timeInstant' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='time' type='wmns1:time'/>  <complexType name='time' base='time' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timePeriod' type='wmns1:timePeriod'/>  <complexType name='timePeriod' base='timePeriod' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='date' type='wmns1:date'/>  <complexType name='date' base='date' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='month' type='wmns1:month'/>  <complexType name='month' base='month' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='year' type='wmns1:year'/>  <complexType name='year' base='year' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='century' type='wmns1:century'/>  <complexType name='century' base='century' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDate' type='wmns1:recurringDate'/>  <complexType name='recurringDate' base='recurringDate' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDay' type='wmns1:recurringDay'/>  <complexType name='recurringDay' base='recurringDay' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ur-type'/>  <complexType name='ur-type'/></schema>", type, ns));
            return;
        }
        if (ns != null && WSDL_11_SCHEMA.equals(ns)) {
            list.addElement(XSDSource.create(ns, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><schema xmlns=\"http://www.w3.org/2001/XMLSchema\"xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"targetNamespace=\"http://schemas.xmlsoap.org/wsdl/\"elementFormDefault=\"qualified\"><complexType mixed = \"true\" name = \"tDocumentation\"><sequence><any minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/></sequence></complexType><complexType name = \"tDocumented\"><annotation><documentation>This type is extended by  component types to allow them to be documented </documentation></annotation><sequence><element name = \"documentation\" type = \"wsdl:tDocumentation\" minOccurs=\"0\"/></sequence></complexType><complexType name=\"tExtensibleAttributesDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component types to allow attributes from other namespaces to be added.</documentation></annotation><anyAttribute namespace=\"##other\"/></extension></complexContent></complexType><complexType name=\"tExtensibleDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component typesto allow attributes from other namespaces to be added.</documentation></annotation><sequence><any namespace=\"##other\" minOccurs = \"0\" maxOccurs = \"unbounded\"/></sequence></extension></complexContent></complexType><element name=\"definitions\" type=\"wsdl:tDefinitions\"><key name=\"message\"><selector xpath=\"wsdl:message\"/><field xpath=\"@name\"/></key><key name=\"portType\"><selector xpath=\"wsdl:portType\"/><field xpath=\"@name\"/></key><key name=\"binding\"><selector xpath=\"wsdl:binding\"/><field xpath=\"@name\"/></key><key name=\"service\"><selector xpath=\"wsdl:service\"/><field xpath=\"@name\"/></key><key name=\"import\"><selector xpath=\"wsdl:import\"/><field xpath=\"@namespace\"/></key><key name=\"port\"><selector xpath=\"wsdl:service/wsdl:port\"/><field xpath=\"@name\"/></key></element><group name = \"anyTopLevelOptionalElement\"><annotation><documentation>Any top level optional element allowed to appear more then once- any child of definitions element except wsdl:types. Any extensibility element is allowed in any place </documentation></annotation><choice><element name = \"import\"   type = \"wsdl:tImport\"/><element name = \"types\"    type = \"wsdl:tTypes\"/><element name = \"message\"  type = \"wsdl:tMessage\"><unique name=\"part\"><selector xpath=\"wsdl:part\"/><field xpath=\"@name\"/></unique></element><element name = \"portType\" type = \"wsdl:tPortType\" /><element name = \"binding\"  type = \"wsdl:tBinding\"/><element name = \"service\"  type = \"wsdl:tService\"/></choice></group><complexType name = \"tDefinitions\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><group ref = \"wsdl:anyTopLevelOptionalElement\"  minOccurs=\"0\"   maxOccurs = \"unbounded\"/></sequence><attribute name=\"targetNamespace\" type=\"anyURI\" use=\"optional\"/><attribute name=\"name\"            type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tImport\"><complexContent><extension base = \"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"namespace\" type=\"anyURI\" use=\"required\"/><attribute name=\"location\" type=\"anyURI\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tTypes\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"/></complexContent></complexType><complexType name=\"tMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"part\" type = \"wsdl:tPart\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPart\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"element\" type=\"QName\" use=\"optional\"/><attribute name=\"type\" type=\"QName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tPortType\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><sequence><element name = \"operation\" type = \"wsdl:tOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><choice><group ref=\"wsdl:request-response-one-way-operation\"/><group ref=\"wsdl:solicit-response-notification-operation\"/></choice><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"parameterOrder\" type=\"NMTOKENS\" use=\"optional\"/></extension></complexContent></complexType><group name = \"optional-response-fault\"><choice><sequence/><sequence><element name = \"output\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"request-response-one-way-operation\"><sequence><element name = \"input\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-response-fault\"/></sequence></group><group name = \"optional-solicit-fault\"><choice><sequence/><sequence><element name = \"input\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"solicit-response-notification-operation\"><sequence><element name = \"output\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-solicit-fault\"/></sequence></group><complexType name=\"tParam\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tFault\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\"  use=\"required\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBinding\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"operation\" type=\"wsdl:tBindingOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"type\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationFault\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBindingOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"input\"  type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"output\" type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"fault\"  type=\"wsdl:tBindingOperationFault\"   minOccurs=\"0\" maxOccurs = \"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tService\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"port\" type = \"wsdl:tPort\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPort\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"binding\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><attribute name=\"arrayType\" type=\"string\"/><attribute name=\"required\" type = \"boolean\"/><complexType name=\"tExtensibilityElement\" abstract = \"true\"><sequence/><attribute ref=\"wsdl:required\" use=\"optional\"/></complexType></schema>", type, ns));
            return;
        }
        if (url == null) {
            return;
        }
        InputStream is = null;
        is = Document.getHostServices().getInputStream(url);
        try {
            XSDSourceBuilder.buildRecursively(ns, url, is, type, list, urls, parentTNS, redefPath);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void buildRecursively(String ns, String url, InputStream is, int type, Vector list, HashSet urls, String parentTNS, String redefPath) throws IOException, WMDocumentException, Exception {
        if (ns != null && "http://schemas.xmlsoap.org/soap/encoding/".equals(ns)) {
            list.addElement(XSDSource.create(ns, "<?xml version='1.0'?><!-- XML Schema for SOAP v 1.1 Encoding --><schema xmlns='http://www.w3.org/1999/XMLSchema'        xmlns:wmns1='http://schemas.xmlsoap.org/soap/encoding/'        targetNamespace='http://schemas.xmlsoap.org/soap/encoding/'> <attribute name='root' use='default' value='0'>    <simpleType base='boolean'>      <pattern value='0|1'/>    </simpleType> </attribute>  <attributeGroup name='commonAttributes'>    <attribute name='id' type='ID'/>    <attribute name='href' type='uriReference'/>    <anyAttribute namespace='##other'/>  </attributeGroup>  <simpleType name='arrayCoordinate' base='string'/>  <attribute name='arrayType' type='string'/>  <attribute name='offset' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayAttributes'>    <attribute ref='wmns1:arrayType' use='required'/>    <attribute ref='wmns1:offset'/>  </attributeGroup>  <attribute name='position' type='wmns1:arrayCoordinate'/>  <attributeGroup name='arrayMemberAttributes'>    <attribute ref='wmns1:position'/>  </attributeGroup>  <element name='Array' type='wmns1:Array'/>  <group name='Array'>    <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Array' content='elementOnly'>    <group ref='wmns1:Array' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:arrayAttributes'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>   <element name='Struct' type='wmns1:Struct'/>  <group name='Struct'>      <any minOccurs='0' maxOccurs='*'/>  </group>  <complexType name='Struct'>    <group ref='wmns1:Struct' minOccurs='0' maxOccurs='1'/>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <simpleType name='base64' base='binary'>    <encoding value='base64'/>  </simpleType>  <element name='string' type='wmns1:string'/>  <complexType name='string' base='string' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='boolean' type='wmns1:boolean'/>  <complexType name='boolean' base='boolean' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='float' type='wmns1:float'/>  <complexType name='float' base='float' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='double' type='wmns1:double'/>  <complexType name='double' base='double' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='decimal' type='wmns1:decimal'/>  <complexType name='decimal' base='decimal' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeDuration' type='wmns1:timeDuration'/>  <complexType name='timeDuration' base='timeDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDuration' type='wmns1:recurringDuration'/>  <complexType name='recurringDuration' base='recurringDuration' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='binary' type='wmns1:binary'/>  <complexType name='binary' base='binary' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='uriReference' type='wmns1:uriReference'/>  <complexType name='uriReference' base='uriReference' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ID' type='wmns1:ID'/>  <complexType name='ID' base='ID' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREF' type='wmns1:IDREF'/>  <complexType name='IDREF' base='IDREF' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITY' type='wmns1:ENTITY'/>  <complexType name='ENTITY' base='ENTITY' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NOTATION' type='wmns1:NOTATION'/>  <complexType name='NOTATION' base='NOTATION' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='QName' type='wmns1:QName'/>  <complexType name='QName' base='QName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='language' type='wmns1:language'/>  <complexType name='language' base='language' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='IDREFS' type='wmns1:IDREFS'/>  <complexType name='IDREFS' base='IDREFS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ENTITIES' type='wmns1:ENTITIES'/>  <complexType name='ENTITIES' base='ENTITIES' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKEN' type='wmns1:NMTOKEN'/>  <complexType name='NMTOKEN' base='NMTOKEN' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NMTOKENS' type='wmns1:NMTOKENS'/>  <complexType name='NMTOKENS' base='NMTOKENS' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='Name' type='wmns1:Name'/>  <complexType name='Name' base='Name' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='NCName' type='wmns1:NCName'/>  <complexType name='NCName' base='NCName' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='integer' type='wmns1:integer'/>  <complexType name='integer' base='integer' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonPositiveInteger' type='wmns1:nonPositiveInteger'/>  <complexType name='nonPositiveInteger' base='nonPositiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='negativeInteger' type='wmns1:negativeInteger'/>  <complexType name='negativeInteger' base='negativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='long' type='wmns1:long'/>  <complexType name='long' base='long' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='int' type='wmns1:int'/>  <complexType name='int' base='int' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='short' type='wmns1:short'/>  <complexType name='short' base='short' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='byte' type='wmns1:byte'/>  <complexType name='byte' base='byte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='nonNegativeInteger' type='wmns1:nonNegativeInteger'/>  <complexType name='nonNegativeInteger' base='nonNegativeInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedLong' type='wmns1:unsignedLong'/>  <complexType name='unsignedLong' base='unsignedLong' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedInt' type='wmns1:unsignedInt'/>  <complexType name='unsignedInt' base='unsignedInt' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedShort' type='wmns1:unsignedShort'/>  <complexType name='unsignedShort' base='unsignedShort' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='unsignedByte' type='wmns1:unsignedByte'/>  <complexType name='unsignedByte' base='unsignedByte' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='positiveInteger' type='wmns1:positiveInteger'/>  <complexType name='positiveInteger' base='positiveInteger' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timeInstant' type='wmns1:timeInstant'/>  <complexType name='timeInstant' base='timeInstant' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='time' type='wmns1:time'/>  <complexType name='time' base='time' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='timePeriod' type='wmns1:timePeriod'/>  <complexType name='timePeriod' base='timePeriod' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='date' type='wmns1:date'/>  <complexType name='date' base='date' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='month' type='wmns1:month'/>  <complexType name='month' base='month' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='year' type='wmns1:year'/>  <complexType name='year' base='year' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='century' type='wmns1:century'/>  <complexType name='century' base='century' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDate' type='wmns1:recurringDate'/>  <complexType name='recurringDate' base='recurringDate' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='recurringDay' type='wmns1:recurringDay'/>  <complexType name='recurringDay' base='recurringDay' content='textOnly'>    <attributeGroup ref='wmns1:commonAttributes'/>  </complexType>  <element name='ur-type'/>  <complexType name='ur-type'/></schema>", type, ns));
            return;
        }
        if (ns != null && WSDL_11_SCHEMA.equals(ns)) {
            list.addElement(XSDSource.create(ns, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><schema xmlns=\"http://www.w3.org/2001/XMLSchema\"xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"targetNamespace=\"http://schemas.xmlsoap.org/wsdl/\"elementFormDefault=\"qualified\"><complexType mixed = \"true\" name = \"tDocumentation\"><sequence><any minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/></sequence></complexType><complexType name = \"tDocumented\"><annotation><documentation>This type is extended by  component types to allow them to be documented </documentation></annotation><sequence><element name = \"documentation\" type = \"wsdl:tDocumentation\" minOccurs=\"0\"/></sequence></complexType><complexType name=\"tExtensibleAttributesDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component types to allow attributes from other namespaces to be added.</documentation></annotation><anyAttribute namespace=\"##other\"/></extension></complexContent></complexType><complexType name=\"tExtensibleDocumented\" abstract=\"true\"><complexContent><extension base = \"wsdl:tDocumented\"><annotation><documentation>This type is extended by  component typesto allow attributes from other namespaces to be added.</documentation></annotation><sequence><any namespace=\"##other\" minOccurs = \"0\" maxOccurs = \"unbounded\"/></sequence></extension></complexContent></complexType><element name=\"definitions\" type=\"wsdl:tDefinitions\"><key name=\"message\"><selector xpath=\"wsdl:message\"/><field xpath=\"@name\"/></key><key name=\"portType\"><selector xpath=\"wsdl:portType\"/><field xpath=\"@name\"/></key><key name=\"binding\"><selector xpath=\"wsdl:binding\"/><field xpath=\"@name\"/></key><key name=\"service\"><selector xpath=\"wsdl:service\"/><field xpath=\"@name\"/></key><key name=\"import\"><selector xpath=\"wsdl:import\"/><field xpath=\"@namespace\"/></key><key name=\"port\"><selector xpath=\"wsdl:service/wsdl:port\"/><field xpath=\"@name\"/></key></element><group name = \"anyTopLevelOptionalElement\"><annotation><documentation>Any top level optional element allowed to appear more then once- any child of definitions element except wsdl:types. Any extensibility element is allowed in any place </documentation></annotation><choice><element name = \"import\"   type = \"wsdl:tImport\"/><element name = \"types\"    type = \"wsdl:tTypes\"/><element name = \"message\"  type = \"wsdl:tMessage\"><unique name=\"part\"><selector xpath=\"wsdl:part\"/><field xpath=\"@name\"/></unique></element><element name = \"portType\" type = \"wsdl:tPortType\" /><element name = \"binding\"  type = \"wsdl:tBinding\"/><element name = \"service\"  type = \"wsdl:tService\"/></choice></group><complexType name = \"tDefinitions\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><group ref = \"wsdl:anyTopLevelOptionalElement\"  minOccurs=\"0\"   maxOccurs = \"unbounded\"/></sequence><attribute name=\"targetNamespace\" type=\"anyURI\" use=\"optional\"/><attribute name=\"name\"            type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tImport\"><complexContent><extension base = \"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"namespace\" type=\"anyURI\" use=\"required\"/><attribute name=\"location\" type=\"anyURI\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tTypes\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"/></complexContent></complexType><complexType name=\"tMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"part\" type = \"wsdl:tPart\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPart\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"element\" type=\"QName\" use=\"optional\"/><attribute name=\"type\" type=\"QName\" use=\"optional\"/></extension></complexContent></complexType><complexType name=\"tPortType\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><sequence><element name = \"operation\" type = \"wsdl:tOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><choice><group ref=\"wsdl:request-response-one-way-operation\"/><group ref=\"wsdl:solicit-response-notification-operation\"/></choice><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"parameterOrder\" type=\"NMTOKENS\" use=\"optional\"/></extension></complexContent></complexType><group name = \"optional-response-fault\"><choice><sequence/><sequence><element name = \"output\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"request-response-one-way-operation\"><sequence><element name = \"input\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-response-fault\"/></sequence></group><group name = \"optional-solicit-fault\"><choice><sequence/><sequence><element name = \"input\" type = \"wsdl:tParam\"/><element name = \"fault\"  type = \"wsdl:tFault\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence></choice></group><group name=\"solicit-response-notification-operation\"><sequence><element name = \"output\" type = \"wsdl:tParam\"/><group   ref = \"wsdl:optional-solicit-fault\"/></sequence></group><complexType name=\"tParam\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tFault\"><complexContent><extension base=\"wsdl:tExtensibleAttributesDocumented\"><attribute name=\"name\" type=\"NCName\"  use=\"required\"/><attribute name=\"message\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBinding\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"operation\" type=\"wsdl:tBindingOperation\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"type\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationMessage\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"optional\"/></extension></complexContent></complexType><complexType name = \"tBindingOperationFault\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tBindingOperation\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name=\"input\"  type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"output\" type=\"wsdl:tBindingOperationMessage\" minOccurs=\"0\"/><element name=\"fault\"  type=\"wsdl:tBindingOperationFault\"   minOccurs=\"0\" maxOccurs = \"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tService\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><sequence><element name = \"port\" type = \"wsdl:tPort\" minOccurs=\"0\" maxOccurs=\"unbounded\"/></sequence><attribute name=\"name\" type=\"NCName\" use=\"required\"/></extension></complexContent></complexType><complexType name=\"tPort\"><complexContent><extension base=\"wsdl:tExtensibleDocumented\"><attribute name=\"name\" type=\"NCName\" use=\"required\"/><attribute name=\"binding\" type=\"QName\" use=\"required\"/></extension></complexContent></complexType><attribute name=\"arrayType\" type=\"string\"/><attribute name=\"required\" type = \"boolean\"/><complexType name=\"tExtensibilityElement\" abstract = \"true\"><sequence/><attribute ref=\"wsdl:required\" use=\"optional\"/></complexType></schema>", type, ns));
            return;
        }
        if (url == null || is == null) {
            return;
        }
        Document doc = null;
        String chameleonNS = null;
        StringBuffer sb = new StringBuffer();
        boolean containsRedefines = false;
        try {
            doc = new Document(is, url, null, true, true);
            doc.completeLoad();
        }
        catch (FileNotFoundException e) {
            throw new LocalizedException(XSDExceptionBundle.class, XSDExceptionBundle.FILE_NOT_FOUND, "", url);
        }
        ElementNode eNode = (ElementNode)doc.getFirstElement();
        if (eNode == null) {
            Object[] subs = new Object[]{url};
            throw new LocalizedException(XSDExceptionBundle.class, XSDExceptionBundle.UNABLE_TO_PARSE, "", subs);
        }
        QName name = QName.create(eNode.getNamespaceUri(), eNode.getLocalNameWm());
        if (XSDSourceBuilder.isSchema(name)) {
            String targetNS = eNode.getAttributeValue(null, TARGET_NAMESPACE);
            if (type == 2 || type == 4) {
                if (targetNS == null && parentTNS != null) {
                    chameleonNS = targetNS = parentTNS;
                } else if (targetNS != null && (parentTNS == null || parentTNS != null && !targetNS.equals(parentTNS))) {
                    throw new LocalizedException(XSDExceptionBundle.class, XSDExceptionBundle.MISMATCHED_INCLUDE, "", url);
                }
            }
            if (type == 3) {
                if (parentTNS == null && targetNS == null || parentTNS != null && targetNS != null && parentTNS.equals(targetNS)) {
                    throw new LocalizedException(XSDExceptionBundle.class, XSDExceptionBundle.IDENTICAL_IMPORT, "", url);
                }
                if (ns != null && !ns.equals(targetNS)) {
                    throw new LocalizedException(XSDExceptionBundle.class, XSDExceptionBundle.MISMATCHED_IMPORT, "", url);
                }
            }
            String usage = XSDSource.useName(url, targetNS);
            if (redefPath != null) {
                usage = XSDSource.redefPathName(redefPath, usage);
            }
            if (urls.contains(usage)) {
                return;
            }
            urls.add(usage);
            doc.appendGeneratedMarkup(sb);
            XSDSource curSource = XSDSource.create(ns, sb.toString(), type, url, chameleonNS, usage, redefPath);
            list.addElement(curSource);
            Node node = eNode;
            for (node = node.getFirstChildWm(); node != null; node = node.getNextSiblingWm()) {
                if (node.getNodeType() != 1) continue;
                eNode = (ElementNode)node;
                name = QName.create(eNode.getNamespaceUri(), eNode.getLocalNameWm());
                if (XSDSourceBuilder.isInclude(name)) {
                    XSDSourceBuilder.buildRecursively(null, URIParser.abs2(url, eNode.getAttributeValue(null, SCHEMALOCATION)), 2, list, urls, targetNS, null);
                    continue;
                }
                if (XSDSourceBuilder.isRedefine(name)) {
                    curSource.containsRedefine(true);
                    String schemaLoc = eNode.getAttributeValue(null, SCHEMALOCATION);
                    XSDSourceBuilder.buildRecursively(null, URIParser.abs2(url, schemaLoc), 4, list, urls, targetNS, XSDSource.redefSubpathName(usage, schemaLoc));
                    continue;
                }
                if (!XSDSourceBuilder.isImport(name)) continue;
                String namespace = eNode.getAttributeValue(null, NAMESPACE);
                String myUrl = URIParser.abs2(url, eNode.getAttributeValue(null, SCHEMALOCATION));
                if (myUrl == null) {
                    try {
                        InputStream tempIs = null;
                        try {
                            QName tn;
                            tempIs = Document.getHostServices().getInputStream(namespace);
                            doc = new Document(tempIs, myUrl, null, true, true);
                            doc.completeLoad();
                            ElementNode n = (ElementNode)doc.getFirstElement();
                            if (n != null && XSDSourceBuilder.isSchema(tn = QName.create(((Node)n).getNamespaceUri().toString(), ((Node)n).getLocalName()))) {
                                myUrl = namespace;
                            }
                        }
                        catch (Exception e) {
                        }
                        finally {
                            if (tempIs != null) {
                                tempIs.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                XSDSourceBuilder.buildRecursively(namespace, myUrl, 3, list, urls, targetNS, null);
            }
            if (is != null) {
                is.close();
            }
        } else {
            throw new LocalizedException(XSDExceptionBundle.class, XSDExceptionBundle.NOT_A_VALID_SCHEMA, "", new Object[]{url});
        }
    }

    private static boolean isSchema(QName name) {
        return SCHEMA_2001.equals(name) || SCHEMA_10_2000.equals(name) || SCHEMA_08_2000.equals(name) || SCHEMA.equals(name);
    }

    private static boolean isInclude(QName name) {
        return INCLUDE_2001.equals(name) || INCLUDE_10_2000.equals(name) || INCLUDE_08_2000.equals(name) || INCLUDE.equals(name);
    }

    private static boolean isImport(QName name) {
        return IMPORT_2001.equals(name) || IMPORT_10_2000.equals(name) || IMPORT_08_2000.equals(name) || IMPORT.equals(name);
    }

    private static boolean isRedefine(QName name) {
        return SCHEMA_CR_REDEFINE.equals(name) || SCHEMA_10_REDEFINE.equals(name);
    }

    public static void main(String[] args) {
        IData[] xsdArray;
        if (args.length != 1) {
            System.out.println("Usage: javac com.wm.lang.schema.xsd.XSDSourceBuilder <filename>");
            return;
        }
        try {
            xsdArray = XSDSourceBuilder.build(args[0]);
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
            return;
        }
        for (int i = 0; i < xsdArray.length; ++i) {
            System.out.println(xsdArray[i]);
        }
    }
}

