/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd;

import com.wm.data.FixedData;
import com.wm.data.MInteger;

public class XSDSource
extends FixedData {
    private int NAMESPACE = this.nextID();
    private int SOURCE = this.nextID();
    private int TYPE = this.nextID();
    private int URL = this.nextID();
    private int CHAMELEON = this.nextID();
    private int USAGE = this.nextID();
    private int REDEFPATH = this.nextID();
    private int CONTAINSREDEFINE = this.nextID();
    public static final int TYPE_GIVEN = 1;
    public static final int TYPE_INCLUDE = 2;
    public static final int TYPE_IMPORT = 3;
    public static final int TYPE_REDEFINE = 4;
    public static final int TYPE_UNKNOWN = 20;

    public static XSDSource create() {
        return new XSDSource();
    }

    private static Object[][] getSchema() {
        return new Object[][]{{"namespace", null}, {"source", null}, {"type", null}, {"url", null}, {"chameleon", null}, {"usage", null}, {"redefpath", null}, {"containsredefine", null}};
    }

    public XSDSource() {
        super(XSDSource.getSchema());
    }

    private XSDSource(String namespace, String source, int type, String url, String chameleon, String usage, String redefPath) {
        this();
        this.setNamespace(namespace);
        this.setSource(source);
        this.setType(type);
        this.setURL(url);
        this.setChameleonNS(chameleon);
        this.setUsage(usage);
        this.setRedefPath(redefPath);
        this.setContainsRedefine("false");
    }

    public static XSDSource create(String namespace, String source, int type, String url, String chameleon, String usage, String redefPath) {
        return new XSDSource(namespace, source, type, url, chameleon, usage, redefPath);
    }

    public static XSDSource create(String namespace, String source, int type, String url, String chameleon) {
        return new XSDSource(namespace, source, type, url, chameleon, null, null);
    }

    public static XSDSource create(String namespace, String source, int type, String url) {
        return new XSDSource(namespace, source, type, url, null, null, null);
    }

    public static XSDSource create(String source, int type, String url) {
        return new XSDSource(null, source, type, url, null, null, null);
    }

    public static XSDSource create(String source, int type, String url, String chameleon) {
        return new XSDSource(null, source, type, url, chameleon, null, null);
    }

    public String getNamespace() {
        return (String)this.get(this.NAMESPACE);
    }

    public String getSource() {
        return (String)this.get(this.SOURCE);
    }

    public int getType() {
        MInteger i = (MInteger)this.get(this.TYPE);
        if (i != null) {
            return i.intValue();
        }
        return 20;
    }

    public String getChameleonNS() {
        return (String)this.get(this.CHAMELEON);
    }

    public String getURL() {
        return (String)this.get(this.URL);
    }

    public String getUsage() {
        return (String)this.get(this.USAGE);
    }

    public String getRedefPath() {
        return (String)this.get(this.REDEFPATH);
    }

    public String getContainsRedefine() {
        return (String)this.get(this.CONTAINSREDEFINE);
    }

    public boolean containsRedefine() {
        return Boolean.valueOf((String)this.get(this.CONTAINSREDEFINE));
    }

    public boolean isRedefineTarget() {
        return this.get(this.REDEFPATH) != null;
    }

    public void setNamespace(String namespace) {
        this.set(this.NAMESPACE, (Object)namespace);
    }

    public void setSource(String source) {
        this.set(this.SOURCE, (Object)source);
    }

    public void setType(int type) {
        this.set(this.TYPE, (Object)new MInteger(type));
    }

    public void setURL(String url) {
        this.set(this.URL, (Object)url);
    }

    public void setChameleonNS(String chameleon) {
        this.set(this.CHAMELEON, (Object)chameleon);
    }

    public void setUsage(String usage) {
        this.set(this.USAGE, (Object)usage);
    }

    public void setRedefPath(String redefPath) {
        this.set(this.REDEFPATH, (Object)redefPath);
    }

    public void setContainsRedefine(String flag) {
        this.set(this.CONTAINSREDEFINE, (Object)flag);
    }

    public void containsRedefine(boolean flag) {
        this.setContainsRedefine(String.valueOf(flag));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHeader() + "\n\n");
        sb.append(this.getSource());
        sb.append("\n\n");
        return sb.toString();
    }

    private String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ----- ");
        switch (this.getType()) {
            case 1: {
                sb.append("GIVEN");
                break;
            }
            case 2: {
                sb.append("INCLUDE");
                break;
            }
            case 3: {
                sb.append("IMPORT namespace=");
                sb.append(this.getNamespace());
            }
            case 4: {
                sb.append("RENAME namespace=");
                sb.append(this.getNamespace());
            }
        }
        sb.append(" -----");
        sb.append("url = " + this.getURL());
        return sb.toString();
    }

    public boolean equals(Object lhs) {
        if (lhs != null && lhs instanceof XSDSource) {
            XSDSource anotherSource = (XSDSource)lhs;
            return this.getSource().equals(anotherSource.getSource());
        }
        return super.equals(lhs);
    }

    public static String useName(String fileURL, String targetNamespace) {
        if (targetNamespace == null) {
            return fileURL;
        }
        return fileURL + "--" + targetNamespace;
    }

    public static String redefPathName(String redefPath, String usagePath) {
        if (redefPath == null) {
            return usagePath;
        }
        return redefPath + "!!" + usagePath;
    }

    public static String redefSubpathName(String usage, String schemaLocation) {
        return usage + "[" + schemaLocation + "]";
    }

    public static String redefTypeName(String path, String type) {
        return path + "**" + type;
    }
}

