/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd;

import com.wm.data.IData;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.NodeValidator;
import com.wm.lang.schema.xsd.AttributeGroup;
import com.wm.lang.schema.xsd.Expressions;
import com.wm.lang.schema.xsd.SchemaInfoset;
import com.wm.lang.schema.xsd.XSDSource;
import com.wm.lang.schema.xsd.XSDSourceBuilder;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Name;
import com.wm.util.Values;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class XSDCompiler {
    static final boolean debug = false;
    public static final String WEBM_DEFAULT_NAMESPACE_DEFAULT = "http://www.webMethods.com/noNamespace/";
    public static final String WATT_DEFAULT_NAMESPACE = "watt.server.ws.defaultNamespace";
    public static final String WEBM_DEFAULT_NAMESPACE_STRING = System.getProperty("watt.server.ws.defaultNamespace", "http://www.webMethods.com/noNamespace/");
    public static final Name WEBM_DEFAULT_NAMESPACE = Name.create(WEBM_DEFAULT_NAMESPACE_STRING);
    static final NSName SCHEMA_FOR_SCHEMAS = NSName.create("pub.schema.w3c:structures");
    public static final Expressions SLAVE = Expressions.create();
    private static final String SYS_VALIDATE_INCOMING_XSD = "watt.core.schema.validateIncomingXSD";
    private static boolean _validateIncomingXSD = true;
    private static boolean _readSystemProperties;
    private static String INVALID_SCHEMA;

    public static final NSSchema[] compileIntoTransientSchemas(Namespace ns, String url, boolean verbose) throws WMDocumentException, IOException, Exception {
        Values result = XSDCompiler.compile(ns, null, null, (XSDSource[])XSDSourceBuilder.build(url), true, verbose, true);
        boolean successful = result.getBoolean("isSuccessful");
        if (successful) {
            return (NSSchema[])result.get("schemaArray");
        }
        throw new Exception(XSDCompiler.format(result));
    }

    public static final NSSchema[] compileIntoTransientSchemas(Namespace ns, String url) throws WMDocumentException, IOException, Exception {
        return XSDCompiler.compileIntoTransientSchemas(ns, url, false);
    }

    public static final Values compileIntoTransientSchemas2(Namespace ns, String url) throws WMDocumentException, IOException, Exception {
        Values result = XSDCompiler.compile(ns, null, null, (XSDSource[])XSDSourceBuilder.build(url), true, false, true);
        boolean successful = result.getBoolean("isSuccessful");
        if (successful) {
            result.put("schemas", result.get("schemaArray"));
        }
        result.remove("schemaArray");
        return result;
    }

    static final String format(Values values) {
        Values[] warnings;
        String key;
        Enumeration keys;
        boolean result;
        StringBuffer sb = new StringBuffer();
        String message = values.getString("message");
        if (message != null) {
            sb.append(values.getString("message"));
            sb.append('\n');
        }
        if (result = values.containsKey("isValid") ? values.getBoolean("isValid") : values.getBoolean("isSuccessful")) {
            sb.append("SUCCESSFUL ------- \n");
        } else {
            sb.append("FAILED --------- \n");
        }
        Values[] errors = values.getValuesArray("errors");
        if (errors != null) {
            for (int i = 0; i < errors.length; ++i) {
                sb.append("-----    ERROR[" + i + "]    -----\n");
                Values error = errors[i];
                keys = error.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    sb.append("\t" + key + ": " + error.get(key) + '\n');
                }
                sb.append("\n\n");
            }
        }
        if ((warnings = values.getValuesArray("warnings")) != null) {
            for (int i = 0; i < warnings.length; ++i) {
                sb.append("-----    WARNINGS [" + i + "]    -----\n");
                Values warning = warnings[i];
                keys = warning.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    sb.append("\t" + key + ": " + warning.get(key) + '\n');
                }
                sb.append("\n\n");
            }
        }
        return sb.toString();
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, IData[] xsdArray, boolean isTransient, boolean verbose, Locale locale) throws WMDocumentException, IOException {
        return XSDCompiler.compile(ns, pkg, name, xsdArray, isTransient, verbose, false, locale);
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, IData[] xsdArray, boolean isTransient, boolean verbose, boolean returnSchemas, Locale locale) throws WMDocumentException, IOException {
        XSDSource[] xsd = new XSDSource[xsdArray.length];
        for (int i = 0; i < xsdArray.length; ++i) {
            xsd[i] = new XSDSource();
            IDataUtil.copy(xsdArray[i], xsd[i]);
        }
        return XSDCompiler.compile(ns, pkg, name, xsd, isTransient, verbose, returnSchemas, locale);
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, XSDSource[] xsdArray, boolean isTransient, boolean verbose, boolean returnSchemas) throws WMDocumentException, IOException {
        return XSDCompiler.compile(ns, pkg, name, xsdArray, isTransient, verbose, returnSchemas, Locale.getDefault());
    }

    public static final Values compile(Namespace ns, NSPackage pkg, NSName name, XSDSource[] xsdArray, boolean isTransient, boolean verbose, boolean returnSchemas, Locale locale) throws WMDocumentException, IOException {
        Values result;
        XSDWorkspace workspace = new XSDWorkspace();
        workspace.ns = ns;
        workspace.pkg = pkg;
        workspace.b2bQName = name;
        workspace.createTransientSchemas = isTransient;
        workspace.verbose = verbose;
        workspace.returnSchemas = returnSchemas;
        workspace.locale = locale;
        SchemaInfoset[] siss = XSDCompiler.generateSISs(xsdArray);
        workspace.siss = siss;
        boolean successful = XSDCompiler.runRedefinePass(siss, workspace);
        successful = XSDCompiler.runRenamePass(siss, workspace);
        if (XSDCompiler.validateIncomingXSD() && (result = XSDCompiler.validate(siss, ns, verbose)) != null) {
            result.put("isSuccessful", new Boolean(false));
            return result;
        }
        successful = XSDCompiler.runFirstPass(siss, workspace);
        successful = XSDCompiler.runSecondPass(siss, workspace);
        successful = XSDCompiler.runThirdPass(siss, workspace);
        workspace.createSchemaArray();
        if (!workspace.createTransientSchemas && successful) {
            XSDCompiler.formalize(workspace);
        }
        Values results = workspace.packageResults();
        return results;
    }

    static final SchemaInfoset[] generateSISs(XSDSource[] xsdArray) throws WMDocumentException, IOException {
        SchemaInfoset[] siss = new SchemaInfoset[xsdArray.length];
        for (int i = 0; i < siss.length; ++i) {
            siss[i] = new SchemaInfoset(xsdArray[i]);
        }
        return siss;
    }

    static final Values validate(SchemaInfoset[] siss, Namespace ns, boolean verbose) throws WMDocumentException {
        NSNode node = ns.getNode(SCHEMA_FOR_SCHEMAS);
        if (node != null && node.getNodeTypeObj().equals(NSSchema.TYPE)) {
            boolean valid = true;
            for (int i = 0; i < siss.length; ++i) {
                NodeValidator validator = new NodeValidator(siss[i].getSchema());
                validator.setVerbose(verbose);
                validator.setMaximumErrors(-1);
                validator.setNamespace(ns);
                Values result = (Values)validator.validate();
                if (result.getBoolean("isValid")) continue;
                result.put("url", siss[i].getSource().getURL());
                result.put("message", INVALID_SCHEMA);
                return result;
            }
            return null;
        }
        return null;
    }

    static final boolean runFirstPass(SchemaInfoset[] siss, XSDWorkspace workspace) throws WMDocumentException {
        for (int i = 0; i < siss.length; ++i) {
            String tns = siss[i].getTargetNamespace();
            if (tns != null && tns.equals(WEBM_DEFAULT_NAMESPACE.toString())) {
                siss[i].setTargetNamespace(null);
            }
            workspace.pushCurrent(siss[i]);
            SLAVE.symbolize(siss[i].getSchema(), workspace, null);
            workspace.popCurrent();
        }
        return workspace.getErrors() == null;
    }

    static final boolean runSecondPass(SchemaInfoset[] siss, XSDWorkspace workspace) throws WMDocumentException {
        for (int i = 0; i < siss.length; ++i) {
            workspace.pushCurrent(siss[i]);
            String tns = siss[i].getTargetNamespace();
            if (tns != null && tns.equals(WEBM_DEFAULT_NAMESPACE.toString())) {
                siss[i].setTargetNamespace(null);
                tns = null;
            }
            workspace.setupSchema(tns);
            SLAVE.prepare(siss[i].getSchema(), workspace, null, null);
            workspace.popCurrent();
        }
        Hashtable attrGroups = workspace.attrGroups;
        Enumeration groups = attrGroups.elements();
        while (groups.hasMoreElements()) {
            ((AttributeGroup)groups.nextElement()).resolveReferences();
        }
        return workspace.getErrors() == null;
    }

    static final boolean runThirdPass(SchemaInfoset[] siss, XSDWorkspace workspace) throws WMDocumentException {
        for (int i = 0; i < siss.length; ++i) {
            workspace.pushCurrent(siss[i]);
            String tns = siss[i].getTargetNamespace();
            if (tns != null && tns.equals(WEBM_DEFAULT_NAMESPACE.toString())) {
                siss[i].setTargetNamespace(null);
                tns = null;
            }
            workspace.setupSchema(tns);
            SLAVE.translate(siss[i].getSchema(), workspace, null, null);
            workspace.registerNSDecl(tns, siss[i].getSchema());
            workspace.popCurrent();
        }
        return workspace.getErrors() == null;
    }

    static final boolean runRedefinePass(SchemaInfoset[] siss, XSDWorkspace workspace) throws WMDocumentException {
        for (int i = 0; i < siss.length; ++i) {
            workspace.pushCurrent(siss[i]);
            if (!siss[i].containsRedefine()) continue;
            String tns = siss[i].getTargetNamespace();
            if (tns != null && tns.equals(WEBM_DEFAULT_NAMESPACE.toString())) {
                siss[i].setTargetNamespace(null);
                tns = null;
            }
            SLAVE.redefine(siss[i].getSchema(), workspace, null);
            workspace.popCurrent();
        }
        return workspace.getErrors() == null;
    }

    static final boolean runRenamePass(SchemaInfoset[] siss, XSDWorkspace workspace) throws WMDocumentException {
        ArrayList<SchemaInfoset> list = new ArrayList<SchemaInfoset>();
        workspace.setRenameFileList(list);
        HashMap<String, Integer> fileIndex = new HashMap<String, Integer>();
        workspace.setFileIndex(fileIndex);
        for (int i = 0; i < siss.length; ++i) {
            SchemaInfoset sis = siss[i];
            fileIndex.put(sis.getSource().getUsage(), new Integer(i));
            if (!siss[i].isRedefineTarget() || sis.containsRedefine()) continue;
            sis.markProcessed();
            list.add(sis);
        }
        while (list.size() > 0) {
            SchemaInfoset cur = list.remove(0);
            if (!cur.isRedefineTarget()) continue;
            workspace.pushCurrent(cur);
            String tns = cur.getTargetNamespace();
            if (tns != null && tns.equals(WEBM_DEFAULT_NAMESPACE.toString())) {
                cur.setTargetNamespace(null);
                tns = null;
            }
            SLAVE.rename(cur.getSchema(), workspace, null);
            workspace.popCurrent();
        }
        return workspace.getErrors() == null;
    }

    static final void formalize(XSDWorkspace workspace) {
        workspace.cleanupURISchemaPairs();
        Enumeration schemas = workspace.uriSchemaPairs.elements();
        Namespace ns = workspace.ns;
        while (schemas.hasMoreElements()) {
            NSSchema aSchema = (NSSchema)schemas.nextElement();
            try {
                boolean successful = ns.registerSchema(aSchema);
                if (successful) continue;
            }
            catch (NSException nse) {}
        }
    }

    private static final boolean validateIncomingXSD() {
        if (!_readSystemProperties) {
            if (System.getProperties().containsKey(SYS_VALIDATE_INCOMING_XSD)) {
                _validateIncomingXSD = new Boolean(System.getProperty(SYS_VALIDATE_INCOMING_XSD));
            }
            _readSystemProperties = true;
        }
        return _validateIncomingXSD;
    }

    static {
        INVALID_SCHEMA = "Schema definition is INVALID";
    }
}

