/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd;

import com.wm.lang.schema.Any;
import com.wm.lang.schema.AnyAttribute;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.xsd.BuiltIns;
import com.wm.lang.schema.xsd.Space;
import com.wm.lang.schema.xsd.Type;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.schema.xsd.XSDWorkspace;
import com.wm.lang.schema.xsd.resources.XSDCompilerMessageBundle;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Expression {
    private static final boolean debug = false;
    protected static final Name SCHEMA = Name.create("schema");
    protected static final Name TARGET_NAMESPACE = Name.create("targetNamespace");
    protected static final Name ATTRIBUTE_FORM_DEFAULT = Name.create("attributeFormDefault");
    protected static final Name ELEMENT_FORM_DEFAUL = Name.create("elementFormDefault");
    protected static final Name SCHEMA_LOCATION = Name.create("schemaLocation");
    protected static final Name REDEFINE = Name.create("redefine");
    protected static final Name NAME = Name.create("name");
    protected static final Name REF = Name.create("ref");
    protected static final Name BASE = Name.create("base");
    protected static final Name FORM = Name.create("form");
    protected static final Name TYPE = Name.create("type");
    protected static final Name USE = Name.create("use");
    protected static final Name VALUE = Name.create("value");
    protected static final Name ABSTRACT = Name.create("abstract");
    protected static final Name EQUIVCLASS = Name.create("equivClass");
    protected static final Name NULLABLE = Name.create("nullable");
    protected static final Name MAXOCCURS = Name.create("maxOccurs");
    protected static final Name MINOCCURS = Name.create("minOccurs");
    protected static final Name DEFAULT = Name.create("default");
    protected static final Name FIXED = Name.create("fixed");
    protected static final Name CONTENT = Name.create("content");
    protected static final Name DERIVED_BY = Name.create("derivedBy");
    protected static final Name UR_SIMPLE_TYPE = Name.create("urSimpleType");
    protected static final Name NAMESPACE = Name.create("namespace");
    protected static final Name PROCESS_CONTENTS = Name.create("processContents");
    protected static final QName UR_COMPLEX_TYPE = QName.create("http://www.w3.org/1999/XMLSchema", "ur-complex-type");
    protected static final Name STRING = Name.create("string");
    protected static final Name SUBSTITUTION_GROUP = Name.create("substitutionGroup");
    protected static final Name MIXED = Name.create("mixed");
    protected static final Name ITEM_TYPE = Name.create("itemType");
    protected static final Name MEMBER_TYPES = Name.create("memberTypes");
    protected static final Name ANY_TYPE = Name.create("anyType");
    protected static final HashSet ANY_SIMPLE_TYPE_NAMES = Expression.createAnySimpleTypeNames();
    public static final HashSet ANY_TYPE_NAMES = Expression.createAnyTypeNames();
    protected static final HashSet XSD_NS = Expression.createXSDNamespaces();
    protected static final Name NILLABLE = Name.create("nillable");
    protected static final Name NIL = Name.create("nil");
    private String _baseIdentifier;
    protected static final String SEPARATOR = "/";
    protected static final String OPEN = "[";
    protected static final String CLOSE = "]";
    protected static final String ATTR_PREFIX = "@";
    protected static final String LIST_SEPARATOR = " ";
    private static final int MIN_INDEX = 0;
    private static final int MAX_INDEX = 1;
    public static final QName ANY_ATTRIBUTE = QName.create(null, "$$ANY_ATTRIBUTE");

    private static final HashSet createAnySimpleTypeNames() {
        HashSet names = new HashSet(3);
        names.add(QName.create("http://www.w3.org/2000/08/XMLSchema", "anySimpleType"));
        names.add(QName.create("http://www.w3.org/2000/10/XMLSchema", "anySimpleType"));
        names.add(QName.create("http://www.w3.org/2001/XMLSchema", "anySimpleType"));
        return names;
    }

    private static final HashSet createAnyTypeNames() {
        HashSet names = new HashSet(3);
        names.add(QName.create("http://www.w3.org/2000/08/XMLSchema", "anyType"));
        names.add(QName.create("http://www.w3.org/2000/10/XMLSchema", "anyType"));
        names.add(QName.create("http://www.w3.org/2001/XMLSchema", "anyType"));
        return names;
    }

    private static final HashSet createXSDNamespaces() {
        HashSet ns = new HashSet(4);
        ns.add("http://www.w3.org/1999/XMLSchema");
        ns.add("http://www.w3.org/2000/08/XMLSchema");
        ns.add("http://www.w3.org/2000/10/XMLSchema");
        ns.add("http://www.w3.org/2001/XMLSchema");
        return ns;
    }

    public void redefine(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
    }

    public void rename(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
    }

    public void symbolize(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
    }

    public void prepare(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        for (Node unknown = node.getFirstChildWm(); unknown != null; unknown = unknown.getNextSiblingWm()) {
            if (unknown.getNodeType() != 1) continue;
            XSDCompiler.SLAVE.prepare((ElementNode)unknown, workspace, parentSpace, baseIdentifier != null ? baseIdentifier : XSDCompiler.SLAVE.createIdentifier((ElementNode)unknown));
        }
    }

    public void translate(ElementNode node, XSDWorkspace workspace, Space parentSpace, String baseIdentifier) throws WMDocumentException {
        for (Node unknown = node.getFirstChildWm(); unknown != null; unknown = unknown.getNextSiblingWm()) {
            if (unknown.getNodeType() != 1) continue;
            XSDCompiler.SLAVE.translate((ElementNode)unknown, workspace, parentSpace, baseIdentifier != null ? baseIdentifier : XSDCompiler.SLAVE.createIdentifier((ElementNode)unknown));
        }
    }

    protected QName computeQName(String ref, ElementNode node, XSDWorkspace workspace, String baseIdentifier, boolean collectURIReferencePrefixPairs) throws WMDocumentException {
        if (ref == null) {
            return null;
        }
        int colon = ref.indexOf(58);
        String prefix = null;
        String ncName = null;
        Name namespaceURI = null;
        if (colon > -1) {
            prefix = ref.substring(0, colon);
        }
        ncName = ref.substring(colon + 1, ref.length());
        if (prefix != null) {
            Name composedPrefix = Name.create(prefix);
            NamespaceDecl ns = node.lookUpInScopeNSDeclByPrefix(composedPrefix);
            if (ns != null) {
                namespaceURI = ns.getUri();
            }
            if (namespaceURI == null) {
                workspace.addError(baseIdentifier, this.getSource(node), "XSDC-009", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_UNABLE_TO_RESOLVE_QNAME, null));
            } else if (collectURIReferencePrefixPairs) {
                workspace.registerNSDecl(namespaceURI.toString(), prefix);
            }
        } else {
            NamespaceDecl ns = node.lookUpInScopeNSDeclByPrefix(null);
            namespaceURI = ns.getUri();
            if (namespaceURI != null) {
                if (namespaceURI != null && collectURIReferencePrefixPairs) {
                    workspace.registerNSDecl(namespaceURI.toString(), node);
                }
            } else {
                String chameleonNS = workspace.getCurrentChameleonNS();
                if (chameleonNS != null) {
                    if (collectURIReferencePrefixPairs) {
                        workspace.registerNSDecl(chameleonNS, node);
                    }
                    namespaceURI = Name.create(chameleonNS);
                }
            }
        }
        if (namespaceURI == QName.NO_NAMESPACE) {
            namespaceURI = null;
        }
        return QName.create(namespaceURI, Name.create(ncName));
    }

    protected QName computeQName(String ref, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        return this.computeQName(ref, node, workspace, baseIdentifier, true);
    }

    protected TypeDef createURTypeDefinition(ElementNode node) {
        Name nsuri = node.getNamespaceUri();
        return DatatypeFactory.createReference(nsuri, QName.create(nsuri, STRING));
    }

    protected void spitOut(ElementNode node, XSDWorkspace workspace) throws WMDocumentException {
        if (!workspace.verbose) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("-----   Processing   -----\n");
        node.appendGeneratedMarkup(sb);
        sb.append("\n-----   $$$$$$$$$$   -----\n");
        System.out.println(sb.toString());
    }

    protected void setBaseIdentifier(String baseIdentifier) {
        this._baseIdentifier = "/schema/" + baseIdentifier + OPEN;
    }

    protected String createIdentifier(ElementNode node) {
        return this._baseIdentifier + this.composeRelativeIdentifier(node) + CLOSE;
    }

    protected String composeRelativeIdentifier(ElementNode node) {
        return null;
    }

    protected String composeRelativeIdentifierUsingName(ElementNode node) {
        return "@name=\"" + node.getAttributeValue(null, NAME) + '\"';
    }

    protected String composeRelativeIdentifierUsingRef(ElementNode node) {
        return "@ref=\"" + node.getAttributeValue(null, REF) + '\"';
    }

    protected String getSource(ElementNode node) throws WMDocumentException {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("-----   Source   -----\n");
        node.appendGeneratedMarkup(sb);
        sb.append("\n");
        return sb.toString();
    }

    protected void captureAny(Any any, ElementNode node, XSDWorkspace workspace) throws WMDocumentException {
        String namespace = node.getAttributeValue(null, NAMESPACE);
        String processContents = node.getAttributeValue(null, PROCESS_CONTENTS);
        String targetNamespace = workspace.getCurrentTargetNamespace();
        if (targetNamespace == null) {
            targetNamespace = "$$unqualified";
        }
        Name uri = node.getNamespaceUri();
        String uriString = null;
        if (uri != null) {
            uriString = uri.toString();
        }
        int intProcessContents = 0;
        if (processContents != null) {
            if (processContents.equals("skip")) {
                intProcessContents = 1;
            } else if (processContents.equals("lax")) {
                intProcessContents = 2;
            }
            any.setProcessContents(intProcessContents);
        }
        if (namespace != null) {
            int qualifier = 0;
            HashSet uris = new HashSet();
            StringTokenizer tokenizer = new StringTokenizer(namespace, LIST_SEPARATOR);
            String[] tokens = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                tokens[i] = tokenizer.nextToken();
                ++i;
            }
            if (tokens.length == 1) {
                if (tokens[0].equals("##any")) {
                    qualifier = 0;
                } else if (tokens[0].equals("##other")) {
                    qualifier = 1;
                    uris.add(targetNamespace);
                    if (uriString != null && uriString.equals("http://www.w3.org/2001/XMLSchema")) {
                        uris.add("$$unqualified");
                    }
                } else if (tokens[0].equals("##targetNamespace")) {
                    qualifier = 2;
                    uris.add(targetNamespace);
                } else if (tokens[0].equals("##local")) {
                    qualifier = 2;
                    uris.add("$$unqualified");
                } else {
                    qualifier = 2;
                    uris.add(tokens[0]);
                }
            } else {
                qualifier = 2;
                for (i = 0; i < tokens.length; ++i) {
                    if (tokens[i].equals("##targetNamespace")) {
                        uris.add(targetNamespace);
                        continue;
                    }
                    if (tokens[i].equals("##local")) {
                        uris.add("$$unqualified");
                        continue;
                    }
                    uris.add(tokens[i]);
                }
            }
            any.setQualifier(qualifier);
            any.setURIs(uris);
        }
    }

    protected void applyOccurrence(Model model, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        int[] occurs = this.retrieveOccurrence(node, workspace, baseIdentifier);
        model.setOccurrence(occurs[0], occurs[1]);
    }

    private int[] retrieveOccurrence(ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        int[] occurs = new int[2];
        String minOccurs = node.getAttributeValue(null, MINOCCURS);
        String maxOccurs = node.getAttributeValue(null, MAXOCCURS);
        int min = 1;
        int max = 1;
        if (minOccurs != null) {
            try {
                min = Integer.parseInt(minOccurs);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        if (maxOccurs != null) {
            if (maxOccurs.equals("unbounded")) {
                max = -1;
            } else {
                try {
                    max = Integer.parseInt(maxOccurs);
                }
                catch (NumberFormatException ne) {
                    max = min;
                }
            }
        }
        occurs[0] = min;
        occurs[1] = max;
        if (max != -1 && max < min) {
            workspace.addError(baseIdentifier, this.getSource(node), "XSDC-012", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_INCORRECT_OCCURRENCE, null));
        }
        return occurs;
    }

    protected boolean retrieveMixed(ElementNode node) {
        String mixed = node.getAttributeValue(null, MIXED);
        return mixed != null && mixed.equals("true");
    }

    protected void check(QName name, int type, ElementNode node, XSDWorkspace workspace, String baseIdentifier) throws WMDocumentException {
        if (type == 1 && BuiltIns.current().containsKey(name)) {
            return;
        }
        Type typeDef = (Type)workspace.types.get(name);
        if (typeDef != null && (typeDef.getAbstractionType() == type || type == -1)) {
            return;
        }
        workspace.addError(baseIdentifier, this.getSource(node), "XSDC-003", new LocalizedMessage(XSDCompilerMessageBundle.class, XSDCompilerMessageBundle.MESSAGE_MISSING_DEFINITION, null));
    }

    protected static final void copy(Vector source, Vector destination) {
        if (source == null || destination == null) {
            return;
        }
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            destination.addElement(source.elementAt(i));
        }
    }

    protected static final void copy(HashSet source, HashSet destination) {
        if (source == null || destination == null) {
            return;
        }
        Object[] sArray = source.toArray();
        for (int i = 0; i < sArray.length; ++i) {
            destination.add(sArray[i]);
        }
    }

    protected static final boolean isProhibited(Model model) {
        int maxOccurs;
        if (model == null) {
            return false;
        }
        int minOccurs = model.getMinOccurs();
        return minOccurs == (maxOccurs = model.getMaxOccurs()) && minOccurs == 0;
    }

    protected int lookup(Vector container, QName key) {
        int index = -1;
        if (container == null) {
            return index;
        }
        int size = container.size();
        for (int i = 0; i < size; ++i) {
            Object item = container.elementAt(i);
            if (item instanceof AnyAttribute) {
                if (!key.equals(ANY_ATTRIBUTE)) continue;
                index = i;
                break;
            }
            if (!item.equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }
}

