/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.xsd;

import com.wm.data.IData;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.LocalizedMessage;
import com.wm.util.Showable;
import com.wm.util.Values;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class CompilerWorkspace {
    private static final boolean debug = false;
    NSName b2bQName;
    public Namespace ns;
    NSPackage pkg;
    boolean createTransientSchemas;
    boolean verbose;
    boolean returnSchemas;
    Locale locale;
    HashSet elementsToBeDefined = new HashSet(50);
    Hashtable uriSchemaPairs = new Hashtable(11);
    private Vector _errors = new Vector(10);
    private Vector _warnings = new Vector(10);
    Schema[] _schemaArray = null;
    static final String NULL_TARGETNS = "$$NULL";

    CompilerWorkspace() {
    }

    public void addError(String identifier, String errorCode, String errorMessage) {
        Values error = new Values(4);
        error.put("identifier", identifier);
        error.put("errorCode", errorCode);
        error.put("errorMessage", errorMessage);
        this._errors.addElement(error);
    }

    public void addError(String identifier, String source, String errorCode, String errorMessage) {
        Values error = new Values(4);
        error.put("identifier", identifier);
        error.put("source", source);
        error.put("errorCode", errorCode);
        error.put("errorMessage", errorMessage);
        this._errors.addElement(error);
    }

    public void addError(String identifier, String errorCode, LocalizedMessage errorMessage) {
        Values error = new Values(4);
        error.put("identifier", identifier);
        error.put("errorCode", errorCode);
        error.put("errorMessage", errorMessage.getLocalizedMessage(this.locale));
        this._errors.addElement(error);
    }

    public void addError(String identifier, String source, String errorCode, LocalizedMessage errorMessage) {
        Values error = new Values(4);
        error.put("identifier", identifier);
        error.put("source", source);
        error.put("errorCode", errorCode);
        error.put("errorMessage", errorMessage.getLocalizedMessage(this.locale));
        this._errors.addElement(error);
    }

    Values[] getErrors() {
        int size = this._errors.size();
        if (size > 0) {
            Object[] vArray = new Values[size];
            this._errors.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    void addWarning(String identifier, String warningCode, String warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("warningCode", warningCode);
        warning.put("warningMessage", warningMessage);
        this._warnings.addElement(warning);
    }

    public void addWarning(String identifier, String source, String warningCode, String warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("source", source);
        warning.put("warningCode", warningCode);
        warning.put("warningMessage", warningMessage);
        this._warnings.addElement(warning);
    }

    void addWarning(String identifier, String warningCode, LocalizedMessage warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("warningCode", warningCode);
        warning.put("warningMessage", warningMessage.getLocalizedMessage(this.locale));
        this._warnings.addElement(warning);
    }

    public void addWarning(String identifier, String source, String warningCode, LocalizedMessage warningMessage) {
        Values warning = new Values(4);
        warning.put("identifier", identifier);
        warning.put("source", source);
        warning.put("warningCode", warningCode);
        warning.put("warningMessage", warningMessage.getLocalizedMessage(this.locale));
        this._warnings.addElement(warning);
    }

    Values[] getWarnings() {
        int size = this._warnings.size();
        if (size > 0) {
            Object[] vArray = new Values[size];
            this._warnings.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    Values packageResults() {
        Values result = new Values(4);
        result.put("isSuccessful", new Boolean(this._errors.size() <= 0).toString());
        result.put("warnings", this.getWarnings());
        result.put("errors", this.getErrors());
        if (this.returnSchemas) {
            result.put("schemaArray", this.createSchemaArray());
        }
        return result;
    }

    void cleanupURISchemaPairs() {
        int size = this.uriSchemaPairs.size();
        if (size < 1) {
            return;
        }
        Enumeration enumvar = this.uriSchemaPairs.keys();
        Vector<String> tobeRemoved = new Vector<String>();
        while (enumvar.hasMoreElements()) {
            String targetNS = (String)enumvar.nextElement();
            Schema schema = (Schema)this.uriSchemaPairs.get(targetNS);
            if (!schema.isEmpty()) continue;
            tobeRemoved.addElement(targetNS);
        }
        size = tobeRemoved.size();
        for (int i = 0; i < size; ++i) {
            this.uriSchemaPairs.remove(tobeRemoved.elementAt(i));
        }
    }

    private Values[] createSchemaView() {
        Enumeration enumvar = this.uriSchemaPairs.elements();
        int size = this.uriSchemaPairs.size();
        if (size < 1) {
            return null;
        }
        Values[] valuesArray = new Values[size];
        int i = 0;
        while (enumvar.hasMoreElements()) {
            Schema schema = (Schema)enumvar.nextElement();
            valuesArray[i] = ((Showable)((Object)schema)).getView();
            ++i;
        }
        return valuesArray;
    }

    public Schema[] createSchemaArray() {
        if (this._schemaArray != null) {
            return this._schemaArray;
        }
        IData uriReferencePrefixPairs = this.createURIReferencePrefixPairs();
        Enumeration enumvar = this.uriSchemaPairs.elements();
        int size = this.uriSchemaPairs.size();
        if (size < 1) {
            return null;
        }
        NSSchema[] schemaArray = new NSSchema[size];
        int i = 0;
        while (enumvar.hasMoreElements()) {
            schemaArray[i] = (NSSchema)enumvar.nextElement();
            schemaArray[i++].setURIReferencePrefixPairs(uriReferencePrefixPairs);
        }
        this._schemaArray = schemaArray;
        return this._schemaArray;
    }

    protected IData createURIReferencePrefixPairs() {
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

