/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.util;

import com.wm.lang.schema.util.Iterator;
import com.wm.lang.schema.util.IteratorImpl;

public class HashSet {
    Object[] _objectArray;
    int _putIndex;

    public HashSet(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this._objectArray = new Object[capacity];
        this._putIndex = 0;
    }

    public HashSet() {
        this(1);
    }

    public synchronized void add(Object o) {
        if (this.contains(o)) {
            return;
        }
        if (this._putIndex >= this._objectArray.length) {
            Object[] oldArray = this._objectArray;
            this._objectArray = new Object[oldArray.length * 2];
            System.arraycopy(oldArray, 0, this._objectArray, 0, oldArray.length);
        }
        this._objectArray[this._putIndex] = o;
        ++this._putIndex;
    }

    public boolean contains(Object o) {
        for (int index = 0; index < this._putIndex; ++index) {
            if (!this._objectArray[index].equals(o)) continue;
            return true;
        }
        return false;
    }

    public synchronized void remove(Object o) {
        int index = this.lookup(o);
        if (index < 0) {
            return;
        }
        int j = this._objectArray.length - index - 1;
        if (j > 0) {
            System.arraycopy(this._objectArray, index + 1, this._objectArray, index, j);
        }
        --this._putIndex;
        this._objectArray[this._putIndex] = null;
    }

    private int lookup(Object o) {
        for (int index = 0; index < this._putIndex; ++index) {
            if (!this._objectArray[index].equals(o)) continue;
            return index;
        }
        return -1;
    }

    public synchronized Iterator iterator() {
        Object[] snapshot = new Object[this._putIndex];
        System.arraycopy(this._objectArray, 0, snapshot, 0, this._putIndex);
        return new IteratorImpl(snapshot);
    }

    public int size() {
        return this._putIndex;
    }

    public final synchronized Object[] toArray() {
        Object[] array = new Object[this._putIndex];
        System.arraycopy(this._objectArray, 0, array, 0, this._putIndex);
        return array;
    }

    public final synchronized Object[] toArray(Object[] array) {
        System.arraycopy(this._objectArray, 0, array, 0, this._putIndex);
        return array;
    }
}

