/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema.util;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.schema.util.Entry;
import com.wm.util.Showable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CodableHashtable
extends Hashtable
implements ValuesCodable,
Showable,
IDataPortable {
    public static final String KEY_TABLE = "table";
    public static final String KEY_JAVA_CLASS = "classname";

    public CodableHashtable() {
    }

    public CodableHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public CodableHashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CodableHashtable(IData values) {
        this();
        if (values != null) {
            this.setFromData(values);
        }
    }

    public Values getValues() {
        Vector<Values> vector = new Vector<Values>();
        Enumeration enumvar = this.elements();
        while (enumvar.hasMoreElements()) {
            Object element = enumvar.nextElement();
            if (!(element instanceof ValuesCodable)) continue;
            Values values = ((ValuesCodable)element).getValues();
            values.put(KEY_JAVA_CLASS, element.getClass().getName());
            vector.addElement(values);
        }
        Object[][] o = new Object[][]{{KEY_TABLE, vector}};
        return new Values(o);
    }

    public void setValues(Values values) {
        this.clear();
        Object in = values.get(KEY_TABLE);
        if (in != null && in instanceof Vector) {
            Vector vector = (Vector)in;
            int size = vector.size();
            for (int index = 0; index < size; ++index) {
                Values entryValues;
                String className;
                in = vector.elementAt(index);
                if (in == null || !(in instanceof Values) || (className = (entryValues = (Values)in).getString(KEY_JAVA_CLASS)) == null) continue;
                try {
                    Object o = Class.forName(className).newInstance();
                    this.customize(o);
                    if (o instanceof ValuesCodable) {
                        ((ValuesCodable)o).setValues(entryValues);
                    }
                    if (!(o instanceof Entry)) continue;
                    ((Entry)o).addTo(this);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public IData getAsData() {
        Vector<IData> vector = new Vector<IData>();
        Enumeration enumvar = this.elements();
        while (enumvar.hasMoreElements()) {
            Object element = enumvar.nextElement();
            if (!(element instanceof IDataPortable)) continue;
            IData values = ((IDataPortable)element).getAsData();
            IDataCursor ic = values.getCursor();
            IDataUtil.put(ic, KEY_JAVA_CLASS, element.getClass().getName());
            ic.destroy();
            vector.addElement(values);
        }
        Object[][] o = new Object[][]{{KEY_TABLE, vector}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        this.clear();
        IDataCursor ic = values.getCursor();
        Object in = IDataUtil.get(ic, KEY_TABLE);
        ic.destroy();
        if (in != null && in instanceof Vector) {
            Vector vector = (Vector)in;
            int size = vector.size();
            for (int index = 0; index < size; ++index) {
                in = vector.elementAt(index);
                if (in == null || !(in instanceof IData)) continue;
                IData entryValues = (IData)in;
                IDataCursor ice = entryValues.getCursor();
                String className = (String)IDataUtil.get(ice, KEY_JAVA_CLASS);
                ice.destroy();
                if (className == null) continue;
                try {
                    Object o = Class.forName(className).newInstance();
                    this.customize(o);
                    if (o instanceof IDataPortable) {
                        ((IDataPortable)o).setFromData(entryValues);
                    } else if (o instanceof ValuesCodable) {
                        ((ValuesCodable)o).setValues(Values.use(entryValues));
                    }
                    if (!(o instanceof Entry)) continue;
                    ((Entry)o).addTo(this);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized Values getView() {
        int size = this.size();
        if (size < 1) {
            return null;
        }
        Values[] valuesArray = new Values[size];
        Enumeration enumvar = this.elements();
        int i = 0;
        while (enumvar.hasMoreElements()) {
            valuesArray[i] = ((Showable)enumvar.nextElement()).getView();
            ++i;
        }
        Object[][] o = new Object[][]{{KEY_TABLE, valuesArray}};
        return new Values(o);
    }

    public static Values[] retrieveValuesArray(Values values) {
        if (values == null) {
            return null;
        }
        return values.getValuesArray(KEY_TABLE);
    }

    public static IData[] retrieveIDataArray(IData values) {
        if (values == null) {
            return null;
        }
        IDataCursor ic = values.getCursor();
        IData[] ida = (IData[])IDataUtil.get(ic, KEY_TABLE);
        ic.destroy();
        return ida;
    }

    public void customize(Object o) {
    }
}

